/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.gate;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor;
import com.xebialabs.xlrelease.domain.tasks.gate.TargetIdResolutionFailedException;
import com.xebialabs.xlrelease.repository.DependencyTargetResolver;
import com.xebialabs.xlrelease.repository.DependencyUpdateCommand;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.user.User;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GateTaskExecutor
implements TaskExecutor<GateTask> {
    private XlrRepository xlrRepository;
    private ReleaseActorService releaseActorService;
    private DependencyTargetResolver dependencyTargetResolver;

    @Autowired
    public GateTaskExecutor(XlrRepository xlrRepository, ReleaseActorService releaseActorService, DependencyTargetResolver dependencyTargetResolver) {
        this.xlrRepository = xlrRepository;
        this.releaseActorService = releaseActorService;
        this.dependencyTargetResolver = dependencyTargetResolver;
    }

    @Override
    public Class<GateTask> getTaskClass() {
        return GateTask.class;
    }

    @Override
    public void execute(GateTask task) {
        try {
            this.tryResolveTargetIdOfDependencies(task);
            this.completeOrFailIfNeeded(task);
        }
        catch (TargetIdResolutionFailedException e) {
            this.releaseActorService.failTaskAsync(task.getId(), FailureReasons.GATE_TASK_FAILED.format(new Object[]{e.getMessage()}), User.AUTHENTICATED_USER);
        }
    }

    private void tryResolveTargetIdOfDependencies(GateTask gateTask) throws TargetIdResolutionFailedException {
        ArrayList<Dependency> updatedDependencies = new ArrayList<Dependency>();
        for (Dependency dependency2 : gateTask.getDependencies()) {
            String targetId = dependency2.getTargetId();
            if (Strings.isEmpty((String)targetId)) {
                if (dependency2.hasResolvedTarget() || dependency2.isArchived()) continue;
                throw new TargetIdResolutionFailedException(String.format("Missing target on dependency %s. Was it defined as a variable with an empty value?", dependency2.getId()));
            }
            if (dependency2.hasResolvedTarget()) continue;
            this.dependencyTargetResolver.resolveTarget(dependency2);
            updatedDependencies.add(dependency2);
        }
        updatedDependencies.forEach(dependency -> this.xlrRepository.handle(new DependencyUpdateCommand(gateTask.getRelease(), (Dependency)dependency, Collections.emptyList())));
    }

    private void completeOrFailIfNeeded(GateTask task) {
        if (task.isCompletable()) {
            this.releaseActorService.markTaskAsDoneAsync(TaskStatus.COMPLETED, task.getId(), null, User.AUTHENTICATED_USER);
        } else if (task.hasAbortedDependencies()) {
            String titles = task.getAbortedDependencyTitles();
            this.releaseActorService.failTaskAsync(task.getId(), FailureReasons.GATE_TASK_DEPENDS_ON_AN_ABORTED_RELEASE.format(new Object[]{titles}), User.AUTHENTICATED_USER);
        }
    }
}

