/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator$;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.repository.DeserializationSupport;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.ReleasesSqlRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.data.ReleaseData;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.SqlFilterSupport;
import com.xebialabs.xlrelease.views.ReleasesFilters;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u0001\u0003\u0001-\u0011qcU9m%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u001dA\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u00011C\u0002\u0001\r)a\u0001c\u0005\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u000bSK2,\u0017m]3TK\u0006\u00148\r[*feZL7-\u001a\t\u00033yi\u0011A\u0007\u0006\u00037q\tQa\u001d7gi)T\u0011!H\u0001\tOJL'P\u001f7fI&\u0011qD\u0007\u0002\b\u0019><w-\u001b8h!\t\tC%D\u0001#\u0015\t\u0019C!\u0001\u0006sKB|7/\u001b;pefL!!\n\u0012\u0003-\u0011+7/\u001a:jC2L'0\u0019;j_:\u001cV\u000f\u001d9peR\u0004\"!F\u0014\n\u0005!\u0012!\u0001E*rY\u001aKG\u000e^3s'V\u0004\bo\u001c:u\u0011!Q\u0003A!A!\u0002\u0013Y\u0013!\u0006:fY\u0016\f7/Z:Tc2\u0014V\r]8tSR|'/\u001f\t\u0003C1J!!\f\u0012\u0003+I+G.Z1tKN\u001c\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\"Aq\u0006\u0001BC\u0002\u0013\u0005\u0001'A\tsKB|7/\u001b;pef\fE-\u00199uKJ,\u0012!\r\t\u0003CIJ!a\r\u0012\u0003)M\u000bHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0011!)\u0004A!A!\u0002\u0013\t\u0014A\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0002B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001O\u0001\u0006i\u0016\fWn]\u000b\u0002sA\u0011\u0011EO\u0005\u0003w\t\u0012Q\u0001V3b[ND\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006I!O\u0001\u0007i\u0016\fWn\u001d\u0011\t\u0011}\u0002!\u0011!Q\u0001\n\u0001\u000b\u0001\u0003Z3d_J\fGo\u001c:TKJ4\u0018nY3\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u0015#\u0011aA1qS&\u0011qI\u0011\u0002!\u0013:$XM\u001d8bY6+G/\u00193bi\u0006$UmY8sCR|'oU3sm&\u001cW\r\u0003\u0005J\u0001\t\u0015\r\u0011b\u0001K\u0003)\u0019\u0018\u000f\u001c#jC2,7\r^\u000b\u0002\u0017B\u0011A\n\u0019\b\u0003\u001bvs!A\u0014.\u000f\u0005=CfB\u0001)X\u001d\t\tfK\u0004\u0002S+6\t1K\u0003\u0002U\u0015\u00051AH]8pizJ\u0011!C\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005e#\u0011A\u00013c\u0013\tYF,A\u0002tc2T!!\u0017\u0003\n\u0005y{\u0016AC*rY\n+\u0018\u000e\u001c3fe*\u00111\fX\u0005\u0003C\n\u0014q\u0001R5bY\u0016\u001cGO\u0003\u0002_?\"AA\r\u0001B\u0001B\u0003%1*A\u0006tc2$\u0015.\u00197fGR\u0004\u0003\u0002\u00034\u0001\u0005\u000b\u0007I1A4\u0002%A,'/\\5tg&|g.\u00128g_J\u001cWM]\u000b\u0002QB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\tg\u0016\u001cWO]5us*\u0011QNB\u0001\tI\u0016\u0004Hn\\=ji&\u0011qN\u001b\u0002\u0013!\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'\u000f\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003i\u0003M\u0001XM]7jgNLwN\\#oM>\u00148-\u001a:!\u0011!\u0019\bA!b\u0001\n\u0003!\u0018a\u0003:pY\u0016\u001cVM\u001d<jG\u0016,\u0012!\u001e\t\u0003SZL!a\u001e6\u0003\u0017I{G.Z*feZL7-\u001a\u0005\ts\u0002\u0011\t\u0011)A\u0005k\u0006a!o\u001c7f'\u0016\u0014h/[2fA!A1\u0010\u0001BC\u0002\u0013\u0005A0\u0001\u0006tK\u000e,(/\u001a3DSN,\u0012! \t\u0003CyL!a \u0012\u0003\u0015M+7-\u001e:fI\u000eK7\u000fC\u0005\u0002\u0004\u0001\u0011\t\u0011)A\u0005{\u0006Y1/Z2ve\u0016$7)[:!\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\ta\u0001P5oSRtDCEA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0011qCA\r\u00037\u0001\"!\u0006\u0001\t\r)\n)\u00011\u0001,\u0011\u0019y\u0013Q\u0001a\u0001c!1q'!\u0002A\u0002eBaaPA\u0003\u0001\u0004\u0001\u0005BB%\u0002\u0006\u0001\u000f1\n\u0003\u0004g\u0003\u000b\u0001\u001d\u0001\u001b\u0005\u0007g\u0006\u0015\u0001\u0019A;\t\rm\f)\u00011\u0001~\u0011\u001d\ty\u0002\u0001C!\u0003C\taa]3be\u000eDG\u0003DA\u0012\u0003[\ti$!\u0014\u0002R\u0005m\u0003\u0003BA\u0013\u0003Si!!a\n\u000b\u0007\u0005}A!\u0003\u0003\u0002,\u0005\u001d\"a\u0005*fY\u0016\f7/Z*fCJ\u001c\u0007NU3tk2$\b\u0002CA\u0018\u0003;\u0001\r!!\r\u0002\u001fI,G.Z1tKN4\u0015\u000e\u001c;feN\u0004B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o!\u0011!\u0002<jK^\u001c\u0018\u0002BA\u001e\u0003k\u0011qBU3mK\u0006\u001cXm\u001d$jYR,'o\u001d\u0005\t\u0003\u007f\ti\u00021\u0001\u0002B\u0005!\u0001/Y4f!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#BAA$\u0003\u0015\u00198-\u00197b\u0013\u0011\tY%!\u0012\u0003\t1{gn\u001a\u0005\t\u0003\u001f\ni\u00021\u0001\u0002B\u0005aa.^7cKJ\u0014\u0015\u0010U1hK\"A\u00111KA\u000f\u0001\u0004\t)&A\u0003eKB$\b\u000e\u0005\u0003\u0002D\u0005]\u0013\u0002BA-\u0003\u000b\u00121!\u00138u\u0011!\ti&!\bA\u0002\u0005}\u0013a\u00054jYR,'o\u00148QKJl\u0017n]:j_:\u001c\b\u0003BA\"\u0003CJA!a\u0019\u0002F\t9!i\\8mK\u0006t\u0007bBA4\u0001\u0011\u0005\u0013\u0011N\u0001\u0010g\u0016\f'o\u00195UK6\u0004H.\u0019;fgRQ\u00111EA6\u0003k\n9(!\u001f\t\u0011\u00055\u0014Q\ra\u0001\u0003_\nq\u0002^3na2\fG/\u001a$jYR,'o\u001d\t\u0005\u0003g\t\t(\u0003\u0003\u0002t\u0005U\"a\u0004+f[Bd\u0017\r^3GS2$XM]:\t\u0011\u0005}\u0012Q\ra\u0001\u0003\u0003B\u0001\"a\u0014\u0002f\u0001\u0007\u0011\u0011\t\u0005\t\u0003'\n)\u00071\u0001\u0002V!9\u0011Q\u0010\u0001\u0005B\u0005}\u0014!F:fCJ\u001c\u0007NU3mK\u0006\u001cXm\u001d\"z)&$H.\u001a\u000b\u000b\u0003\u0003\u000bI*!,\u00020\u0006E\u0006CBAB\u0003\u0013\u000bi)\u0004\u0002\u0002\u0006*\u0019\u0011q\u0011\t\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0017\u000b)I\u0001\u0003MSN$\b\u0003BAH\u0003+k!!!%\u000b\u0007\u0005ME!\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003/\u000b\tJA\u0004SK2,\u0017m]3\t\u0011\u0005m\u00151\u0010a\u0001\u0003;\u000bAB]3mK\u0006\u001cX\rV5uY\u0016\u0004B!a(\u0002(:!\u0011\u0011UAR!\r\u0011\u0016QI\u0005\u0005\u0003K\u000b)%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003S\u000bYK\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003K\u000b)\u0005\u0003\u0005\u0002@\u0005m\u0004\u0019AA!\u0011!\ty%a\u001fA\u0002\u0005\u0005\u0003\u0002CA*\u0003w\u0002\r!!\u0016\t\u000f\u0005U\u0006\u0001\"\u0011\u00028\u0006\u0011b-\u001b8e\u00032dG+Z7qY\u0006$X-\u00133t)\t\tI\f\u0005\u0004\u0002\u0004\u0006%\u0015Q\u0014\u0005\b\u0003{\u0003A\u0011IA\\\u0003]1\u0017N\u001c3BY2\f5\r^5wKJ+G.Z1tK&#7\u000fC\u0004\u0002B\u0002!\t%a.\u00021\u0019Lg\u000eZ!mYB+g\u000eZ5oOJ+G.Z1tK&#7\u000fC\u0004\u0002F\u0002!I!a2\u0002\u001bE,XM]=SK2,\u0017m]3t))\tI-a7\u0002n\u0006=\u0018\u0011\u001f\t\u0007\u0003\u0017\f).!$\u000f\t\u00055\u0017\u0011\u001b\b\u0004%\u0006=\u0017BAA$\u0013\u0011\t\u0019.!\u0012\u0002\u000fA\f7m[1hK&!\u0011q[Am\u0005\r\u0019V-\u001d\u0006\u0005\u0003'\f)\u0005\u0003\u0005\u0002^\u0006\r\u0007\u0019AAp\u0003%\u0019X-\u0019:dQ&#7\u000f\u0005\u0005\u0002D\u0005\u0005\u0018Q]Av\u0013\u0011\t\u0019/!\u0012\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u0011\u0002h&\u0019\u0011\u0011\u001e\u0012\u0003\tA\u000bw-\u001a\t\u0007\u0003\u0017\f).!(\t\u0011\u0005}\u00121\u0019a\u0001\u0003\u0003B\u0001\"a\u0014\u0002D\u0002\u0007\u0011\u0011\t\u0005\t\u0003g\f\u0019\r1\u0001\u0002v\u0006Q\u0001/\u001a:nSN\u001c\u0018n\u001c8\u0011\t\u0005]\u00181`\u0007\u0003\u0003sT1!a=k\u0013\u0011\ti0!?\u0003\u0015A+'/\\5tg&|g\u000eC\u0004\u0003\u0002\u0001!IAa\u0001\u00021\u0019Lg\u000e\u001a*fY\u0016\f7/Z:Cs&#7/\u00138Pe\u0012,'\u000f\u0006\u0003\u0002J\n\u0015\u0001\u0002\u0003B\u0004\u0003\u007f\u0004\r!a;\u0002\u0015I,G.Z1tK&#7\u000fC\u0004\u0003\f\u0001!IA!\u0004\u0002\u001dQ|7+Z1sG\"\u0014Vm];miR1\u00111\u0005B\b\u0005#A\u0001\"a\u0010\u0003\n\u0001\u0007\u0011\u0011\t\u0005\t\u0005'\u0011I\u00011\u0001\u0002J\u0006A!/\u001a7fCN,7\u000fC\u0004\u0003\u0018\u0001!\tE!\u0007\u0002\u0019\u0015D\u0018n\u001d;t\u0005ft\u0015-\\3\u0015\t\u0005}#1\u0004\u0005\t\u0005;\u0011)\u00021\u0001\u0002\u001e\u0006i1-\u00198eS\u0012\fG/\u001a(b[\u0016DqA!\t\u0001\t\u0013\u0011\u0019#A\tdkJ\u0014XM\u001c;Qe&t7-\u001b9bYN,\"A!\n\u0011\r\u0005-'qEAO\u0013\u0011\u0011I#!7\u0003\u0011%#XM]1cY\u0016DqA!\f\u0001\t\u0013\u0011y#\u0001\bdkJ\u0014XM\u001c;S_2,\u0017\nZ:\u0016\u0005\tE\u0002C\u0002B\u001a\u0005{\u0011\t%\u0004\u0002\u00036)!!q\u0007B\u001d\u0003\u001diW\u000f^1cY\u0016TAAa\u000f\u0002F\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t}\"Q\u0007\u0002\u0007\u0005V4g-\u001a:\u0011\u00075\u0011\u0019%C\u0002\u0002*:\u0001")
public class SqlReleaseSearchService
implements ReleaseSearchService,
Logging,
DeserializationSupport,
SqlFilterSupport {
    private final ReleasesSqlRepository releasesSqlRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final Teams teams;
    private final InternalMetadataDecoratorService decoratorService;
    private final SqlBuilder.Dialect sqlDialect;
    private final PermissionEnforcer permissionEnforcer;
    private final RoleService roleService;
    private final SecuredCis securedCis;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    @Override
    public ReleasesSqlBuilder sqlBuilderByReleaseFilters(ReleasesFilters filters, Iterable<String> principals, Iterable<String> roleIds) {
        return SqlFilterSupport.sqlBuilderByReleaseFilters$(this, filters, principals, roleIds);
    }

    @Override
    public ReleasesSqlBuilder sqlBuilderByTemplateFilters(TemplateFilters filters, Iterable<String> principals, Iterable<String> roleIds) {
        return SqlFilterSupport.sqlBuilderByTemplateFilters$(this, filters, principals, roleIds);
    }

    @Override
    public Release deserializeRelease(ReleaseData releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ReleaseSearchResult search(ReleasesFilters x$1, long x$2, long x$3) {
        return super.search(x$1, x$2, x$3);
    }

    public ReleaseSearchResult search(ReleasesFilters x$1, long x$2, long x$3, int x$4) {
        return super.search(x$1, x$2, x$3, x$4);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseSearchService sqlReleaseSearchService = this;
        synchronized (sqlReleaseSearchService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public Teams teams() {
        return this.teams;
    }

    @Override
    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public SecuredCis securedCis() {
        return this.securedCis;
    }

    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page2, long numberByPage, int depth, boolean filterOnPermissions) {
        ReleaseSearchResult releaseSearchResult;
        releasesFilters.checkConsistency();
        if (releasesFilters.hasASelectedFilter()) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for releases by filters"})).s((Seq)Nil$.MODULE$));
            Seq<Release> releases = this.queryReleases((Function1<Page, Seq<String>>)(Function1 & Serializable & scala.Serializable)page -> this.searchIds$1((Page)page, releasesFilters), page2, numberByPage, XLReleasePermissions.VIEW_RELEASE);
            releaseSearchResult = this.toSearchResult(page2, releases);
        } else {
            releaseSearchResult = new ReleaseSearchResult();
        }
        return releaseSearchResult;
    }

    public ReleaseSearchResult searchTemplates(TemplateFilters templateFilters, long page2, long numberByPage, int depth) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for templates by filters"})).s((Seq)Nil$.MODULE$));
        Seq<Release> templates = this.queryReleases((Function1<Page, Seq<String>>)(Function1 & Serializable & scala.Serializable)page -> this.searchIds$2((Page)page, templateFilters), page2, numberByPage, XLReleasePermissions.VIEW_TEMPLATE);
        return this.toSearchResult(page2, templates);
    }

    public List<Release> searchReleasesByTitle(String releaseTitle, long page2, long numberByPage, int depth) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for releases by title ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseTitle})));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.queryReleases((Function1<Page, Seq<String>>)(Function1 & Serializable & scala.Serializable)page -> this.searchIds$3((Page)page, releaseTitle), page2, numberByPage, XLReleasePermissions.VIEW_RELEASE)).asJava();
    }

    public List<String> findAllTemplateIds() {
        Tuple2<String, Seq<Object>> sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE})))).build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.releasesSqlRepository.findReleaseIdsByQuery(sqlWithParams)).asJava();
    }

    public List<String> findAllActiveReleaseIds() {
        Tuple2<String, Seq<Object>> sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.releasesSqlRepository.findReleaseIdsByQuery(sqlWithParams)).asJava();
    }

    public List<String> findAllPendingReleaseIds() {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for all pending releases"})).s((Seq)Nil$.MODULE$));
        Tuple2<String, Seq<Object>> sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED})))).withAutoStart().build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.releasesSqlRepository.findReleaseIdsByQuery(sqlWithParams)).asJava();
    }

    private Seq<Release> queryReleases(Function1<Page, Seq<String>> searchIds, long page, long numberByPage, Permission permission) {
        Seq releaseIds = (Seq)searchIds.apply((Object)new Page((long)((int)page), (long)((int)numberByPage), Predef$.MODULE$.int2Integer(0)));
        Seq releases = releaseIds.nonEmpty() ? this.findReleasesByIdsInOrder((Seq<String>)releaseIds) : (Seq)Seq$.MODULE$.empty();
        this.teams().decorateWithEffectiveTeams((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(releases).asJava());
        this.decoratorService.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(releases).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
        return releases;
    }

    private Seq<Release> findReleasesByIdsInOrder(Seq<String> releaseIds) {
        Tuple2<String, Seq<Object>> sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds(releaseIds).build();
        Seq releasesUnordered = (Seq)this.releasesSqlRepository.findReleaseDatasByQuery(sqlWithParams).map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseData)releaseData), Seq$.MODULE$.canBuildFrom());
        return (Seq)releasesUnordered.sortBy((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)releaseIds.indexOf((Object)r.getId())), (Ordering)Ordering.Int$.MODULE$);
    }

    private ReleaseSearchResult toSearchResult(long page, Seq<Release> releases) {
        ReleaseSearchResult searchResult = new ReleaseSearchResult();
        searchResult.setPage(page + 1L);
        searchResult.addReleases((List)JavaConverters$.MODULE$.seqAsJavaListConverter(releases).asJava());
        return searchResult;
    }

    public boolean existsByName(String candidateName) {
        Tuple2<String, Seq<Object>> sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withReleaseName(candidateName).withPage(new Page(0L, 1L, Predef$.MODULE$.int2Integer(0))).build();
        return this.releasesSqlRepository.findReleaseIdsByQuery(sqlWithParams).nonEmpty();
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<String> currentRoleIds() {
        return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Buffer$.MODULE$.canBuildFrom());
    }

    private final Seq searchIds$1(Page page, ReleasesFilters releasesFilters$1) {
        Tuple2<String, Seq<Object>> sqlWithParams = this.sqlBuilderByReleaseFilters(releasesFilters$1, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds()).selectReleaseId().withPage(page).build();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for a batch of releases by SQL query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlWithParams._1()})));
        return this.releasesSqlRepository.findReleaseIdsByQuery(sqlWithParams);
    }

    private final Seq searchIds$2(Page page, TemplateFilters templateFilters$1) {
        Tuple2<String, Seq<Object>> sqlWithParams = this.sqlBuilderByTemplateFilters(templateFilters$1, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds()).selectReleaseId().withPage(page).build();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for a batch of templates by SQL query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlWithParams._1()})));
        return this.releasesSqlRepository.findReleaseIdsByQuery(sqlWithParams);
    }

    private final Seq searchIds$3(Page page, String releaseTitle$1) {
        ReleasesSqlBuilder sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withTitle(releaseTitle$1).withPage(page);
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? sqlWithParams.withPermission(XLReleasePermissions.VIEW_RELEASE, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds()) : BoxedUnit.UNIT;
        return this.releasesSqlRepository.findReleaseIdsByQuery(sqlWithParams.build());
    }

    public SqlReleaseSearchService(ReleasesSqlRepository releasesSqlRepository, SqlRepositoryAdapter repositoryAdapter, Teams teams, InternalMetadataDecoratorService decoratorService, SqlBuilder.Dialect sqlDialect, PermissionEnforcer permissionEnforcer, RoleService roleService, SecuredCis securedCis) {
        this.releasesSqlRepository = releasesSqlRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.teams = teams;
        this.decoratorService = decoratorService;
        this.sqlDialect = sqlDialect;
        this.permissionEnforcer = permissionEnforcer;
        this.roleService = roleService;
        this.securedCis = securedCis;
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        SqlFilterSupport.$init$(this);
    }
}

