/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.domain;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskAssessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class TaskFlagRiskAssessor
extends RiskAssessor {
    protected RiskAssessment executeForFlag(RiskAssessment assessment, Release release, FlagStatus flagStatus, String flaggedHeadline) {
        List<Task> flaggedTasks = release.getAllTasks().stream().filter(t -> flagStatus == t.getFlagStatus()).collect(Collectors.toList());
        ArrayList<String> messages = new ArrayList<String>();
        int numberOfFlaggedTasks = flaggedTasks.size();
        if (numberOfFlaggedTasks == 0) {
            assessment.setScore(0);
            assessment.setHeadline("Release is on track");
        } else {
            assessment.setHeadline(flaggedHeadline);
            flaggedTasks.forEach(t -> messages.add(String.format("%s: %s", t.getTitle(), Optional.ofNullable(t.getFlagComment()).orElse(""))));
            assessment.setScore(this.getScore(numberOfFlaggedTasks));
        }
        assessment.setMessages(messages);
        return assessment;
    }

    protected abstract int getScore(int var1);
}

