angular.module("xlrelease").run(["$templateCache", function($templateCache) {$templateCache.put("static/7.1.0/partials/calendar/calendar-tooltip.html","<div class=\"calendar-tooltip\" calendar-tooltip on-show=\"loadReleaseDetails(release)\">\n    <div class=\"title\">\n        {{ release.title }}\n    </div>\n    <div class=\"main-content\">\n        <div ng-if=\"release.currentPhase && release.currentSimpleTasks.length\">\n            <p display-variables=\"release.currentPhase\" variables=\"release.variables\"></p>\n            <ul class=\"current-tasks-list\">\n                <li ng-repeat=\"currentTask in release.currentSimpleTasks\">\n                    <span>{{currentTask.title}}</span>\n                </li>\n            </ul>\n        </div>\n        <div ng-show=\"loadingDetails\" class=\"light-text mbm\">Loading dependencies...</div>\n        <div ng-if=\"releasesDependencies && getOutgoingDependencies(release.id).length\">\n            <p class=\"outgoing-header\">Depends on</p>\n            <ul class=\"outgoing-dependencies\">\n                <li ng-repeat=\"dependency in getOutgoingDependencies(release.id)\"\n                    calendar-tooltip-dependency dependency=\"dependency\" type=\"outgoing\"\n                    display-with-separators=\"/\">\n                    <span ng-if=\"isReleaseOrSubtaskFlagged(dependency)\" class=\"flagged\">\n                        <span class=\"small-flag-icon-{{ dependency.flag.status | lowercase }}\"></span>\n                    </span>\n                    <span display-when=\"true\">{{ dependency.releaseTitle }}</span>\n                    <span display-when=\"dependency.phaseTitle\">{{ interpolate(dependency.phaseTitle, dependency.releaseId) }}</span>\n                    <span display-when=\"dependency.taskTitle\">{{ interpolate(dependency.taskTitle, dependency.releaseId)  }}</span>\n                </li>\n            </ul>\n        </div>\n        <div ng-if=\"releasesDependencies && getIncomingDependencies(release.id).length\">\n            <p class=\"incoming-header\">Depending on this release</p>\n            <ul class=\"incoming-dependencies\">\n                <li ng-repeat=\"dependency in getIncomingDependencies(release.id)\"\n                    calendar-tooltip-dependency dependency=\"dependency\" type=\"incoming\"\n                    display-with-separators=\"/\">\n                    <span ng-if=\"isReleaseOrSubtaskFlagged(dependency)\" class=\"flagged\">\n                        <span class=\"small-flag-icon-{{ dependency.flag.status | lowercase }}\"></span>\n                    </span>\n                    <span display-when=\"true\">{{ dependency.releaseTitle }}</span>\n                    <span display-when=\"dependency.phaseTitle\">{{ interpolate(dependency.phaseTitle, dependency.releaseId) }}</span>\n                    <span display-when=\"dependency.taskTitle\">{{ interpolate(dependency.taskTitle, dependency.releaseId) }}</span>\n                </li>\n            </ul>\n        </div>\n        <div class=\"text-centered tooltip-actions\">\n            <a href=\"#/releases/{{release.id}}\" class=\"link\">View release</a> |\n            <span class=\"link download-ics\" ng-click=\"downloadCalendar(release)\">Export to calendar</span>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/calendar/calendar.html","<div id=\"calendar\">\n    <div id=\"calendar-header\" class=\"header\">\n        <div class=\"filter-release\" ng-controller=\"filtersController\">\n            <div id=\"current-month\">{{currentDate.toDate() | date:\'MMMM yyyy\'}}</div>\n            <div class=\"navigation\">\n                <div class=\"button previous-month\" ng-click=\"showPreviousMonth()\">&lt;</div>\n                <div class=\"button show-today\" ng-click=\"showToday()\">Today</div>\n                <div class=\"button next-month\" ng-click=\"showNextMonth(month.fullDate)\">&gt;</div>\n            </div>\n            <button type=\"button\" class=\"button dropdown-button\" bs-popover data-content-template=\"partials/releases/filter.html\" data-placement=\"bottom\"\n                    auto-close=\"true\">Filter options\n            </button>\n            <input id=\"searchFilter\" type=\"search\" placeholder=\"Filter by title...\" ng-model=\"filters.title\">\n            <span class=\"tags-label\">Tags</span>\n            <div class=\"transparent tags-input green-tags\" tags-input tags=\"filters.tags\" focus-on-click\n                 placeholder=\"Add a tag...\"></div>\n        </div>\n        <span doc-icon=\"calendar.html\"></span>\n    </div>\n    <div id=\"calendar-content\" class=\"content\" ng-if=\"weeks.length > 0\" ng-class=\"{\'navigator-opened\': showNavigator}\" resize-days>\n        <div id=\"navigator-toggler\" ng-click=\"toggleNavigator()\" ng-class=\"{\'navigator-opened\': showNavigator}\">\n            <div class=\"arrow-container\">\n                <i class=\"arrow\" ng-class=\"{\'arrow-gray-left\': showNavigator, \'arrow-gray-right\': !showNavigator}\"></i>\n            </div>\n        </div>\n        <div id=\"navigator\" ng-show=\"showNavigator\">\n            <div ng-repeat=\"month in months\" class=\"month-link-container\" ng-class=\"{\'highlight\': isCurrentMonth(month)}\">\n                <div class=\"month-link\" ng-click=\"showDate(month.fullDate)\">\n                    {{month.title}} <span class=\"pull-right\" ng-if=\"month.index === 0 || $index === 0\">{{month.year}}</span>\n                </div>\n            </div>\n        </div>\n\n        <div class=\"calendar-body\">\n            <div class=\"alert too-many-results-alert\" ng-show=\"maxLimitReached\">Some releases are not shown because the filter produced too many results. Please\n                narrow your search criteria.\n            </div>\n            <div id=\"days-name\">\n                <div ng-repeat=\"weekDay in weekDays\">{{::weekDay}}</div>\n            </div>\n            <div class=\"clearfix\"></div>\n            <div id=\"days\">\n                <div class=\"week\" ng-repeat=\"week in weeks\" adjust-week-height>\n                    <div ng-repeat=\"day in week.days\" ng-init=\"displayMonth = ($index == 0 && $parent.$index == 0) || day.date == 1\"\n                         class=\"day {{day.dateStatus}}\" tooltip=\"day.label\">\n                        <div class=\"day-header\" ng-style=\"{\'background-color\': computeDayColor(day) }\">\n                            <div class=\"context-menu-button dropdown-button pull-left\"\n                                 bs-popover data-content-template=\"partials/calendar/context-menu.html\" data-placement=\"bottom\" auto-close=\"true\">\n                                <i class=\"context-menu-icon\"></i>\n                            </div>\n\n                            <div class=\"pull-left\">\n                                <span ng-show=\"displayMonth\">{{day.month}}</span>\n                                <span ng-show=\"displayMonth && day.label\">|</span>\n                                <span ng-show=\"!displayMonth && !day.label\"></span>\n                                {{day.label}}\n                            </div>\n                            <div ng-click=\"openDay(day)\" class=\"pull-right day-number\">\n                                {{day.date}}\n                            </div>\n                        </div>\n                        <div class=\"day-content\" ng-style=\"{\'background-color\': computeDayColor(day) }\"></div>\n                        <div ng-if=\"day.dateStatus === \'today\'\" class=\"time-indicator\" position-current-time></div>\n                    </div>\n                    <span ng-repeat=\"blackout in week.blackouts\" position-blackout=\"blackout-{{blackout.name}}\" class=\"blackout blackout-{{blackout.name}}\">\n                    <span class=\"blackout-header\" bs-popover\n                          template=\"<calendar-blackout-tooltip blackout=\'blackout\' on-delete=\'deleteBlackout(blackout);\' on-change=\'refreshBlackouts();\'></calendar-blackout-tooltip>\"\n                          container=\"body\" data-placement=\"top\" auto-close=\"true\" tooltip=\"blackout.label\">\n                        <span class=\"blackout-label\">\n                            <i class=\"blackout-icon\"></i><span>{{::blackout.label}}</span>\n                        </span>\n                    </span>\n                </span>\n\n                    <span ng-repeat=\"release in week.releases\" position-release=\"{{ release.id }}\"\n                          class=\"release {{ release.status | lowercase}} {{ release.id }} {{ release.flag.status | lowercase }}\">\n                    <span display-release-title release=\"release\"></span>\n\n                    <div class=\"tooltip\">\n                        <div ng-include=\"\'partials/calendar/calendar-tooltip.html\'\"></div>\n                    </div>\n                </span>\n                    <span ng-repeat=\"release in week.releases\">\n                    <span ng-repeat=\"phase in release.displayablePhases\" position-phase=\"{{ phase.id }}\" class=\"phase {{phase.id}}\"\n                          ng-style=\"{\'background-color\': computePhaseColor(release, phase)}\"></span>\n                </span>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/calendar/context-menu.html","<xlr-context-menu id=\"context-menu-container\" items=\"menuOptions\" ng-init=\"menuOptions = getContextMenuOptions(day)\"></xlr-context-menu>");
$templateCache.put("static/7.1.0/partials/calendar/release-title.html","<span class=\"title\">\n    <span ng-if=\"isReleaseOrSubtaskFlagged(release)\">\n        <span class=\"small-flag-icon-{{ release.flag.status | lowercase }}\"></span>\n    </span>\n    {{ release.title }}\n</span>\n");
$templateCache.put("static/7.1.0/partials/colorpicker/main.html","<span>\n    <span class=\"toggle-picker\"\n         ng-style=\"{ \'background-color\': currentColor }\" ng-hide=\"inline\">\n    </span>\n    <span class=\"simplecolorpicker colors\">\n        <div ng-repeat=\"color in colors\"\n             color-picker-swatch cp-current-color=\"currentColor\" cp-color=\"color\"\n             class=\"button\">\n        </div>\n    </span>\n</span>\n");
$templateCache.put("static/7.1.0/partials/colorpicker/swatch.html","<div title=\"{{color.name}}\"\n     ng-style=\"{ \'background-color\': \'{{color.value || \'#ffffff\'}}\' }\"\n     role=\"button\" tabindex=\"0\"\n     ng-class=\"currentColor == color.value && \'selected\' || \'\'\"\n     ng-click=\"clicked()\">\n</div>\n");
$templateCache.put("static/7.1.0/partials/configuration/configuration-instance.html","<div id=\"configuration-instance\" class=\"standalone-form\">\n    <div id=\"configuration-header\" class=\"header\">\n        <h4 ng-if=\"!ctrl.newInstance\">{{ ctrl.descriptor.label }} - {{ ctrl.instance.title }}</h4>\n        <h4 ng-if=\"ctrl.newInstance\">New {{ ctrl.descriptor.label }}</h4>\n        <div class=\"buttons\">\n            <button ng-disabled=\"configurationInstanceForm.$invalid\" id=\"submit\" class=\"button primary\" ng-click=\"ctrl.save()\">Save</button>\n            <button class=\"button test\" id=\"testButton\" ng-click=\"ctrl.testConnection(ctrl.descriptor.type)\"\n                    ng-disabled=\"!ctrl.canCheckConnection || configurationInstanceForm.$invalid || ctrl.checkingConnection\">Test</button>\n            <span ng-if=\"ctrl.lastSavedDate\" class=\"last-saved\">Last saved on {{ ctrl.lastSavedDate | date: \'medium\' }}</span>\n        </div>\n        <span doc-icon=\"custom-configuration-types.html\"></span>\n    </div>\n    <div class=\"content-under-header\">\n        <div class=\"help\">\n            After editing, press Save to apply the changes.<br>\n        </div>\n        <div class=\"sub-help\" ng-if=\"ctrl.tested\">\n            <img src=\"static/7.1.0/styles/img/ajax-loader.gif\" ng-show=\"ctrl.checkingConnection\"/>\n            <div class=\"error connection-check-error\" ng-if=\"ctrl.scriptFound && !ctrl.success\">Can\'t connect to {{ctrl.descriptor.label}}.</div>\n            <div class=\"error connection-check-error\" ng-if=\"ctrl.scriptFound && !ctrl.success\">{{ctrl.errorText}}</div>\n            <span class=\"success connection-check-success\" ng-if=\"ctrl.success\">{{ctrl.descriptor.label}} is available</span>\n            <br>\n        </div>\n        <form name=\"configurationInstanceForm\" class=\"form-horizontal\" confirm-leave>\n            <div ng-repeat=\"(category, properties) in ctrl.descriptor.propertiesByCategory\">\n                <fieldset>\n                    <legend ng-if=\"ctrl.isNotCommonCategory(category)\">{{ category }}</legend>\n                    <div ng-repeat=\"property in properties\" dip-control property=\"property\" container=\"ctrl.instance.properties\"></div>\n                </fieldset>\n            </div>\n        </form>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/configuration/configuration-list.html","<div id=\"configuration\">\n    <div id=\"configuration-header\" class=\"header\">\n        <span>On this page you can configure settings that are shared between tasks. For example, a server connection.</span>\n        <span doc-icon=\"custom-configuration-types.html\"></span>\n    </div>\n    <div class=\"content-under-header\">\n        <fieldset ng-repeat=\"descriptor in descriptors\" class=\"configuration-type\">\n            <legend>\n                <span class=\"name\">{{ descriptor.label }}</span>\n            </legend>\n            <table class=\"table table-rounded table-striped\">\n                <tbody>\n                    <tr ng-repeat=\"instance in instances[descriptor.type]\" class=\"configuration-instance\">\n                        <td class=\"open-instance\"><a class=\"link\" ng-href=\"#/configuration/{{ instance.id }}\">{{ instance.title }}</a></td>\n                        <td class=\"delete-instance\" ng-click=\"deleteInstance(instance)\"><i class=\"remove-icon\"></i></td>\n                    </tr>\n                </tbody>\n            </table>\n            <div class=\"new-instance\">\n                <a class=\"link\" ng-href=\"#/configuration/create/{{ descriptor.type }}\">Add {{ descriptor.label | shortConfigurationItemLabelFormatter }}</a>\n            </div>\n        </fieldset>\n    </div>\n    <div modal=\"\'partials/configuration/delete-instance-error-modal.html\'\" open-on=\"deleteInstanceError\" on-modal-hide=\"resetError()\"></div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/configuration/delete-instance-error-modal.html","<div class=\"modal-content modal-error\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>Error</h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>This configuration instance can not be deleted because it is still referenced.</p>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/attachments-list.html","<table class=\"attachments table table-rounded table-striped\" ng-if=\"attachments.length > 0\">\n    <tbody>\n        <tr ng-repeat=\"attachment in attachments | orderBy:\'-filename\'\">\n            <td class=\"filename title-column\">\n                <a class=\"filelink\" ng-click=\"downloadAttachment(attachment)\">\n                    {{ attachment.filename }}\n                </a>\n                <span class=\"delete pull-right\" ng-click=\"attachment.confirmDelete = true\" ng-if=\"!readonly() && canDeleteAttachments() && !attachment.confirmDelete\">\n                    <i class=\"remove-icon\"/>\n                </span>\n\n                <div class=\"confirm\" ng-if=\"!readonly() && canDeleteAttachments() && attachment.confirmDelete\">\n                    Remove this file?&nbsp;\n                    <a class=\"confirmDelete\" ng-click=\"deleteAttachment({attachment: attachment})\">Remove</a>\n                    &middot;\n                    <a class=\"cancelDelete\" ng-click=\"attachment.confirmDelete = false\">Cancel</a>\n                </div>\n            </td>\n        </tr>\n    </tbody>\n</table>\n<div ng-if=\"!readonly()\"\n     upload auto\n     upload-url=\"uploadUrl\"\n     on-success=\"attachmentAdded(uploadResult)\"\n     ng-controller=\"uploadController\"\n        >\n    <input type=\"file\" ng-model=\"file\" file-input ng-disabled=\"creationInProgress\">\n    <span class=\"error\" ng-show=\"UploadService.data.error\">An upload error occurred : {{UploadService.data.errorMessage}}</span>\n    <img class=\"load-attachment\" src=\"static/7.1.0/styles/img/ajax-loader.gif\" ng-show=\"UploadService.data.loading\"/>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/date-editor.html","<span date-time-picker date=\"date\" date-format=\"{{dateFormat}}\" class=\"date-editor\" ng-class=\"{readonly: readonly()}\">\n    <span class=\"date date-picker-holder\">\n        <span ng-hide=\"displayedDate()\" class=\"light-text date-placeholder\">\n            <span ng-if=\"!placeholder\">Set date</span>\n            <span ng-if=\"placeholder\">{{ placeholder }}</span>\n        </span>\n        <input ng-show=\"displayedDate()\" readonly type=\"text\" value=\"{{ displayedDate()| toDate |date:\'shortDate\' }}\" ng-class=\"{\'light-text\': hasNoDate()}\"/>\n    </span>\n\n    <span class=\"time bootstrap-timepicker\" ng-show=\"displayedDate()\">\n        <span class=\"time-picker-holder\">\n            <input readonly type=\"text\" value=\"{{ displayedDate() | toDate | date:\'shortTime\' }}\" ng-class=\"{\'light-text\': hasNoDate()}\"/>\n        </span>\n    </span>\n\n    <span ng-if=\"deletable() && date\" class=\"remove\" ng-click=\"deleteDate()\"><i class=\'remove-icon\'></i></span>\n </span>\n");
$templateCache.put("static/7.1.0/partials/directives/dip-control.html","<div ng-hide=\"property.hidden\" ng-switch on=\"property.kind\" class=\"dip-control form-group\">\n    <label ng-class=\"{\'col-sm-5\': large, \'col-sm-3\': !large}\"  class=\"control-label\" for=\"{{ property.name }}\">{{ property.label }} <span ng-if=\"property.required\" id=\"{{ property.name }}-required\" class=\"error\">*</span></label>\n    <div ng-class=\"{\'col-sm-7\': large, \'col-sm-9\': !large}\">\n        <div>\n            <div ng-switch-when=\"STRING\">\n                <input ng-if=\"!property.password\" type=\"text\" id=\"{{ property.name }}\" ng-model=\"container[property.name]\" name=\"{{ property.name }}\" ng-required=\"property.required\" class=\"input-block-level\">\n                <input ng-if=\"property.password\" type=\"password\" id=\"{{ property.name }}\" ng-model=\"container[property.name]\" name=\"{{ property.name }}\" ng-required=\"property.required\" class=\"input-block-level\">\n            </div>\n\n            <input type=\"checkbox\"\n                   id=\"{{ property.name }}\"\n                   class=\"input-block-level\"\n                   name=\"{{ property.name }}\"\n                   ng-switch-when=\"BOOLEAN\"\n                   ng-model=\"container[property.name]\"\n                   ng-required=\"property.required\">\n\n            <input type=\"number\"\n                   id=\"{{ property.name }}\"\n                   class=\"input-block-level\"\n                   name=\"{{ property.name }}\"\n                   ng-switch-when=\"INTEGER\"\n                   ng-model=\"container[property.name]\"\n                   ng-required=\"property.required\">\n\n            <div ng-switch-when=\"ENUM\">\n                <div inline-select-editor\n                     select-options=\"enumItems\"\n                     placeholder=\"Select a value\"\n                     name=\"{{ property.name }}\"\n                     model=\"container[property.name]\"\n                     id=\"{{ property.name }}\"\n                     class=\"field\"\n                     ng-required=\"property.required\">\n                    {{ container[property.name] }}\n                </div>\n            </div>\n\n            <div ng-switch-when=\"CI\" ng-if=\"ConfigurationInstances.loaded()\">\n                <div inline-select-editor\n                     select-options=\"ConfigurationInstances.getInstancesByType(property.referencedType)\"\n                     placeholder=\"Select a CI\"\n                     name=\"{{ property.name }}\"\n                     model=\"container[property.name]\"\n                     id=\"{{ property.name }}\"\n                     class=\"field\"\n                     ng-required=\"property.required\">\n                    {{ ConfigurationInstances.getTitle(container[property.name]) }}\n                </div>\n            </div>\n\n            <div ng-switch-when=\"SET_OF_STRING\">\n                <div xl-dip-set\n                     class=\"field\"\n                     name=\"{{ property.name }}\"\n                     ng-model=\"container[property.name]\"\n                     metadata=\"{name: property.name, required: property.required }\"\n                     read-only=\"false\">\n                </div>\n            </div>\n            <div ng-switch-when=\"LIST_OF_STRING\">\n                <div xl-dip-list\n                     class=\"field\"\n                     name=\"{{ property.name }}\"\n                     ng-model=\"container[property.name]\"\n                     metadata=\"{name: property.name, required: property.required }\"\n                     read-only=\"false\">\n                </div>\n            </div>\n            <div ng-switch-when=\"MAP_STRING_STRING\">\n                <span ng-if=\"!property.password\">\n                    <div xl-dip-map-string-string\n                         class=\"field\"\n                         ng-model=\"container[property.name]\"\n                         name=\"{{ property.name} }\"\n                         read-only=\"false\"\n                         metadata=\"{name: property.name, required: property.required, minVisibleRow: 5}\"\n                         open-on-click=\"true\">\n                    </div>\n                </span>\n            </div>\n        </div>\n        <div class=\"description\" ng-if=\"property.label != property.description && !isError(form[property.name])\">{{ ::property.description }}</div>\n        <div class=\"field-errors\" ng-if=\"isError(form[property.name])\">\n            <span ng-if=\"form[property.name].$error.required\">{{ ::property.label }} is mandatory</span>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/duration-editor-fields.html","<table>\n    <tbody>\n        <tr>\n            <td>\n                <input type=\"text\" class=\"days\"\n                       ng-model=\"durationData.days\" ng-required=\"true\"\n                       ng-keydown=\"keyDown($event)\" ng-keypress=\"keyPress($event)\"/>\n            </td>\n            <td class=\"duration-label\">days</td>\n            <td>\n                <input type=\"text\" class=\"hours\"\n                       ng-model=\"durationData.hours\" ng-required=\"true\"\n                       ng-keydown=\"keyDown($event)\" ng-keypress=\"keyPress($event)\"/>\n            </td>\n            <td class=\"duration-label\">hours</td>\n            <td>\n                <input type=\"text\" class=\"minutes\"\n                       ng-model=\"durationData.minutes\" ng-required=\"true\"\n                       ng-keydown=\"keyDown($event)\" ng-keypress=\"keyPress($event)\"/>\n            </td>\n            <td class=\"duration-label\">mins</td>\n        </tr>\n    </tbody>\n</table>\n");
$templateCache.put("static/7.1.0/partials/directives/duration-editor.html","<span class=\"pull-right remove-duration\" ng-click=\"removeDuration()\" ng-if=\"hasDuration(duration) && editable()\"><i class=\'remove-icon\'></i></span>\n<div class=\"duration-editor\" ng-class=\"{\'editable\': editable()}\" ng-click=\"showDurationPicker()\">\n    <span class=\"duration placeholder\" ng-if=\"!hasDuration(duration) || !editable()\" ng-class=\"{\'done\': done()}\">\n        {{inferredDuration()  | prettyDuration}}\n    </span>\n    <span class=\"duration\" ng-click=\"showDurationPicker()\" ng-if=\"hasDuration(duration) && editable()\">{{duration | prettyDuration}}</span>\n</div>");
$templateCache.put("static/7.1.0/partials/directives/grid-date-editor.html","<div date-time-picker date=\"date\" class=\"date-editor\">\n    <span class=\"date date-picker-holder col-sm-12\">\n        <div class=\"left-inner-addon\">\n            <i class=\"glyphicon glyphicon-calendar\"></i>\n            <input ng-if=\"date\" type=\"text\" class=\"ui-grid-filter-input\" ng-attr-placeholder=\"{{placeholder || \'\'}}\" readonly\n                   value=\"{{date | toDate | date:\'shortDate\' }}\" />\n            <input ng-if=\"!date\" type=\"text\" class=\"ui-grid-filter-input\" ng-attr-placeholder=\"{{placeholder || \'\'}}\" readonly value=\"\" />\n        </div>\n    </span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/members-input.html","<ul class=\"tags\">\n    <li ng-repeat=\"tag in tags\" class=\"tag\" ng-class=\"tag.type | lowercase\">\n        <span class=\"tag-icon\"></span>\n        <span class=\"tag-label\" display-member=\"tag\"></span>\n        <a class=\"tag-close\" ng-hide=\"readOnly\" ng-click=\"remove(tag)\">\n            <span class=\"tag-close-icon\"><i class=\'remove-icon\'></i></span>\n        </a>\n    </li>\n    <li class=\"tag-new\" ng-hide=\"readOnly\">\n        <input class=\"tag-input\" type=\"text\" ng-model=\"newTag\" placeholder=\"{{ placeholder }}\"/>\n    </li>\n</ul>\n");
$templateCache.put("static/7.1.0/partials/directives/modal-date-editor.html","<div ng-show=\"!readonly()\">\n    <div ng-show=\"dateModel\" class=\"pull-right remove-date\" ng-click=\"removeDate()\"><i class=\'remove-icon\'></i></div>\n    <div class=\"date-editor\" date-time-picker date=\"dateModel\">\n        <div class=\"modal-section\">{{dateTitle}}</div>\n        <div class=\"date\">\n            <div ng-class=\"{\'placeholder\': dateModel == undefined}\" time-zone-tooltip ng-include=\"\'partials/directives/modal-date-fields.html\'\">\n            </div>\n        </div>\n        <a class=\"date-picker-holder\"></a>\n\n        <div class=\"time bootstrap-timepicker\" time-zone-tooltip>\n            <i class=\"time-icon\"></i>\n            <span class=\"time-picker-holder\">\n                <input readonly=\"readonly\" type=\"text\" ng-class=\"{placeholder: !dateModel}\" value=\"{{ displayedDate() | toDate | date:\'shortTime\' }}\"/>\n            </span>\n        </div>\n\n    </div>\n</div>\n<div ng-show=\"readonly()\" class=\"date-editor\">\n    <div class=\"modal-section\">{{dateTitle}}</div>\n    <div class=\"date-readonly\" ng-class=\"{\'placeholder\': dateModel == undefined}\">\n        <div ng-include=\"\'partials/directives/modal-date-fields.html\'\">\n        </div>\n    </div>\n\n    <div class=\"time-readonly\">\n        <div>\n            <span time-zone-tooltip ng-class=\"{\'placeholder\': dateModel == undefined}\">\n                <i class=\"time-icon\"></i>\n                {{displayedDate() | toDate | date:\'shortTime\'}}\n            </span>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/modal-date-fields.html","<div class=\"day\">{{displayedDate() | toDate | date:\'dd\'}}</div>\n<div class=\"date-detail\" time-zone-tooltip>\n    {{displayedDate() | toDate | date:\'MMMM yyyy\'}}<br/>\n    {{displayedDate() | toDate | date:\'EEEE\'}}\n</div>\n<div class=\"clearfix\"></div>");
$templateCache.put("static/7.1.0/partials/directives/pagination.html","<div id=\"cisLoader\" ng-show=\"ciLoader\">\n    <div ng-show=\"ciLoader.isLoading()\">\n        <img src=\"static/7.1.0/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/>\n    </div>\n    <div ng-show=\"!ciLoader.isLoading()\">\n        <button type=\"button\" class=\"button\" ng-show=\"ciLoader.hasMoreCis()\" ng-click=\"ciLoader.loadNextCis()\">Show more</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/tags-input.html","<ul class=\"tags\">\n    <li ng-repeat=\"tag in tags\" class=\"tag\" ng-class=\"{\'tag-read-only\': readOnly}\">\n        <span class=\"tag-icon\"></span>\n        <span class=\"tag-label\">{{ tag }}</span>\n        <a class=\"tag-close\" ng-hide=\"readOnly\" ng-click=\"remove(tag)\">\n            <span class=\"tag-close-icon\"><i class=\'remove-icon\'></i></span>\n        </a>\n    </li>\n    <li class=\"tag-new\" ng-hide=\"readOnly\">\n        <input class=\"tag-input\" type=\"text\" ng-model=\"newTag\" placeholder=\"{{ placeholder }}\"/>\n    </li>\n</ul>\n");
$templateCache.put("static/7.1.0/partials/directives/users-input.html","<ul class=\"tags\">\n    <li ng-repeat=\"tag in tags\" class=\"tag\">\n        <span class=\"tag-icon principal\"></span>\n        <span class=\"tag-label\" display-user=\"tag\"></span>\n        <a class=\"tag-close\" ng-hide=\"readOnly\" ng-click=\"remove(tag)\">\n            <span class=\"tag-close-icon\"><i class=\'remove-icon\'></i></span>\n        </a>\n    </li>\n    <li class=\"tag-new\" ng-hide=\"readOnly\">\n        <input class=\"tag-input\" type=\"text\" ng-model=\"newTag\" placeholder=\"{{ placeholder }}\"/>\n    </li>\n</ul>\n");
$templateCache.put("static/7.1.0/partials/directives/xlr-dip-of-inline-with-variables.html","\n<div ng-repeat=\"p in xlrDipCtrl.propertyDefinitions\" ng-switch on=\"p.kind\" class=\"form-group\">\n\n    <label class=\"col-xs-3 control-label\" for=\"{{ p.name }}\">\n        {{ p.label }}\n        <span ng-if=\"p.required && xlrDipCtrl.showRequiredSign\" id=\"{{ p.name }}-required\" class=\"error\">*</span>\n    </label>\n\n    <div class=\"col-xs-9\" id=\"{{ p.name }}\">\n\n        <div ng-switch-when=\"STRING\">\n            <div ng-if=\"!p.password && xlrDipCtrl.showVariableSelectorForText\"\n                 xlr-inline-text-with-variables\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 variables=\"xlrDipCtrl.variables\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\">\n            </div>\n            <span ng-if=\"!p.password && !xlrDipCtrl.showVariableSelectorForText\">\n                <span ng-if=\"!xlrDipCtrl.readOnly\">\n                    <span inline-text-editor\n                          class=\"field\"\n                          ng-if=\"p.size != \'LARGE\'\"\n                          model=\"xlrDipCtrl.propertyValues[p.name]\"\n                          on-change=\"xlrDipCtrl.onChange()\"\n                          name=\"{{::p.name}}\">\n                        <span display-variables=\"xlrDipCtrl.propertyValues[p.name]\" variables=\"xlrDipCtrl.variables\"></span>\n                    </span>\n                    <span inline-textarea-editor\n                          class=\"field\"\n                          ng-if=\"p.size == \'LARGE\'\"\n                          model=\"xlrDipCtrl.propertyValues[p.name]\"\n                          on-change=\"xlrDipCtrl.onChange()\"\n                          name=\"{{::p.name}}\">\n                        <span display-variables=\"xlrDipCtrl.propertyValues[p.name]\" variables=\"xlrDipCtrl.variables\" keep-new-lines></span>\n                    </span>\n                </span>\n                <span ng-if=\"xlrDipCtrl.readOnly\" class=\"field-readonly read-only\">\n                    <span display-variables=\"xlrDipCtrl.propertyValues[p.name]\" variables=\"xlrDipCtrl.variables\" keep-new-lines></span>\n                </span>\n            </span>\n\n            <span ng-if=\"p.password\">\n                <div xlr-inline-password-with-variables\n                     name=\"p.name\"\n                     model=\"xlrDipCtrl.propertyValues[p.name]\"\n                     on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                     on-change=\"xlrDipCtrl.onChange()\"\n                     variables=\"xlrDipCtrl.variables\"\n                     read-only=\"xlrDipCtrl.readOnly\"\n                     enforce-mode=\"xlrDipCtrl.enforceMode\"></div>\n            </span>\n        </div>\n\n        <div ng-switch-when=\"INTEGER\">\n            <div xlr-integer-with-variables\n                 class=\"field\"\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 variables=\"xlrDipCtrl.variables\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\">\n            </div>\n        </div>\n\n        <div ng-switch-when=\"BOOLEAN\">\n            <div xlr-boolean-with-variables\n                 class=\"field\"\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 variables=\"xlrDipCtrl.variables\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\"></div>\n        </div>\n\n        <div ng-switch-when=\"DATE\">\n            <div xlr-date-with-variables\n                 class=\"field\"\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 variables=\"xlrDipCtrl.variables\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\">\n            </div>\n        </div>\n\n        <span ng-switch-when=\"CI\" ng-if=\"xlrDipCtrl.ConfigurationInstances.loaded()\">\n            <div inline-select-editor\n                 ng-if=\"!xlrDipCtrl.readOnly\"\n                 name=\"{{::p.name}}\"\n                 select-options=\"xlrDipCtrl.selectOptions(p)\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 on-change=\"xlrDipCtrl.onChange();\"\n                 class=\"field\">\n                {{ xlrDipCtrl.ConfigurationInstances.getTitle(xlrDipCtrl.propertyValues[p.name]) }}\n            </div>\n            <span ng-if=\"xlrDipCtrl.readOnly\" class=\"field-readonly\">\n                {{ xlrDipCtrl.ConfigurationInstances.getTitle(xlrDipCtrl.propertyValues[p.name]) }}\n            </span>\n        </span>\n\n        <div ng-switch-when=\"LIST_OF_STRING\">\n            <div xlr-list-of-strings-with-variables\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 variables=\"xlrDipCtrl.variables\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\"></div>\n        </div>\n        <div ng-switch-when=\"SET_OF_STRING\">\n            <div xlr-set-of-strings-with-variables\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 variables=\"xlrDipCtrl.variables\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\"></div>\n        </div>\n        <div ng-switch-when=\"MAP_STRING_STRING\">\n            <div xlr-map-string-string-with-variables\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 variables=\"xlrDipCtrl.variables\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\"></div>\n        </div>\n\n        <div ng-switch-when=\"ENUM\">\n            <div inline-select-editor\n                 select-options=\"p.enumValues\"\n                 placeholder=\"Select a value\"\n                 name=\"{{p.name}}\"\n                 model=\"xlrDipCtrl.propertyValues[p.name].value\"\n                 id=\"{{p.name}}\"\n                 class=\"field\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 ng-required=\"{{p.required}}\">\n                {{ xlrDipCtrl.propertyValues[p.name].value }}\n            </div>\n        </div>\n\n        <div class=\"description\" ng-if=\"p.description != p.label\">{{ ::p.description }}</div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/filters/from-to-date-filters.html","<div class=\"from-to-date-filters\">\n    <div class=\"date-filter from-date\">\n        <b>From:</b>\n        <div date-editor date=\"filters.from\" deletable=\"true\" class=\"date-filter_date\"></div>\n    </div>\n    <div class=\"date-filter to-date\">\n        <b>To:</b>\n        <div date-editor date=\"filters.to\" deletable=\"true\" class=\"date-filter_date\"></div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/filters/time-filters.html","<div class=\"actions\">\n    <div class=\"btn-group time-frame\">\n        <button type=\"button\" class=\"btn\" ng-click=\"filters.timeFrame = \'LAST_MONTH\'\" ng-class=\"{active: filters.timeFrame == \'LAST_MONTH\'}\">Last 30 days</button>\n        <button type=\"button\" class=\"btn\" ng-click=\"filters.timeFrame = \'LAST_THREE_MONTHS\'\" ng-class=\"{active: filters.timeFrame == \'LAST_THREE_MONTHS\'}\">Last 3 months</button>\n        <button type=\"button\" class=\"btn\" ng-click=\"filters.timeFrame = \'LAST_SIX_MONTHS\'\" ng-class=\"{active: filters.timeFrame == \'LAST_SIX_MONTHS\'}\">Last 6 months</button>\n        <button type=\"button\" class=\"btn\" ng-click=\"filters.timeFrame = \'LAST_YEAR\'\" ng-class=\"{active: filters.timeFrame == \'LAST_YEAR\'}\">Last year</button>\n        <button type=\"button\" class=\"btn\" ng-click=\"filters.timeFrame = \'RANGE\'\" ng-class=\"{active: filters.timeFrame == \'ALL_TIME\' || filters.timeFrame == \'RANGE\'}\">Range</button>\n    </div>\n</div>\n<div class=\"dates\" ng-if=\"filters.timeFrame == \'ALL_TIME\' || filters.timeFrame == \'RANGE\'\">\n    <div ng-include=\"\'partials/filters/from-to-date-filters.html\'\"></div>\n</div>\n<div class=\"dates\" ng-if=\"filters.timeFrame != \'ALL_TIME\' && filters.timeFrame != \'RANGE\'\">\n        <span class=\"date-filter from-date\">\n            <b>From:</b>\n            <span class=\"date-filter-editor\">\n                <span class=\"date date-picker-holder\">\n                    {{filters.timeFrame == \'LAST_MONTH\' ? \'Last 30 days\' : \'\'}}\n                    {{filters.timeFrame == \'LAST_THREE_MONTHS\' ? \'Last 3 months\' : \'\'}}\n                    {{filters.timeFrame == \'LAST_SIX_MONTHS\' ? \'Last 6 months\' : \'\'}}\n                    {{filters.timeFrame == \'LAST_YEAR\' ? \'Last year\' : \'\'}}\n                </span>\n            </span>\n        </span>\n        <span class=\"date-filter to-date\">\n            <b>To:</b>\n            <span class=\"date-filter-editor\">\n                <span class=\"date date-picker-holder\">\n                    Present\n                </span>\n            </span>\n        </span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/flags/delayed-line-directive.html","<div class=\"delayed-line\">\n    <span class=\"warning-padding\">\n        <span class=\"warning-icon icon\"></span>\n        <span>Task {{ task.title }} is delayed</span>\n        <span ng-transclude></span>\n    </span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/flags/flag-line-directive.html","<div ng-show=\"isItemFlagged(item)\" class=\"flag-line {{ item.flag.status | lowercase }}\">\n    <span class=\"flag-padding\">\n        <span class=\"flags\">\n            <span class=\"flag-icon {{ item.flag.status | lowercase }}\"></span>\n        </span>\n        <span ng-if=\"item.flag.comment.length\">{{item.flag.comment}}</span>\n        <span ng-if=\"!item.flag.comment.length && isFlaggedAttentionNeeded(item)\">Attention needed</span>\n        <span ng-if=\"!item.flag.comment.length && isFlaggedAtRisk(item)\">At risk</span>\n        <span ng-transclude></span>\n    </span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/flags/flag-picker.html","<div class=\"flag-picker-popover\">\n    <div class=\"ok\" ng-click=\"flag(\'OK\')\" hide-popover-on-click></div>\n    <div class=\"attention_needed\" ng-click=\"flag(\'ATTENTION_NEEDED\')\" hide-popover-on-click></div>\n    <div class=\"at_risk\" ng-click=\"flag(\'AT_RISK\')\" hide-popover-on-click></div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/flags/other-alerts.html","<span ng-if=\"releasesAlerts[release.id].totalAlerts > 1\">\n    |\n    <a ng-href=\"#/releases/{{release.id}}/summary\" class=\"link\" stop-click-propagation>\n        See all alerts\n    </a>\n</span>\n");
$templateCache.put("static/7.1.0/partials/index/main-menu-extension-container.html","<div class=\"content\">\n    <h4 ng-if=\"vm.menuExtension && !vm.menuExtension.uri\">\n        No <strong>uri</strong> parameter specified in menu item \"{{ vm.menuExtension.label }}\". Please check your plugin.\n    </h4>\n    <div ng-if=\"vm.menuExtension.uri\" ng-include=\"\'static/7.1.0/\' + vm.menuExtension.uri\"></div>\n</div>");
$templateCache.put("static/7.1.0/partials/inline-editor/inline-drop-down-list.html","<div class=\"inline-drop-down-list-editor\">\n    <div class=\"ui-front\" inline-simple-select-editor\n         name=\"{{$ctrl.variable.key}}\"\n         select-options=\"$ctrl.values\"\n         model=\"$ctrl.variable\"\n         on-change=\"$ctrl.onChange({variable: $ctrl.variable})\"\n         ng-required=\"$ctrl.variable.requiresValue\">\n    </div>\n</div>");
$templateCache.put("static/7.1.0/partials/inline-editor/list.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    <span ng-show=\"model\" class=\"text\" ng-transclude></span>\n    <span ng-hide=\"model\" class=\"text placeholder light-text\">{{placeholder}}</span>\n    <span class=\"edit-icon\"></span>\n</div>\n<label class=\"edit\">\n    <input class=\"editable\" type=\"text\" name=\"{{name}}\" ng-show=\"editMode\" ng-model=\"draft\" ng-list ng-required=\"isRequired\"/>\n    <span class=\"error\" ng-show=\"isRequired && draft == \'\'\">*</span>\n</label>\n");
$templateCache.put("static/7.1.0/partials/inline-editor/number-field.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    <span class=\"text\" ng-show=\"isNumber(model)\" ng-transclude></span>\n    <span ng-hide=\"isNumber(model)\" class=\"text placeholder light-text\">{{ placeholder }}</span>\n    <span class=\"edit-icon\"></span>\n</div>\n<label class=\"edit\" ng-show=\"editMode\">\n    <input class=\"editable\" type=\"number\" name=\"{{name}}\" ng-model=\"draft\" ng-required=\"isRequired\"/>\n    <span class=\"error\" ng-show=\"isRequired && draft == \'\'\">*</span>\n</label>\n");
$templateCache.put("static/7.1.0/partials/inline-editor/password-field.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    <span class=\"text\" ng-show=\"hasText(model)\" ng-transclude></span>\n    <span ng-hide=\"hasText(model)\" class=\"text placeholder light-text\">{{ placeholder }}</span>\n    <span class=\"edit-icon\"></span>\n</div>\n<label class=\"edit\" ng-show=\"editMode\">\n    <input class=\"editable\" type=\"password\" name=\"{{name}}\" ng-model=\"draft\" ng-required=\"isRequired\"/>\n    <span class=\"error\" ng-show=\"isRequired && draft == \'\'\">*</span>\n</label>\n");
$templateCache.put("static/7.1.0/partials/inline-editor/select.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    <span class=\"text\" ng-show=\"model\" ng-transclude></span>\n    <span class=\"text placeholder light-text\" ng-hide=\"model\">{{placeholder}}</span>\n    <span class=\"edit-icon\"></span>\n</div>\n<label class=\"edit\" ng-show=\"editMode\">\n    <select class=\"editable\" name=\"{{name}}\" ng-model=\"draft\" ng-options=\"option.id as option.title for option in selectOptions\" ng-required=\"isRequired\"></select>\n</label>\n");
$templateCache.put("static/7.1.0/partials/inline-editor/simple-select.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    {{ model.value }}\n    <span class=\"edit-icon\"></span>\n</div>\n<label class=\"edit\" ng-show=\"editMode\">\n    <select class=\"editable\" name=\"{{name}}\" ng-model=\"model.value\" ng-options=\"option as option for option in selectOptions\" ng-required=\"isRequired\"></select>\n</label>\n");
$templateCache.put("static/7.1.0/partials/inline-editor/text-field.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    <span class=\"text\" ng-show=\"hasText(model)\" ng-transclude></span>\n    <span ng-hide=\"hasText(model)\" class=\"text placeholder light-text\">{{ placeholder }}</span>\n    <span class=\"edit-icon\"></span>\n</div>\n<label class=\"edit\" ng-show=\"editMode\">\n    <input class=\"editable\" name=\"{{name}}\" type=\"text\" ng-model=\"draft\" ng-required=\"isRequired\"/>\n    <span class=\"error\" ng-show=\"isRequired && draft == \'\'\">*</span>\n</label>");
$templateCache.put("static/7.1.0/partials/inline-editor/textarea.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display inline-textarea\" ng-hide=\"editMode\">\n    <span class=\"text\" ng-show=\"hasText(model)\" ng-transclude></span>\n    <span class=\"text placeholder light-text\" ng-hide=\"hasText(model)\">{{placeholder}}</span>\n    <span class=\"edit-icon\"></span>\n</div>\n<div class=\"edit inline-textarea\" ng-show=\"editMode\">\n    <textarea class=\"editable\" name=\"{{name}}\" ng-model=\"draft\" rows=\"10\" ng-required=\"isRequired\"></textarea>\n    <div>\n        <span class=\"error\" ng-show=\"isRequired && draft == \'\'\">*</span>\n        <span class=\"ok\">\n            <i class=\"ok-icon\" style=\"vertical-align: middle; margin-right: 5px;\"></i>Save\n        </span>\n        <span class=\"cancel\">\n            <i class=\"remove-icon\" style=\"vertical-align: middle; margin-left: 15px; margin-right: 5px;\"></i>Cancel\n        </span>\n        <span ng-if=\"helpUrl\" style=\"margin-left: 15px; margin-right: 5px;\"><a href=\"{{ helpUrl }}\" target=\"_blank\" style=\"text-decoration: none;\" class=\"help-icon link\" style=\"vertical-align: middle;\"></a></span>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/inline-editor/user.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    <span class=\"text\" ng-show=\"model\" ng-transclude></span>\n    <span ng-hide=\"model\" class=\"text placeholder light-text\">{{ placeholder }}</span>\n    <span class=\"edit-icon\"></span>\n</div>\n<label class=\"edit\" ng-show=\"editMode\">\n    <input class=\"editable\" name=\"{{name}}\" type=\"text\" ng-model=\"draft.username\" ng-required=\"isRequired\"/>\n    <span class=\"error\" ng-show=\"isRequired && draft == \'\'\">*</span>\n</label>\n");
$templateCache.put("static/7.1.0/partials/login/login.html","<div id=\"login\">\n    <div class=\"content\">\n        <div class=\"disabled-page-dialog login-dialog\">\n            <div class=\"disabled-page-title\">\n                Log in\n            </div>\n            <form name=\"loginForm\" ng-submit=\"login()\">\n                <div class=\"login-label\">\n                    <label class=\"control-label\" for=\"inputLogin\">\n                        <span class=\"required\">*</span>\n                        User\n                    </label>\n                </div>\n                <div class=\"login-input\">\n                    <input type=\"text\" id=\"inputLogin\" placeholder=\"Login\" ng-model=\"loginInfo.login\" autofocus required>\n                </div>\n                <div class=\"login-label\">\n                    <label class=\"control-label\" for=\"inputPassword\">\n                        <span class=\"required\">*</span>\n                        Password\n                    </label>\n                </div>\n                <div class=\"login-input\">\n                    <input type=\"password\" id=\"inputPassword\" placeholder=\"Password\" ng-model=\"loginInfo.password\" required>\n                </div>\n                <div ng-include=\"\'partials/menu/license-warning.html\'\"></div>\n                <div class=\"login-button\">\n                    <button class=\"button primary\" type=\"submit\" ng-disabled=\"loginForm.$invalid || security.isAuthenticated()\">Log in</button>\n                </div>\n            </form>\n            <div class=\"error\" ng-show=\'loginInfo.failedStatus == 401\'>\n                The username or password you have entered is incorrect.\n            </div>\n            <div class=\"error\" ng-show=\'loginInfo.failedStatus == 403\'>\n                Permission \'login\' is not granted to you.\n            </div>\n            <div class=\"login-providers\" ng-if=\"providers.length > 0\">\n                <hr/>\n                <div class=\"login-provider\" ng-repeat=\"provider in providers\">\n                    <a class=\"button {{provider.loginCss}}\" ng-click=\"provider.login()\"><img ng-src=\"{{provider.loginIcon}}\">{{provider.loginLabel}}</a>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n<div class=\"disabled-page-background\"></div>\n");
$templateCache.put("static/7.1.0/partials/menu/about.html","<div class=\"modal-content about\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"$dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>About</h4>\n    </div>\n    <div class=\"modal-body\">\n        <p class=\"brand\"><img src=\"static/7.1.0/styles/img/xl_release_logo_purple_no_trademark.svg\" class=\"logo\"/></p>\n        <p class=\"version-text\">Version {{ version }}</p>\n\n        <fieldset id =\"license-box\" ng-if=\"license\">\n            <legend>License information</legend>\n            Expires on <span ng-class=\'{expired: licenseIsExpired() || licenseIsAlmostExpired()}\'>{{ license.expiresAfter | date:\'shortDate\' }}</span><br/>\n            <span ng-show=\"license.maxNumberOfUsers\">Maximum number of users {{ license.maxNumberOfUsers }}<br/></span>\n            <span ng-show=\"license.repositoryId\">Repository ID {{ license.repositoryId }}<br/></span>\n            Licensed to {{ license.licensedTo }}<br/>\n            License version {{ license.version }}<br/>\n            <strong><a href=\"/productregistration\">Renew license</a></strong>\n        </fieldset>\n\n        <p><strong>&copy; 2017 XebiaLabs, Inc. and its affiliates. All rights reserved.</strong></p>\n        <p class=\"brand-xl\"><img src=\"static/7.1.0/styles/img/xebialabs_logo2.svg\"></p>\n    </div>\n</div>\n\n");
$templateCache.put("static/7.1.0/partials/menu/help.html","<help-popover></help-popover>");
$templateCache.put("static/7.1.0/partials/menu/license-warning.html","<span ng-controller=\"licenseController\" class=\"license-warning\">\n    <span ng-if=\"licenseIsAlmostExpired()\">\n        Your XL Release license expires in {{ getNbDaysBeforeExpiration() }} days.\n    </span>\n    <span ng-if=\"licenseIsExpired() && license.repositoryId\">\n        Your repository ID is {{ license.repositoryId }}\n    </span>\n</span>\n");
$templateCache.put("static/7.1.0/partials/menu/navigation-menu-item.html","<li ng-class=\"{ active: $ctrl.isItemActive($ctrl.item) }\" ng-if=\"$ctrl.isPermitted($ctrl.item)\">\n    <a ng-if=\"::$ctrl.isMenuItem\" ng-click=\"$ctrl.goToRoute()\"><span class=\"menu-element\">{{$ctrl.item.label}}</span></a>\n    <div ng-if=\"::$ctrl.hasSubItems\">\n        <span class=\"menu-element\">{{$ctrl.item.label}} <span class=\"caret\"></span></span>\n        <navigation-menu items=\"$ctrl.item.items\" level=\"{{$ctrl.level + 1}}\"></navigation-menu>\n    </div>\n</li>\n");
$templateCache.put("static/7.1.0/partials/menu/navigation-menu.html","<ul class=\"menu-level-{{$ctrl.level}}\">\n    <navigation-menu-item ng-repeat=\"menuItem in $ctrl.items\" item=\"menuItem\"></navigation-menu-item>\n</ul>");
$templateCache.put("static/7.1.0/partials/menu/sub-header.html","<div class=\"sub-header\" ng-class=\"{\'full-page\': isFullPage()}\">\n    <div class=\"sub-header-top\">\n        <xlr-breadcrumbs breadcrumbs=\"breadcrumbs\" class=\"pull-left bread-crumbs\"></xlr-breadcrumbs>\n        <xlr-template-label class=\"pull-right\" ng-if=\"isTemplateDetailsPage()\"></xlr-template-label>\n        <div class=\"clearfix\"></div>\n        <span ng-include=\"\'partials/menu/license-warning.html\'\" ng-if=\"!isLoginPage()\"></span>\n    </div>\n</div>");
$templateCache.put("static/7.1.0/partials/profile/profile.html","<div id=\"profile\" class=\"standalone-form\">\n    <div id=\"user-profile-header\" class=\"header\">\n        <button ng-click=\"$ctrl.save()\" ng-disabled=\"profileForm.$invalid || ($ctrl.profile.password != $ctrl.profile.passwordConfirmation)\"\n                class=\"button save primary\">\n            Save\n        </button>\n        <span class=\"last-saved error\" ng-if=\"$ctrl.previousPasswordIsInvalid\">Previous password is invalid.</span>\n        <span ng-if=\"$ctrl.lastSavedDate\" class=\"last-saved\">Last saved on {{ $ctrl.lastSavedDate | date: \'medium\' }}</span>\n        <span doc-icon=\"profile.html\"></span>\n    </div>\n    <div class=\"content-under-header\">\n        <h4>Personal settings for {{ ::$ctrl.username }}</h4>\n        <form ng-if=\"$ctrl.profile\" name=\"profileForm\" id=\"profileForm\" class=\"form-horizontal\" confirm-leave>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"full-name\">Name</label>\n                <div class=\"col-sm-9\">\n                    <input type=\"text\" class=\"input-block-level text\" id=\"full-name\" name=\"full-name\" ng-model=\"$ctrl.profile.fullName\"/>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"email\">Email address</label>\n                <div class=\"col-sm-9\">\n                    <input type=\"email\" class=\"input-block-level email\" id=\"email\" name=\"email\" ng-model=\"$ctrl.profile.email\" autofocus/>\n                    <span class=\"error\" ng-if=\"profileForm.email.$error.email\">Malformed email address</span>\n                </div>\n            </div>\n            <br/>\n\n            <div ng-if=\"$ctrl.isJcrUser($ctrl.profile)\">\n                <h4>Change password</h4>\n\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\" for=\"previousPassword\">Previous password</label>\n                    <div class=\"col-sm-9\">\n                        <input type=\"password\" class=\"input-block-level password\" id=\"previousPassword\" name=\"previousPassword\"\n                               ng-model=\"$ctrl.profile.previousPassword\" ng-required=\"$ctrl.profile.password.length > 0\"/>\n                        <span class=\"error\" ng-if=\"profileForm.previousPassword.$error.required\">Previous password is required when changing passwords</span>\n                    </div>\n                </div>\n\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\" for=\"password\">New password</label>\n                    <div class=\"col-sm-9\">\n                        <input type=\"password\" class=\"input-block-level password\" id=\"password\" name=\"password\"\n                               ng-model=\"$ctrl.profile.password\"/>\n                    </div>\n                </div>\n\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\" for=\"password\">Confirm new password</label>\n                    <div class=\"col-sm-9\">\n                        <input type=\"password\" class=\"input-block-level password\" id=\"passwordConfirmation\" name=\"passwordConfirmation\"\n                               ng-model=\"$ctrl.profile.passwordConfirmation\"/>\n                        <span class=\"error\" ng-if=\"$ctrl.profile.password != $ctrl.profile.passwordConfirmation\">Passwords don\'t match</span>\n                    </div>\n                </div>\n            </div>\n            <br/>\n\n            <h4>Personal regional settings</h4>\n\n            <div class=\"help\">\n                These settings control date formats, time formats, and the first day of the week in the calendar.\n                Changes made here will be used instead of the default browser settings.\n            </div>\n\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Date format</label>\n                <div class=\"col-sm-9\">\n                    <select ng-model=\"$ctrl.profile.dateFormat\" ng-options=\"$ctrl.getDateLabel(format) for format in ::$ctrl.dateFormats\"></select>\n                </div>\n            </div>\n\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Time format</label>\n                <div class=\"col-sm-9\">\n                    <select ng-model=\"$ctrl.profile.timeFormat\" ng-options=\"$ctrl.getTimeLabel(format) for format in ::$ctrl.timeFormats\"></select>\n                </div>\n            </div>\n\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">First day of week</label>\n                <div class=\"col-sm-9\">\n                    <select ng-model=\"$ctrl.profile.firstDayOfWeek\"\n                            ng-options=\"$ctrl.getFirstDayOfWeekLabel(format) for format in ::$ctrl.firstDayOfWeekFormats\"></select>\n                </div>\n            </div>\n        </form>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/abort-release-modal-ctrl-binding.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>Abort Release</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to abort the release <b>{{ctrl.release.title}}</b>.\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button continue primary\" ng-click=\"ctrl.onAbort(ctrl.release);dismiss()\">Abort</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/abort-release-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>Abort Release</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to abort the release <b>{{release.title}}</b>.\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button continue primary\" ng-click=\"abortRelease(release);dismiss()\">Abort</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/add-attachment-modal.html","<div id=\"addAttachmentModal\" class=\"modal-content\" upload upload-url=\"upload/attachment/{{release.id}}\">\n    <form name=\"addAttachmentForm\" id=\"addAttachmentForm\" class=\"form-horizontal\">\n        <div class=\"modal-header\">\n            <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n            <h4>Add attachment</h4>\n        </div>\n        <div>\n            <div class=\"modal-body\">\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\" for=\"addAttachment-file\">Attachment<span ng-if=\"addAttachmentForm.$error.required\" class=\"error\">*</span></label>\n\n                    <div class=\"col-sm-9\">\n                        <input type=\"file\" ng-model=\"file\" file-input id=\"addAttachment-file\" required></input>\n                        <span class=\"error\" ng-show=\"addAttachmentForm.$error.required\">Attachment required</span>\n                    </div>\n                    <span class=\"error pull-right\" ng-show=\"UploadService.data.error\">An upload error occurred</span>\n                </div>\n                <img class=\"pull-right\" src=\"static/7.1.0/styles/img/ajax-loader.gif\" ng-show=\"UploadService.data.loading\"/>\n            </div>\n            <div class=\"modal-footer\">\n                <button class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n                <button class=\"button import primary\" ng-disabled=\"addAttachmentForm.$invalid\" ng-click=\"upload(file)\">Import</button>\n            </div>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/completed-release-filter.html","<div id=\"filter-container\">\n    <label class=\"filter-item\" for=\"display-flagged\">\n        <input type=\"checkbox\" ng-model=\"filters.flagged\" id=\"display-flagged\" ng-change=\"setFilters(release.id, filters)\"/>\n            <span class=\"flag-icon\">Show flagged tasks</span>\n    </label>\n    <label class=\"filter-item\" for=\"display-failed\">\n        <input type=\"checkbox\" ng-model=\"filters.failed\" id=\"display-failed\" ng-change=\"setFilters(release.id, filters)\"/>\n        <span class=\"failure-icon\">Show failed tasks</span>\n    </label>\n    <label class=\"filter-item\" for=\"display-delayed\">\n        <input type=\"checkbox\" ng-model=\"filters.delayed\" id=\"display-delayed\" ng-change=\"setFilters(release.id, filters)\"/>\n        <span class=\"delay-icon\">Show delayed tasks</span>\n    </label>\n    <label class=\"filter-item\" for=\"display-clean\">\n        <input type=\"checkbox\" ng-model=\"filters.clean\" id=\"display-clean\" ng-change=\"setFilters(release.id, filters)\"/> Show clean tasks\n    </label>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/delete-phase-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>Delete Phase</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to delete the phase <b>{{phase.title}}</b>.\n        All tasks within this phase will be deleted.\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" focus-on=\"true\" ng-click=\"deletePhase(phase);dismiss()\">Delete</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/delete-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>Delete Task</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to delete the task <b>{{task.title}}</b>.\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" focus-on=\"true\" ng-click=\"ctrl.deleteTask(container, task);dismiss()\">Delete</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/filter.html","<div id=\"filter-container\">\n    <label class=\"filter-item\" for=\"display-active\">\n        <input type=\"checkbox\" ng-model=\"filters.active\" id=\"display-active\"/> All active releases\n    </label>\n    <label class=\"filter-item\" for=\"display-planned\">\n        <input type=\"checkbox\" ng-model=\"filters.planned\" id=\"display-planned\"/> All planned releases\n    </label>\n    <hr/>\n    <label class=\"filter-item\" for=\"display-completed\">\n        <input type=\"checkbox\" ng-model=\"filters.inactive\" id=\"display-completed\"/> All completed and aborted releases\n    </label>\n    <hr/>\n    <label class=\"filter-item\" for=\"display-only-mine\">\n        <input type=\"checkbox\" ng-model=\"filters.onlyMine\" id=\"display-only-mine\"/> Only my releases\n    </label>\n    <label class=\"filter-item\" for=\"display-only-flagged\">\n        <input type=\"checkbox\" ng-model=\"filters.onlyFlagged\" id=\"display-only-flagged\"/> Only flagged releases\n    </label>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/move-task-error-modal.html","<div class=\"modal-content modal-error\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>Error</h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>An error occurred while moving the task.</p>\n        <b>Details:</b>\n        <br>\n        <p>{{ moveTaskError }}</p>\n        <br>\n        Please refresh the release.\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"loadRelease();dismiss()\">Refresh</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/phase-details-modal.html","<div class=\"modal-content\" ng-controller=\"phaseDetailsController\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4 ng-if=\"isEditable()\" class=\"phase-title\" inline-text-editor model=\"phase.title\" on-change=\"updatePhase(phase)\">\n            <span display-variables=\"phase.title\" variables=\"release.variables\"></span>\n        </h4>\n        <h4 ng-if=\"!isEditable()\" class=\"phase-title\">{{phase.title}}</h4>\n    </div>\n    <div class=\"modal-body\">\n        <div class=\"alert alert-warning\" ng-show=\"warning.displayScheduledStartDateBefore && !phase.startDate\"><i class=\"small-warning-icon\"></i>Start date is before the scheduled start date of the release, which is {{release.scheduledStartDate | date:\'medium\'}}</div>\n        <div class=\"alert alert-warning\" ng-show=\"warning.displayScheduledStartDateAfter && !phase.startDate\"><i class=\"small-warning-icon\"></i>Start date is after the due date of the release, which is {{release.dueDate | date:\'medium\'}}</div>\n        <div class=\"alert alert-warning\" ng-show=\"warning.displayDueDateBefore && !phase.endDate\"><i class=\"small-warning-icon\"></i>Due date is before the scheduled start date of the release, which is {{release.scheduledStartDate | date:\'medium\'}}</div>\n        <div class=\"alert alert-warning\" ng-show=\"warning.displayDueDateAfter && !phase.endDate\"><i class=\"small-warning-icon\"></i>Due date is after the due date of the release, which is {{release.dueDate | date:\'medium\'}}</div>\n        <div class=\"pull-left left-detail\">\n            <div ng-show=\"isEditable()\">\n                <div inline-textarea-editor\n                     placeholder=\"Set phase description\"\n                     model=\"phase.description\"\n                     on-change=\"updatePhase(phase)\"\n                     markdown\n                     class=\"phase-description\">\n                    <span display-variables=\"phase.description\" variables=\"release.variables\" markdown class=\"markdown\"></span>\n                </div>\n            </div>\n            <div class=\"phase-description\" ng-hide=\"isEditable()\">\n                <span display-variables=\"phase.description\" variables=\"release.variables\" markdown class=\"markdown\"></span>\n            </div>\n        </div>\n        <div class=\"pull-right right-detail\">\n            <div class=\"scheduled-start-date\" ng-if=\"!phase.startDate\"\n                 modal-date-editor\n                 date-model=\"phase.scheduledStartDate\"\n                 on-change=\"planning.updateScheduledStartDate(phase)\"\n                 readonly=\"!isEditable()\"\n                 inferred-date=\"planning.planElement.displayStartDate\"\n                 date-title=\"Start date\">\n            </div>\n            <div class=\"start-date\" ng-if=\"phase.startDate\"\n                 modal-date-editor\n                 date-model=\"phase.startDate\"\n                 date-title=\"Start date\"\n                 inferred-date=\"planning.planElement.displayStartDate\"\n                 readonly=\"true\">\n            </div>\n            <div class=\"due-date\" ng-if=\"!phase.endDate\"\n                 modal-date-editor\n                 date-model=\"phase.dueDate\"\n                 on-change=\"planning.updateDueDate(phase)\"\n                 readonly=\"!isEditable()\"\n                 inferred-date=\"planning.planElement.displayEndDate\"\n                 date-title=\"Due date\">\n            </div>\n            <div class=\"end-date\" ng-if=\"phase.endDate\"\n                 modal-date-editor\n                 date-model=\"phase.endDate\"\n                 date-title=\"End date\"\n                 inferred-date=\"planning.planElement.displayEndDate\"\n                 readonly=\"true\">\n            </div>\n            <div class=\"modal-section\">\n                Duration\n            </div>\n            <div duration-editor\n                 duration=\"phase.plannedDuration\"\n                 inferred-duration=\"planning.planElement.displayDuration\"\n                 on-change=\"planning.updateDuration(phase)\"\n                 editable=\"isEditable()\"\n                 done=\"phase.done\"/>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/release-editor.html","<div id=\"release\" class=\"{{ release.status | lowercase }}\">\n    <div id=\"navigator-toggler\" ng-show=\"hasOverflow\" ng-click=\"showNavigator = !showNavigator\"\n         ng-class=\"{\'navigator-opened\': showNavigator, \'navigator-shifted\': release.status !== \'TEMPLATE\'}\">\n        <div class=\"arrow-container\">\n            <i class=\"arrow\" ng-class=\"{\'arrow-gray-left\': hasOverflow && showNavigator, \'arrow-gray-right\': hasOverflow && !showNavigator}\"></i>\n        </div>\n    </div>\n    <div id=\"navigator\" ng-show=\"showNavigator && hasOverflow\"\n         ng-class=\"{\'navigator-shifted\': release.status !== \'TEMPLATE\'}\">\n        <div class=\"phase-link-container\" ng-if=\"areDonePhasesCollapsed(release)\">\n            <div class=\"phase-link\">Completed phases <br>\n                <span class=\"light-text\">\n                    <span ng-pluralize\n                          count=\"countPhasesDone(release)\"\n                          when=\"{\'1\': \'{} phase\', \'other\': \'{} phases\'}\"></span> completed\n                </span>\n            </div>\n        </div>\n        <div ng-repeat=\"phase in release.phases | filter:collapseFilter(release)\" class=\"phase-link-container\">\n            <div class=\"phase-link\">\n                {{phase.title}}<br>\n                <span class=\"light-text\" ng-pluralize\n                      count=\"getLeafTasks(phase).length\"\n                      when=\"{\'0\': \'No task\', \'1\': \'{} task\', \'other\': \'{} tasks\'}\"></span>\n            </div>\n        </div>\n    </div>\n    <div worksheet-scrolling class=\"wrapper\">\n        <div release-flow-header>\n            <button type=\"button\" class=\"button dropdown-button completed-release-filter-button\" ng-if=\"isReleaseCompleted(release)\"\n                    bs-popover data-content-template=\"partials/releases/completed-release-filter.html\" data-placement=\"bottom\" auto-close=\"true\">\n                Filter options\n            </button>\n            <a ng-click=\"addPhase()\" class=\"add-phase button\" ng-if=\"!isReleaseCompleted(release) && security.hasEditPermission(release)\">Add Phase</a>\n            <a ng-if=\"isReleasePlanned(release) && security.hasPermission(\'release#start\', release)\" modal=\"\'partials/releases/start-release-modal.html\'\"\n               class=\"start-release primary button\">Start Release</a>\n            <span ng-if=\"isReleasePlanned(release) && release.autoStart\" class=\"timer-icon\"\n                  bs-tooltip\n                  placement=\"bottom\"\n                  data-container=\"body\"\n                  data-title=\"Start date scheduled on\n                    {{release.scheduledStartDate | date: \'mediumDate\'}}\n                    {{release.scheduledStartDate | date: \'shortTime\'}}.\">\n            </span>\n            <a ng-if=\"release.status != \'TEMPLATE\' && security.hasPermission(\'release#abort\', release) && !isReleaseCompleted(release) && !hasAutomatedTaskInProgress\"\n               modal=\"\'partials/releases/abort-release-modal.html\'\" class=\"abort-release button\">Abort Release</a>\n            <a ng-show=\"canRestartPhases(release)\" class=\"restart-phases button\" modal=\"\'partials/releases/restart-phases-modal.html\'\"\n               init=\"computePhasesToRestart()\">Restart Phase...</a>\n            <a class=\"resume primary button\" ng-if=\"canResume(release)\" ng-click=\"resumeRelease(release)\">Resume Release</a>\n            <button type=\"button\" class=\"export-buttons button dropdown-button\" bs-popover\n                    data-content-template=\"partials/releases/template-export-dropdown.html\"\n                    data-placement=\"bottom\"\n                    auto-close=\"true\">\n                Export\n                <span class=\"caret\"></span>\n            </button>\n            <a ng-if=\"countPhasesDone(release) > 0 && !areDonePhasesCollapsed(release) && !isReleaseCompleted(release)\" class=\"button collapse-completed-phases\"\n               ng-click=\"toggleDonePhasesCollapseState(release)\">Hide completed</a>\n\n            <span doc-icon=\"release-flow-editor.html\"></span>\n            <div class=\"release-status-line\" ng-if=\"release.status !== \'TEMPLATE\'\">\n                <release-status-label release=\"release\"></release-status-label>\n                <release-progress-bar progress=\"release.extensions.progress\"></release-progress-bar>\n            </div>\n        </div>\n        <div id=\"release-content\" phase-sortable\n             ng-class=\"{\'navigator-opened\': showNavigator, \'release\': release.status != \'TEMPLATE\', \'template\': release.status === \'TEMPLATE\'}\">\n            <div class=\"phase collapsed drag-disabled\" ng-if=\"areDonePhasesCollapsed(release)\">\n                <div class=\"phase-header-wrapper\">\n                    <div class=\"phase-header\">\n                    <span class=\"phase-title\">\n                        <span ng-pluralize\n                              count=\"countPhasesDone(release)\"\n                              when=\"{\'1\': \'One phase\', \'other\': \'{} phases\'}\"></span> completed\n                    </span>\n                </div>\n                </div>\n                <div class=\"phase-content\">\n                    <a ng-click=\"toggleDonePhasesCollapseState(release)\" class=\"expand link light-text\" stop-click-propagation>View all completed phases</a>\n                </div>\n            </div>\n            <div class=\"phase pull-left overflow\"\n                 ng-repeat=\"phase in release.phases | filter:collapseFilter(release) track by phase.id\"\n                 ng-class=\"{\'drag-disabled\': !isPhasePlanned(phase) || !security.hasEditPermission(release), \'done\': isPhaseReadOnly(phase)}\"\n                 ng-controller=\"containerController\">\n                <div class=\"phase-header-wrapper\" ng-class=\"{\'critical\': isCritical(phase) && isReleaseCompleted(release)}\">\n                    <div class=\"phase-header phase-sort-handle\" ng-style=\"{\'border-top-color\': phase.color}\"\n                         ng-class=\"{\'active-phase\': isPhaseInProgress(phase), \'planned-phase\': isPhasePlanned(phase), \'critical\': isCritical(phase) && isReleaseCompleted(release)}\">\n                        <div class=\"pull-left expander\" ng-if=\"isPhasePlanned(phase)\">\n                            <i class=\"expander-icon\"\n                               ng-class=\"{\'expand-icon\': !isPlannedPhaseCollapsed(phase), \'contract-icon\': isPlannedPhaseCollapsed(phase)}\"\n                               ng-click=\"togglePlannedPhaseCollapseState(phase)\"></i>\n                        </div>\n                        <div ng-if=\"!isPhaseReadOnly(phase) && security.hasEditPermission(release)\" class=\"phase-title\" inline-text-editor model=\"phase.title\"\n                             on-change=\"updatePhase(phase)\" required>\n                            <span display-variables=\"phase.title\" variables=\"release.variables\"></span>\n                        </div>\n                        <span ng-if=\"isPhaseReadOnly(phase) || !security.hasEditPermission(release)\" class=\"phase-title\">{{phase.title}}</span>\n                        <div class=\"actions pull-right\">\n                        <span ng-if=\"!isPhaseReadOnly(phase) && security.hasEditPermission(release)\" color-picker colors=\"PhaseColors\"\n                              current-color=\"phase.color\" tooltip=\"\'Select phase color\'\" on-change=\"updatePhaseColor(phase, color)\" class=\"pick-color\"></span>\n                            <span ng-if=\"!isPhaseReadOnly(phase) && security.hasEditPermission(release)\" ng-click=\"duplicatePhase(phase)\"\n                                  class=\"duplicate-phase\"\n                                  tooltip=\"\'Duplicate phase\'\"><i class=\"duplicate-icon\"></i></span>\n                            <span class=\"phase-details\" modal=\"\'partials/releases/phase-details-modal.html\'\" on-modal-hide=\"loadReleaseAfterPhaseUpdate()\"\n                                  tooltip=\"\'Phase details\'\"><i class=\"details-icon\"></i></span>\n                            <span ng-if=\"!isPhaseReadOnly(phase) && security.hasEditPermission(release) && !isPhaseInProgress(phase)\" class=\"delete-phase\"\n                                  modal=\"\'partials/releases/delete-phase-modal.html\'\" tooltip=\"\'Delete phase\'\"><i class=\"remove-icon\"></i></span>\n                        </div>\n                    </div>\n                </div>\n\n                <div class=\"phase-wrapper\">\n                    <div ng-if=\"!isPhasePlanned(phase) || (isPhasePlanned(phase) && !isPlannedPhaseCollapsed(phase))\" class=\"phase-content\"\n                         ng-class=\"{\'critical\': isCritical(phase) && isReleaseCompleted(release)}\">\n                        <div class=\"phase-content-inner\">\n                            <ul task-sortable ng-model=\"phase.tasks\" class=\"task-sortable\"\n                                ng-class=\"{\'drop-disabled\': isPhaseReadOnly(phase) || !security.hasEditPermission(release)}\">\n                                <li ng-repeat=\"task in phase.tasks | filter:taskFilter(release, filters) track by task.id\" class=\"item-sortable\"\n                                    ng-class=\"{\'drag-disabled\': !isTaskDraggable(task, phase) || !security.hasEditPermission(release)}\">\n                                    <div ng-include=\"\'partials/releases/task-in-release.html\'\"></div>\n                                </li>\n                            </ul>\n                            <div ng-if=\"!isPhaseReadOnly(phase) && security.hasEditPermission(release)\" quick-task-generator add-task=\"addTask(phase, taskForm)\"\n                                 task-definitions=\"taskDefinitions\" class=\"task-generator\"></div>\n                        </div>\n                    </div>\n                    <div class=\"phase-content\" ng-if=\"isPhasePlanned(phase) && isPlannedPhaseCollapsed(phase)\">\n                        <div class=\"phase-content-inner\">\n                            <div class=\"view-nested-tasks\">\n                                <a class=\"link light-text\" ng-click=\"togglePlannedPhaseCollapseState(phase)\">\n                                    View <span ng-pluralize count=\"getLeafTasks(phase).length\"\n                                               when=\"{\'0\': \'{} tasks\', \'1\': \'one task\', \'other\': \'{} tasks\', \'many\': \'{} tasks\', \'few\': \'{} tasks\'}\"></span>\n                                </a>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n    <div modal=\"\'partials/releases/move-task-error-modal.html\'\" open-on=\"moveTaskError\" on-modal-hide=\"resetError()\"></div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/release-flow-header.html","<div id=\"release-header\" class=\"header\" ng-controller=\"releaseHeaderController\">\n    <div class=\"subpage-links\">\n        <span class=\"show-label visible-lg-inline\">Show</span>\n        <button type=\"button\" class=\"button dropdown-button\" bs-popover data-content-template=\"partials/releases/subpages.html\" data-placement=\"bottom\"\n                auto-close=\"true\">\n            {{ page.label }}\n            <span class=\"caret\"></span>\n        </button>\n    </div>\n    <div class=\"btn-group btn-group-padding\">\n        <a class=\"btn btn-flat btn-fixed\" ng-class=\"{\'btn-flat-active\': isActive(\'\')}\" ng-href=\"#/{{releaseTemplateVariable}}/{{release.id}}\">\n            <i class=\"column-view-icon\"/><span class=\"visible-lg-inline\">Flow</span>\n        </a>\n        <a class=\"btn btn-flat btn-fixed\" ng-class=\"{\'btn-flat-active\': isActive(\'/table\')}\" ng-href=\"#/{{releaseTemplateVariable}}/{{release.id}}/table\">\n            <i class=\"table-view-icon\"/><span class=\"visible-lg-inline\">Table</span>\n        </a>\n        <a class=\"btn btn-flat btn-fixed\" ng-class=\"{\'btn-flat-active\': isActive(\'/planner\')}\"\n           ng-href=\"#/{{releaseTemplateVariable}}/{{release.id}}/planner\">\n            <i class=\"gantt-view-icon\"/><span class=\"visible-lg-inline\">Planner</span>\n        </a>\n        <a ng-if=\"release.status == \'TEMPLATE\'\" class=\"btn btn-flat btn-fixed\" ng-class=\"{\'btn-flat-active\': isActive(\'/xfile\')}\"\n           ng-href=\"#/templates/{{release.id}}/xfile\">\n            <i class=\"xfile-view-icon\"/><span class=\"visible-lg-inline\">XFile</span>\n        </a>\n    </div>\n    <release-grid-actions-bar ng-if=\"selectedCount > 0 && isActive(\'/table\')\"></release-grid-actions-bar>\n    <span ng-if=\"showNewReleaseButton()\" ng-if=\"!isActive(\'/table\') || selectedCount === 0\">\n        <a class=\"new-release button primary\" ng-href=\"#/releases/create?fromTemplateId={{ release.id }}\">New release</a>\n    </span>\n    <span ng-transclude ng-if=\"!isActive(\'/table\') || selectedCount === 0\"></span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/release-header.html","<div id=\"release-header\" class=\"header\" ng-controller=\"releaseHeaderController\">\n    <div class=\"subpage-links\">\n        <span class=\"show-label\">Show</span>\n        <button type=\"button\" class=\"button dropdown-button\" bs-popover data-content-template=\"partials/releases/subpages.html\" data-placement=\"bottom\"\n                auto-close=\"true\">\n            {{ page.label }}\n            <span class=\"caret\"></span>\n        </button>\n    </div>\n    <span ng-if=\"showNewReleaseButton()\">\n        <a class=\"new-release button primary\" ng-href=\"#/releases/create?fromTemplateId={{ release.id }}\">New release</a>\n    </span>\n    <span ng-transclude></span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/release-page-extension-container.html","<div ng-if=\"releasePageExtensionCtrl.pageExtension.uri\" ng-include=\"\'static/7.1.0/\' + releasePageExtensionCtrl.pageExtension.uri\"></div>\n<div ng-if=\"releasePageExtensionCtrl.pageExtension && !releasePageExtensionCtrl.pageExtension.uri\">\n    <div release-header></div>\n    <div class=\"content-under-header\">\n        <h4>\n            No <strong>uri</strong> parameter specified in release menu item [{{ releasePageExtensionCtrl.pageExtension.label }}]. Please check your plugin.\n        </h4>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/release-permissions.html","<div id=\"release-permissions\">\n    <div release-header>\n        <button class=\"button primary save\" ng-click=\"$ctrl.save()\" ng-disabled=\"!$ctrl.dirty || $ctrl.readOnly\">Save</button>\n        <button class=\"button reset\" ng-click=\"$ctrl.reset()\" ng-disabled=\"!$ctrl.dirty || $ctrl.readOnly\">Reset</button>\n        <span class=\"last-saved\" ng-if=\"$ctrl.lastSavedDate\">Last saved on {{ $ctrl.lastSavedDate | date: \'medium\' }}</span>\n        <span doc-icon=\"release-permissions.html\"></span>\n    </div>\n    <div class=\"ng-cloak content-under-header\">\n        <p ng-if=\"$ctrl.inherited\">Permissions and Teams are inherited from the folder\n            <span><a ng-href=\"#folders/{{$ctrl.inheritedFrom.id}}/permissions\">{{$ctrl.inheritedFrom.title}}</a></span>\n        </p>\n        <div id=\"teams-permissions-table\" ng-model=\"$ctrl.teamsCollapsed\" bs-collapse>\n            <div>\n                <h4 class=\"title\">\n                    <i class=\"collapse-button\" ng-class=\"{\'arrow-black-down\': !$ctrl.teamsCollapsed, \'arrow-black-right\': $ctrl.teamsCollapsed}\" bs-collapse-toggle></i>\n                    Teams\n                    <button class=\"button primary button-add-team\" ng-click=\"$ctrl.openAddTeamModal()\" ng-disabled=\"$ctrl.readOnly\">New team</button>\n                </h4>\n            </div>\n\n            <permission-table-v2\n                                 columns=\"$ctrl.teamsTableColumns\"\n                                 read-only=\"$ctrl.readOnly\"\n                                 permissions=\"$ctrl.teamsPermissionsContainer\"\n                                 on-update=\"$ctrl.setDirty()\"\n                                 on-remove=\"$ctrl.onRemoveTeam(row)\"\n                                 bs-collapse-target>\n            </permission-table-v2>\n        </div>\n        <div id=\"permissions-table\" ng-model=\"$ctrl.permissionsCollapsed\" bs-collapse>\n            <div>\n                <h4 class=\"title\">\n                    <i class=\"collapse-button\" ng-class=\"{\'arrow-black-down\': !$ctrl.permissionsCollapsed, \'arrow-black-right\': $ctrl.permissionsCollapsed}\" bs-collapse-toggle></i>\n                    {{$ctrl.isTemplate() ? \'Template permissions\' : \'Release permissions\'}}\n                </h4>\n            </div>\n            <permission-table-v2\n                columns=\"$ctrl.permissionsTableColumns\"\n                read-only=\"$ctrl.readOnly\"\n                permissions=\"$ctrl.permissionsContainers\"\n                on-update=\"$ctrl.setDirty()\"\n                bs-collapse-target>\n            </permission-table-v2>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/release-properties.html","<div id=\"release-properties\">\n    <div ng-if=\"!releaseForm.newRelease\" release-header>\n        <span doc-icon=\"release-properties.html\"></span>\n    </div>\n    <div id=\"new-release-header\" class=\"header\" ng-if=\"releaseForm.newRelease\">\n        <h4>Create new release</h4>\n        <span doc-icon=\"release-properties.html\"></span>\n    </div>\n    <div class=\"content-under-header form-content\" ng-class=\"{\'new-release\': releaseForm.newRelease}\">\n        <form name=\"releasePropertiesForm\" id=\"releasePropertiesForm\" class=\"form-horizontal\">\n            <div class=\"row\">\n                <div class=\"col-sm-7\" style=\"padding-right: 50px;\">\n                    <fieldset ng-if=\"releaseForm\">\n                        <legend ng-if=\"!releaseForm.newRelease\">Properties for {{ release.title }}</legend>\n\n                    <div class=\"form-group\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\" for=\"releaseForm-title\">Release name <span ng-if=\"releasePropertiesForm.title.$error.required\" class=\"error\">*</span></label>\n\n                        <div class=\"col-sm-8 col-lg-9\">\n                            <input type=\"text\" name=\"title\" class=\"input-block-level\" id=\"releaseForm-title\" ng-model=\"releaseForm.title\" autofocus required ng-disabled=\"releaseForm.readonly\"/>\n                            <span class=\"error\" ng-if=\"releasePropertiesForm.title.$error.required\">Release name is mandatory</span>\n                        </div>\n                    </div>\n\n                    <div class=\"form-group\" ng-if=\"releaseForm.newRelease\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\" for=\"releaseForm-template\">Use template</label>\n\n                        <div class=\"col-sm-8 col-lg-9\">\n                            <select class=\"input-block-level template-select\" ng-model=\"releaseForm.templateId\" id=\"releaseForm-template\"\n                                    ng-options=\"option.id as option.title for option in templates\" ng-disabled=\"releaseForm.readonly\"\n                                    ng-change=\"updateFormWithTemplate(releaseForm.templateId)\">\n                                <option value=\"\">No template</option>\n                            </select>\n                        </div>\n                    </div>\n\n                    <div class=\"form-group\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">Description</label>\n\n                        <div class=\"col-sm-8 col-lg-9\">\n                            <span class=\"release-description\" ng-if=\"!releaseForm.readonly\" inline-textarea-editor model=\"releaseForm.description\" placeholder=\"Set description...\" markdown>\n                                <span display-variables=\"releaseForm.description\" variables=\"releaseForm.variables\" markdown class=\"markdown\"></span>\n                            </span>\n                            <span ng-if=\"releaseForm.readonly\" class=\"markdown release-description\">\n                                <span display-variables=\"releaseForm.description\" variables=\"releaseForm.variables\" markdown class=\"markdown\"></span>\n                            </span>\n                        </div>\n                    </div>\n\n                    <div class=\"form-group\" ng-if=\"!releaseForm.newRelease\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">Created from template</label>\n                        <div class=\"col-sm-8 col-lg-9 fix-padding\" ng-if=\"!releaseForm.createdFromTemplateId\">No template</div>\n                        <div class=\"col-sm-8 col-lg-9 fix-padding\" ng-if=\"releaseForm.createdFromTemplateId\">\n                            <a ng-if=\"releaseForm.createdFromTemplateTitle\" class=\"created-from-template\" ng-href=\"#/templates/{{releaseForm.createdFromTemplateId}}\">{{releaseForm.createdFromTemplateTitle}}</a>\n                            <span ng-if=\"!releaseForm.createdFromTemplateTitle\">[Template has been deleted]</span>\n                        </div>\n                    </div>\n\n                    <div class=\"form-group\" ng-if=\"releaseForm.startedFromReleaseId\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">Started from release</label>\n                        <div class=\"col-sm-8 col-lg-9\">\n                            <a class=\"started-from-release\" ng-href=\"#/releases/{{releaseForm.startedFromReleaseId}}\">{{releaseForm.startedFromReleaseTitle}}</a>\n                        </div>\n                    </div>\n\n                </fieldset>\n\n                <div class=\"variables\" ng-if=\"releaseForm.newRelease && (releaseForm.variables | filter: variablesFilter).length > 0\">\n                    <span class=\"releaseVariablesLegend\">Release Variables &nbsp;<span doc-icon=\"variables.html\"></span></span>\n\n                    <div variables-editor\n                         variables=\"releaseForm.variables\"\n                         form=\"releasePropertiesForm\"\n                         readonly=\"releaseForm.readonly\"\n                         filter=\"variablesFilter\">\n                    </div>\n                </div>\n                <fieldset class=\"variables\" ng-if=\"!releaseForm.newRelease\">\n                    <legend>Release Variables &nbsp;<span doc-icon=\"variables.html\"></span></legend>\n\n                    <div class=\"help\">\n                        Release variables can be set on the <a ng-href=\"#/releases/{{releaseForm.id}}/variables\">Variables Screen</a>.\n                    </div>\n                </fieldset>\n\n                <div class=\"form-footer\">\n                    <div ng-show=\"creationInProgress\" class=\"progress pull-left\">\n                        <span>Release is being created</span>\n                        <img src=\"static/7.1.0/styles/img/ajax-loader.gif\" ng-show=\"creationInProgress\"/>\n                    </div>\n                    <button class=\"button continue primary\" ng-click=\"releasePropertiesUpdated()\" ng-disabled=\"releasePropertiesForm.$invalid || !releaseForm.hasValidDates || creationInProgress || releaseForm.readonly\">\n                        <span ng-if=\"releaseForm.newRelease\">Create</span>\n                        <span ng-if=\"!releaseForm.newRelease\">Save</span>\n                    </button>\n                    <button ng-if=\"releaseForm.newRelease\" type=\"button\" class=\"button cancel\" ng-click=\"back()\" ng-disabled=\"creationInProgress\">Cancel</button>\n                    <button ng-if=\"!releaseForm.newRelease\" ng-disabled=\"!releasePropertiesForm.$dirty\" type=\"button\" class=\"button\"\n                            ng-click=\"releasePropertiesForm.$setPristine(); initReleaseForm()\" ng-disabled=\"creationInProgress\">Reset</button>\n                    <div ng-if=\"releaseUpdatedAt\" class=\"pull-left last-saved\">Last saved on {{ releaseUpdatedAt | date: \'medium\' }}</div>\n                </div>\n            </div>\n            <div class=\"col-sm-5\">\n                <fieldset>\n                    <legend>Release details</legend>\n\n                    <div class=\"form-group\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\" for=\"releaseForm-flagComment\">Flag status</label>\n\n                        <div class=\"col-sm-8 col-lg-9 flags\">\n                            <div ng-if=\"!releaseForm.readonly\" class=\"flag-icon dropdown-button {{ releaseForm.flag.status | lowercase }}\"\n                                 bs-popover data-content-template=\"partials/flags/flag-picker.html\" data-placement=\"bottom\" auto-close=\"true\"></div>\n                            <div ng-if=\"releaseForm.readonly\" class=\"flag-icon {{ releaseForm.flag.status | lowercase }}\"></div>\n                            &nbsp;\n                            <input type=\"text\" placeholder=\"Set status text...\" class=\"flag-comment\" id=\"releaseForm-flagComment\"\n                                   ng-model=\"releaseForm.flag.comment\" ng-disabled=\"releaseForm.readonly\"/>\n                        </div>\n                    </div>\n                    <hr>\n                    <div class=\"form-group\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">Start date <span ng-if=\"!releaseForm.hasValidDates\" class=\"error\">*</span></label>\n\n                        <div class=\"col-sm-8 col-lg-9\">\n                            <span class=\"scheduled-start-date\" ng-if=\"!releaseForm.started\" date-editor date=\"releaseForm.scheduledStartDate\"\n                                  placeholder=\"No date\" deletable=\"false\" readonly=\"releaseForm.readonly\"\n                                  on-change=\"planning.updateScheduledStartDate(releaseForm)\"></span>\n                            <span ng-if=\"releaseForm.started\" date-editor date=\"releaseForm.startDate\" deletable=\"false\" readonly=\"\'true\'\"></span>\n                            &nbsp;{{CurrentTimeZone.timeZone}}\n                        </div>\n                    </div>\n                    <div class=\"form-group\" ng-if=\"!releaseForm.endDate\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">Due date <span ng-if=\"!releaseForm.hasValidDates\" class=\"error\">*</span></label>\n\n                        <div class=\"due-date col-sm-8 col-lg-9\" date-editor date=\"releaseForm.dueDate\" placeholder=\"No date\" deletable=\"false\"\n                             readonly=\"releaseForm.readonly\" on-change=\"planning.updateDueDate(releaseForm)\">\n                        </div>\n                        <div class=\"col-sm-8 col-lg-9\" ng-if=\"!releaseForm.hasValidDates\">\n                            <span class=\"error\">Start date must be before due date</span>\n                        </div>\n                    </div>\n                    <div class=\"form-group\" ng-if=\"releaseForm.endDate\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">End date</label>\n\n                        <div class=\"col-sm-8 col-lg-9\" date-editor date=\"releaseForm.endDate\" deletable=\"false\" readonly=\"releaseForm.readonly\">\n                        </div>\n                    </div>\n                    <div class=\"form-group\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">Duration</label>\n\n                        <div class=\"col-sm-8 col-lg-9 duration\"\n                             duration-editor\n                             duration=\"releaseForm.plannedDuration\"\n                             inferred-duration=\"planning.planElement.displayDuration\"\n                             editable=\"!releaseForm.readonly\"\n                             on-change=\"planning.updateDuration(releaseForm)\"\n                             done=\"releaseForm.done\"></div>\n                    </div>\n                    <hr>\n                    <div class=\"form-group\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">Release Owner <span ng-if=\"releasePropertiesForm.owner.$error.required\" class=\"error\">*</span></label>\n\n                        <div class=\"col-sm-8 col-lg-9\">\n                        <span class=\"input-block-level release-owner\" ng-if=\"!releaseForm.readonly\" inline-user-editor model=\"releaseForm.owner\"\n                              autocomplete-data=\"allUsers\" name=\"owner\" required>\n                            <span display-user=\"releaseForm.owner\"></span>\n                        </span>\n                            <span ng-if=\"releaseForm.readonly\" class=\"release-owner read-only\"><span display-user=\"releaseForm.owner\"></span></span>\n                        </div>\n                    </div>\n                    <div class=\"form-group\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">Run automated tasks as user</label>\n\n                        <div class=\"col-sm-8 col-lg-9\">\n                        <span class=\"input-block-level script-username\" ng-if=\"!releaseForm.readonly\" inline-user-editor model=\"releaseForm.scriptUsername\"\n                              autocomplete-data=\"allUsers\" placeholder=\"Set user...\" name=\"scriptUsername\">\n                            <span display-user=\"releaseForm.scriptUsername\"></span>\n                        </span>\n                            <span ng-if=\"releaseForm.readonly\" class=\"script-username read-only\"><span display-user=\"releaseForm.scriptUsername\"></span></span>\n                        </div>\n                    </div>\n                    <div class=\"form-group\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">Password</label>\n\n                        <div class=\"col-sm-8 col-lg-9\">\n                        <span class=\"input-block-level script-userpassword\" ng-if=\"!releaseForm.readonly\" inline-password-editor\n                              model=\"releaseForm.scriptUserPassword\" placeholder=\"Set password...\" name=\"scriptUserPassword\">\n                            <span class=\"light-text\">Click here to modify the password</span>\n                        </span>\n                            <span ng-if=\"releaseForm.readonly\" class=\"script-userpassword read-only\"><span class=\"light-text\">*****</span></span>\n                        </div>\n                    </div>\n                    <hr>\n                    <div class=\"form-group\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\" for=\"releaseForm-abortOnFailure\">Abort on failure</label>\n\n                        <div class=\"col-sm-8 col-lg-9\">\n                            <input type=\"checkbox\" ng-model=\"releaseForm.abortOnFailure\" id=\"releaseForm-abortOnFailure\" ng-disabled=\"releaseForm.readonly\"/>\n                        </div>\n                    </div>\n\n                    <div class=\"form-group\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">Tags</label>\n\n                        <div class=\"col-sm-8 col-lg-9\">\n                            <div id=\"tags\" class=\"transparent green-tags\" tags-input tags=\"releaseForm.tags\" placeholder=\"Add a tag...\" read-only=\"releaseForm.readonly\"></div>\n                        </div>\n                    </div>\n\n                    <div class=\"form-group attachments-list\" ng-if=\"!releaseForm.newRelease\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">Attachments</label>\n\n                        <div class=\"col-sm-8 col-lg-9\">\n                            <div attachments-list\n                                 attachments=\"releaseForm.attachments\"\n                                 readonly=\"releaseForm.readonly\"\n                                 upload-url=\"\'upload/attachment/\' + releaseForm.id\"\n                                 can-delete-attachments=\"!releaseForm.readonly\"\n                                 delete-attachment=\"deleteAttachment(attachment)\"></div>\n                        </div>\n                    </div>\n                    <div ng-if=\"!releaseForm.newRelease && releaseForm.hasValidDates\">\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Share calendar</label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <input type=\"checkbox\" ng-model=\"releaseForm.calendarPublished\" id=\"releaseForm-calendarPublished\"\n                                       ng-disabled=\"releaseForm.readonly\"/><label class=\"public-link\" for=\"releaseForm-calendarPublished\">Publish link</label>\n                            </div>\n                            <div class=\"clearfix\"></div>\n                            <span ng-if=\"releaseForm.calendarPublished\" class=\"subscribe-link\" href=\"{{ calendarUrl }}\" target=\"_blank\">{{ calendarUrl }}</span>\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <button type=\"button\" class=\"button download-ics\" ng-click=\"downloadCalendar(releaseForm)\" ng-disabled=\"creationInProgress\">\n                                    Download calendar event\n                                </button>\n                            </div>\n                        </div>\n                    </div>\n                </fieldset>\n            </div>\n            </div>\n        </form>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/release-variables.html","<div id=\"release-variables\">\n    <div release-header>\n        <span>\n            <input id=\"variables-filter\" autofocus type=\"search\" class=\"variables-filter\" placeholder=\"Search...\" ng-model=\"filters.filter\">\n            <span ng-if=\"!readonly\" edit-variable\n                  init-variable=\"newVariable()\"\n                  save=\"createReleaseVariable\"\n                  on-new-variable=\"createReleaseVariable\"\n                  is-new=\"true\"\n                  is-readonly=\"false\"\n                  is-rename-enabled=\"true\"\n                  page-type=\"pageType\"\n                  all-variables=\"allVariables\"\n                  class=\"button primary new-variable\">New variable</span>\n        </span>\n        <span doc-icon=\"variables.html\"></span>\n    </div>\n    <div id=\"variables-content\" class=\"content-under-header\">\n        <div variables-list \n             variables=\"variables\"\n             all-variables=\"allVariables\"\n             filter=\"filters.filter\"\n             on-change=\"updateReleaseVariable\"\n             on-delete=\"deleteReleaseVariable(variable, callback)\"\n             on-reorder=\"reorderReleaseVariables(variables)\"\n             on-new-variable=\"createReleaseVariable\"\n             is-readonly=\"readonly\"\n             is-rename-enabled=\"!readonly && (release.status === \'PLANNED\' || release.status === \'TEMPLATE\')\"\n             page-type=\"pageType\"></div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/restart-phases-modal.html","<div class=\"modal-content restart-phases-modal\" ng-controller=\"restartPhasesController\">\n    <form name=\"restartPhaseForm\" id=\"restartPhaseForm\" class=\"form-horizontal\">\n        <div class=\"modal-header\">\n            <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n            <h4>Restart phase in \'{{release.title}}\'</h4>\n        </div>\n        <div ng-if=\"!releaseRestored\">\n            <div class=\"modal-body\">\n                <div class=\"form-group\">\n                    <span class=\"col-sm-3 control-label\">Restart from phase</span>\n                    <span class=\"col-sm-9\">\n                        <select ng-model=\"restartPhases.fromPhase\" ng-options=\"phase as phase.title for phase in restartPhases.restartables\" ng-change=\"restartPhases.selectFirstTaskOfPhase()\"></select>\n                    </span>\n                </div>\n                <div class=\"form-group\" ng-show=\"restartPhases.canSelectTasks()\">\n                    <span class=\"col-sm-3 control-label\">Task to start with</span>\n                    <span class=\"col-sm-9\"><select ng-model=\"restartPhases.fromTask\" ng-options=\"task as interpolate(task.title) for task in restartPhases.restartableTasks()\"></select></span>\n                </div>\n                <p>\n                    The remaining tasks in the current phase will be skipped, and the release will be paused. When resumed, the release will continue from the first task of the recreated phases.\n                </p>\n            </div>\n            <div class=\"modal-footer\">\n                <div class=\"pull-left\" ng-if=\"phaseRestartInProgress\">\n                    Restarting phase<img src=\"static/7.1.0/styles/img/ajax-loader.gif\"/>\n                </div>\n                <button type=\"button\" class=\"button cancel\" ng-disabled=\"phaseRestartInProgress\" ng-click=\"dismiss()\">Cancel</button>\n                <button type=\"button\" class=\"button continue primary\" ng-disabled=\"phaseRestartInProgress\" ng-click=\"restartPhasesFrom(restartPhases.fromPhase, restartPhases.fromTask)\">Continue</button>\n            </div>\n        </div>\n        <div ng-if=\"releaseRestored\">\n            <div class=\"modal-body\">\n                <p ng-pluralize\n                   count=\"numberOfPhaseRestarted\"\n                   when=\"{\'one\': \'The new phase was added and the release has been paused.\',\n                          \'other\': \'The new phases were added and the release has been paused. \'}\"></p>\n                <p>You can resume the release now or later. By choosing \'Resume now\' you will continue the release flow immediately. If you want to review the newly added phase first or change release variables before carrying on, choose \'Resume later\'.</p>\n            </div>\n            <div class=\"modal-footer\">\n                <button type=\"button\" class=\"button resume-later\" ng-disabled=\"restartPhaseForm.$invalid\" ng-click=\"dismiss()\">Resume later</button>\n                <button type=\"button\" class=\"button resume-now primary\" ng-disabled=\"restartPhaseForm.$invalid\" ng-click=\"resumeRelease(release);dismiss()\">Resume now</button>\n            </div>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/start-release-modal-ctrl-binding.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>{{ctrl.release.title}}</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to start a release.\n        Team members will be notified and once the release start date has been reached, the release flow will commence.\n    </div>\n    <div class=\"modal-body\" ng-if=\"ctrl.release.autoStart\">\n        This release is scheduled to start <strong>automatically</strong> on\n        {{::ctrl.release.scheduledStartDate | date: \'mediumDate\'}}\n        {{::ctrl.release.scheduledStartDate | date: \'shortTime\'}}.\n        Are you sure you want to start the release now?\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.onStart(ctrl.release);dismiss()\">Start</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/start-release-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>{{release.title}}</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to start a release.\n        Team members will be notified and once the release start date has been reached, the release flow will commence.\n    </div>\n    <div class=\"modal-body\" ng-if=\"release.autoStart\">\n        This release is scheduled to start <strong>automatically</strong> on\n        {{::release.scheduledStartDate | date: \'mediumDate\'}}\n        {{::release.scheduledStartDate | date: \'shortTime\'}}.\n        Are you sure you want to start the release now?\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"startRelease(release);dismiss()\">Start</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/subpages.html","<div id=\"subpages-container\">\n    <span>\n        <a ng-repeat=\"subpage in releaseSubpages\"\n           ng-href=\"#/{{release.status == \'TEMPLATE\' ? \'templates\' : \'releases\'}}/{{releaseId}}{{subpage.path}}\"\n           ng-if=\"isSubpageDisplayed(subpage)\"\n           class=\"{{subpage.class}}\">\n            <div><span ng-class=\"{\'active\': page === subpage}\"></span> {{ subpage.label }}</div>\n        </a>\n    </span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/task-in-release.html","<div class=\"arrow-wrapper\">\n    <i class=\"arrow-active\" ng-show=\"isTaskOrPreconditionInProgress(task) && !isTaskGroup(task)\"></i>\n</div>\n<div class=\"task-container task-sort-handle {{task.type | taskTypeCssClass}} {{ task.status | lowercase}}\" ng-class=\"{\'done\': isTaskReadOnly(task), \'active\': isTaskOrPreconditionInProgress(task), \'release-completed\': isReleaseCompleted(release)}\">\n    <div ng-controller=\"taskDetailsController\" class=\"task-box row-fluid {{task.type | taskTypeCssClass}}\" ng-style=\"{\'border-top-color\': isReleaseCompleted(release) ? \'\' : task.color }\" ng-class=\"{\'active\': isTaskOrPreconditionInProgress(task), \'done\': isTaskReadOnly(task), \'planned\': isTaskPlanned(task), \'release-completed\': isReleaseCompleted(release)}\">\n        <div class=\"task {{task.type | taskTypeCssClass}}  {{ task.status | lowercase}}\" ng-class=\"{\'active\': isTaskOrPreconditionInProgress(task)}\">\n            <span ng-if=\"isActiveTask(task)\" scroll-to-me></span>\n            <div class=\"pull-left expander\" ng-if=\"isTaskGroup(task)\">\n                <i ng-class=\"{\'expand-icon\': !isTaskGroupCollapsed(task), \'contract-icon\': isTaskGroupCollapsed(task)}\" ng-click=\"toggleTaskGroupCollapseState(task)\"></i>\n            </div>\n\n            <div ng-if=\"isTaskContextMenuAvailable(task)\" context-menu-popover\n                 items=\"taskContextMenuItems(task, release, container, groupedTaskDefinitions, withinBlackout)\" scrollable-change-task-type=\"true\"></div>\n            <div class=\"cursor-pointer\" ng-click=\"openTaskDetailsModal(task)\">\n                <div class=\"labels\" ng-if=\"isTaskDisabledInView(task)\">\n                    <span class=\"pull-right pending-icon\"></span>\n                </div>\n                <div class=\"labels\" ng-if=\"!isTaskDisabledInView(task)\">\n                    <span ng-if=\"isTaskFlagged(task)\" class=\"pull-right\">\n                        <span class=\"small-flag-icon-{{ task.flag.status | lowercase }}\" tooltip=\"task.flag.comment\"></span>\n                    </span>\n                    <span ng-if=\"isTaskPending(task)\" class=\"pull-right pending\" scheduled-start-date-tooltip=\"task.scheduledStartDate\"></span>\n                    <span ng-if=\"isTaskSkipped(task) || isTaskSkippedInAdvance(task)\" class=\"pull-right label label-default\">Skipped</span>\n                    <span ng-if=\"isTaskFailed(task)\" class=\"pull-right label label-warning-failed\">Failed</span>\n                    <span ng-if=\"isTaskFailing(task)\" class=\"pull-right label label-warning-failing\">Failing</span>\n                    <span ng-if=\"isTaskWaitingForInput(task)\" class=\"pull-right label label-waiting\">Needs input</span>\n                    <span ng-if=\"isTaskAborted(task)\" class=\"pull-right label label-default\">Aborted</span>\n                    <span ng-if=\"isTaskInProgress(task)\" class=\"pull-right label label-inprogress\">In progress</span>\n                    <span ng-if=\"isTaskDelayedDuringBlackout(task)\" class=\"pull-right blackout-icon\" bs-tooltip data-title=\"Postpone during blackout\" data-container=\"body\"></span>\n                    <span ng-if=\"isTaskPreconditionInProgress(task)\" class=\"pull-right label label-preconditioninprogress\">Precondition</span>\n                    <span ng-if=\"isUserInputTask(task)\" class=\"pull-right\"><i class=\"user-input-icon\"></i></span>\n                    <span ng-if=\"isNotificationTask(task)\" class=\"pull-right\"><i class=\"envelope-icon\"></i></span>\n                    <span ng-if=\"isScriptTask(task)\" class=\"script-icon pull-right\"><i class=\"file-icon\"></i></span>\n                    <span ng-if=\"isGateTask(task)\" class=\"pull-right gate-icon\"></span>\n                    <span ng-if=\"isParallelGroup(task)\" class=\"pull-right parallel-icon\"></span>\n                    <span ng-if=\"isSequentialGroup(task)\" class=\"pull-right sequential-icon\"></span>\n                    <span ng-if=\"isCreateReleaseTask(task)\" class=\"pull-right create-release-task-icon\"></span>\n                    <span ng-if=\"isManualTask(task) && task.owner\" class=\"pull-right manual-icon\"></span>\n                    <span ng-if=\"isManualTask(task) && !task.owner\" class=\"pull-right manual-team-icon\"></span>\n                    <span ng-if=\"task.precondition && task.preconditionEnabled\" class=\"pull-right precondition-icon\"></span>\n                    <span ng-if=\"isCustomScriptTask(task) && !task.customIconLocation\" class=\"pull-right custom-script-icon\"></span>\n                    <span ng-if=\"isCustomScriptTask(task) && task.customIconLocation\" class=\"pull-right custom-script-image\">\n                        <img ng-src=\"static/7.1.0/{{ task.customIconLocation }}\">\n                    </span>\n                </div>\n                <div class=\"task-header\">\n                    <span class=\"task-title\" display-variables=\"task.title\" variables=\"release.variables\"></span>\n                </div>\n                <span ng-if=\"isCustomScriptTask(task) && isTaskInProgress(task) && task.statusLine\" class=\"status-line\">\n                    {{task.statusLine}}\n                </span>\n                <div class=\"task-infos\" ng-if=\"!isAutomated(task) && !isTaskGroup(task) && !isReleaseCompleted(release)\">\n                    <span class=\"pull-left\" ng-show=\"task.owner\" display-user=\"task.owner\" variables=\"release.variables\"></span>\n                    <span class=\"pull-left\" ng-show=\"!task.owner && task.team\">{{task.team}}</span>\n                    <span ng-if=\"(isTaskPlanned(task) || isTaskPending(task)) && task.scheduledStartDate\" class=\"pull-right\">\n                        <span ng-if=\"task.waitForScheduledStartDate\">Starts</span>\n                        {{task.scheduledStartDate | dateFormatter}} at {{ task.scheduledStartDate | date:\'shortTime\' }}\n                    </span>\n                    <span ng-if=\"(isTaskInProgress(task) || !task.scheduledStartDate && !task.endDate) && task.dueDate\" class=\"pull-right\" ng-class=\"{\'date-overdue\': isOverdue(task.dueDate)}\">{{task.dueDate | dateFormatter}}</span>\n                    <span ng-if=\"isTaskCompleted(task) || isTaskSkipped(task)\" class=\"pull-right\">{{ getCIDuration(task) | duration }}</span>\n                    <span ng-if=\"isTaskCompletedInAdvance(task)\" class=\"pull-right\">Completed on {{task.endDate | date:\'shortDate\'}}</span>\n                    <span ng-if=\"isTaskSkippedInAdvance(task)\" class=\"pull-right\">Skipped on {{task.endDate | date:\'shortDate\'}}</span>\n                </div>\n                <div class=\"task-infos\" ng-if=\"isAutomated(task) && !isReleaseCompleted(release)\">\n                    <span ng-if=\"isTaskCompleted(task) || isTaskSkipped(task)\" class=\"pull-right\">{{ getCIDuration(task) | duration }}</span>\n                    <span ng-if=\"isCustomScriptTask(task)\" class=\"pull-left\">{{ task.typeDisplayGroup }}: {{ task.typeDisplayName }}</span>\n                </div>\n                <div class=\"task-infos\" ng-if=\"isReleaseCompleted(release) && !isTaskGroup(task)\">\n                    <span class=\"flag-count\"\n                          ng-show=\"task.flagsCount\"\n                          tooltip=\"\'Has been flagged\'\"></span>\n                    <span class=\"failure-count\"\n                          ng-show=\"task.failuresCount == 1\"\n                          tooltip=\"\'Failed once\'\">\n                        1\n                    </span>\n                    <span class=\"failure-count\"\n                          ng-show=\"task.failuresCount > 1\"\n                          ng-class=\"{\'count-warning\': task.failuresCount >= getWarningThreshold(), \'count-error\': task.failuresCount >= getErrorThreshold()}\"\n                          tooltip=\"\'Failed \' + task.failuresCount + \' times\'\">\n                        {{task.failuresCount}}\n                    </span>\n                    <span class=\"delay-count\"\n                          ng-show=\"task.delaysCount == 1\"\n                          tooltip=\"\'Has been delayed\'\"></span>\n                    <span class=\"pull-right\" ng-if=\"!isTaskGroup(task)\">{{ getCIDuration(task) | duration }}</span>\n                </div>\n                <div class=\"task-infos\" ng-if=\"isReleaseCompleted(release) && isTaskGroup(task) && isTaskGroupCollapsed(task)\">\n                    <task-counters flags-count=\"task.flagsCount\" delays-count=\"task.delaysCount\" failures-count=\"task.failuresCount\"></task-counters>\n                </div>\n            </div>\n            <div class=\"task-group\" ng-if=\"isTaskGroup(task) && !isTaskGroupCollapsed(task)\" ng-controller=\"containerController\">\n                <ul task-sortable ng-model=\"task.tasks\" class=\"task-sortable\" ng-class=\"{\'drop-disabled\': !isTaskGroupDroppable(task)}\">\n                    <li ng-repeat=\"task in task.tasks | filter:taskFilter(release, filters)\" class=\"item-sortable\" ng-class=\"{\'drag-disabled\': !isTaskDraggable(task, container) || !security.hasEditPermission(release)}\">\n                        <div ng-include=\"\'partials/releases/task-in-release.html\'\"></div>\n                    </li>\n                </ul>\n                <div ng-if=\"canAddTask(release, task)\" quick-task-generator add-task=\"addTask(task, taskForm)\" task-definitions=\"taskDefinitions\" class=\"task-generator\"></div>\n            </div>\n            <div class=\"task-group\" ng-if=\"isTaskGroup(task) && isTaskGroupCollapsed(task)\" ng-controller=\"containerController\">\n                <a class=\"link light-text view-nested-tasks\" ng-click=\"toggleTaskGroupCollapseState(task)\">\n                    View <span ng-pluralize count=\"getSubTasks(task).length\" when=\"{\'0\': \'{} tasks\', \'1\': \'one task\', \'other\': \'{} tasks\', \'many\': \'{} tasks\', \'few\': \'{} tasks\'}\"></span>\n                </a>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/template-export-dropdown.html","<div class=\"export-buttons-container\">\n    <span>\n        <a ng-if=\"release.status == \'TEMPLATE\'\" ng-click=\"exportZip(release)\">\n            <div>XLR</div>\n        </a>\n        <a ng-if=\"release.status == \'TEMPLATE\'\" ng-click=\"exportDsl(release)\">\n            <div>XFile</div>\n        </a>\n        <a ng-click=\"downloadExcel(release)\">\n           <div>Excel</div>\n        </a>\n    </span>\n</div>");
$templateCache.put("static/7.1.0/partials/reports/dashboard.html","<div id=\"report\">\n    <div ng-include=\"\'partials/reports/reports-header.html\'\"></div>\n    <div class=\"content-under-header\">\n        <div id=\"releases-at-risk\" ng-controller=\"releasesAtRiskController\" class=\"section\">\n            <div class=\"section-header\">\n                Releases at risk\n            </div>\n            <div class=\"section-body\">\n                <div class=\"release\">\n                    <div ng-if=\"releasesLoader.isLoading()\" class=\"spinner\"><img src=\"static/7.1.0/styles/img/big-ajax-loader.gif\" alt=\"Loading...\" /></div>\n                    <table ng-if=\"!releasesLoader.isLoading() && releases.length\">\n                        <tr ng-repeat=\"release in releases\" ng-click=\"displayReleaseSummary(release)\">\n                            <td class=\"release-title\">{{ release.title }}</td>\n                            <td class=\"release-completion-percentage light-text\">{{ release.progression }}% complete</td>\n                            <td class=\"failed-status\">\n                                <span ng-if=\"isReleaseFailed(release)\" class=\"failed-label label label-warning-failed\">Failed</span>\n                            </td>\n                            <td class=\"release-alert\">\n                                <div ng-if=\"releasesAlerts[release.id] && showFlag(releasesAlerts[release.id])\">\n                                    <div flag-line item=\"releasesAlerts[release.id].flaggedItems[0]\">\n                                        <span ng-if=\"releasesAlerts[release.id].flaggedItems[0].title\">({{ releasesAlerts[release.id].flaggedItems[0].title }})</span>\n                                        <span ng-include=\"\'partials/flags/other-alerts.html\'\"></span>\n                                    </div>\n                                </div>\n                            </td>\n                        </tr>\n                    </table>\n                    <div pagination ci-loader=\"releasesLoader\"></div>\n                    <div ng-show=\"!releasesLoader.isLoading() && !releases.length\" class=\"no-releases-at-risk\">No releases at risk</div>\n                </div>\n            </div>\n        </div>\n        <div class=\"clearfix\"></div>\n\n        <div class=\"section\">\n            <div class=\"section-header\">\n                Release efficiency\n            </div>\n            <div id=\"release-efficiency\" class=\"section-body\">\n                <div id=\"summary\" class=\"three-columns\" report-container report=\"reports.releaseEfficiency\">\n                    <table class=\"table table-striped table-rounded\">\n                        <tr>\n                            <td>Total tasks</td>\n                            <td>{{ reports.releaseEfficiency.data.totalTasks }}</td>\n                        </tr>\n                        <tr>\n                            <td>Total automated tasks</td>\n                            <td>{{ reports.releaseEfficiency.data.totalAutomatedTasks }}</td>\n                        </tr>\n                        <tr>\n                            <td>Total manual tasks</td>\n                            <td>{{ reports.releaseEfficiency.data.totalManualTasks }}</td>\n                        </tr>\n                        <tr>\n                            <td>Total time spent</td>\n                            <td>{{ reports.releaseEfficiency.data.totalTimeSpent | duration }}</td>\n                        </tr>\n                        <tr>\n                            <td>Total time spent in automated tasks</td>\n                            <td>{{ reports.releaseEfficiency.data.totalAutomatedTimeSpent | duration }}</td>\n                        </tr>\n                        <tr>\n                            <td>Total time spent in manual tasks</td>\n                            <td>{{ reports.releaseEfficiency.data.totalManualTimeSpent | duration }}</td>\n                        </tr>\n                    </table>\n                </div>\n                <div id=\"task-automation\" class=\"report-chart three-columns\" report-container report=\"reports.releaseEfficiency\">\n                    <h4>{{ reports.releaseEfficiency.data.totalTasks }} tasks executed</h4>\n                    <div release-efficiency-automation></div>\n                </div>\n                <div id=\"task-time-spent\" class=\"report-chart three-columns\" report-container report=\"reports.releaseEfficiency\">\n                    <h4>Time Spent: {{ reports.releaseEfficiency.data.totalTimeSpent | duration}}</h4>\n                    <div release-efficiency-time-spent></div>\n                </div>\n            </div>\n        </div>\n        <div class=\"clearfix\"></div>\n\n        <div id=\"release-duration-with-automation\" class=\"section two-columns pull-left report-chart\">\n            <div class=\"section-header\">\n                Average release duration and automation\n            </div>\n            <div class=\"section-body\" report-container report=\"reports.averageDurationAndAutomation\">\n                <div release-duration-with-automation></div>\n            </div>\n        </div>\n\n        <div id=\"release-number-report\" class=\"section two-columns pull-right report-chart\">\n            <div class=\"section-header\">\n                Releases per month\n            </div>\n            <div class=\"section-body\" report-container report=\"reports.numberOfReleasesPerMonth\">\n                <div release-number-report></div>\n            </div>\n        </div>\n        <div class=\"clearfix\"></div>\n\n        <div id=\"longest-releases\" class=\"section two-columns pull-left report-table\">\n            <div class=\"section-header\">\n                <span class=\"button pull-right\" ng-click=\"exportReport(\'TOP_LONGEST_RELEASE\')\">Export</span>\n                Top-10 longest releases\n            </div>\n            <div class=\"section-body\" report-container report=\"reports.longestReleases\">\n                <table class=\"table table-striped\">\n                    <tr>\n                        <th>Release</th>\n                        <th>Duration</th>\n                    </tr>\n                    <tr ng-repeat=\"release in reports.longestReleases.data\">\n                        <td><a class=\"link\" ng-href=\"#/releases/{{ release.releaseId }}\">{{ release.title }}</a></td>\n                        <td>{{ release.duration | duration }}</td>\n                    </tr>\n                </table>\n            </div>\n        </div>\n        <div id=\"longest-phases\" class=\"section two-columns pull-right report-table\">\n            <div class=\"section-header\">\n                <span class=\"button pull-right\" ng-click=\"exportReport(\'TOP_LONGEST_PHASE\')\">Export</span>\n                Top-10 longest phases\n            </div>\n            <div class=\"section-body\" report-container report=\"reports.longestPhases\">\n                <table class=\"table table-striped\">\n                    <tr>\n                        <th>Phase</th>\n                        <th>Release</th>\n                        <th>Duration</th>\n                    </tr>\n                    <tr ng-repeat=\"phase in reports.longestPhases.data\">\n                        <td>{{ phase.title }}</td>\n                        <td><a class=\"link\" ng-href=\"#/releases/{{ phase.releaseId }}\">{{ phase.release }}</a></td>\n                        <td>{{ phase.duration | duration }}</td>\n                    </tr>\n                </table>\n            </div>\n        </div>\n        <div class=\"clearfix\"></div>\n\n        <div id=\"longest-tasks\" class=\"section two-columns pull-left report-table\">\n            <div class=\"section-header\">\n                <span class=\"button pull-right\" ng-click=\"exportReport(\'TOP_LONGEST_TASK\')\">Export</span>\n                Top-10 longest tasks\n            </div>\n            <div class=\"section-body\" report-container report=\"reports.longestTasks\">\n                <table class=\"table table-striped\">\n                    <tr>\n                        <th>Task</th>\n                        <th>Release</th>\n                        <th>Duration</th>\n                        <th>Owner (Team)</th>\n                    </tr>\n                    <tr ng-repeat=\"task in reports.longestTasks.data\">\n                        <td>{{ task.title }}</td>\n                        <td><a class=\"link\" ng-href=\"#/releases/{{ task.releaseId }}\">{{ task.release }}</a></td>\n                        <td>{{ task.duration | duration }}</td>\n                        <td><span display-user=\"task.owner\"></span> <span ng-if=\"task.team\">({{ task.team }})</span></td>\n                    </tr>\n                </table>\n            </div>\n        </div>\n        <div id=\"most-involved-people-report\" class=\"section two-columns pull-right report-table\">\n            <div class=\"section-header\">\n                <span class=\"button pull-right\" ng-click=\"exportReport(\'TOP_PEOPLE_MOST_INVOLVED\')\">Export</span>\n                Top-10 people most involved\n            </div>\n            <div class=\"section-body\" report-container report=\"reports.mostInvolvedPeople\">\n                <table class=\"table table-striped\">\n                    <tr>\n                        <th>Person</th>\n                        <th>Time spent</th>\n                        <th>Tasks handled</th>\n                    </tr>\n                    <tr ng-repeat=\"userParticipation in reports.mostInvolvedPeople.data\">\n                        <td><span display-user=\"userParticipation.user\"></span></td>\n                        <td>{{ userParticipation.timeSpent | duration }}</td>\n                        <td>{{ userParticipation.tasksHandled }}</td>\n                    </tr>\n                </table>\n            </div>\n        </div>\n        <div class=\"clearfix\"></div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/reports/release-automation.html","<div id=\"report\">\n    <div ng-include=\"\'partials/reports/reports-header.html\'\"></div>\n\n    <div class=\"content-under-header\">\n        <div id=\"release-duration-area-spline-report\" class=\"section two-columns pull-left report-chart\">\n            <div class=\"section-header\">\n                Release duration\n            </div>\n            <div class=\"section-body\" report-container report=\"reports.releasesDuration\">\n                <div release-duration-area-spline-report></div>\n            </div>\n        </div>\n        <div id=\"release-automation-area-spline-report\" class=\"section two-columns pull-right report-chart\">\n            <div class=\"section-header\">\n                Release automation\n            </div>\n            <div class=\"section-body\" report-container report=\"reports.releasesAutomation\">\n                <div release-automation-area-spline-report></div>\n            </div>\n        </div>\n\n        <div class=\"clearfix\"></div>\n        <div id=\"most-recent-releases-tasks-count-report\" class=\"section two-columns pull-left report-chart\">\n            <div class=\"section-header\">\n                Number of tasks\n            </div>\n            <div class=\"section-body\" report-container report=\"reports.mostRecentReleases\">\n                <div most-recent-releases-tasks-count-report></div>\n            </div>\n        </div>\n        <div id=\"most-recent-releases-time-spent-report\" class=\"section two-columns pull-right report-chart\">\n            <div class=\"section-header\">\n                Time spent\n            </div>\n            <div class=\"section-body\" report-container report=\"reports.mostRecentReleases\">\n                <div most-recent-releases-time-spent-report></div>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/reports/report-container.html","<div>\n    <div ng-if=\"report.loading()\" class=\"spinner\"><img src=\"static/7.1.0/styles/img/big-ajax-loader.gif\" alt=\"Loading...\" /></div>\n    <div ng-if=\"!report.loading() && report.isEmpty()\" class=\"no-data\">No Data</div>\n    <div ng-if=\"!report.loading() && !report.isEmpty()\" ng-transclude></div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/reports/reports-header.html","<div id=\"reports-header\" class=\"header\" ng-controller=\"filtersController\">\n    <div ng-include=\"\'partials/filters/time-filters.html\'\"></div>\n    <span doc-icon=\"reports.html\"></span>\n    <div class=\"tags-label\">Tags</div>\n    <div class=\"transparent tags-input green-tags\" tags-input tags=\"filters.tags\" focus-on-click\n         placeholder=\"Add a tag...\" autofocus></div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/security/delete-user-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>Delete User</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to delete the user <b>{{user.username}}</b>.\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button continue primary\" focus-on=\"true\" ng-click=\"deleteUser(user);dismiss()\">Delete</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/security/permissions.html","<div id=\"permissions\">\n    <div id=\"permissions-header\" class=\"header\">\n        <div class=\"buttons\" ng-show=\"$ctrl.permissionsContainer.length > 0\">\n            <span class=\"button save primary\" ng-click=\"$ctrl.save()\" ng-disabled=\"!$ctrl.dirty\">Save</span>\n            <span class=\"button reset\" ng-click=\"$ctrl.reset()\" ng-disabled=\"!$ctrl.dirty\">Reset</span>\n            <span class=\"last-saved\" ng-if=\"$ctrl.lastSavedDate\">Last saved on {{ $ctrl.lastSavedDate | date: \'medium\' }}</span>\n        </div>\n        <span doc-icon=\"global-permissions.html\"></span>\n    </div>\n    <div class=\"ng-cloak content-under-header\">\n        <div class=\"help\">\n            Use this page to define which part of XL Release is accessible for its users. <br>\n            Permissions are set on roles – see the <a href=\"#/roles\">Roles screen</a>. <br>\n\n            After editing, press Save to apply the changes.\n        </div>\n        <permission-table-v2\n                columns=\"$ctrl.permissionsTableColumns\"\n                read-only=\"false\"\n                permissions=\"$ctrl.permissionsContainer\"\n                on-update=\"$ctrl.setDirty()\">\n        </permission-table-v2>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/security/task-access.html","<div id=\"task-access\">\n    <div id=\"task-access-header\" class=\"header\">\n        <div class=\"buttons\">\n            <span ng-click=\"$pageCtrl.save()\" class=\"button save primary\" ng-disabled=\"$pageCtrl.isUnchanged()\">Save</span>\n            <span ng-click=\"!$pageCtrl.isUnchanged() && $pageCtrl.reset()\" class=\"button reset\" ng-disabled=\"$pageCtrl.isUnchanged()\" disabled=\"disabled\">Reset</span>\n            <span ng-if=\"$pageCtrl.lastSavedDate\" class=\"last-saved\">Last saved on {{ $pageCtrl.lastSavedDate | date: \'medium\' }}</span>\n        </div>\n        <span doc-icon=\"task-access.html\"></span>\n    </div>\n    <div class=\"content-under-header\">\n        <div class=\"help\">\n            On this page you can restrict task types to be used only by certain roles. See the <a ng-href=\"#/roles\">Roles screen</a> to see who is in a\n            role.<br>\n            After editing, press Save to apply the changes.\n        </div>\n\n        <form name=\"taskAccessForm\" confirm-leave>\n            <table class=\"table table-rounded table-striped\">\n                <thead>\n                <tr>\n                    <th class=\"title-column\">Task type</th>\n                    <th>Available for all users</th>\n                    <th>Available to roles</th>\n                </tr>\n                </thead>\n                <tbody ng-repeat=\"taskAccesses in $pageCtrl.groupedTaskAccesses | toArray | orderBy:\'$key\'\">\n                <tr>\n                    <td colspan=\"3\" class=\"group\">\n                        {{taskAccesses.$key | capitalize}}\n                    </td>\n                </tr>\n                <tr ng-repeat=\"taskAccess in taskAccesses\">\n                    <td class=\"name title-column\">\n                        {{taskAccess.label}}\n                    </td>\n                    <td>\n                        <input type=\"checkbox\" ng-model=\"taskAccess.allowedToAll\" ng-change=\"$pageCtrl.onCheckboxAllowToAllChange(taskAccess)\"/>\n                    </td>\n                    <td class=\"roles content-column\">\n                        <div class=\"roles transparent\"\n                             tags-input\n                             tags=\"taskAccess.roles\"\n                             placeholder=\"Add a role...\"\n                             completion-candidates=\"$pageCtrl.allRoles\"\n                             on-change=\"taskAccess.allowedToAll = false\">\n                        </div>\n                    </td>\n                </tr>\n                </tbody>\n            </table>\n        </form>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/security/user-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>User</h4>\n    </div>\n    <form name=\"userForm\" id=\"userForm\" class=\"form-horizontal\" novalidate\n          ng-submit=\"userForm.$valid && users.editedUser.password == users.editedUser.passwordConfirmation && users.saveUser(dismiss)\">\n        <div class=\"modal-body\">\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"username\">\n                    Username\n                    <span ng-show=\"userForm.username.$error.required\" class=\"error\">*</span>\n                </label>\n\n                <div class=\"col-sm-9\">\n                    <input type=\"text\" class=\"input-block-level\" id=\"username\" name=\"username\" ng-model=\"users.editedUser.username\" autofocus required ng-disabled=\"!users.newUser\"/>\n                    <span ng-show=\"users.conflict\" class=\"error\">User already exists</span>\n                    <span class=\"error\" ng-if=\"userForm.username.$error.required\">Username is required</span>\n                </div>\n            </div>\n\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"full-name\">\n                    Name\n                </label>\n\n                <div class=\"col-sm-9\">\n                    <input type=\"text\" class=\"input-block-level\" id=\"full-name\" name=\"full-name\" ng-model=\"users.editedUser.fullName\"/>\n                </div>\n            </div>\n\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"email\">\n                    Email\n                    <span ng-show=\"userForm.email.$error.email\" class=\"error\">*</span>\n                </label>\n\n                <div class=\"col-sm-9\">\n                    <input type=\"email\" class=\"input-block-level\" id=\"email\" name=\"email\" ng-model=\"users.editedUser.email\"/>\n                    <span class=\"error\" ng-if=\"userForm.email.$error.email\">Malformed email address</span>\n                </div>\n            </div>\n\n            <div ng-if=\"isJcrUser(users.editedUser)\">\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\" for=\"password\">\n                        <span ng-show=\"users.newUser\">Set password</span>\n                        <span ng-hide=\"users.newUser\">Change password</span>\n                        <span class=\"error\" ng-if=\"userForm.password.$error.required\">*</span>\n                    </label>\n\n                    <div class=\"col-sm-9\">\n                        <input type=\"password\" class=\"input-block-level\" id=\"password\" name=\"password\"\n                               ng-model=\"users.editedUser.password\" ng-required=\"users.newUser\"/>\n                        <span class=\"error\" ng-if=\"userForm.password.$error.required\">Password is required</span>\n                    </div>\n                </div>\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\" for=\"passwordConfirmation\">\n                        Confirm password\n                        <span class=\"error\" ng-if=\"userForm.password.$error.required\">*</span>\n                    </label>\n\n                    <div class=\"col-sm-9\">\n                        <input type=\"password\" class=\"input-block-level\" id=\"passwordConfirmation\" name=\"passwordConfirmation\"\n                               ng-model=\"users.editedUser.passwordConfirmation\" ng-required=\"users.newUser\"/>\n                        <span class=\"error\" ng-if=\"users.editedUser.password != users.editedUser.passwordConfirmation\">Passwords don\'t match</span>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"modal-footer\">\n            <button class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"button\" class=\"button save primary\" ng-click=\"users.saveUser(dismiss)\" ng-disabled=\"userForm.$invalid || users.editedUser.password != users.editedUser.passwordConfirmation\">Save</button>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/7.1.0/partials/security/users.html","<div id=\"users\">\n    <div id=\"users-header\" class=\"header\">\n        <div class=\"actions\">\n            <span modal=\"\'partials/security/user-modal.html\'\" init=\"users.editNewUser()\" class=\"button primary new-user\">New user</span>\n            <input type=\"search\" placeholder=\"Filter...\" ng-model=\"userFilter\">\n            <span ng-show=\"LimitedUsers.isEnabled()\" id=\"limited-users-message\">\n                <span ng-if=\"!LimitedUsers.maximumReached()\">\n                    You can allow <span ng-pluralize count=\"LimitedUsers.countLeft()\" when=\"{\'1\': \'1 more user\', \'other\': \'{} more users\', \'many\': \'{} more users\', \'few\': \'{} more users\'}\"></span> to login.\n                </span>\n                <span ng-if=\"LimitedUsers.maximumReached()\">\n                    You have reached the maximum number of users allowed to login by your license.\n                </span>\n            </span>\n        </div>\n        <span doc-icon=\"users.html\"></span>\n    </div>\n    <div class=\"content-under-header\">\n        <div class=\"help\">\n            <h4>XL Release users</h4>\n            Internal users are managed by XL Release and can be added and removed by an administrator. <br>\n            External users are maintained in an external system like Active Directory. <br>\n        </div>\n        <table class=\"table table-rounded table-striped\" ng-show=\"users.all.length > 0\">\n            <thead>\n                <tr>\n                    <th class=\"full-name-column\">Name</th>\n                    <th class=\"name-column\">Username</th>\n                    <th class=\"email-column\">Email address</th>\n                    <th class=\"type-column\">Type</th>\n                    <th class=\"login-permission-column\">Enabled</th>\n                    <th></th>\n                </tr>\n            </thead>\n            <tbody>\n                <tr ng-repeat=\"user in users.all | filter:userFilter\" modal=\"\'partials/security/user-modal.html\'\" init=\"users.editUser(user)\">\n                    <td class=\"full-name\">{{ user.fullName }}</td>\n                    <td class=\"name\">{{ user.username }}</td>\n                    <td class=\"email\">{{ user.email }}</td>\n                    <td class=\"type\">{{ (user.external) ? \'External\' : \'Internal\' }}</td>\n                    <td class=\"login-permission\" stop-click-propagation>\n                        <input type=\"checkbox\"\n                               ng-model=\"user.loginAllowed\"\n                               ng-show=\"!isUserNameAdmin(user.username)\"\n                               ng-disabled=\"LimitedUsers.maximumReached() && !user.loginAllowed\"\n                               ng-click=\"users.toggleLoginPermission(user)\"/>\n                    </td>\n                    <td ng-if=\"isJcrUser(user) && !isUserNameAdmin(user.username)\" class=\"delete-user action-column\" modal=\"\'partials/security/delete-user-modal.html\'\" stop-click-propagation><i class=\"remove-icon\"/></td>\n                    <td ng-if=\"!isJcrUser(user) || isUserNameAdmin(user.username)\" class=\"no-action\" stop-click-propagation>&nbsp;</td>\n                </tr>\n            </tbody>\n        </table>\n        <h3 ng-show=\"users.all.length == 0\">No users defined</h3>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/server-error/forbidden-access.html","<div class=\"content\" id=\"forbidden-access\">\n    <div class=\"standalone-form\">\n        <h3>Forbidden access</h3>\n        <p>Your request has been rejected, your permissions may have been revoked.</p>\n        <div ng-if=\"errorMessage\">\n            Error message :\n            <ul>\n                <li>{{errorMessage}}</li>\n            </ul>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/server-error/version-changed.html","<div class=\"modal-content about\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>Version changed</h4>\n    </div>\n    <div class=\"modal-body\">\n        {{ versionChangedMessage }}\n        <br/>\n        <br/>\n        <button class=\"button primary\" ng-click=\"dismiss()\">Reload</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/settings/general-settings.html","<div id=\"general-settings\" class=\"standalone-form\">\n    <div id=\"general-settings-header\" class=\"header\">\n        <div class=\"buttons\">\n            <button ng-disabled=\"settingsForm.$invalid\" class=\"button submit primary\" ng-click=\"save()\">Save</button>\n            <span ng-click=\"!$pageCtrl.isUnchanged() && $pageCtrl.reset()\" class=\"button reset\" ng-disabled=\"$pageCtrl.isUnchanged()\" disabled=\"disabled\">Cancel</span>\n            <span ng-if=\"lastSavedDate\" class=\"last-saved\">Last saved on {{ lastSavedDate | date: \'medium\' }}</span>\n        </div>\n        <span doc-icon=\"general-settings.html\"></span>\n    </div>\n    <div class=\"content-under-header\">\n        <form name=\"settingsForm\" class=\"form-horizontal\" confirm-leave>\n            <div class=\"help\">\n                After editing, press Save to apply the changes.\n            </div>\n            <fieldset id=\"reports-settings\">\n                <legend>Reports</legend>\n                <div class=\"help\">\n                    XL Release will use these settings in the <a ng-href=\"#/release-value-stream\">Release Value Stream report</a>.\n                </div>\n                <div ng-repeat=\"property in reportsSettings.type.properties\" dip-control large=\"true\" property=\"property\" container=\"reportsSettings.ci\"></div>\n            </fieldset>\n            <fieldset id=\"polling-settings\">\n                <legend>Task polling</legend>\n                <div class=\"help\">\n                    XL Release will use these settings to automatically refresh screens when task status change.\n                </div>\n                <div ng-repeat=\"property in pollingSettings.type.properties\" dip-control large=\"true\" property=\"property\" container=\"pollingSettings.ci\"></div>\n            </fieldset>\n\n            <fieldset id=\"archiving-settings\">\n                <legend>Archiving</legend>\n                <div class=\"help\">\n                    XL Release will use these settings to archive completed releases. <br/> <strong>Note:</strong> Only archived releases appear in reports.\n                </div>\n\n                <div class=\"form-group archiving-settings-age\">\n                    <label class=\"col-sm-5 control-label\" for=\"archivingSettingsAge\">{{ getProperty(archivingSettings, \'releaseAgeToDeleteFromJcr\').label }}</label>\n                    <div class=\"col-sm-7\">\n                        <div style=\"display: inline-block; width: 90%;\">\n                            <input type=\"number\"\n                                   id=\"archivingSettingsAge\"\n                                   class=\"input-block-level\"\n                                   min=\"0\"\n                                   ng-model=\"archivingSettingsAge\"\n                                   required>\n\n                            <select ng-model=\"archivingSettingsAgeUnit\"\n                                    ng-options=\"unit for unit in [\'Days\', \'Hours\']\"\n                                    ng-change=\"changeUnitType()\"></select>\n                        </div>\n                    </div>\n                </div>\n            </fieldset>\n        </form>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/smtp/smtp.html","<div id=\"smtp\" class=\"standalone-form\">\n    <div id=\"smtp-header\" class=\"header\">\n        <div class=\"buttons\">\n            <button ng-disabled=\"smtpForm.$invalid\" id=\"submit\" class=\"button primary\" ng-click=\"smtp.save()\">Save</button>\n            <span ng-if=\"smtp.lastSavedDate\" class=\"last-saved\">Last saved on {{ smtp.lastSavedDate | date: \'medium\' }}</span>\n        </div>\n        <span doc-icon=\"smtp-server.html\"></span>\n    </div>\n    <div class=\"content-under-header\">\n        <div class=\"help\">\n            XL Release will use these settings to send notifications. <br><br>\n\n            After editing, press Save to apply the changes.\n        </div>\n        <div class=\"container-fluid\">\n            <div class=\"row\">\n                <div class=\"col-md-2\">\n                    <form name=\"smtpForm\" class=\"form-horizontal\" confirm-leave>\n                        <div ng-repeat=\"property in smtp.type.properties\" dip-control property=\"property\" container=\"smtp.ci\"></div>\n                    </form>\n                </div>\n                <div class=\"col-md-10\"></div>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/abort-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to abort the task.</p>\n\n        <form name=\"abortTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"abortComment\" placeholder=\"Give feedback or place a comment...\" required></textarea>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.abortTask(task, abortComment);dismiss()\" ng-disabled=\"abortTaskForm.$invalid\">Abort</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/assignee.html","<span class=\"assignee\">\n    <span ng-if=\"owner || team\">\n        Assigned to\n\n        <span ng-if=\"owner.username == loggedUser.username\">me</span>\n        <span ng-if=\"owner && owner.username != loggedUser.username\" display-user=\"owner\" variables=\"variables\"></span>\n        <span ng-if=\"owner && team\" class=\'team-name\'>({{team}})</span>\n        <span ng-if=\"!owner && team\" class=\'team-name\'>{{team}}</span>\n    </span>\n    <span ng-if=\"!owner && !team\">\n        Not Assigned\n    </span>\n</span>\n");
$templateCache.put("static/7.1.0/partials/tasks/change-type-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>Change Task Type</h4>\n    </div>\n    <div class=\"modal-body\">\n        The task type will be changed from <strong>{{task.typeDisplayName}}</strong> to <strong>{{item.taskDefinition.displayName}}</strong>.\n        <p><span ng-if=\"task.typeDisplayName != \'Manual\'\">XL Release will copy task properties where possible.</span></p>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" auto-focus ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.changeType(container, task, item.taskDefinition.typeName);dismiss()\">Change Task</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/change-type-submenu-item.html","<a tabindex=\"-1\" ng-click=\"openModal(\'partials/tasks/change-type-modal.html\', item)\"  class=\"task-definition-name\" ng-class=\"{\'current-type\': item.isSameType}\"\n   ng-disabled=\"item.disabled\" hide-popover-on-click>\n    <i ng-class=\"{\'ok-icon\': item.isSameType}\">&nbsp;</i>\n    <span>{{ item.taskDefinition.displayName }}</span>\n</a>\n");
$templateCache.put("static/7.1.0/partials/tasks/claim-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        Would you like to pick up the task?\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" auto-focus ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"assignToMe(task);dismiss()\">Assign to me</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/complete-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to complete the task.</p>\n        <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"completeComment\" placeholder=\"Give feedback or place a comment...\" auto-focus></textarea>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.completeTask(task, completeComment);dismiss()\">Complete</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/context-menu.html","<div class=\"popover\" tabindex=\"-1\">\n    <div class=\"arrow\"></div>\n    <div context-menu id=\"context-menu-container\" items=\"taskContextMenuItems(task, release, container, groupedTaskDefinitions, withinBlackout)\" ctrl=\"ctrl\"\n         task=\"task\" container=\"container\" scrollable-change-task-type=\"scrollableChangeTaskType\"></div>\n</div>");
$templateCache.put("static/7.1.0/partials/tasks/fail-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to fail the task.</p>\n\n        <form name=\"failTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"failComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.failTask(task, failComment);dismiss()\" ng-disabled=\"failTaskForm.$invalid\">Fail</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/filter.html","<div id=\"filter-container\">\n    <label class=\"filter-item\" for=\"display-active\">\n        <input type=\"checkbox\" ng-model=\"filters.active\" id=\"display-active\"/> Active tasks\n    </label>\n    <label class=\"filter-item\" for=\"display-me\">\n        <input type=\"checkbox\" ng-model=\"filters.assignedToMe\" id=\"display-me\"/> Assigned to me\n    </label>\n    <label class=\"filter-item\" for=\"display-teams\">\n        <input type=\"checkbox\" ng-model=\"filters.assignedToMyTeams\" id=\"display-teams\"/> Assigned to my teams\n    </label>\n     <label class=\"filter-item\" for=\"display-others\">\n         <input type=\"checkbox\" ng-model=\"filters.assignedToOthers\" id=\"display-others\"/> Assigned to others\n     </label>\n    <label class=\"filter-item\" for=\"display-not-assigned\">\n        <input type=\"checkbox\" ng-model=\"filters.notAssigned\" id=\"display-not-assigned\"/> Not assigned\n    </label>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/quick-task-generator.html","<a class=\"add-task link\" ng-hide=\"showForm || taskGeneratorDisabled\">Add task</a>\n<div ng-show=\"showForm\" class=\"form-container\">\n    <form name=\"quickTaskForm\" class=\"form-horizontal\">\n        <input type=\"text\" ng-model=\"title\" placeholder=\"Task title...\" required/><br>\n        <select class=\"task-type\" ng-model=\"taskType\">\n            <optgroup ng-repeat=\"groupTaskDefinition in groupedTaskDefinitions | toArray | orderBy:\'$key\'\" label=\"{{ groupTaskDefinition.$key }}\">\n                <option ng-repeat=\"taskDefinition in groupTaskDefinition | orderBy: \'displayName\'\"\n                        value=\"{{ taskDefinition.typeName }}\"\n                        label=\"{{ taskDefinition.displayName }}\"\n                        ng-selected=\"{{ taskDefinition.typeName == taskType }}\">{{taskDefinition.displayName}}</option>\n            </optgroup>\n        </select>\n        <a class=\"button add primary pull-right\" ng-disabled=\"quickTaskForm.$invalid\">Add</a>\n        <a class=\"button cancel pull-right\">Cancel</a>\n    </form>\n    <div class=\"clearfix\"></div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/reopen-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to reopen the task.</p>\n\n        <form name=\"reopenTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"reopenComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.reopenTask(task, reopenComment);dismiss()\" ng-disabled=\"reopenTaskForm.$invalid\">Reopen</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/retry-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to retry the task.</p>\n\n        <form name=\"retryTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"retryComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.retryTask(task, retryComment);dismiss()\" ng-disabled=\"retryTaskForm.$invalid\">Retry</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/skip-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to skip the task.</p>\n\n        <form name=\"skipTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"skipComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.skipTask(task, skipComment);dismiss()\" ng-disabled=\"skipTaskForm.$invalid\">Skip</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/start-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to start the pending task.</p>\n\n        <form name=\"startTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"startComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n            <div class=\"task-actions-info\" ng-if=\"task.delayDuringBlackout && ctrl.withinBlackout\">\n                <span class=\"error\">Are you sure you want to run this task during the blackout period?</span>\n            </div>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.startNow(task, startComment);dismiss()\" ng-disabled=\"startTaskForm.$invalid\">Start now</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/task-context-menu.html","<ul class=\"dropdown-menu\" role=\"menu\">\n    <li ng-if=\"item.type == \'modal\'\" ng-repeat-start=\"item in items\" ng-class=\"{\'disabled\': item.disabled}\">\n        <a tabindex=\"-1\" ng-click=\"openModal(item.modal, item)\" ng-disabled=\"item.disabled\" hide-popover-on-click class=\"{{item.cssClass}}\">\n            {{ item.text }}\n        </a>\n    </li>\n    <li ng-if=\"item.type == \'click\'\" ng-class=\"{\'disabled\': item.disabled}\">\n        <a tabindex=\"-1\" ng-disabled=\"item.disabled\" hide-popover-on-click class=\"{{item.cssClass}}\" ng-click=\"item.disabled || handleClick(item)\">\n            {{ item.text }}\n        </a>\n    </li>\n    <li ng-if=\"item.type == \'noAction\'\" ng-class=\"{\'disabled\': item.disabled}\">\n        <a tabindex=\"-1\" class=\"{{item.cssClass}}\">\n            {{ item.text }}\n        </a>\n    </li>\n    <li ng-if=\"item.type == \'submenu\'\" ng-class=\"{\'disabled\': item.disabled}\" class=\"dropdown-submenu\">\n        <a tabindex=\"-1\" class=\"{{item.cssClass}}\">\n            {{ item.text }}\n        </a>\n        <ul ng-include=\"\'partials/tasks/task-context-menu.html\'\" include-replace ng-init=\"items = item.items\"></ul>\n    </li>\n    <li ng-if=\"item.type == \'template\'\" ng-class=\"{\'disabled\': item.disabled}\" ng-include=\"item.templateUrl\"></li>\n    <li ng-if=\"item.type == \'divider\'\" ng-repeat-end class=\"divider\"></li>\n</ul>\n");
$templateCache.put("static/7.1.0/partials/tasks/task-labels.html","<div class=\"labels\">\n    <span ng-if=\"isTaskPlanned(task)\" class=\"label label-planned\">Planned</span>\n    <span ng-if=\"!isTaskAborted(task) && (isTaskCompleted(task) || isTaskCompletedInAdvance(task))\" class=\"label label-completed\">Completed</span>\n    <span ng-if=\"isTaskAborted(task)\" class=\"label label-default\">Aborted</span>\n    <span ng-if=\"isTaskSkipped(task) || isTaskSkippedInAdvance(task)\" class=\"label label-warning\">Skipped</span>\n    <span ng-if=\"isTaskFailed(task)\" class=\"label label-warning-failed\">Failed</span>\n    <span ng-if=\"isTaskFailing(task)\" class=\"label label-warning-failing\">Failing</span>\n    <span ng-if=\"isTaskWaitingForInput(task)\" class=\"label label-waiting\">Needs input</span>\n    <span ng-if=\"isTaskInProgress(task)\" class=\"label label-active\">In progress</span>\n    <span ng-if=\"isTaskPreconditionInProgress(task)\" class=\"pull-right label label-preconditioninprogress\">Precondition</span>\n    <span ng-if=\"isTaskPending(task)\" class=\"label label-pending\">Pending</span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/task.html","<div id=\"single-task\">\n    <div id=\"tasks-header\" class=\"header\">\n        <div class=\"filter-tasks actions\">\n            <span><span class=\"light-text\">Release: </span>\n                <a ng-if=\"security.hasViewPermission(release)\" href=\"#/releases/{{task.releaseId}}\" class=\"link\">{{task.releaseTitle}}</a>\n                <span ng-if=\"!security.hasViewPermission(release)\">{{task.releaseTitle}}</span>\n            </span>\n            <span><span class=\"light-text\">Phase: </span>{{task.phaseTitle}}</span>\n            <span><span class=\"light-text\">Task: </span>{{task.title}}</span>\n        </div>\n        <span doc-icon=\"task-overview.html\"></span>\n    </div>\n\n    <div id=\"tasks-content\" class=\"content-under-header\">\n        <task-list index=\"0\" tasks=\"tasks\" release=\"release\" on-task-details-closed=\"onTaskDetailsClosed()\" on-task-change=\"onTaskChange()\" show-task-details-modal=\"showTaskDetailsModal\"></task-list>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/tasks.html","<div id=\"tasks\">\n    <div id=\"tasks-header\" class=\"header\">\n        <div class=\"filter-tasks actions\" ng-controller=\"filtersController\">\n            <button type=\"button\" class=\"button dropdown-button\" bs-popover data-content-template=\"partials/tasks/filter.html\" data-placement=\"bottom\" auto-close=\"true\">Filter options</button>\n            <input id=\"searchFilter\" type=\"text\" placeholder=\"Search...\" ng-model=\"filters.filter\">\n            <span ng-include=\"\'partials/filters/from-to-date-filters.html\'\" />\n        </div>\n        <div class=\"actions\">\n           <order-selector on-select=\"onChange(order)\" order-by-values=\"orderByValues\"></order-selector>\n        </div>\n    </div>\n    <div id=\"tasks-content\" class=\"content-under-header container-fluid\">\n        <div class=\"alert too-many-results-alert\" ng-show=\"limitReached\">Some tasks are not shown because the filter produced too many results. Please narrow your search criteria.</div>\n        <div ng-repeat=\"release in releases\" data-release-title=\"{{release.title}}\">\n            <div expander=\"tasks{{$index}}\">\n                <fieldset>\n                    <legend class=\"task-header\">\n                        <span class=\"expander expand-icon\"></span>\n                        <span class=\"expander contract-icon hide\"></span>\n                        <span class=\"expander group-title release-name\">{{release.title}} ({{release.tasks.length}})</span>\n                    </legend>\n\n                    <task-list index=\"$index\" tasks=\"release.tasks\" on-task-details-closed=\"onTaskDetailsClosed()\" on-task-change=\"onTaskChange()\" release=\"release\"/>\n                </fieldset>\n            </div>\n        </div>\n        <div class=\"alert notice\" ng-show=\"releases.length == 0\">No tasks found.</div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/templates/copy-template-modal.html","<div class=\"modal-content\">\n    <form name=\"copyTemplateForm\" id=\"copyTemplateForm\" class=\"form-horizontal\" novalidate>\n        <div class=\"modal-header\">\n            <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n            <h4>Copy Template</h4>\n        </div>\n        <div class=\"modal-body\">\n            <div class=\"form-group\">\n                  <label class=\"col-sm-2 control-label\" for=\"copyTemplate-title\">Template name <span ng-if=\"ctrl.templatePropertiesForm.$error.required\" class=\"error\">*</span></label>\n                <div class=\"col-sm-10\">\n                    <input type=\"text\" class=\"input-block-level\" name=\"title\" id=\"copyTemplate-title\" ng-model=\"ctrl.copyOfTemplate.title\" required autofocus/>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-sm-2 control-label\" for=\"copyTemplate-description\">Description</label>\n\n                <div class=\"col-sm-10\">\n                    <textarea rows=\"4\" class=\"input-block-level\" id=\"copyTemplate-description\" ng-model=\"ctrl.copyOfTemplate.description\"></textarea>\n                </div>\n            </div>\n        </div>\n        <div class=\"modal-footer\">\n            <ul class=\"form-errors mln list-unstyled\">\n                <li ng-if=\"!ctrl.hasPermissionToEdit()\">Passwords will be cleared because you do not have permission to edit the original template.</li>\n                <li ng-if=\"copyTemplateForm.title.$error.required\">Template name is mandatory</li>\n            </ul>\n            <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"button continue primary\" ng-click=\"ctrl.copyTemplate(dismiss)\" ng-disabled=\"copyTemplateForm.$invalid\">Continue</button>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/7.1.0/partials/templates/delete-template-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>Delete Template</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to delete the template <b>{{ctrl.template.title}}</b>.\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button continue primary\" focus-on=\"true\" ng-click=\"ctrl.deleteTemplate(); dismiss()\">Delete</button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/templates/import-template-modal.html","<div id=\"importTemplateModal\" class=\"modal-content\"\n     upload\n     upload-url=\"\'upload/templates/zip?folderId={{folderId}}\'\">\n    <form name=\"importTemplateForm\" id=\"importTemplateForm\" class=\"form-horizontal\" novalidate>\n        <div class=\"modal-header\">\n            <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n            <h4>Import Template</h4>\n        </div>\n        <div ng-show=\"!UploadService.data.result\">\n            <div class=\"modal-body\">\n                <div class=\"form-group\">\n                    <label class=\"col-sm-2 control-label\" for=\"importTemplate-file\">Template file<span ng-if=\"importTemplateForm.$error.required\" class=\"error\">*</span></label>\n\n                    <div class=\"col-sm-10\">\n                        <input type=\"file\" ng-model=\"file\" file-input id=\"importTemplate-file\" required />\n                    </div>\n                </div>\n                <div class=\"form-group\">\n                    <div class=\"col-sm-offset-2 col-sm-10\">\n                        <span class=\"error\" ng-show=\"importTemplateForm.$error.required\">Template file required</span>\n                        <span class=\"error\" ng-show=\"UploadService.data.error\">\n                            An upload error occurred\n                            <!-- On IE9 the error message is not set since it\'s based on an iframe -->\n                            <span ng-show=\"UploadService.data.errorMessage\">: {{UploadService.data.errorMessage}}</span>\n                        </span>\n                    </div>\n                </div>\n                <img class=\"pull-right\" src=\"static/7.1.0/styles/img/ajax-loader.gif\" ng-show=\"UploadService.data.loading\"/>\n            </div>\n            <div class=\"modal-footer\">\n                <button class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n                <button class=\"button import primary\" ng-disabled=\"importTemplateForm.$invalid\" ng-click=\"upload(file)\">Import</button>\n            </div>\n        </div>\n        <div ng-show=\"UploadService.data.result\">\n            <div class=\"modal-body\">\n                <div class=\"form-group\" ng-repeat=\"templateImport in UploadService.data.result\">\n                    <label class=\"col-xs-4 control-label\">\n                        <a ng-href=\"#/templates/{{templateImport.id}}\" ng-click=\"dismiss()\">{{templateImport.title}}</a>\n                    </label>\n\n                    <div class=\"col-xs-8 results\">\n                        <ul ng-if=\"templateImport.warnings.length > 0\">\n                            <li ng-repeat=\"warning in templateImport.warnings track by $index\">{{warning}}</li>\n                        </ul>\n                        <span ng-if=\"templateImport.warnings.length == 0\">\n                            Template successfully imported\n                        </span>\n                    </div>\n                </div>\n            </div>\n            <div class=\"modal-footer\">\n                <button class=\"button ok primary\" ng-click=\"dismiss()\">OK</button>\n            </div>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/7.1.0/partials/templates/move-template-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <h4>Move template to</h4>\n    </div>\n    <form name=\"moveTemplateForm\">\n        <div class=\"modal-body\">\n            <folder-explorer class=\"folder-explorer\" mode=\"moveTemplateMode\" on-select=\"ctrl.onFolderSelect(folder)\">\n            </folder-explorer>\n        </div>\n        <span ng-if=\"ctrl.containsUnclickableRows()\" class=\"default-padding-left\">* Some folders are not available because you do not have the Edit Template permission on them.</span>\n        <div class=\"modal-footer\">\n            <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"button continue primary\" ng-disabled=\"!ctrl.canMove\" ng-click=\"ctrl.moveTemplate(dismiss)\">Move</button>\n        </div>\n    </form>\n</div>");
$templateCache.put("static/7.1.0/partials/templates/template-edit-trigger.html","<div id=\"triggers\">\n    <div release-header>\n        <span doc-icon=\"creating-custom-trigger.html\"></span>\n    </div>\n    <div class=\"container-fluid\">\n        <div class=\"row\">\n            <div class=\"col-md-2\">\n                <div class=\"content-under-header form-content\">\n                    <h4>{{ $ctrl.descriptor.label }}</h4>\n                    <div class=\"help\">\n                        After editing, press Save to apply the changes.<br>\n\n                        <div ng-if=\"$ctrl.variableProperties\">\n                            <br>\n                            The following trigger variables can be used in release title and tags:\n                            <ul>\n                                <li ng-repeat=\"variable in $ctrl.variableProperties\">${<span ng-bind=\"variable.name\"></span>}</li>\n                            </ul>\n                        </div>\n                    </div>\n                    <form name=\"triggerForm\" class=\"form-horizontal\">\n                        <div ng-repeat=\"(category, properties) in $ctrl.groupedProperties\">\n                            <fieldset>\n                                <legend ng-if=\"$ctrl.isNotCommonCategory(category)\">{{ category }}</legend>\n                                <div ng-repeat=\"property in properties\" dip-control large=\"false\" property=\"property\" container=\"$ctrl.trigger.properties\"></div>\n                            </fieldset>\n                        </div>\n\n                        <fieldset>\n                            <legend>Release tags</legend>\n                            <div class=\"form-group\">\n                                <label class=\"col-sm-3 control-label\">Tags</label>\n\n                                <div class=\"col-sm-9\">\n                                    <div id=\"tags\" class=\"transparent green-tags\" tags-input tags=\"$ctrl.trigger.tags\" placeholder=\"Add a tag...\" stop-submit-propagation></div>\n                                </div>\n                            </div>\n                        </fieldset>\n\n                        <fieldset ng-if=\"$ctrl.trigger.variables.length\">\n                            <legend>Template variables</legend>\n                            <div variables-editor\n                                 variables=\"$ctrl.trigger.variables\"\n                                 readonly=\"false\"\n                                 filter=\"{showOnReleaseStart: true}\">\n                            </div>\n                        </fieldset>\n\n                        <button ng-disabled=\"triggerForm.$invalid\" id=\"submit\" class=\"button primary\" ng-click=\"$ctrl.saveTrigger()\">Save</button>\n                        <button id=\"cancel\" class=\"button cancel\" ng-click=\"$ctrl.listTriggers()\">Cancel</button>\n                    </form>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n\n");
$templateCache.put("static/7.1.0/partials/templates/template-properties.html","<div id=\"template-properties\">\n    <div ng-if=\"!templateForm.newTemplate\" release-header>\n        <span doc-icon=\"release-properties.html\"></span>\n    </div>\n    <div id=\"new-template-header\" class=\"header\" ng-if=\"templateForm.newTemplate\">\n        <h4>{{title}}</h4>\n        <span doc-icon=\"creating-a-template.html\"></span>\n    </div>\n    <div class=\"content-under-header form-content\" ng-class=\"{\'new-template\': templateForm.newTemplate}\">\n        <form name=\"templatePropertiesForm\" id=\"templatePropertiesForm\" class=\"form-horizontal\">\n            <div class=\"row\">\n                <div class=\"col-sm-7\">\n                    <fieldset>\n                        <legend ng-if=\"!templateForm.newTemplate\">Properties for {{ release.title }}</legend>\n\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\" for=\"templateForm-title\">Template name <span ng-if=\"templatePropertiesForm.$error.required\"\n                                                                                                                        class=\"error\">*</span></label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <input type=\"text\" class=\"input-block-level\" id=\"templateForm-title\" ng-model=\"templateForm.title\" required autofocus\n                                       ng-disabled=\"!canEditTemplate()\"/>\n                                <span class=\"error\" ng-if=\"templatePropertiesForm.title.$error.required\">Template name is mandatory</span>\n                            </div>\n                        </div>\n\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Description</label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <span class=\"template-description\" ng-if=\"canEditTemplate()\" inline-textarea-editor model=\"templateForm.description\"\n                                      placeholder=\"Set description...\" markdown>\n                                    <span display-variables=\"templateForm.description\" variables=\"templateForm.variables\" markdown class=\"markdown\"></span>\n                                </span>\n                                <span ng-if=\"!canEditTemplate()\" class=\"template-description markdown\">\n                                    <span display-variables=\"templateForm.description\" variables=\"templateForm.variables\" markdown class=\"markdown\"></span>\n                                </span>\n                            </div>\n                        </div>\n\n                    </fieldset>\n                    <div class=\"form-footer\">\n                        <button class=\"button continue primary\" ng-click=\"templatePropertiesUpdated();\"\n                                ng-disabled=\"templatePropertiesForm.$invalid || !canEditTemplate()\">\n                            <span ng-if=\"templateForm.newTemplate\">Create</span>\n                            <span ng-if=\"!templateForm.newTemplate\">Save</span>\n                        </button>\n                        <button ng-if=\"templateForm.newTemplate\" type=\"button\" class=\"button cancel\" ng-click=\"back()\">Cancel</button>\n                        <button ng-if=\"!templateForm.newTemplate\" ng-disabled=\"!templatePropertiesForm.$dirty\" type=\"button\" class=\"button\"\n                                ng-click=\"templatePropertiesForm.$setPristine(); initTemplateForm()\">Reset\n                        </button>\n                        <div ng-if=\"templateUpdatedAt\" class=\"pull-left last-saved\">Last saved on {{ templateUpdatedAt | date: \'medium\' }}</div>\n                    </div>\n                </div>\n                <div class=\"col-sm-5\">\n                    <fieldset>\n                        <legend>Template details</legend>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Scheduled start date <span ng-if=\"!templateForm.hasValidDates\" class=\"error\">*</span></label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                            <span class=\"scheduled-start-date\"\n                                  date-editor\n                                  date=\"templateForm.scheduledStartDate\"\n                                  deletable=\"false\"\n                                  on-change=\"planning.updateScheduledStartDate(templateForm)\">\n                            </span>\n                                &nbsp;{{CurrentTimeZone.timeZone}}\n                            </div>\n                        </div>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Due date</label>\n\n                            <div class=\"due-date col-sm-8 col-lg-9\"\n                                 date-editor\n                                 date=\"templateForm.dueDate\"\n                                 placeholder=\"No date\"\n                                 inferred-date=\"planning.planElement.displayEndDate\"\n                                 deletable=\"true\"\n                                 on-change=\"planning.updateDueDate(templateForm)\">\n                            </div>\n                            <div class=\"col-sm-8 col-lg-9\" ng-if=\"!templateForm.hasValidDates\">\n                                <span class=\"error\">Start date must be before due date</span>\n                            </div>\n                        </div>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Duration</label>\n\n                            <div class=\"col-sm-8 col-lg-9 duration\" duration-editor\n                                 inferred-duration=\"planning.planElement.displayDuration\"\n                                 duration=\"templateForm.plannedDuration\"\n                                 editable=\"true\"\n                                 on-change=\"planning.updateDuration(templateForm)\">\n                            </div>\n                        </div>\n                        <hr>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Run automated tasks as user</label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <span ng-if=\"!templateForm.readonly\" class=\"input-block-level script-username\" inline-user-editor model=\"templateForm.scriptUsername\"\n                                      autocomplete-data=\"allUsers\" placeholder=\"Set user...\">\n                                    <span display-user=\"templateForm.scriptUsername\"></span>\n                                </span>\n                                <span ng-if=\"templateForm.readonly\" class=\"script-username read-only\">\n                                    <span display-user=\"templateForm.scriptUsername\"></span>\n                                </span>\n                            </div>\n                        </div>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Password</label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <span ng-if=\"!templateForm.readonly\" class=\"input-block-level script-userpassword\" inline-password-editor\n                                      model=\"templateForm.scriptUserPassword\" placeholder=\"Set password...\">\n                                    <span class=\"light-text\">Click here to modify the password</span>\n                                </span>\n                                <span ng-if=\"templateForm.readonly\" class=\"script-userpassword read-only\">\n                                    <span class=\"light-text\">*****</span>\n                                </span>\n                            </div>\n                        </div>\n                        <hr>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\" for=\"templateForm-abortOnFailure\">Abort on failure</label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <input type=\"checkbox\" ng-model=\"templateForm.abortOnFailure\" id=\"templateForm-abortOnFailure\"/>\n                            </div>\n                        </div>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Tags</label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <div id=\"tags\" class=\"transparent green-tags\" tags-input tags=\'templateForm.tags\' placeholder=\"Add a tag...\" read-only=\"!canEditTemplate()\"></div>\n                            </div>\n                        </div>\n                        <div class=\"form-group attachments-list\" ng-if=\"!templateForm.newTemplate\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Attachments</label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <div attachments-list\n                                     attachments=\"templateForm.attachments\"\n                                     readonly=\"!canEditTemplate()\"\n                                     upload-url=\"\'upload/attachment/\' + templateForm.templateId\"\n                                     can-delete-attachments=\"canEditTemplate()\"\n                                     delete-attachment=\"deleteAttachment(attachment)\"></div>\n                            </div>\n                        </div>\n\n                    </fieldset>\n                </div>\n            </div>\n        </form>\n\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/templates/template-triggers.html","<div id=\"triggers\">\n    <div release-header>\n        <span doc-icon=\"triggers.html\"></span>\n    </div>\n    <div class=\"content-under-header\">\n        <div class=\"help\">\n            On this page you can define your triggers, and the setting about the trigger execution.\n        </div>\n        <div id=\"triggers-settings\">\n\n            <h3>Settings</h3>\n\n            <form name=\"releaseTriggerOptions\" id=\"releaseTriggerOptions\" class=\"form-horizontal\">\n                <div class=\"form-group\">\n                    <label class=\"col-xs-3 control-label\" for=\"templateForm-allowConcurrentReleasesFromTrigger\">Allow concurrent\n                        triggered releases</label>\n\n                    <div class=\"col-xs-8\">\n                        <input type=\"checkbox\" ng-model=\"$ctrl.template.allowConcurrentReleasesFromTrigger\"\n                               id=\"templateForm-allowConcurrentReleasesFromTrigger\"/>\n                    </div>\n                </div>\n                <div class=\"last-saved\">\n                    <span ng-if=\"$ctrl.templateUpdatedAt\">Last saved on {{ $ctrl.templateUpdatedAt | date: \'medium\' }}</span>\n                    <span ng-if=\"!$ctrl.templateUpdatedAt\">&nbsp;</span>\n                </div>\n                <div class=\"form-footer\">\n                    <button type=\"submit\" class=\"button primary continue\" id=\"templateForm-save\"\n                            ng-click=\"$ctrl.updateTemplate()\" ng-disabled=\"releaseTriggerOptions.$pristine\">\n                        <span>Save</span>\n                    </button>\n                </div>\n            </form>\n        </div>\n        <hr/>\n        <div id=\"triggers-list\">\n            <h3>Triggers list</h3>\n            <table class=\"table table-rounded table-striped\" ng-if=\"$ctrl.triggers && $ctrl.triggers.length > 0\">\n                <tbody>\n                <tr ng-repeat=\"trigger in $ctrl.triggers\" class=\"trigger-instance\">\n                    <td class=\"open-instance\">\n                        <a class=\"link\"\n                           ng-href=\"#/templates/{{$ctrl.template.id}}/triggers/edit/{{trigger.id}}\">{{trigger.title}}</a>\n                    </td>\n                    <td class=\"open-related-release\">\n                        <a class=\"link\" ng-href=\"#/releases?tags={{trigger.name}}&has_filter&inProgress&paused&failing&failed\">\n                            Releases linked to this trigger\n                        </a>\n                    </td>\n                    <td class=\"delete-instance\" ng-click=\"$ctrl.deleteTrigger(trigger)\"><i class=\"remove-icon\"></i></td>\n                </tr>\n                </tbody>\n            </table>\n            <div ng-if=\"!$ctrl.triggers || $ctrl.triggers.length == 0\">\n                <p class=\"bold\">No triggers</p>\n            </div>\n            <select class=\"trigger-types\"\n                    ng-if=\"$ctrl.canCreateTriggers\"\n                    ng-change=\"$ctrl.addTrigger(triggerType)\"\n                    ng-model=\"triggerType\"\n                    ng-options=\"triggerType.type as triggerType.label for triggerType in $ctrl.triggerTypes\">\n                <option value=\"\" disabled selected>Add trigger ...</option>\n            </select>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/templates/templates.html","<div id=\"templates\" class=\"container-fluid\">\n    <div id=\"templates-header\" class=\"header\">\n        <filter filters=\"filters\" on-change=\"filtersChanged(filters)\">\n            <text-filter class=\"searchFilter_templates\" field=\"\'title\'\" placeholder=\"\'Filter by title...\'\"></text-filter>\n            <span class=\"filter-title\">Tags</span> <tag-filter class=\"tags-input\"></tag-filter>\n        </filter>\n        <a ng-href=\"#/templates/create\" class=\"button primary new-template\" ng-show=\"security.hasPermission(\'template#create\')\">New template</a>\n        <a class=\"button import-template\" ng-show=\"security.hasPermission(\'template#create\')\"\n           ng-click=\"UploadService.reset()\"\n           modal=\"\'partials/templates/import-template-modal.html\'\"\n           ng-controller=\"uploadController\">Import</a>\n        <span doc-icon=\"template-overview.html\"></span>\n    </div>\n    <xlr-template-list-component list=\"templates\"\n                                 templates-loader=\"templatesLoader\"\n                                 on-change=\"loadTemplates()\">\n    </xlr-template-list-component>\n</div>\n");
$templateCache.put("static/7.1.0/partials/value-stream-mapping/release-value-stream.html","<div id=\"release-value-stream\">\n    <div id=\"release-value-stream-header\" class=\"header\">\n        <div class=\"filter-release actions\" ng-controller=\"filtersController\">\n            <div ng-include=\"\'partials/filters/time-filters.html\'\"></div>\n            <input id=\"searchFilter\" autofocus type=\"search\" placeholder=\"Filter by title...\" ng-model=\"filters.title\">\n            <span class=\"tags-label\">Tags</span>\n            <div class=\"transparent tags-input green-tags\" tags-input tags=\"filters.tags\"\n                 placeholder=\"Add a tag...\" focus-on-click></div>\n        </div>\n        <span doc-icon=\"release-value-stream.html\"></span>\n        <div class=\"clearfix\"></div>\n    </div>\n    <div class=\"content\">\n        <div ng-if=\"releases.length != 0\">\n            <div id=\"legend\">\n                Legend <span class=\"flag-count\">Flagged tasks</span><span class=\"failure-count\">Failed tasks</span><span class=\"delay-count\">Delayed tasks</span>\n            </div>\n            <div ng-repeat=\"release in releases\">\n                <a class=\"release section color-inherited\" ui-sref=\"release({releaseId: release.id})\">\n                    <div class=\"section-header\">\n                        <span class=\"release-title\">{{ release.title }}</span>\n                        <span class=\"release-details\">From {{ release.startDate | date:\'mediumDate\' }} to {{ release.endDate | date:\'mediumDate\' }} | Duration {{ getCIDuration(release) | duration}}\n                            <span class=\"critical-phases-counter\" ng-show=\"getCriticalPhasesCount(release) > 0\">\n                                | <span ng-pluralize count=\"getCriticalPhasesCount(release)\" when=\"{\'0\': \'{} tasks\', \'1\': \'1 Critical phase\', \'other\': \'{} Critical phases\', \'many\': \'{} Critical phases\', \'few\': \'{} Critical phases\'}\"></span>\n                            </span>\n                            <span class=\"label label-aborted\" ng-show=\"release.status == \'ABORTED\'\">Aborted</span>\n                        </span>\n                    </div>\n                    <div class=\"section-body\">\n                        <div class=\"phase\" ng-repeat=\"phase in release.phases\" ng-class=\"{\'done\': isPhaseReadOnly(phase), \'critical\': isCritical(phase)}\">\n                            <div class=\"phase-body\">\n                                <div class=\"phase-header\" ng-style=\"{\'border-top-color\': phase.color}\">\n                                    <span class=\"phase-title\">{{ phase.title }}</span>\n                                </div>\n                                <div class=\"phase-content\">\n                                    <span ng-pluralize count=\"getLeafTasks(phase).length\" when=\"{\'0\': \'{} tasks\', \'1\': \'1 task\', \'other\': \'{} tasks\', \'many\': \'{} tasks\', \'few\': \'{} tasks\'}\"></span>\n                                    <br/>\n                                    <task-counters class=\"counters\" flags-count=\"phase.taskFlaggedCount\" delays-count=\"phase.taskDelayCount\" failures-count=\"phase.taskFailureCount\"></task-counters>\n                                </div>\n                            </div>\n                            <div class=\"phase-footer\">\n                                <span class=\"phase-duration\">{{ getCIDuration(phase) | duration }}</span>, {{ getDurationPercentage(release, phase) }}%\n                                <span class=\"phase-duration-graph\" phase-duration></span>\n                            </div>\n                        </div>\n                    </div>\n                </a>\n                <div class=\"clearfix\"></div>\n            </div>\n        </div>\n        <div pagination ci-loader=\"releasesLoader\"></div>\n        <div class=\"alert notice\" ng-show=\"!releasesLoader.isLoading() && !releases.length\">No releases found.</div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/variables/delete-variable-modal.html","<div class=\"modal-content delete-variable-modal\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <h4>{{ pageType !== \'GLOBAL\' ? \'Replace and delete\' : \'Delete\' }} {{::getKey(variable)}}</h4>\n    </div>\n    <div class=\"modal-body\">\n        <form name=\"deleteVariableForm\" class=\"form-horizontal delete-variable-form\" novalidate>\n            <span>\n                You are about to delete the variable <strong>{{::variable.key}}</strong>.\n            </span>\n            <div ng-if=\"pageType === \'GLOBAL\'\">\n                <p class=\"mtm\">This variable may still be in use. Tasks that use this variable will not be able to start.</p>\n            </div>\n            <div ng-if=\"checksUsage()\">\n                <div ng-if=\"isUsed\" class=\"variable-replacement\">\n                    <p class=\"mtm\">This variable is still in use.</p>\n                    <div variables-editor\n                         variables=\"replacement\"\n                         form=\"deleteVariableForm\"\n                         readonly=\"false\"\n                         all-variables=\"allVariables\"\n                         replace-variables=\"true\"\n                         supports-new-variable=\"true\"\n                         on-new-variable=\"createVariable(name, variableType, createdCallback)\"\n                         filter=\"{}\">\n                    </div>\n                </div>\n                <div ng-if=\"!isUsed\">\n                    <p class=\"mtm\">This variable is not currently in use.</p>\n                </div>\n            </div>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button class=\"button delete primary\" focus-on=\"true\" ng-disabled=\"deleteVariableForm.$invalid\" ng-click=\"deleteVariable(variable, dismiss);\">\n            {{ isUsed ? \'Replace and delete\' : \'Delete\' }}\n        </button>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/variables/edit-variable-modal.html","<div class=\"modal-content edit-variable-modal\">\n    <form name=\"editVariableForm\" class=\"form-horizontal edit-variable-form\" novalidate>\n        <div class=\"modal-header\">\n            <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n            <h4 ng-if=\"isReadonly\">{{::getKey(var)}}</h4>\n            <h4 ng-if=\"!isReadonly && !isNew\">Edit {{::getKey(var)}}</h4>\n            <h4 ng-if=\"!isReadonly && isNew\">Create variable {{getKey(var)}}</h4>\n        </div>\n        <div class=\"modal-body\">\n            <div class=\"form-group\">\n                <label class=\"col-xs-3 control-label\">Variable name</label>\n\n                <div class=\"col-xs-9\">\n                    <div ng-if=\"isRenameEnabled\" class=\"variable-name\">\n                        <div ng-if=\"pageType === \'GLOBAL\'\">\n                            <div class=\"input-group\" ng-init=\"currKey = var.key.replace(\'global.\', \'\')\">\n                                <span class=\"input-group-addon\">global.</span>\n                                <input name=\"fieldKey\" type=\"text\" class=\"input-block-level\" ng-model=\"currKey\" ng-change=\"var.key = \'global.\' + currKey\"\n                                       required not-in-list=\"existingVariableKeys\" autofocus>\n                            </div>\n                        </div>\n                        <div ng-if=\"pageType !== \'GLOBAL\'\">\n                            <input name=\"fieldKey\" type=\"text\" class=\"input-block-level\" ng-model=\"var.key\"\n                                   required not-in-list=\"existingVariableKeys\" autofocus ng-pattern=\"allowedKeyPattern\">\n                        </div>\n                    </div>\n                    <div ng-if=\"!isRenameEnabled\" class=\"variable-name\">\n                        <span class=\"field-readonly\">{{::getKey(var)}}</span>\n                    </div>\n                    <div class=\"description\" ng-if=\"!editVariableForm.fieldKey.$dirty || editVariableForm.$valid\">Unique name for the variable.</div>\n                    <div class=\"field-errors\" ng-if=\"editVariableForm.fieldKey.$dirty\">\n                        <span ng-if=\"editVariableForm.fieldKey.$error.required\">Variable name is mandatory</span>\n                        <span ng-if=\"editVariableForm.fieldKey.$error.notInList\">Variable with this name already exists</span>\n                        <span ng-if=\"editVariableForm.fieldKey.$error.pattern\">\n                            {{ pageType === \'TEMPLATE\' ?\n                            \'Template variable names cannot start with \\\'release.\\\' or \\\'global.\\\'\' :\n                            \'Release variable names cannot start with \\\'release.\\\' or \\\'global.\\\'\' }}\n                        </span>\n                    </div>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-xs-3 control-label\">Label</label>\n\n                <div class=\"col-xs-9\">\n                    <div ng-if=\"!isReadonly\" class=\"variable-label\">\n                        <input type=\"text\" class=\"input-block-level\" ng-model=\"var.label\" ng-disabled=\"isReadonly\" autofocus/>\n                    </div>\n                    <div ng-if=\"isReadonly\" class=\"variable-label\">\n                        <span class=\"field-readonly\">{{ var.label }}</span>\n                    </div>\n                    <div class=\"description\">The label of the variable.</div>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-xs-3 control-label\">Type</label>\n\n                <div class=\"col-xs-9\">\n                    <span ng-if=\"!isNew\" class=\"field-readonly\">{{::getVariableType(var).label}}</span>\n                    <select ng-if=\"isNew\" class=\"input-block-level\" ng-model=\"variableType\"\n                            ng-options=\"type as type.label for type in variableTypes track by type.id\"\n                            ng-change=\"typeSelected(\'{{getVariableType(var).id}}\', variableType.id)\">\n                    </select>\n                    <div class=\"description\">Variable type.</div>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-xs-3 control-label\">\n                    {{ pageType === \'TEMPLATE\' ? \'Default value\' : \'Value\' }}\n                </label>\n\n                <div class=\"col-xs-9\">\n                    <div ng-if=\"!isReadonly\" class=\"variable-value\">\n                        <input ng-if=\"isStringVariable(var)\" type=\"text\" class=\"input-block-level\" ng-model=\"var.value\" ng-disabled=\"isReadonly\" autofocus/>\n                        <select ng-if=\"isDropDownListBox(var)\" ng-options=\"v as v for v in possibleValues\" ng-model=\"var.value\" class=\"input-block-level\">\n                            <option value=\"\"></option>\n                        </select>\n                        <input ng-if=\"var.type == \'xlrelease.PasswordStringVariable\'\" type=\"password\" class=\"input-block-level\" ng-model=\"var.value\" ng-disabled=\"isReadonly\" autofocus/>\n                        <input ng-if=\"var.type == \'xlrelease.BooleanVariable\'\" type=\"checkbox\" class=\"input-block-level\" ng-model=\"var.value\" ng-checked=\"var.value\" ng-disabled=\"isReadonly\" autofocus/>\n                        <input xl-dip-integer ng-if=\"var.type == \'xlrelease.IntegerVariable\'\" type=\"text\" class=\"input-block-level\" ng-model=\"var.value\" ng-disabled=\"isReadonly\" autofocus metadata=\"{default: 0}\"/>\n                        <div ng-if=\"var.type == \'xlrelease.ListStringVariable\'\"\n                             xl-dip-list\n                             class=\"ui-front\"\n                             ng-model=\"var.value\"\n                             metadata=\"{name: \'list\', required: false }\"\n                             read-only=\"false\">\n                        </div>\n\n                        <div ng-if=\"var.type === \'xlrelease.DateVariable\'\">\n                            <div class=\"date-variable\"\n                                 date-editor\n                                 date=\"var.value\"\n                                 date-format=\"YYYY-MM-DDTHH:mm:ssZ\"\n                                 deletable=\"true\"\n                                 placeholder=\"Select date\"\n                                 readonly=\"false\">\n                            </div>\n                        </div>\n\n                        <div ng-if=\"var.type == \'xlrelease.SetStringVariable\'\"\n                             xl-dip-set\n                             class=\"ui-front\"\n                             ng-model=\"var.value\"\n                             metadata=\"{name: \'set\', required: false }\"\n                             read-only=\"false\">\n                        </div>\n                        <div ng-if=\"var.type == \'xlrelease.MapStringStringVariable\'\"\n                             xl-dip-map-string-string\n                             class=\"field\"\n                             ng-model=\"var.value\"\n                             metadata=\"{name: \'mapstringstring\', required: false, minVisibleRow: 3 }\"\n                             read-only=\"false\">\n                        </div>\n                    </div>\n                    <div ng-if=\"isReadonly\" class=\"variable-value\">\n                        <span ng-if=\"isSimpleStringType(var.type) || var.type === \'xlrelease.DateVariable\' || var.type === \'xlrelease.IntegerVariable\'\" class=\"field-readonly\">{{ getValue(var) }}</span>\n                        <input type=\"checkbox\" data-ng-if=\"var.type === \'xlrelease.BooleanVariable\'\" data-ng-checked=\"var.value\" disabled=\"disabled\">\n                        <div ng-if=\"var.type == \'xlrelease.ListStringVariable\'\"\n                             xl-dip-list\n                             class=\"field\"\n                             ng-model=\"var.value\"\n                             metadata=\"{name: \'list\', required: false }\"\n                             read-only=\"true\"></div>\n                        <div ng-if=\"var.type == \'xlrelease.SetStringVariable\'\"\n                             xl-dip-set\n                             class=\"ui-front\"\n                             ng-model=\"var.value\"\n                             metadata=\"{name: \'set\', required: false }\"\n                             read-only=\"true\"></div>\n                        <div ng-if=\"var.type == \'xlrelease.MapStringStringVariable\'\"\n                             xl-dip-map-string-string\n                             class=\"field\"\n                             ng-model=\"var.value\"\n                             metadata=\"{name: \'mapstringstring\', required: false, minVisibleRow: 3 }\"\n                             read-only=\"true\"></div>\n                    </div>\n                    <div class=\"description\">The value of the variable.</div>\n                </div>\n            </div>\n            <div class=\"form-group\" ng-if=\"isDropDownListBox(var) && expandedValueProvider.values\">\n                <label class=\"col-xs-3 control-label\">\n                    Possible values\n                </label>\n                <div class=\"col-xs-9\">\n                    <div xlr-list-of-strings-with-variables\n                         name=\"expanded-value-provider-value\"\n                         model=\"expandedValueProvider.values\"\n                         on-new=\"onNewVariablePF(name, variableType, createdCallback)\"\n                         on-change=\"saveProviderAndPopulateValues()\"\n                         variables=\"allVariables\"\n                         read-only=\"isReadonly\">\n                    </div>\n                    <div class=\"description\">The list of possible values.</div>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-xs-3 control-label\">Description</label>\n\n                <div class=\"col-xs-9\">\n                    <div ng-if=\"!isReadonly\" class=\"variable-description\">\n                        <input type=\"text\" class=\"input-block-level\" ng-model=\"var.description\" ng-disabled=\"isReadonly\" autofocus/>\n                    </div>\n                    <div ng-if=\"isReadonly\" class=\"variable-description\">\n                        <span class=\"field-readonly\">{{ var.description }}</span>\n                    </div>\n                    <div class=\"description\">The description of the variable.</div>\n                </div>\n            </div>\n            <div class=\"form-group\" ng-if=\"pageType !== \'GLOBAL\'\">\n                <label class=\"col-xs-3 control-label\">Required</label>\n\n                <div class=\"col-xs-9\">\n                    <input type=\"checkbox\" ng-model=\"var.requiresValue\" ng-disabled=\"isReadonly\"/>\n                    <div class=\"description\">If selected, the variable cannot be empty when the release or task that uses the variable starts.</div>\n                </div>\n            </div>\n            <div class=\"form-group\" ng-if=\"pageType !== \'GLOBAL\' && pageType !== \'RELEASE\'\">\n                <label class=\"col-xs-3 control-label\">Show on Create Release form</label>\n\n                <div class=\"col-xs-9\">\n                    <input type=\"checkbox\" ng-model=\"var.showOnReleaseStart\" ng-disabled=\"isReadonly\"/>\n                    <div class=\"description\">Show the variable on the Create Release screen or Create Release task.</div>\n                </div>\n            </div>\n        </div>\n        <div class=\"modal-footer\">\n            <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"button save primary\" ng-if=\"!isReadonly\" ng-disabled=\"editVariableForm.$invalid\"\n                    ng-click=\"saveVariable(var, dismiss);\">{{ isNewTemplate ? \'Create\' : \'Save\' }}</button>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/7.1.0/partials/variables/global-variables.html","<div id=\"global-variables\">\n    <div class=\"header\">\n        <div class=\"actions\">\n            <input id=\"variables-filter\" type=\"search\" class=\"variables-filter\" placeholder=\"Search...\" ng-model=\"filters.filter\">\n            <span ng-if=\"!isReadonly\"\n                  edit-variable\n                  init-variable=\"newVariable()\"\n                  save=\"createGlobalVariable\"\n                  on-new-variable=\"createGlobalVariable\"\n                  is-new=\"true\"\n                  is-readonly=\"false\"\n                  is-rename-enabled=\"true\"\n                  all-variables=\"decoratedVariables\"\n                  page-type=\"\'GLOBAL\'\"\n                  class=\"button primary new-variable\">New global variable</span>\n        </div>\n        <span doc-icon=\"global-variables.html\"></span>\n    </div>\n\n    <div id=\"variables-content\" class=\"content-under-header\">\n        <div variables-list\n             variables=\"variables\"\n             all-variables=\"decoratedVariables\"\n             filter=\"filters.filter\"\n             on-change=\"updateGlobalVariable\"\n             on-delete=\"deleteGlobalVariable(variable, callback)\"\n             on-new-variable=\"createGlobalVariable\"\n             is-readonly=\"isReadonly\"\n             is-rename-enabled=\"false\"\n             page-type=\"\'GLOBAL\'\"></div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/variables/variables-editor-default-controls.html","<div ng-if=\"variable.type == \'xlrelease.PasswordStringVariable\' && !readonly\" class=\"password ui-front\" inline-password-editor name=\"{{variable.key}}\"\n     placeholder=\"Set password\" model=\"variable.value\" on-change=\"onChange({variable: variable})\" ng-required=\"variable.requiresValue\"\n     allow-commit-on-invalid=\"true\">\n     <span class=\"light-text\">*****</span>\n</div>\n<div ng-if=\"variable.type == \'xlrelease.PasswordStringVariable\' && readonly\" class=\"password field-readonly read-only\" ng-if=\"vm.readOnly\">\n     <span class=\"light-text\">*****</span>\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.BooleanVariable\'\" class=\"ui-front\" name=\"{{variable.key}}\">\n     <input type=\"checkbox\" ng-model=\"variable.value\" ng-checked=\"variable.value\" ng-change=\"onChange({variable: variable})\" ng-disabled=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.IntegerVariable\'\" class=\"ui-front\" name=\"{{variable.key}}\">\n     <input xl-dip-integer type=\"text\" ng-model=\"variable.value\" ng-blur=\"onChange({variable: variable})\" metadata=\"{default: 0}\" ng-disabled=\"readonly\" ng-class=\"{\'input-readonly read-only\': readonly}\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.ListStringVariable\'\"\n     xl-dip-list\n     class=\"ui-front\"\n     name=\"{{variable.key}}\"\n     ng-model=\"variable.value\"\n     metadata=\"{name: \'list\', required: variable.requiresValue}\"\n     read-only=\"readonly\"\n     on-change=\"onChange({variable: variable})\"></div>\n\n<div ng-if=\"variable.type == \'xlrelease.SetStringVariable\'\"\n     xl-dip-set\n     class=\"ui-front\"\n     name=\"{{variable.key}}\"\n     ng-model=\"variable.value\"\n     metadata=\"{name: \'set\', required: variable.requiresValue}\"\n     read-only=\"readonly\"\n     on-change=\"onChange({variable: variable})\"></div>\n\n<div ng-if=\"variable.type == \'xlrelease.MapStringStringVariable\'\"\n     xl-dip-map-string-string\n     class=\"field\"\n     name=\"{{variable.key}}\"\n     ng-model=\"variable.value\"\n     on-change=\"onChange({variable: variable})\"\n     read-only=\"readonly\"\n     metadata=\"{name: \'mapstringstring\', required: variable.requiresValue, minVisibleRow: 3}\"\n     open-on-click=\"true\"></div>\n\n<div ng-if=\"variable.type === \'xlrelease.DateVariable\'\" class=\"ui-front\">\n    <div class=\"date-variable\"\n         date-editor\n         date=\"variable.value\"\n         date-format=\"YYYY-MM-DDTHH:mm:ssZ\"\n         placeholder=\"Select date\"\n         on-change=\"onChange({variable: variable})\"\n         deletable=\"true\"\n         readonly=\"readonly\">\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/variables/variables-editor-replace-controls.html","<div ng-if=\"variable.type == \'xlrelease.PasswordStringVariable\'\"\n     xlr-inline-password-with-variables\n     class=\"field\"\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.BooleanVariable\'\"\n     xlr-boolean-with-variables\n     class=\"field\"\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.IntegerVariable\'\"\n     xlr-integer-with-variables\n     class=\"field\"\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     metadata=\"{default: 0}\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.ListStringVariable\'\"\n     xlr-list-of-strings-with-variables\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.SetStringVariable\'\"\n     xlr-set-of-strings-with-variables\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.MapStringStringVariable\'\"\n     xlr-map-string-string-with-variables\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.DateVariable\'\"\n     xlr-date-with-variables\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n");
$templateCache.put("static/7.1.0/partials/variables/variables-editor.html","<div class=\"variable-editor\">\n    <div class=\"form-group\" ng-repeat=\"variable in variables | filter : filter\">\n        <label class=\"col-sm-3 control-label\" ng-class=\"getVariableControlLabelClass(variable)\">\n            <span tooltip=\"getKey(variable)\" tooltip-position=\"bottom\">{{ getDisplayName(variable) }}</span>\n            <span ng-if=\"variable.requiresValue\"\n                  class=\"error\">*</span>\n        </label>\n        <div class=\"col-sm-9\" id=\"{{variable.key}}\">\n            <div ng-if=\"!readonly\">\n                <div ng-if=\"isStringVariable(variable)\" class=\"ui-front\" inline-text-editor name=\"{{variable.key}}\" model=\"variable.value\"\n                     on-change=\"onChange({variable: variable})\" ng-required=\"variable.requiresValue\" allow-commit-on-invalid=\"true\">\n                    <span display-variables=\"variable.value\" variables=\"allVariables\"></span>\n                </div>\n                <inline-drop-down-list-editor ng-if=\"isDropDownListBox(variable)\" variable=\"variable\"\n                                              on-change=\"onChange({variable: variable})\"></inline-drop-down-list-editor>\n            </div>\n            <div ng-if=\"readonly\">\n                <div ng-if=\"variable.type == \'xlrelease.StringVariable\'\" class=\"ui-front xl-components\">\n                    <span class=\"field-readonly read-only\">\n                        <span display-variables=\"variable.value\" variables=\"allVariables\"></span>\n                    </span>\n                </div>\n            </div>\n            <div ng-if=\"replaceVariables\" ng-include=\"\'partials/variables/variables-editor-replace-controls.html\'\"></div>\n            <div ng-if=\"!replaceVariables\" ng-include=\"\'partials/variables/variables-editor-default-controls.html\'\"></div>\n\n            <div class=\"description\" ng-if=\"variable.description\">{{ ::variable.description }}</div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/variables/variables-list.html","<div class=\"variables-list\">\n    <div class=\"row-table container-fluid\" ng-if=\"variables.length > 0\">\n        <div class=\"header-row row\">\n            <div class=\"col-xs-3 plm\">Variable name</div>\n            <div class=\"col-xs-2\">Label</div>\n            <div class=\"col-xs-3\">{{ pageType === \'TEMPLATE\' ? \'Default value\' : \'Value\' }}</div>\n            <div class=\"col-xs-1 col-lg-2\">Type</div>\n            <div class=\"col-xs-3 col-lg-2\">Actions</div>\n        </div>\n        <div ui-sortable=\"sortableOptions\" ng-model=\"variables\" class=\"xl-dip-collection-of-ci row\">\n            <div ng-repeat=\"variable in variables | filter : filterOnVisibleFields(filter)  track by variable.id\" class=\"variable ui-sortable-handle\">\n                <div edit-variable\n                     init-variable=\"editVariable(variable)\"\n                     save=\"saveVariable\"\n                     on-new-variable=\"createVariable\"\n                     is-new=\"false\"\n                     is-readonly=\"isReadonly\"\n                     all-variables=\"allVariables\"\n                     is-rename-enabled=\"isRenameEnabled\"\n                     page-type=\"pageType\"\n                     class=\"data-row row ui-sortable\">\n                    <div class=\"col-xs-3 plm\">{{ getKey(variable) }}</div>\n                    <div class=\"col-xs-2\">{{ variable.label }}</div>\n                    <div class=\"col-xs-3\">{{ getValue(variable) }}</div>\n                    <div class=\"col-xs-1 col-lg-2\">{{ getVariableType(variable).label }}</div>\n                    <div class=\"col-xs-3 col-lg-2\">\n                        <div class=\"row variable-actions\">\n                            <div ng-if=\"isReadonly\" class=\"col-md-12\"><span class=\"action edit\"><i class=\"view-icon\"></i>  View</span></div>\n                            <div ng-if=\"!isReadonly\" class=\"col-md-12\">\n                                <span class=\"action edit\"><i class=\"pencil-icon\"></i>  Edit</span>\n                                <span delete-variable model=\"variable\" all-variables=\"allVariables\"\n                                      on-delete=\"onDelete({variable: variable, callback: callback})\"\n                                      on-new-variable=\"createVariable\"\n                                      page-type=\"pageType\"></span>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class=\"alert notice\" ng-if=\"variables.length == 0\">No variables defined.</div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/variable-selector/variable-toggle-and-selector.html","<span class=\"variable-toggle\" ng-click=\"vm.toggleMode();\" ng-if=\"vm.showToggle == true && !vm.readOnly\">\n    <button class=\"button\"\n            ng-class=\"{\'primary\': vm.variableMode}\"\n            tooltip=\"vm.variableMode ? \'Switch to manual entry\' : \'Switch to variable\'\"\n            tooltip-position=\"bottom\">\n        ${\n    </button>\n</span>\n<span class=\"variable-dropdown\" ng-show=\"vm.variableMode == true\">\n    <span ng-if=\"vm.variableMode == true && vm.readOnly\" class=\"field-readonly read-only\" name=\"{{::vm.name}}\">\n        <span>{{ vm.draft.variable.displayName }}</span>\n     </span>\n    <div ng-if=\"!vm.readOnly\"\n         xl-widget-autocomplete\n         ng-model=\"vm.draft.variable\"\n         handlers=\"vm.handlers\"\n         options=\"{placeholder : \'Please select a variable of type \' + vm.variableTypeName}\"\n         obj-label=\"displayName\"\n         show-all-on-click=\"true\"\n         new-item-suffix=\"{{\'<i> &ndash; Create a new variable of type \' + vm.variableTypeName + \'</i>\'}}\"\n         auto-select-on-exact-match=\"false\"\n         open-on-click=\"true\"></div>\n</span>\n");
$templateCache.put("static/7.1.0/partials/directives/variable-selector/xlr-boolean-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-show=\"!vm.variableMode\">\n        <div ng-class=\"{\'field\': !vm.readOnly, \'field-readonly\': vm.readOnly}\">\n            <input name=\"{{::vm.name}}\" type=\"checkbox\" ng-model=\"vm.draft.value\"\n                     ng-checked=\"vm.draft.value\" ng-change=\"vm.onChangeInternal()\" ng-disabled=\"vm.readOnly\">\n        </div>\n    </span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/variable-selector/xlr-date-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-show=\"!vm.variableMode\">\n        <div ng-class=\"{\'field\': !vm.readOnly, \'field-readonly\': vm.readOnly}\">\n            <div class=\"date-variable\"\n                 date-editor\n                 name=\"{{::vm.name}}\"\n                 date-format=\"YYYY-MM-DDTHH:mm:ssZ\"\n                 date=\"vm.draft.value\"\n                 placeholder=\"Select date\"\n                 on-change=\"vm.onChangeInternal()\"\n                 deletable=\"true\"\n                 readonly=\"vm.readOnly\">\n            </div>\n        </div>\n    </span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/variable-selector/xlr-dependency-with-variables.html","<div class=\"variable-selector\">\n    <div class=\"row\">\n        <div class=\"col-md-9\">\n            <div class=\"btn-group btn-group-justified\" role=\"group\">\n                <div class=\"btn-group\">\n                    <button class=\"btn btn-flat manual-dependency-radio\" ng-class=\"{\'btn-flat-active\': !vm.variableMode}\" ng-click=\"vm.variableMode = false; vm.commit()\">\n                        <i class=\"manual-dependency-icon\"></i>Release, phase, or task\n                    </button>\n                </div>\n                <div class=\"btn-group\">\n                    <button class=\"btn btn-flat variable-dependency-radio\" ng-class=\"{\'btn-flat-active\': vm.variableMode}\"\n                            ng-click=\"vm.variableMode = true; vm.commit()\"\n                            ng-disabled=\"!vm.options.variableModeEnabled\">\n                        <i class=\"variable-icon\"></i>Variable\n                    </button>\n                </div>\n            </div>\n        </div>\n    </div>\n    <ng-switch on=\"vm.variableMode\">\n        <div class=\"variable-dropdown variable-dropdown-with-margin\" ng-switch-when=\"true\">\n            <div xl-widget-autocomplete\n                 ng-model=\"vm.draft.variable\"\n                 handlers=\"vm.handlers\"\n                 options=\"{placeholder : \'Please select a variable of type \' + vm.variableTypeName}\"\n                 obj-label=\"displayName\"\n                 show-all-on-click=\"true\"\n                 new-item-suffix=\"{{\'<i> &ndash; Create a new variable of type \' + vm.variableTypeName + \'</i>\'}}\"\n                 auto-select-on-exact-match=\"false\"\n                 open-on-click=\"true\"></div>\n        </div>\n        <div class=\"editor\" ng-switch-default>\n            <dependency-selector\n                 model=\"vm.draft.value\"\n                 task-id=\"vm.options.taskId\"\n                 on-change=\"vm.onChangeInternal()\">\n            </dependency-selector>\n        </div>\n    </ng-switch>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/variable-selector/xlr-inline-password-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-show=\"vm.variableMode == false\">\n        <span ng-if=\"!vm.readOnly\">\n            <span class=\"field\" name=\"{{::vm.name}}\" inline-password-editor model=\"vm.draft.value\" on-change=\"vm.onChangeInternal()\">\n                <span class=\"light-text\">Click here to modify the password</span>\n            </span>\n        </span>\n        <span class=\"field-readonly read-only\" ng-if=\"vm.readOnly\">\n           <span class=\"light-text\">*****</span>\n        </span>\n    </span>\n</div>");
$templateCache.put("static/7.1.0/partials/directives/variable-selector/xlr-inline-text-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-show=\"vm.variableMode == false\">\n         <span inline-text-editor\n               ng-if=\"!vm.readOnly\"\n               name=\"{{::vm.name}}\"\n               class=\"field\"\n               model=\"vm.draft.value\"\n               on-change=\"vm.onChangeInternal()\">\n            <span>{{ vm.draft.value }}</span>\n         </span>\n         <span ng-if=\"vm.readOnly\" class=\"field-readonly read-only inline-textarea\" name=\"{{::vm.name}}\">\n             <span>{{ vm.draft.value }}</span>\n         </span>\n    </span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/variable-selector/xlr-integer-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"xl-components editor\" ng-show=\"vm.variableMode == false\">\n         <input xl-dip-integer ng-if=\"!vm.readOnly\" name=\"{{::vm.name}}\" type=\"text\" class=\"editable\" ng-model=\"vm.draft.value\"\n                ng-blur=\"vm.onChangeInternal()\" metadata=\"{default: 0}\">\n         <span ng-if=\"vm.readOnly\" class=\"field-readonly read-only\" name=\"{{::vm.name}}\">\n            <span>{{ vm.draft.value }}</span>\n         </span>\n    </span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/variable-selector/xlr-list-of-strings-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-show=\"vm.variableMode == false\">\n        <div xl-dip-list\n             class=\"field\"\n             name=\"{{::vm.name}}\"\n             data-ng-model=\"vm.draft.value\"\n             metadata=\"{name: vm.name, required: false}\"\n             read-only=\"vm.readOnly\"\n             on-change=\"vm.onChangeInternal()\"></div>\n    </span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/variable-selector/xlr-map-string-string-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-show=\"vm.variableMode == false\">\n        <div xl-dip-map-string-string\n             class=\"field\"\n             name=\"{{::vm.name}}\"\n             data-ng-model=\"vm.draft.value\"\n             metadata=\"{name: vm.name, required: false, minVisibleRow: 5}\"\n             read-only=\"vm.readOnly\"\n             on-change=\"vm.onChangeInternal()\"\n             open-on-click=\"true\"></div>\n    </span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/directives/variable-selector/xlr-set-of-strings-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-show=\"vm.variableMode == false\">\n        <div xl-dip-set\n             class=\"field\"\n             name=\"{{::vm.name}}\"\n             data-ng-model=\"vm.draft.value\"\n             metadata=\"{name: vm.name, required: false}\"\n             read-only=\"vm.readOnly\"\n             on-change=\"vm.onChangeInternal()\"></div>\n    </span>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/gantt/gantt.html","<div id=\"gantt\" class=\"gantt\">\n    <div release-flow-header>\n        <div id=\"gantt-zooms-container\">\n            <span>Zoom</span>\n            <button class=\"btn btn-flat\"\n                    ng-click=\"ganttZoom.select(ganttZoom.previous())\"\n                    ng-disabled=\"!ganttZoom.hasPrevious()\">-</button>\n            <button type=\"button\" class=\"btn btn-flat dropdown-button\" bs-popover data-content-template=\"partials/releases/gantt/zoom.html\" data-placement=\"bottom\" auto-close=\"true\">\n                {{ ganttZoom.getCurrent().label }}\n                <span class=\"caret\"></span>\n            </button>\n            <button class=\"btn btn-flat\"\n                    ng-click=\"ganttZoom.select(ganttZoom.next())\"\n                    ng-disabled=\"!ganttZoom.hasNext()\">+</button>\n            <input type=\"checkbox\" id=\"toggleIsDatesColumnsShown\"\n                   ng-model=\"ganttConfig.isDatesColumnsShown\">\n            <label for=\"toggleIsDatesColumnsShown\">Show dates</label>\n        </div>\n        <span doc-icon=\"planner.html\"></span>\n    </div>\n    <div class=\"content-under-header\">\n        <div class=\"gantt-container\" gantt readonly=\"ganttConfig.isReadOnly\"></div>\n    </div>\n    <div ng-if=\"editTask\" modal=\"\'partials/tasks/details/task-details-modal.html\'\" open-on=\"editTask\" on-modal-hide=\"endEditTask()\" init=\"editTask(task, release)\" ng-controller=\"taskDetailsController\"></div>\n    <div ng-if=\"editPhase\" modal=\"\'partials/releases/phase-details-modal.html\'\" open-on=\"editPhase\" on-modal-hide=\"endEditPhase()\" ng-controller=\"phaseDetailsController\"></div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/gantt/zoom.html","<div id=\"gantt-zooms\">\n    <a ng-repeat=\"zoom in ganttZoom.zooms\" ng-click=\"ganttZoom.select(zoom)\">\n        <div><span ng-class=\"{\'active\': ganttZoom.isCurrent(zoom)}\"></span> {{ zoom.label }}</div>\n    </a>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/grid/grid-context-menu.html","<div context-menu id=\"context-menu-container\" items=\"grid.appScope.ctrl.contextMenuItems(row.entity.planItem, grid.appScope.ctrl.withinBlackout)\" ctrl=\"grid.appScope.ctrl\" task=\"row.entity.planItem\" container=\"row.entity.container\"></div>");
$templateCache.put("static/7.1.0/partials/releases/grid/more-bulk-actions-menu.html","<div class=\"xlr-popover\">\n    <a class=\"add-comment-action\" ng-class=\"{\'link-disabled\': !$ctrl.allowedActions.comment}\"\n       ng-click=\"$ctrl.allowedActions.comment && $ctrl.addComment()\">\n        <div>Add comment</div>\n    </a>\n    <a class=\"remove-action\" ng-class=\"{\'link-disabled\': !$ctrl.allowedActions.remove}\"\n       ng-click=\"$ctrl.allowedActions.remove && $ctrl.remove()\">\n        <div>Delete</div>\n    </a>\n    <a class=\"fail-action\" ng-class=\"{\'link-disabled\': !$ctrl.allowedActions.fail}\"\n       ng-click=\"$ctrl.allowedActions.fail && $ctrl.fail()\">\n        <div>Fail</div>\n    </a>\n    <a class=\"retry-action\" ng-class=\"{\'link-disabled\': !$ctrl.allowedActions.retry}\"\n       ng-click=\"$ctrl.allowedActions.retry && $ctrl.retry()\">\n        <div>Retry</div>\n    </a>\n    <a class=\"abort-action\" ng-class=\"{\'link-disabled\': !$ctrl.allowedActions.abort}\"\n       ng-click=\"$ctrl.allowedActions.abort && $ctrl.abort()\">\n        <div>Abort</div>\n    </a>\n    <a class=\"reopen-action\" ng-class=\"{\'link-disabled\': !$ctrl.allowedActions.reopen}\"\n       ng-click=\"$ctrl.allowedActions.reopen && $ctrl.reopen()\">\n        <div>Reopen</div>\n    </a>\n</div>\n");
$templateCache.put("static/7.1.0/partials/releases/grid/release-grid.html","<div id=\"release\" class=\"release-grid {{ release.status | lowercase }}\">\n    <div release-flow-header>\n        <a ng-if=\"pageCtrl.canRefreshGrid(release)\" ng-click=\"pageCtrl.refreshGrid()\" title=\"Refresh\" class=\"refresh-grid button\">\n            <i class=\"glyphicon glyphicon-refresh\"></i> Refresh\n        </a>\n        <a ng-if=\"pageCtrl.canStartRelease(release)\" modal=\"\'partials/releases/start-release-modal.html\'\" class=\"start-release primary button\">Start Release</a>\n        <a ng-if=\"pageCtrl.canAbortRelease(release)\" modal=\"\'partials/releases/abort-release-modal.html\'\" class=\"abort-release button\">Abort Release</a>\n\n        <span doc-icon=\"release-grid.html\"></span>\n    </div>\n    <div class=\"content-under-header\">\n        <div release-grid release=\"release\"></div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/actions/done-in-advance-task.html","<div class=\"task-actions\">\n    <button class=\"button primary\" ng-click=\"reopenTaskMode = !reopenTaskMode\" ng-hide=\"reopenTaskMode\">Reopen</button>\n</div>\n<div class=\"task-actions\" ng-show=\"reopenTaskMode\">\n    <form name=\"reopenTaskForm\">\n        <textarea rows=\"4\" ng-model=\"reopenFeedback\" placeholder=\"Give feedback or place a comment to reopen the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"reopenTask(task, reopenFeedback); dismiss();\" ng-disabled=\"reopenTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"reopenTaskMode = !reopenTaskMode\">Cancel</button>\n    </form>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/actions/failed-task.html","<div class=\"task-actions\">\n    <button class=\"button primary\" ng-click=\"retryTaskMode = !retryTaskMode; skipTaskMode = false\" ng-hide=\"!security.isAdminOr(task.releaseOwner) && !security.isAdminOr(task.owner) || skipTaskMode || retryTaskMode\">Retry</button>\n    <button class=\"button\" ng-click=\"skipTaskMode = !skipTaskMode; retryTaskMode = false\" ng-hide=\"skipTaskMode || retryTaskMode\">Skip</button>\n</div>\n<div class=\"task-actions\" ng-show=\"skipTaskMode\">\n    <form name=\"skipTaskForm\">\n        <textarea rows=\"4\" ng-model=\"skipFeedback\" placeholder=\"Give feedback or place a comment to skip the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"skipTask(task, skipFeedback); dismiss();\" ng-disabled=\"skipTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button\" ng-click=\"skipTaskMode = !skipTaskMode\">Cancel</button>\n    </form>\n</div>\n<div class=\"task-actions\" ng-show=\"retryTaskMode\">\n    <form name=\"retryTaskForm\">\n        <textarea rows=\"4\" ng-model=\"retryFeedback\" placeholder=\"Give feedback or place a comment to retry the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"retryTask(task, retryFeedback); dismiss();\" ng-disabled=\"retryTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button\" ng-click=\"retryTaskMode = !retryTaskMode\">Cancel</button>\n    </form>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/actions/in-progress-script-task.html","<div class=\"task-actions\">\n    <button class=\"button\" ng-click=\"abortTaskMode = !abortTaskMode\" ng-hide=\"abortTaskMode\">Abort</button>\n</div>\n<div class=\"task-actions\" ng-show=\"abortTaskMode\">\n    <form name=\"abortTaskForm\">\n        <textarea rows=\"4\" ng-model=\"abortFeedback\" placeholder=\"Give feedback or place a comment to abort the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"abortTask(task, abortFeedback); dismiss();\" ng-disabled=\"abortTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"abortTaskMode = !abortTaskMode\">Cancel</button>\n    </form>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/actions/in-progress-task.html","<div class=\"task-actions\">\n    <button class=\"button primary\" ng-click=\"completeTaskMode = !completeTaskMode; skipTaskMode = false; failTaskMode = false\" ng-disabled=\"!canCompleteTask(release, task)\" ng-hide=\"completeTaskMode || skipTaskMode || failTaskMode\">Complete</button>\n    <button class=\"button\" ng-click=\"skipTaskMode = !skipTaskMode; completeTaskMode = false; failTaskMode = false\" ng-hide=\"completeTaskMode || skipTaskMode || failTaskMode\">Skip</button>\n    <button class=\"button\" ng-click=\"failTaskMode = !failTaskMode; completeTaskMode = false; skipTaskMode = false\" ng-hide=\"completeTaskMode || skipTaskMode || failTaskMode\">Fail</button>\n</div>\n<div class=\"task-actions\" ng-show=\"completeTaskMode && canCompleteTask(release, task)\">\n    <form name=\"completeTaskForm\">\n        <textarea rows=\"4\" ng-model=\"feedback\" placeholder=\"Give feedback or place a comment to complete the task...\"></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"completeTask(task, feedback); dismiss();\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"completeTaskMode = !completeTaskMode\">Cancel</button>\n    </form>\n</div>\n<div class=\"task-actions\" ng-show=\"skipTaskMode\">\n    <form name=\"skipTaskForm\">\n        <textarea rows=\"4\" ng-model=\"skipFeedback\" placeholder=\"Give feedback or place a comment to skip the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"skipTask(task, skipFeedback); dismiss();\" ng-disabled=\"skipTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"skipTaskMode = !skipTaskMode\">Cancel</button>\n    </form>\n</div>\n<div class=\"task-actions\" ng-show=\"failTaskMode\">\n    <form name=\"failTaskForm\">\n        <textarea rows=\"4\" ng-model=\"failFeedback\" placeholder=\"Give feedback or place a comment to fail the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"failTask(task, failFeedback); dismiss();\" ng-disabled=\"failTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"failTaskMode = !failTaskMode\">Cancel</button>\n    </form>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/actions/pending-task.html","<div class=\"task-actions\">\n    <div ng-if=\"!canStartTaskWithinBlackout(release)\">\n        <span class=\"error\">\n            You can\'t start this task now because it\'s subject to the current blackout period.\n        </span>\n    </div>\n    <button class=\"button\" ng-click=\"startTaskMode = !startTaskMode;\" ng-hide=\"startTaskMode\" ng-disabled=\"!canStartTaskWithinBlackout(release)\">Start now</button>\n</div>\n<div ng-show=\"startTaskMode\" class=\"task-actions\">\n    <form name=\"startTaskNowForm\">\n        <textarea rows=\"4\" ng-model=\"feedback\" placeholder=\"Give feedback or place a comment to start the task now...\" required></textarea>\n        <div class=\"task-actions-info\" ng-if=\"task.delayDuringBlackout && withinBlackout\">\n            <span class=\"error\">Are you sure you want to run this task during the blackout period?</span>\n        </div>\n        <button type=\"button\" class=\"button primary\" ng-click=\"startNow(task, feedback);dismiss();\" ng-disabled=\"startTaskNowForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"startTaskMode = !startTaskMode;\">Cancel</button>\n    </form>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/actions/planned-task.html","<div class=\"task-actions\">\n    <button class=\"button primary\" ng-click=\"completeTaskMode = !completeTaskMode; skipTaskMode = false\" ng-disabled=\"isGateClosed(task)\" ng-hide=\"isAutomated(task) || completeTaskMode || skipTaskMode\">Complete</button>\n    <button class=\"button\" ng-click=\"skipTaskMode = !skipTaskMode; completeTaskMode = false\" ng-hide=\"completeTaskMode || skipTaskMode\">Skip</button>\n</div>\n<div class=\"task-actions\" ng-show=\"!isAutomated(task) && completeTaskMode && !isGateClosed(task)\">\n    <form name=\"completeTaskForm\">\n        <textarea rows=\"4\" ng-model=\"feedback\" placeholder=\"Give feedback or place a comment to complete the task...\"></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"completeTask(task, feedback); dismiss();\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"completeTaskMode = !completeTaskMode\">Cancel</button>\n    </form>\n</div>\n<div class=\"task-actions\" ng-show=\"skipTaskMode\">\n    <form name=\"skipTaskForm\">\n        <textarea rows=\"4\" ng-model=\"skipFeedback\" placeholder=\"Give feedback or place a comment to skip the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"skipTask(task, skipFeedback); dismiss();\" ng-disabled=\"skipTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"skipTaskMode = !skipTaskMode\">Cancel</button>\n    </form>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/actions/waiting-for-input-task.html","<div>\n    <form name=\"taskVariablesForm\" class=\"form-horizontal\">\n        <p>Please enter the required information and start the task.</p>\n        <div variables-editor\n             variables=\"variables\"\n             form=\"taskVariablesForm\"\n             filter=\"{}\">\n        </div>\n        <button type=\"button\" class=\"button primary\" ng-disabled=\"taskVariablesForm.$invalid\" ng-click=\"startTaskWithInput(task, variables);dismiss();\">Start task</button>\n    </form>\n</div>");
$templateCache.put("static/7.1.0/partials/tasks/details/create-release-details.html","<div class=\"create-release-details\" ng-controller=\"xlrelease.CreateReleaseDetailsController as createReleaseCtrl\">\n    <div class=\"form-horizontal\" ng-form=\"createReleaseForm\">\n        <div class=\"properties\">\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Release title <span class=\"error\">*</span></label>\n\n                <div class=\"col-sm-9\">\n                    <div ng-if=\"!createReleaseCtrl.readOnly\" class=\"ui-front\" inline-text-editor model=\"createReleaseCtrl.newReleaseTitle\">\n                        <span display-variables=\"createReleaseCtrl.newReleaseTitle\" variables=\"createReleaseCtrl.releaseVariables\"></span>\n                    </div>\n                    <div ng-if=\"createReleaseCtrl.readOnly\" class=\"ui-front field-readonly read-only\">\n                        <span display-variables=\"createReleaseCtrl.newReleaseTitle\" variables=\"createReleaseCtrl.releaseVariables\"></span>\n                    </div>\n                    <div class=\"description\">Title of the release to create.</div>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Template <span class=\"error\">*</span></label>\n\n                <div class=\"col-sm-9\">\n                    <div ng-if=\"createReleaseCtrl.readOnly\" class=\"field-readonly read-only\">{{createReleaseCtrl.selectedTemplate.title}}</div>\n                    <div ng-if=\"!createReleaseCtrl.readOnly && createReleaseCtrl.templates\"\n                         xl-widget-autocomplete\n                         ng-model=\"createReleaseCtrl.selectedTemplate\"\n                         metadata=\"{name: \'template\'}\"\n                         obj-label=\"title\"\n                         show-all-on-click=\"true\"\n                         open-on-click=\"true\"\n                         handlers=\"createReleaseCtrl.templateListHandlers\">\n                    </div>\n                    <div class=\"description\">Template to use when creating the release.</div>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Start release</label>\n\n                <div class=\"col-sm-9\">\n                    <div id=\"startRelease\" xlr-boolean-with-variables\n                         class=\"field\"\n                         name=\"\'startRelease\'\"\n                         model=\"createReleaseCtrl.startRelease\"\n                         variables=\"createReleaseCtrl.allVariables\"\n                         on-change=\"createReleaseCtrl.saveTask()\"\n                         on-new=\"createReleaseCtrl.createVariable(name, variableType, createdCallback, true)\"\n                         read-only=\"createReleaseCtrl.readOnly\"></div>\n                    <div class=\"description\">Immediately start the release after it is created.</div>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Release tags</label>\n\n                <div class=\"col-sm-9\">\n                    <div id=\"releaseTags\" tags-input\n                         class=\"transparent green-tags\"\n                         tags=\"createReleaseCtrl.releaseTags\"\n                         placeholder=\"Add a tag...\"\n                         on-change=\"createReleaseCtrl.updateReleaseTags(tags)\"\n                         read-only=\"createReleaseCtrl.readOnly\"></div>\n                </div>\n            </div>\n            <hr ng-if=\"createReleaseCtrl.variables.length > 0\"/>\n            <div ng-if=\"createReleaseCtrl.variables.length > 0\">\n                <h4>Variables</h4>\n\n                <div class=\"help-block\">Variable values to pass to the created release.</div>\n\n                <div variables-editor\n                     variables=\"createReleaseCtrl.variables\"\n                     all-variables=\"createReleaseCtrl.allVariables\"\n                     form=\"createReleaseForm\"\n                     readonly=\"createReleaseCtrl.readOnly\"\n                     on-change=\"createReleaseCtrl.saveTask()\"\n                     replace-variables=\"true\"\n                     supports-new-variable=\"true\"\n                     on-new-variable=\"createReleaseCtrl.createVariable(name, variableType, createdCallback, true)\">\n                </div>\n            </div>\n            <hr/>\n            <div>\n                <h4>Output properties</h4>\n                <span class=\"help-block\" id=\"outputVarHelpText\">The ID of the newly created release can be stored in a release variable. This variable can be used in a Gate task dependency to wait for the completion of the release.</span>\n\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\">Release ID</label>\n\n                    <div class=\"col-sm-9\" id=\"createdReleaseId\">\n                        <div ng-if=\"createReleaseCtrl.readOnly\" class=\"field-readonly read-only\">{{createReleaseCtrl.createdReleaseId.variable}}</div>\n                        <div ng-if=\"!createReleaseCtrl.readOnly\"\n                             xlr-inline-text-with-variables\n                             name=\"\'createdReleaseId\'\"\n                             model=\"createReleaseCtrl.createdReleaseId\"\n                             on-change=\"createReleaseCtrl.saveTask()\"\n                             on-new=\"createReleaseCtrl.createVariable(name, variableType, createdCallback, false)\"\n                             variables=\"createReleaseCtrl.allVariables\"\n                             enforce-mode=\"\'variable\'\">\n                        </div>\n                        <div class=\"description\">ID of the release created from this task.</div>\n                    </div>\n                </div>\n\n            </div>\n        </div>\n    </div>\n</div>");
$templateCache.put("static/7.1.0/partials/tasks/details/custom-script-details.html","<div class=\"form-horizontal\">\n    <div class=\"properties\">\n        <div ng-show=\"scriptDefinition.inputProperties.length > 0\">\n            <h4>Input properties</h4>\n\n            <div xlr-dip-of-inline-with-variables\n                 property-definitions=\"scriptDefinition.inputProperties\"\n                 variables=\"allVariables\"\n                 read-only=\"areTaskPropertiesReadonly(release, task)\"\n                 property-values=\"task.inputProperties\"\n                 on-change=\"saveTask(task)\"\n                 on-new-variable=\"createRequiredVariable(task, name, variableType, createdCallback)\"\n                 show-variable-selector-for-text=\"false\">\n            </div>\n            <hr>\n        </div>\n        <div ng-show=\"scriptDefinition.outputProperties.length > 0\">\n            <h4>Output properties</h4>\n            <span class=\"help-block\" id=\"outputVarHelpText\">{{task.outputVarHelpText}}</span>\n\n            <div xlr-dip-of-inline-with-variables\n                 property-definitions=\"scriptDefinition.outputProperties\"\n                 variables=\"releaseVariables\"\n                 read-only=\"areTaskPropertiesReadonly(release, task)\"\n                 property-values=\"task.outputProperties\"\n                 on-change=\"saveTask(task)\"\n                 on-new-variable=\"createOptionalVariable(task, name, variableType, createdCallback)\"\n                 enforce-mode=\"isDone(task) || isDoneInAdvance(task) || isTaskAborted(task) ? \'editor\' : \'variable\'\"\n                 show-required-sign=\"false\"\n                 show-variable-selector-for-text=\"true\">\n            </div>\n            <hr>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/details/gate-details.html","<div ng-controller=\"gateDetailsController\" class=\"gate-details\">\n    <div ng-repeat=\"condition in task.conditions\" class=\"condition\">\n        <div class=\"row\">\n            <div class=\"col-xs-1\">\n                <input type=\"checkbox\" ng-model=\"condition.checked\" ng-change=\"updateCondition(condition)\"\n                       ng-disabled=\"!canWorkOnTask(release) || release.status == \'TEMPLATE\'\"/>\n            </div>\n            <div class=\"col-xs-10\">\n                <div ng-if=\"canEditTask(release)\" inline-text-editor model=\"condition.title\" on-change=\"updateCondition(condition)\"\n                     placeholder=\"Set condition title...\" class=\"condition-title editor\">\n                    <span display-variables=\"condition.title\" variables=\"release.variables\"></span>\n                </div>\n                <div ng-if=\"!canEditTask(release)\" class=\"condition-title\">\n                    <span display-variables=\"condition.title\" variables=\"release.variables\"></span>\n                </div>\n            </div>\n            <div ng-if=\"canEditTask(release)\" class=\"pull-right remove-condition\" ng-click=\"removeCondition(condition)\">\n                <i class=\'remove-icon\'></i>\n            </div>\n        </div>\n    </div>\n    <a ng-if=\"showAddCondition()\" class=\"link\" ng-click=\"addCondition()\">Add condition</a>\n\n    <hr ng-if=\"showConditions() || showAddCondition()\">\n\n    <div ng-if=\"showDependencies() || showAddDependency()\">\n        <div class=\"dependency-title\" ng-if=\"showDependencies()\">Wait for completion of</div>\n        <div class=\"dependency\" ng-repeat=\"dependency in task.dependencies\">\n            <div class=\"row line\" ng-click=\"canEditDependency(dependency) && editDependency(dependency)\" ng-hide=\"isEditingDependency(dependency)\"\n                 ng-class=\"{\'editable-line\': canEditDependency(dependency)}\">\n                <span class=\"col-xs-1\" ng-class=\"{\'resolved\': dependency.resolved}\"></span>\n                <span ng-if=\"!dependency.variableOrTarget.variable && !dependency.variableOrTarget.value\" class=\"col-xs-10 dependency-objects\">\n                    <span class=\"placeholder\">(empty)</span>\n                </span>\n                <span ng-if=\"dependency.variableOrTarget.value\" class=\"col-xs-10 dependency-objects\">\n                    <span class=\"release\"> {{ dependency.variableOrTarget.value.releaseTitle }} </span>\n                    <span class=\"phase\" ng-show=\"dependency.variableOrTarget.value.phaseId\"> / {{ dependency.variableOrTarget.value.phaseTitle }}</span>\n                    <span class=\"task\" ng-show=\"dependency.variableOrTarget.value.taskId\"> / {{ dependency.variableOrTarget.value.taskTitle }}</span>\n                </span>\n                <span ng-if=\"dependency.variableOrTarget.variable\" class=\"col-xs-10 dependency-objects\">{{dependency.variableOrTarget.variable}}</span>\n                <span class=\"pull-right\"\n                      ng-if=\"canDeleteDependency(dependency)\"\n                      ng-click=\"removeDependency(dependency)\"\n                      stop-click-propagation>\n                    <i class=\"remove remove-icon\"></i>\n                </span>\n            </div>\n\n            <div class=\"row\" ng-if=\"isEditingDependency(dependency)\">\n                <div class=\"col-xs-12\">\n                    <div xlr-dependency-with-variables\n                         enforce-mode=\"dependencyDetailsMode\"\n                         model=\"draftDependency.variableOrTarget\"\n                         name=\"\'target\'\"\n                         on-new=\"createRequiredVariable(task, name, variableType, createdCallback)\"\n                         variables=\"allVariables\"\n                         options=\"{\'taskId\': task.id, \'variableModeEnabled\': !isTaskInProgress(task)}\">\n                    </div>\n                    <button class=\"button save primary\" ng-click=\"saveDependency()\">OK</button>\n                    <button class=\"button cancel\" ng-click=\"cancelDependencyEditing()\">Cancel</button>\n                </div>\n            </div>\n        </div>\n\n        <a ng-if=\"showAddDependency()\" class=\"add-dependency link\" ng-click=\"addDependency()\">Add dependency</a>\n        <hr>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/details/notification-details.html","<div class=\"form-horizontal\">\n    <div class=\"properties\">\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">To <span class=\"error\">*</span></label>\n\n            <div class=\"col-sm-9\">\n                <div ng-if=\"!areTaskPropertiesReadonly(release, task)\" class=\"email-addresses\" inline-list-editor model=\"task.addresses\" on-change=\"saveTask(task);\">\n                    <span display-variables=\"task.addresses.join(\', \')\" variables=\"release.variables\"></span>\n                </div>\n                <div ng-if=\"areTaskPropertiesReadonly(release, task)\" class=\"email-addresses field-readonly read-only\">{{task.addresses.join(\', \')}}</div>\n                <div class=\"description\">List of email addresses where the message will be sent</div>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">Subject <span class=\"error\">*</span></label>\n\n            <div class=\"col-sm-9\">\n                <div ng-if=\"!areTaskPropertiesReadonly(release, task)\" class=\"email-subject ui-front\" inline-text-editor model=\"task.subject\" on-change=\"saveTask(task)\">\n                    <span display-variables=\"task.subject\" variables=\"release.variables\"></span>\n                </div>\n                <div ng-if=\"areTaskPropertiesReadonly(release, task)\" class=\"email-subject ui-front field-readonly read-only\">\n                    <span display-variables=\"task.subject\" variables=\"release.variables\"></span>\n                </div>\n                <div class=\"description\">Subject of the message</div>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">Body <span class=\"error\">*</span></label>\n\n            <div class=\"col-sm-9\">\n                <div ng-if=\"!areTaskPropertiesReadonly(release, task)\" class=\"email-body ui-front\">\n                    <div inline-textarea-editor model=\"task.body\" on-change=\"saveTask(task)\" markdown>\n                        <span display-variables=\"task.body\" variables=\"release.variables\" markdown class=\"markdown\"></span>\n                    </div>\n                </div>\n                <div ng-if=\"areTaskPropertiesReadonly(release, task)\" class=\"email-body ui-front field-readonly read-only\">\n                    <span display-variables=\"task.body\" variables=\"release.variables\" markdown class=\"markdown\"></span>\n                </div>\n                <div class=\"description\">Message body, in Markdown format</div>\n            </div>\n        </div>\n\n        <hr>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/details/script-details.html","<div class=\"form-horizontal\">\n    <div class=\"properties\">\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">Script <span class=\"error\">*</span></label>\n\n            <div class=\"col-sm-9\">\n                <div ng-if=\"!areTaskPropertiesReadonly(release, task)\" class=\"script-content ui-front\" inline-textarea-editor placeholder=\"Set a script\"  model=\"task.script\" on-change=\"saveTask(task)\">\n                    <span display-variables=\"task.script\" variables=\"release.variables\" keep-new-lines></span>\n                </div>\n                <div ng-if=\"areTaskPropertiesReadonly(release, task)\" class=\"script-content ui-front pts read-only\">\n                    <span display-variables=\"task.script\" variables=\"release.variables\" keep-new-lines></span>\n                </div>\n                <div class=\"description\">Python script to execute when the task becomes active. Please see the XL Release Python API for the list of helper objects, functions, and classes available to the script</div>\n            </div>\n        </div>\n        <hr>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/details/task-details-modal.html","<div class=\"modal-content task-details {{task.type | taskTypeCssClass}} {{ task.status | taskStatusCssClass }}\" ng-style=\"{\'border-color\': task.color}\">\n    <div class=\"modal-header\" ng-style=\"{\'background-color\': task.color}\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">×</button>\n        <span ng-if=\"isGateTask(task)\" class=\"gate-icon\"></span>\n        <div ng-if=\"isUserInputTask(task)\" class=\"task-type-icon\">\n            <i class=\"user-input-icon\"></i>\n            <p>User Input</p>\n        </div>\n        <i ng-if=\"isCustomScriptTask(task) && !task.customIconLocation\" class=\"custom-script-icon pull-right\"></i>\n        <img ng-if=\"isCustomScriptTask(task) && task.customIconLocation\" class=\"custom-icon pull-right\"\n             ng-src=\"static/7.1.0/{{ task.customIconLocation }}\">\n\n        <div ng-show=\"canEditTask(release)\">\n            <h4 class=\"task-title\" inline-text-editor model=\"task.title\" on-change=\"saveTask(task)\"><span display-variables=\"task.title\"\n                                                                                                          variables=\"release.variables\"></span></h4>\n        </div>\n        <div ng-hide=\"canEditTask(release)\">\n            <h4 class=\"task-title\" display-variables=\"task.title\" variables=\"release.variables\"></h4>\n        </div>\n        <div ng-if=\"isScriptTask(task)\" class=\"pull-right\">\n            {{ task.typeDisplayGroup }} : {{ task.typeDisplayName }}\n        </div>\n        <div ng-if=\"isCustomScriptTask(task)\" class=\"pull-right\">\n            {{ scriptDefinition.displayGroup }} : {{ scriptDefinition.displayName }}\n        </div>\n        <div class=\"task-info\">\n            <span class=\"link\" ng-show=\"!security.hasViewPermission(release)\">{{task.releaseTitle}}</span>\n            <span class=\"link\" ng-show=\"security.hasViewPermission(release)\" ng-click=\"dismiss();viewTaskInRelease(release.id)\">{{task.releaseTitle}}</span>\n            /\n            <span display-variables=\"task.phaseTitle\" variables=\"release.variables\"></span>\n        </div>\n    </div>\n\n    <div class=\"task-alert\" ng-if=\"isTaskWaitingForInput(task) && canWorkOnTask(release) && !inGantt\">\n        <div class=\"task-warning-alert\">\n            <i class=\"warning-triangle-icon icon-sm\"></i>The task cannot start because some required information is missing.\n        </div>\n    </div>\n    <div class=\"modal-body\">\n        <div class=\"pull-left left-detail\">\n            <div ng-if=\"isTaskWaitingForInput(task) && canWorkOnTask(release) && !inGantt\">\n                <a id=\"variables-anchor\" name=\"variables\"></a>\n                <div ng-include src=\"\'partials/tasks/actions/waiting-for-input-task.html\'\"></div>\n                <hr>\n            </div>\n            <div ng-show=\"canEditTask(release)\">\n                <div inline-textarea-editor placeholder=\"Set task description\" model=\"task.description\" on-change=\"saveTask(task)\" markdown\n                     class=\"task-description\">\n                    <span display-variables=\"task.description\" variables=\"release.variables\" markdown class=\"markdown\"></span>\n                </div>\n            </div>\n            <div class=\"task-description\" ng-hide=\"canEditTask(release)\">\n                <span display-variables=\"task.description\" variables=\"release.variables\" markdown class=\"markdown\"></span>\n            </div>\n\n            <div ng-if=\"isCreateReleaseTask(task)\" ng-include=\"\'partials/tasks/details/create-release-details.html\'\"></div>\n\n            <div ng-if=\"isUserInputTask(task)\" ng-include=\"\'partials/tasks/details/user-input-details.html\'\"></div>\n\n            <div ng-if=\"isTaskPending(task) && !inGantt\">\n                <div ng-include src=\"\'partials/tasks/actions/pending-task.html\'\"></div>\n            </div>\n            <div ng-if=\"canUpdateInProgressStatus(task) && canWorkOnTask(release) && !isTaskGroup(task) && !inGantt\">\n                <div ng-include src=\"\'partials/tasks/actions/in-progress-task.html\'\"></div>\n            </div>\n            <div ng-if=\"(isInProgressScriptTask(task) || isTaskPreconditionInProgress(task)) && canWorkOnTask(release) && !inGantt\">\n                <div ng-include src=\"\'partials/tasks/actions/in-progress-script-task.html\'\"></div>\n            </div>\n            <div ng-if=\"isReleaseInProgress(release) && canUpdatePlannedStatus(task) && canWorkOnTask(release) && !isTaskGroup(task) && !inGantt\">\n                <div ng-include src=\"\'partials/tasks/actions/planned-task.html\'\"></div>\n            </div>\n            <div ng-if=\"canWorkOnFailedTask(release, task) && !inGantt\">\n                <div ng-include src=\"\'partials/tasks/actions/failed-task.html\'\"></div>\n            </div>\n            <div ng-if=\"isReleaseInProgress(release) && isTaskDoneInAdvance(task) && canWorkOnReadOnlyTask(release) && !isTaskGroup(task) && !inGantt\">\n                <div ng-include src=\"\'partials/tasks/actions/done-in-advance-task.html\'\"></div>\n            </div>\n\n            <hr ng-if=\"canWorkOnTask(release)\">\n\n            <div ng-if=\"hasConfigurationUri(task)\" ng-include=\"getConfigurationUri(task)\"></div>\n            <div ng-if=\"!hasConfigurationUri(task)\" ng-include=\"\'partials/tasks/details/custom-script-details.html\'\"></div>\n\n            <div ng-if=\"task.preconditionEnabled\"\n                 class=\"form-horizontal precondition properties form-group mbn\">\n            <span ng-click=\"togglePreConditionState(task)\">\n                <span ng-if=\"isPreConditionCollapsed(task)\"\n                      class=\"contract-icon precondition-title-collapsed\"/>\n                <span ng-if=\"!isPreConditionCollapsed(task)\"\n                      class=\"expand-icon precondition-title-expanded\"/>\n                <h4 class=\"inline-label\">Precondition &nbsp;<span ng-if=\"task.precondition && task.preconditionEnabled\" class=\"precondition-icon\"/></h4>\n            </span>\n                <div ng-if=\"!isPreConditionCollapsed(task)\">\n                    <div ng-show=\"canEditTask(release)\">\n                        <span>Only execute the task if:</span>\n                        <div inline-textarea-editor placeholder=\"Set precondition expression or script\" model=\"task.precondition\" on-change=\"saveTask(task)\"\n                             class=\"task-precondition ui-front\">\n                            <span display-variables=\"task.precondition\" variables=\"release.variables\" keep-new-lines></span>\n                        </div>\n                    </div>\n                    <div ng-hide=\"canEditTask(release)\">\n                        <span display-variables=\"task.precondition\" variables=\"release.variables\" keep-new-lines></span>\n                    </div>\n                </div>\n            </div>\n            <hr ng-if=\"task.preconditionEnabled\">\n\n            <div class=\"comments\">\n            <span ng-click=\"toggleCommentsState(task)\">\n                <span ng-if=\"isCommentsCollapsed(task)\"\n                      class=\"contract-icon comments-title-collapsed\"/>\n                <span ng-if=\"!isCommentsCollapsed(task)\"\n                      class=\"expand-icon comments-title-expanded\"/>\n                <h4 class=\"inline-label\">Comments (<span ng-bind=\"comments.length\"/>)</h4>\n            </span>\n                <div ng-show=\"comments.length > 0 && !isCommentsCollapsed(task)\" class=\"comment\" ng-repeat=\"comment in comments\">\n                    <strong ng-if=\"comment.author.username\" display-user=\"comment.author\" variables=\"release.variables\"></strong>\n                    <strong ng-if=\"!comment.author.username\">SYSTEM</strong>\n                    <span class=\"pull-right comment-date\">{{comment.date | date:\'mediumDate\'}} at {{comment.date | date:\'shortTime\'}}</span><br/>\n\n                    <div>\n                        <span ng-if=\"canCommentOnTask(release)\" inline-textarea-editor model=\"comment.text\" on-change=\"saveComment(comment)\" required\n                              class=\"comment-text\" markdown>\n                            <span ng-bind-html=\"comment.text | markdown\" class=\"markdown\"></span>\n                        </span>\n                        <span ng-if=\"!canCommentOnTask(release)\" ng-bind-html=\"comment.text | markdown\" class=\"markdown\"></span>\n                    </div>\n                </div>\n\n                <div ng-if=\"canCommentOnTask(release) && !isCommentsCollapsed(task)\">\n                    <form class=\"addCommentForm\" name=\"addCommentForm\" ng-if=\"data.showCommentForm\">\n                        <textarea ng-model=\"data.newComment\" placeholder=\"Give feedback or place a comment ...\" autofocus rows=\"5\"\n                                  class=\"new-comment\"></textarea><br/>\n                        <button class=\"button primary save-comment\" ng-click=\"addComment(task, data.newComment)\" ng-disabled=\"data.newComment.length == 0\">OK\n                        </button>\n                        <button class=\"button cancel\" ng-click=\"data.showCommentForm = !data.showCommentForm\">Cancel</button>\n                    </form>\n                </div>\n\n                <div class=\"comment-actions\" ng-if=\"!data.showCommentForm && !isCommentsCollapsed(task)\">\n                    <button class=\"button add-comment\" ng-if=\"canCommentOnTask(release)\" ng-click=\"data.showCommentForm = !data.showCommentForm\">Add comment\n                    </button>\n                </div>\n\n            </div>\n\n            <hr>\n\n            <div class=\"attachments-details\">\n            <span ng-click=\"toggleAttachmentsState(task)\">\n                <span ng-if=\"isAttachmentsCollapsed(task)\"\n                      class=\"contract-icon attachments-title-collapsed\"/>\n                <span ng-if=\"!isAttachmentsCollapsed(task)\"\n                      class=\"expand-icon attachments-title-expanded\"/>\n                <h4 class=\"inline-label\">Attachments (<span ng-bind=\"task.attachments.length\"/>)</h4>\n            </span>\n\n                <div attachments-list\n                     ng-hide=\"isAttachmentsCollapsed(task)\"\n                     attachments=\"task.attachments\"\n                     readonly=\"!canEditTask(release)\"\n                     upload-url=\"\'upload/attachment/\' + task.id\"\n                     can-delete-attachments=\"!isTaskInProgress(task)\"\n                     delete-attachment=\"deleteAttachment(release, task, attachment)\"\n                     dismiss=\"dismiss()\"></div>\n            </div>\n            <div>&nbsp;</div>\n        </div>\n        <div class=\"pull-right right-detail\">\n            <ng-include src=\"\'partials/tasks/task-labels.html\'\"></ng-include>\n            <div class=\"flags\">\n\n                <div ng-if=\"canEditTask(release)\">\n                    <div class=\"flag-icon dropdown-button {{ task.flag.status | lowercase }}\" bs-popover data-content-template=\"partials/flags/flag-picker.html\"\n                         data-placement=\"bottom\" auto-close=\"true\"></div>\n                    <div class=\"flag-comment\" inline-text-editor model=\"task.flag.comment\" placeholder=\"Set status text\" on-change=\"saveTask(task)\">\n                        {{task.flag.comment}}\n                    </div>\n                </div>\n                <div ng-if=\"!canEditTask(release)\" class=\"readonly\">\n                    <div class=\"flags\">\n                        <div class=\"flag-icon {{ task.flag.status | lowercase }}\"></div>\n                        <div class=\"flag-comment\">{{task.flag.comment}}</div>\n                    </div>\n                </div>\n            </div>\n            <div class=\"scheduled-start-date\" ng-if=\"isPlannedOrPending(task)\"\n                 modal-date-editor\n                 inferred-date=\"planning.planElement.displayStartDate\"\n                 date-model=\"task.scheduledStartDate\"\n                 on-change=\"planning.updateScheduledStartDate(task)\"\n                 readonly=\"!canEditTask(release)\"\n                 date-title=\"Scheduled start date\">\n            </div>\n            <label ng-class=\"{\'disabled\': isTaskPending(task)}\" for=\"wait-for-scheduled-start-date\" ng-if=\"isPlannedOrPending(task) && task.scheduledStartDate\">\n                <input type=\"checkbox\" id=\"wait-for-scheduled-start-date\" ng-model=\"task.waitForScheduledStartDate\" ng-change=\"saveTask(task)\"\n                       ng-disabled=\"isTaskPending(task)\"/> Wait for start date\n            </label>\n\n            <div class=\"start-date\" ng-if=\"!isPlannedOrPending(task)\"\n                 modal-date-editor\n                 date-model=\"task.startDate\"\n                 inferred-date=\"planning.planElement.displayStartDate\"\n                 readonly=\"\'true\'\"\n                 date-title=\"Start date\">\n            </div>\n            <div ng-if=\"isPlannedOrPending(task)\"\n                 ng-class=\"{\'disabled\': !(canDelayTask(task) && canEditBlackout(release, task) && !isTaskPostponedDueToBlackout(task))}\">\n                <label for=\"delay-during-blackout\">\n                    <input type=\"checkbox\" ng-disabled=\"!(canDelayTask(task) && canEditBlackout(release, task) && !isTaskPostponedDueToBlackout(task))\"\n                           id=\"delay-during-blackout\" ng-model=\"task.delayDuringBlackout\" ng-change=\"saveTask(task)\"/> Postpone during blackout\n                </label>\n            </div>\n            <div class=\"blackout-info\" ng-if=\"isTaskPostponedDueToBlackout(task)\">\n                <label class=\"blackout-text\" ng-if=\"!isTaskInFinishedState(task)\"><i class=\"blackout-icon\"></i>Start date set due to blackout</label>\n                <label class=\"blackout-text\" ng-if=\"isTaskInFinishedState(task)\"><i class=\"blackout-icon\"></i>Task postponed due to blackout</label>\n                <label class=\"blackout-text\" ng-if=\"getOriginalScheduledStartDate(task) != null\">Original scheduled start date was: <br/> <span\n                        class=\"original-date\">{{getOriginalScheduledStartDate(task) | mediumDateShortTime}}</span></label>\n            </div>\n            <div class=\"due-date\" ng-if=\"!isTaskSkipped(task) && !isTaskCompleted(task) && !isTaskCompletedInAdvance(task) && !isTaskSkippedInAdvance(task)\"\n                 modal-date-editor\n                 date-model=\"task.dueDate\"\n                 on-change=\"planning.updateDueDate(task)\"\n                 readonly=\"!canEditTask(release)\"\n                 date-title=\"Due date\"\n                 inferred-date=\"planning.planElement.displayEndDate\">\n            </div>\n            <div class=\"end-date\" ng-if=\"isTaskSkipped(task) || isTaskCompleted(task) || isTaskCompletedInAdvance(task) || isTaskSkippedInAdvance(task)\"\n                 modal-date-editor\n                 date-model=\"task.endDate\"\n                 inferred-date=\"planning.planElement.displayEndDate\"\n                 date-title=\"End date\"\n                 readonly=\"\'true\'\">\n            </div>\n            <div class=\"modal-section\">\n                Duration\n            </div>\n            <div duration-editor\n                 duration=\"task.plannedDuration\"\n                 inferred-duration=\"planning.planElement.displayDuration\"\n                 on-change=\"planning.updateDuration(task)\"\n                 editable=\"canEditTask(release)\"\n                 done=\"task.done\"/>\n\n            <div class=\"assignee\">\n                <div ng-click=\"assignToMe(task)\" ng-if=\"canClaimTask(task, release)\" class=\"pull-right light-text link assign-to-me\">Assign to me</div>\n                <div class=\"modal-section\">Assigned to</div>\n                <div ng-show=\"security.hasReassignTaskPermission(release) && !isTaskReadOnly(task)\">\n\n                    <div ng-show=\"task.owner\" class=\"pull-right remove-owner\" ng-click=\"removeOwner()\"><i class=\'remove-icon\'></i></div>\n                    <div class=\"owner-icon\"></div>\n                    <div inline-user-editor placeholder=\"assign\" model=\"task.owner\" on-change=\"updateOwner(task);\" class=\"task-owner\"\n                         autocomplete-data=\"allUsers\">\n                        <span display-user=\"task.owner\" variables=\"release.variables\"></span>\n                    </div>\n\n                    <div ng-show=\"task.team\" class=\"pull-right remove-team\" ng-click=\"removeTeam()\"><i class=\'remove-icon\'></i></div>\n                    <div class=\"team-icon\"></div>\n                    <div inline-select-editor select-options=\"teams\" placeholder=\"assign\" model=\"task.team\" on-change=\"updateTeam(task);\" class=\"task-team\">\n                        {{task.team}}\n                    </div>\n                </div>\n                <div ng-hide=\"security.hasReassignTaskPermission(release) && !isTaskReadOnly(task)\">\n                    <div class=\"owner-icon\" ng-show=\"task.owner\"></div>\n                    <div class=\"task-owner\" ng-show=\"task.owner\">\n                        <div class=\"readonly\" display-user=\"task.owner\" variables=\"release.variables\"></div>\n                    </div>\n                    <div ng-show=\"task.team\">\n                        <div class=\"team-icon\"></div>\n                        <div class=\"task-team\">\n                            <div class=\"readonly\">\n                                {{task.team}}\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <div class=\"watchers\">\n                <header class=\"watchers-header\">\n                    <div class=\"pull-right light-text link assign-me-as-watcher\" ng-show=\"!isTaskReadOnly(task) && !isUserWatchingTask()\" ng-click=\"addMeAsWatcher(task)\">Add me</div>\n                    <div class=\"modal-section\">Watchers <i class=\"doc-icon\" uib-tooltip=\"{{watchersTooltip.text}}\"\n                                                           tooltip-placement=\"{{watchersTooltip.placement}}\" style=\"vertical-align: -1.0px;\"></i></div>\n                </header>\n                <ul class=\"watchers-list\" ng-show=\"watchers && watchers.length > 0\">\n                    <li ng-repeat=\"watcher in watchers\">\n                        <span display-user=\"watcher\" variables=\"release.variables\"></span>\n                        <i ng-if=\"!isTaskReadOnly(task) && canRemoveWatcher(release, watcher)\"\n                           ng-click=\"removeWatcher(task, watcher)\"\n                           class=\"remove-icon pull-right\"></i>\n                    </li>\n                </ul>\n                <footer data-ng-if=\"canEditTask(release) && !isTaskReadOnly(task)\">\n                    <i class=\"add-watcher-icon binoculars-icon\"></i>\n                    <div inline-user-editor placeholder=\"add user\" autocomplete-data=\"nonWatchingUsers\" model=\"watcherContainer.watcher\"\n                         on-change=\"handleWatcherChange(task, watcherContainer.watcher)\"\n                         class=\"add-watcher-input\">\n                        <span display-user=\"watcherContainer.watcher\" variables=\"release.variables\"></span>\n                    </div>\n                </footer>\n            </div>\n\n            <div>\n                <div class=\"modal-section\">Tags</div>\n                <div>\n                    <div id=\"tags1\" class=\"transparent green-tags\"\n                         tags-input\n                         tags=\"task.tags\"\n                         placeholder=\"Add a tag...\"\n                         on-change=\"updateTags(tags,task)\"\n                         read-only=\"!canEditTask(release)\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/7.1.0/partials/tasks/details/user-input-details.html","<div class=\"user-input-details\" ng-controller=\"userInputDetailsController\">\n    <div ng-show=\"!designMode\">\n        <form ng-show=\"task.variables && task.variables.length\" name=\"userInputForm\" class=\"form-horizontal\">\n            <div variables-editor\n                 variables=\"task.variables\"\n                 form=\"userInputForm\"\n                 readonly=\"!canEditVariables || release.status === \'TEMPLATE\'\"\n                 filter=\"{}\" on-change=\"updateReleaseVariable(variable)\">\n            </div>\n        </form>\n        <div ng-hide=\"task.variables && task.variables.length\">\n            <p class=\"lighter-text\">No variables have been added to this task</p>\n        </div>\n        <button class=\"button\" ng-show=\"canEditVariableList\" ng-click=\"editVariableList();designMode = true\">Edit variable list</button>\n    </div>\n    <div ng-show=\"designMode && canEditVariableList\">\n        <hr/>\n        <form name=\"userInputDesignForm\" class=\"form-horizontal\">\n            <div xl-dip-list-of-ci\n                 ng-model=\"variableList\"\n                 metadata=\"{name: \'userInputVariables\', label: \'Variables in this task\'}\"\n                 obj-label=\"displayName\"\n                 handlers=\"variableListHandler\"\n                 open-on-click=\"true\"\n                 empty-placeholder=\"Please select a variable\">\n            </div>\n            <div class=\"task-actions\">\n                <button class=\"button primary save\" ng-click=\"saveVariableList();designMode = false;\">Save</button>\n                <button class=\"button cancel\" ng-click=\"designMode = false;\">Cancel</button>\n            </div>\n        </form>\n        <div class=\"help\" style=\"margin-top: 15px;\">\n            Go to the <a ng-href=\"#/releases/{{release.id}}/variables\" ng-click=\"saveVariableList()\">Variables</a> section to see an overview of all variables\n            in the release.\n        </div>\n    </div>\n</div>");
$templateCache.put("static/7.1.0/xlr-components/dependency-selector/dependency-selector-partial.html","<div class=\"dependency-selector form-horizontal\">\n    <div class=\"col-xs-offset-2 loading-indicator placeholder\" ng-if=\"$ctrl.showLoadingIndicator\">\n        <img src=\"static/7.1.0/styles/img/ajax-loader.gif\" alt=\"Loading...\"/> Loading...\n    </div>\n    <div class=\"col-xs-offset-2 non-accessible-warning\" ng-if=\"!$ctrl.accessible\">\n        <span class=\"glyphicon glyphicon-warning-sign\"></span>\n        <ng-switch on=\"$ctrl.model.archived\">\n            <span ng-switch-when=\"false\">You do not have permission to view this release</span>\n            <span ng-switch-when=\"true\">This dependency has been archived</span>\n        </ng-switch>\n    </div>\n    <div class=\"form-group\">\n        <label class=\"col-xs-2 control-label\">Release</label>\n        <div class=\"col-xs-10\">\n            <select class=\"release form-control\" ng-model=\"$ctrl.model.releaseId\"\n                    ng-options=\"release.id as release.title for release in $ctrl.dependencyTargetCandidates\"\n                    ng-change=\"$ctrl.updateReleaseDropdown($ctrl.model)\"\n                    ng-disabled=\"!$ctrl.accessible || $ctrl.fetchingData\">\n                <option value=\"\">--</option>\n            </select>\n        </div>\n    </div>\n    <div class=\"form-group\">\n        <label class=\"col-xs-2 control-label\">Phase</label>\n        <div class=\"col-xs-10\">\n            <select class=\"phase form-control\" ng-model=\"$ctrl.model.phaseId\"\n                    ng-options=\"phase.id as $ctrl.interpolate(phase.title) for phase in $ctrl.getPhases()\"\n                    ng-change=\"$ctrl.updatePhaseDropdown($ctrl.model)\" ng-disabled=\"!$ctrl.accessible || $ctrl.fetchingData\">\n                <option value=\"\">--</option>\n            </select>\n        </div>\n    </div>\n    <div class=\"form-group\">\n        <label class=\"col-xs-2 control-label\">Task</label>\n        <div class=\"col-xs-10\">\n            <select class=\"task form-control\" ng-model=\"$ctrl.model.taskId\"\n                    ng-options=\"task.id as $ctrl.interpolate(task.title) for task in $ctrl.getTasks($ctrl.model.phaseId)\"\n                    ng-change=\"$ctrl.updateTaskDropdown()\" ng-disabled=\"!$ctrl.accessible || $ctrl.fetchingData\">\n                <option value=\"\">--</option>\n            </select>\n        </div>\n    </div>\n</div>");
$templateCache.put("static/7.1.0/xlr-components/flag-picker-component/flag-picker-popover-partial.html","<div class=\"flag-picker-popover\">\n    <div class=\"ok\" ng-click=\"$ctrl.onUpdate({flag: \'OK\'})\" hide-popover-on-click></div>\n    <div class=\"attention_needed\" ng-click=\"$ctrl.onUpdate({flag: \'ATTENTION_NEEDED\'})\" hide-popover-on-click></div>\n    <div class=\"at_risk\" ng-click=\"$ctrl.onUpdate({flag: \'AT_RISK\'})\" hide-popover-on-click></div>\n</div>\n");
$templateCache.put("static/7.1.0/xlr-components/release-properties-component/release-properties-partial.html","<release-properties-container id=\"release-properties\" release=\"$ctrl.release\">\n    <header id=\"new-release-header\">\n        <h4>Create new release</h4>\n        <span doc-icon=\"release-properties.html\"></span>\n    </header>\n    <content>\n        <release-properties-form release=\"$ctrl.release\"\n                                 read-only=\"!$ctrl.canEditRelease()\"\n                                 on-save=\"$ctrl.onSave(release)\"\n                                 on-cancel=\"$ctrl.onCancel()\">\n        </release-properties-form>\n    </content>\n</release-properties-container>\n");
$templateCache.put("static/7.1.0/xlr-components/release-properties-form-component/release-properties-form-partial.html","<form name=\"releasePropertiesForm\" class=\"form-horizontal release-properties-form\" confirm-leave>\n    <div class=\"row\">\n        <!-- Summary? -->\n        <div class=\"col-sm-7\">\n            <fieldset>\n                <!-- this should probably bind to to $ctrl.releaseForm, but the other stuff should be ported to a $ctrl.form that\'s copy of $ctrl.releaseForm -->\n                <legend ng-if=\"!$ctrl.isNewRelease()\">Properties for {{ $ctrl.release.title }}</legend>\n\n                <!-- Release title -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\" for=\"release-form-title\">\n                        {{$ctrl.isTemplate() ? \'Template name\' : \'Release name\'}} <span ng-if=\"releasePropertiesForm.title.$error.required\" class=\"error\">*</span>\n                    </label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <input type=\"text\" id=\"release-form-title\"\n                               name=\"title\"\n                               class=\"input-block-level\"\n                               ng-model=\"$ctrl.releaseForm.title\"\n                               required\n                               auto-focus\n                               ng-disabled=\"$ctrl.readOnly\">\n                        <span class=\"error\" ng-if=\"releasePropertiesForm.title.$error.required\">{{$ctrl.isTemplate() ? \'Template\' : \'Release\'}} name is mandatory</span>\n                    </div>\n                </div>\n\n                <!-- Use template select *New Release* -->\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate() && $ctrl.isNewRelease()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\" for=\"release-form-template\">Use template</label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <select class=\"input-block-level template-select\" ng-model=\"$ctrl.releaseForm.templateId\" id=\"release-form-template\"\n                                ng-options=\"option.id as option.title for option in $ctrl.templates\" ng-disabled=\"$ctrl.readOnly\"\n                                ng-change=\"$ctrl.updateFormWithTemplate()\">\n                            <option value=\"\">No template</option>\n                        </select>\n                    </div>\n                </div>\n\n                <!-- Release description -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Description</label>\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <span class=\"release-description\" ng-if=\"!$ctrl.readOnly\" inline-textarea-editor model=\"$ctrl.releaseForm.description\"\n                              placeholder=\"Set description...\" markdown>\n                            <span display-variables=\"$ctrl.releaseForm.description\" variables=\"$ctrl.releaseForm.variables\" markdown class=\"markdown\"></span>\n                        </span>\n                        <span ng-if=\"$ctrl.readOnly\" class=\"release-description markdown\">\n                            <span display-variables=\"$ctrl.releaseForm.description\" variables=\"$ctrl.releaseForm.variables\" markdown class=\"markdown\"></span>\n                        </span>\n                    </div>\n                </div>\n\n                <!-- Template link *Edit Release* -->\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate() && !$ctrl.isNewRelease()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Created from template</label>\n                    <div class=\"col-sm-8 col-lg-9 fix-padding\" ng-if=\"!$ctrl.releaseForm.createdFromTemplateId\">No template</div>\n                    <div class=\"col-sm-8 col-lg-9 fix-padding\" ng-if=\"$ctrl.releaseForm.createdFromTemplateId\">\n                        <p>\n                            <a ng-if=\"$ctrl.releaseForm.createdFromTemplateTitle\" class=\"created-from-template\" ng-href=\"#/templates/{{$ctrl.releaseForm.createdFromTemplateId}}\">{{$ctrl.releaseForm.createdFromTemplateTitle}}</a>\n                            <span ng-if=\"!$ctrl.releaseForm.createdFromTemplateTitle\">[Template has been deleted]</span>\n                        </p>\n                    </div>\n                </div>\n\n                <div class=\"form-group\" ng-if=\"$ctrl.releaseForm.startedFromReleaseId\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Started from release</label>\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <a class=\"started-from-release\" ng-href=\"#/releases/{{$ctrl.releaseForm.startedFromReleaseId}}\">{{$ctrl.releaseForm.startedFromReleaseTitle}}</a>\n                    </div>\n                </div>\n\n            </fieldset>\n\n            <!-- Release variables... -->\n            <div class=\"variables\" ng-if=\"!$ctrl.isTemplate() && $ctrl.isNewRelease() && ($ctrl.releaseForm.variables | filter: $ctrl.variablesFilter).length > 0\">\n                <span class=\"release-variables-legend\">Release Variables &nbsp;<span doc-icon=\"variables.html\"></span></span>\n\n                <div variables-editor\n                     variables=\"$ctrl.releaseForm.variables\"\n                     form=\"releasePropertiesForm\"\n                     readonly=\"$ctrl.readOnly\"\n                     filter=\"$ctrl.variablesFilter\">\n                </div>\n            </div>\n\n            <fieldset class=\"variables\" ng-if=\"!$ctrl.isTemplate() && !$ctrl.isNewRelease()\">\n                <legend>Release Variables &nbsp;<span doc-icon=\"variables.html\"></span></legend>\n\n                <div class=\"help\">\n                    Release variables can be set on the <a ng-href=\"#/releases/{{$ctrl.releaseForm.id}}/variables\">Variables Screen</a>.\n                </div>\n            </fieldset>\n\n            <!-- Actions... -->\n            <div class=\"form-footer\">\n                <!-- should add creation in progress logic... -->\n                <button class=\"button continue primary\" ng-click=\"$ctrl.onUpdate()\"\n                        ng-disabled=\"releasePropertiesForm.$invalid || !$ctrl.hasValidDates() || $ctrl.readOnly\">\n                    <span>{{$ctrl.isNewRelease() ? \'Create\' : \'Save\'}}</span>\n                </button>\n                <button ng-if=\"$ctrl.isNewRelease()\" type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.onCancel()\">Cancel</button>\n                <button ng-if=\"!$ctrl.isNewRelease()\" ng-disabled=\"!releasePropertiesForm.$dirty\" type=\"button\" class=\"button\"\n                        ng-click=\"releasePropertiesForm.$setPristine(); $ctrl.resetForm()\">Reset\n                </button>\n                <div ng-if=\"$ctrl.lastUpdatedAt\" class=\"pull-left last-saved\">Last saved on {{ $ctrl.lastUpdatedAt | date: \'medium\' }}</div>\n            </div>\n        </div>\n\n        <!-- Details column -->\n        <div class=\"col-sm-5\">\n            <fieldset>\n                <legend>{{$ctrl.isTemplate() ? \'Template details\' : \'Release details\'}}</legend>\n\n                <!-- Flag status -->\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\" for=\"releaseForm-flagComment\">Flag status</label>\n\n                    <div class=\"col-sm-8 col-lg-9 flags\">\n                        <!-- all of this should be extracted to a component -->\n                        <flag-picker ng-if=\"!$ctrl.readOnly\" flag=\"$ctrl.releaseForm.flag.status\" on-update=\"$ctrl.onFlagUpdate(flag)\"></flag-picker>\n                        <div ng-if=\"$ctrl.readOnly\" class=\"flag-icon {{ $ctrl.releaseForm.flag.status | lowercase }}\"></div>\n                        &nbsp;\n                        <input type=\"text\" placeholder=\"Set status text...\" class=\"flag-comment\" id=\"releaseForm-flagComment\"\n                               ng-model=\"$ctrl.releaseForm.flag.comment\" ng-disabled=\"$ctrl.readOnly\"/>\n                    </div>\n                </div>\n\n                <!-- (Schedule) Start date -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">\n                        {{$ctrl.isTemplate() ? \'Scheduled start date\' : \'Start date\'}} <span ng-if=\"!$ctrl.hasValidDates()\" class=\"error\">*</span>\n                    </label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <span class=\"scheduled-start-date\"\n                              ng-if=\"$ctrl.isTemplate() || !$ctrl.isReleaseStarted()\"\n                              date-editor\n                              date=\"$ctrl.releaseForm.scheduledStartDate\"\n                              placeholder=\"No date\"\n                              deletable=\"false\"\n                              readonly=\"$ctrl.readOnly\"\n                              on-change=\"$ctrl.planning.updateScheduledStartDate($ctrl.releaseForm)\">\n                        </span>\n\n                        <span ng-if=\"!$ctrl.isTemplate() && $ctrl.isReleaseStarted()\"\n                              date-editor\n                              date=\"$ctrl.releaseForm.startDate\"\n                              deletable=\"false\"\n                              readonly=\"\'true\'\">\n                        </span>\n                        &nbsp;{{$ctrl.timeZone}}\n                    </div>\n                </div>\n\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\"></label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <input type=\"checkbox\"\n                               class=\"pull-left mls\"\n                               ng-disabled=\"$ctrl.readOnly || $ctrl.isReleaseStarted()\"\n                               ng-model=\"$ctrl.releaseForm.autoStart\"\n                               id=\"release-form-start-on-scheduled-start-date\"/>\n                        <span class=\"pls\">Start automatically on selected date</span>\n                    </div>\n                </div>\n\n                <!-- Due date -->\n                <div class=\"form-group\" ng-if=\"$ctrl.isTemplate() || !$ctrl.releaseForm.endDate\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Due date</label>\n\n                    <div class=\"due-date col-sm-8 col-lg-9\"\n                         date-editor\n                         date=\"$ctrl.releaseForm.dueDate\"\n                         placeholder=\"No date\"\n                         inferred-date=\"$ctrl.planning.planElement.displayEndDate\"\n                         deletable=\"$ctrl.isTemplate()\"\n                         readonly=\"$ctrl.readOnly\"\n                         on-change=\"$ctrl.planning.updateDueDate($ctrl.releaseForm)\">\n                    </div>\n                    <div class=\"col-sm-8 col-lg-9\" ng-if=\"!$ctrl.hasValidDates()\">\n                        <span class=\"error\">Start date must be before due date</span>\n                    </div>\n                </div>\n\n                <!-- End date -->\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate() && $ctrl.releaseForm.endDate\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">End date</label>\n\n                    <div class=\"col-sm-8 col-lg-9\" date-editor date=\"$ctrl.releaseForm.endDate\" deletable=\"false\" readonly=\"$ctrl.readOnly\">\n                    </div>\n                </div>\n\n                <!-- Duration -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Duration</label>\n\n                    <div class=\"col-sm-8 col-lg-9 duration\"\n                         duration-editor\n                         duration=\"$ctrl.releaseForm.plannedDuration\"\n                         inferred-duration=\"$ctrl.planning.planElement.displayDuration\"\n                         editable=\"!$ctrl.readOnly\"\n                         on-change=\"$ctrl.planning.updateDuration($ctrl.releaseForm)\"\n                         done=\"$ctrl.releaseForm.done\">\n                    </div>\n                </div>\n\n                <hr>\n\n                <!-- Release owner -->\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">\n                        Release Owner <span ng-if=\"releasePropertiesForm.owner.$error.required\" class=\"error\">*</span>\n                    </label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <span class=\"input-block-level release-owner\" ng-if=\"!$ctrl.readOnly\"\n                              inline-user-editor model=\"$ctrl.releaseForm.owner\"\n                              autocomplete-data=\"$ctrl.allUsers\" name=\"owner\" required>\n                            <span display-user=\"$ctrl.releaseForm.owner\"></span>\n                        </span>\n                        <span ng-if=\"$ctrl.readOnly\" class=\"release-owner read-only\">\n                            <span display-user=\"$ctrl.releaseForm.owner\"></span>\n                        </span>\n                    </div>\n                </div>\n\n                <!-- Run automated tasks as user -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Run automated tasks as user</label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <span ng-if=\"!$ctrl.readOnly\"\n                              class=\"input-block-level script-username\"\n                              inline-user-editor\n                              model=\"$ctrl.releaseForm.scriptUsername\"\n                              autocomplete-data=\"$ctrl.allUsers\"\n                              placeholder=\"Set user...\">\n                            <span display-user=\"$ctrl.releaseForm.scriptUsername\"></span>\n                        </span>\n                        <span ng-if=\"$ctrl.readOnly\" class=\"script-username read-only\">\n                            <span display-user=\"$ctrl.releaseForm.scriptUsername\"></span>\n                        </span>\n                    </div>\n                </div>\n\n                <!-- Password -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Password</label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <span ng-if=\"!$ctrl.readOnly\"\n                              class=\"input-block-level script-userpassword\"\n                              inline-password-editor\n                              model=\"$ctrl.releaseForm.scriptUserPassword\"\n                              placeholder=\"Set password...\">\n                            <span class=\"light-text\">Click here to modify the password</span>\n                        </span>\n                        <span ng-if=\"$ctrl.readOnly\" class=\"script-userpassword read-only\">\n                            <span class=\"light-text\">*****</span>\n                        </span>\n                    </div>\n                </div>\n\n                <hr>\n\n                <!-- Abort on failure -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\" for=\"release-form-abort-on-failure\">Abort on failure</label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <input type=\"checkbox\" ng-disabled=\"$ctrl.readOnly\" ng-model=\"$ctrl.releaseForm.abortOnFailure\" id=\"release-form-abort-on-failure\"/>\n                    </div>\n                </div>\n\n                <!-- Tags -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Tags</label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <div id=\"tags\" class=\"transparent orange-tags\"\n                             tags-input\n                             tags=\"$ctrl.releaseForm.tags\"\n                             placeholder=\"Add a tag...\"\n                             read-only=\"$ctrl.readOnly\">\n                        </div>\n                    </div>\n                </div>\n\n                <!-- Attachments -->\n                <div class=\"form-group attachments-list\" ng-if=\"!$ctrl.isNewRelease()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Attachments</label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <div attachments-list\n                             attachments=\"$ctrl.releaseForm.attachments\"\n                             readonly=\"$ctrl.readOnly\"\n                             upload-url=\"$ctrl.attachmentUploadUrl\"\n                             can-delete-attachments=\"!$ctrl.readOnly\"\n                             delete-attachment=\"$ctrl.deleteAttachment(attachment)\"></div>\n                    </div>\n                </div>\n\n                <!-- Share calendar -->\n                <div ng-if=\"!$ctrl.isTemplate() && !$ctrl.isNewRelease() && $ctrl.hasValidDates\">\n                    <div class=\"form-group\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">Share calendar</label>\n\n                        <div class=\"col-sm-8 col-lg-9\">\n                            <input type=\"checkbox\" ng-model=\"$ctrl.releaseForm.calendarPublished\" id=\"releaseForm-calendarPublished\" ng-disabled=\"$ctrl.readOnly\"/>\n                            <label class=\"public-link\" for=\"releaseForm-calendarPublished\">Publish link</label>\n                        </div>\n                        <div class=\"clearfix\"></div>\n                        <span ng-if=\"$ctrl.releaseForm.calendarPublished\" class=\"subscribe-link\" href=\"{{ $ctrl.calendarUrl }}\" target=\"_blank\">{{ $ctrl.calendarUrl }}</span>\n                        <div class=\"col-sm-8 col-lg-9\">\n                            <button type=\"button\" class=\"button download-ics\" ng-click=\"$ctrl.downloadCalendar()\" ng-disabled=\"creationInProgress\">\n                                Download calendar event\n                            </button>\n                        </div>\n                    </div>\n                </div>\n\n            </fieldset>\n        </div>\n    </div>\n</form>\n\n");
$templateCache.put("static/7.1.0/xlr-components/template-list-component/template-list-partial.html","<div class=\"content-under-header\">\n    <div ng-show=\"vm.list.length > 0\">\n        <div class=\"template\" ng-repeat=\'template in vm.list\'>\n            <xlr-template-row-component responsive=\"vm.responsive\" template=\"template\" on-move=\"vm.onChange()\" on-delete=\"vm.onChange()\"></xlr-template-row-component>\n        </div>\n    </div>\n    <div pagination ci-loader=\"vm.templatesLoader\" />\n    <div class=\"alert notice\" ng-show=\"!vm.templatesLoader.isLoading() && !vm.list\">No templates found.</div>\n</div>");
$templateCache.put("static/7.1.0/xlr-components/template-properties-component/template-properties-partial.html","<release-properties-container id=\"template-properties\" release=\"$ctrl.template\">\n    <header id=\"new-release-header\">\n        <h4>Create template</h4>\n        <span doc-icon=\"creating-a-template.html\"></span>\n    </header>\n    <content>\n        <release-properties-form release=\"$ctrl.template\"\n                                 read-only=\"!$ctrl.canEditTemplate()\"\n                                 on-save=\"$ctrl.onSave(release)\"\n                                 on-cancel=\"$ctrl.onCancel()\">\n        </release-properties-form>\n    </content>\n</release-properties-container>\n");
$templateCache.put("static/7.1.0/xlr-components/template-row-component/template-row-partial.html","<div class=\"title col-xs-12 raised-link-wrapper\" ng-class=\"{ \'center\': !vm.isInsideFolder(), \'title-in-folder\': vm.responsive }\">\n        <a class=\"raised-link col-xs-6\" href=\"{{vm.getTemplateEditorURL()}}\"></a>\n        <div class=\"template-title col-xs-6\">\n            <span class=\"menu-icon template-icon\"></span>\n            <strong class=\"raised-link-target\">{{vm.template.title}}</strong>\n            <div ng-if=\"vm.isInsideFolder()\">\n                <folder-path ci=\"vm.template\"></folder-path>\n            </div>\n        </div>\n        <div class=\"template-actions col-xs-6\" ng-class=\"{ \'center\': vm.isInsideFolder() }\">\n            <span class=\"pull-right\">\n                <span ng-show=\"vm.hasPermissionToEdit()\">\n                    <a class=\"link color-inherited\" href=\"{{vm.getTemplateEditorURL()}}\">\n                        <i title=\"Edit\" class=\"menu-icon glyphicon glyphicon-pencil\"></i><span class=\"action-label\">Edit</span>\n                    </a>\n                </span>\n                <span ng-show=\"vm.hasPermissionToCreate()\">\n                    <a ng-href=\"#/releases/create?fromTemplateId={{ vm.template.id }}\" class=\"link\" stop-click-propagation>\n                        <i title=\"New release\" class=\"menu-icon glyphicon glyphicon-plus\"></i><span class=\"action-label\">New release</span>\n                    </a>\n                </span>\n                <span ng-show=\"vm.hasPermissionToCopy()\">\n                    <span class=\"link copy\"\n                          scope-less-modal=\"\'partials/templates/copy-template-modal.html\'\"\n                          ctrl=\"vm\"\n                          stop-click-propagation>\n                        <i title=\"Copy\" class=\"menu-icon copy-icon\"></i><span class=\"action-label\">Copy</span>\n                    </span>\n                </span>\n                <span ng-show=\"vm.hasPermissionToMove()\">\n                    <span class=\"link move\"\n                          scope-less-modal=\"\'partials/templates/move-template-modal.html\'\"\n                          ctrl=\"vm\"\n                          stop-click-propagation>\n                        <i title=\"Move\" class=\"menu-icon glyphicon glyphicon-arrow-right\"></i><span class=\"action-label\">Move</span>\n                    </span>\n                </span>\n                <span ng-show=\"vm.hasPermissionToDelete()\">\n                    <span class=\"link delete\"\n                          scope-less-modal=\"\'partials/templates/delete-template-modal.html\'\"\n                          ctrl=\"vm\"\n                          stop-click-propagation>\n                        <i title=\"Delete\" class=\"menu-icon glyphicon glyphicon-remove\"></i><span class=\"action-label\">Delete</span>\n                    </span>\n                </span>\n            </span>\n        </div>\n\n</div>\n");}]);