/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCopiedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.risk.domain.progress.ReleaseProgress;
import com.xebialabs.xlrelease.risk.repository.Progress;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProgressService {
    private static final Logger logger = LoggerFactory.getLogger(ProgressService.class);
    private XLReleaseEventBus eventBus;
    private Releases releases;
    private Progress progress;

    @Autowired
    public ProgressService(XLReleaseEventBus eventBus, Releases releases, Progress progress) {
        this.eventBus = eventBus;
        this.releases = releases;
        this.progress = progress;
    }

    @PostConstruct
    public void register() {
        this.eventBus.register((Object)this);
        logger.debug("Progress service registered in an event bus");
    }

    @PreDestroy
    public void unregister() {
        this.eventBus.deregister((Object)this);
        logger.debug("Progress service deregistered from an event bus");
    }

    @Subscribe
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.updateReleaseProgress(releaseCreatedEvent.release());
    }

    @Subscribe
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.updateReleaseProgress(taskSkippedEvent.task());
    }

    @Subscribe
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.updateReleaseProgress(taskCompletedEvent.task());
    }

    @Subscribe
    public void taskCreated(TaskCreatedEvent taskCreatedEvent) {
        this.updateReleaseProgress(taskCreatedEvent.task());
    }

    @Subscribe
    public void taskDuplicated(TaskCopiedEvent taskCopiedEvent) {
        this.updateReleaseProgress(taskCopiedEvent.taskCopied());
    }

    @Subscribe
    public void taskDeleted(TaskDeletedEvent event) {
        this.updateReleaseProgress(event.task());
    }

    private Release loadReleaseFromTask(String id) {
        return this.releases.findById(Ids.releaseIdFrom((String)id));
    }

    private void updateReleaseProgress(Task task) {
        this.updateReleaseProgress(this.loadReleaseFromTask(task.getId()));
    }

    public void updateReleaseProgress(Release release) {
        if (!release.isTemplate()) {
            List allTasks = release.getAllTasks();
            int totalTasks = allTasks.size();
            int tasksCompleted = (int)allTasks.stream().filter(ProgressService::isTaskCompleted).count();
            ReleaseProgress releaseProgress = new ReleaseProgress();
            releaseProgress.setId(release.getId() + "/progress");
            releaseProgress.setTotalRemainingTasks(totalTasks - tasksCompleted);
            releaseProgress.setTotalTasks(totalTasks);
            HashMap<String, String> phasesProgress = new HashMap<String, String>();
            release.getPhases().forEach(phase -> {
                int totalPhaseTasks = phase.getAllTasks().size();
                int tasksCompletedInPhase = (int)phase.getAllTasks().stream().filter(ProgressService::isTaskCompleted).count();
                phasesProgress.put(phase.getId(), String.format("%d;%d", totalPhaseTasks, tasksCompletedInPhase));
            });
            releaseProgress.setPhasesProgress(phasesProgress);
            this.progress.createOrUpdate(releaseProgress);
            logger.debug("Release progress updated");
        }
    }

    private static boolean isTaskCompleted(Task task) {
        return task.isDone() || task.isDoneInAdvance();
    }
}

