/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.handlers;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.TaskDueSoonEvent;
import com.xebialabs.xlrelease.domain.events.TaskFailedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskRetriedEvent;
import com.xebialabs.xlrelease.domain.events.TaskStartedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskWaitingForInputEvent;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.events.EventListening;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.notifications.ActiveTaskAssigned;
import com.xebialabs.xlrelease.notifications.ActiveTaskUnassigned;
import com.xebialabs.xlrelease.notifications.ManualTaskStarted;
import com.xebialabs.xlrelease.notifications.ManualTaskStartedWithoutAssignee;
import com.xebialabs.xlrelease.notifications.NotificationService;
import com.xebialabs.xlrelease.notifications.TaskDueSoon;
import com.xebialabs.xlrelease.notifications.TaskFailed;
import com.xebialabs.xlrelease.notifications.TaskFlagged;
import com.xebialabs.xlrelease.notifications.TaskOverdue;
import com.xebialabs.xlrelease.notifications.TaskWaitingForInput;
import com.xebialabs.xlrelease.notifications.package$;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Tuple2;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u00015\u0011A\u0004V1tW:{G/\u001b4jG\u0006$\u0018n\u001c8Fm\u0016tG\u000fS1oI2,'O\u0003\u0002\u0004\t\u0005A\u0001.\u00198eY\u0016\u00148O\u0003\u0002\u0006\r\u0005ian\u001c;jM&\u001c\u0017\r^5p]NT!a\u0002\u0005\u0002\u0013ad'/\u001a7fCN,'BA\u0005\u000b\u0003%AXMY5bY\u0006\u00147OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011AB3wK:$8/\u0003\u0002\u001a-\tqQI^3oi2K7\u000f^3oS:<\u0007\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u0011\u00154XM\u001c;CkN,\u0012!\b\t\u0003+yI!a\b\f\u0003#ac%+\u001a7fCN,WI^3oi\n+8\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001e\u0003%)g/\u001a8u\u0005V\u001c\b\u0005\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003Mqw\u000e^5gS\u000e\fG/[8o'\u0016\u0014h/[2f!\t)c%D\u0001\u0005\u0013\t9CAA\nO_RLg-[2bi&|gnU3sm&\u001cW\rC\u0003*\u0001\u0011\u0005!&\u0001\u0004=S:LGO\u0010\u000b\u0004W5r\u0003C\u0001\u0017\u0001\u001b\u0005\u0011\u0001\"B\u000e)\u0001\u0004i\u0002\"B\u0012)\u0001\u0004!\u0003F\u0001\u00151!\t\tD(D\u00013\u0015\t\u0019D'\u0001\u0006b]:|G/\u0019;j_:T!!\u000e\u001c\u0002\u000f\u0019\f7\r^8ss*\u0011q\u0007O\u0001\u0006E\u0016\fgn\u001d\u0006\u0003si\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002w\u0005\u0019qN]4\n\u0005u\u0012$!C!vi><\u0018N]3e\u0011\u0015y\u0004\u0001\"\u0001A\u00035yg\u000eV1tWV\u0003H-\u0019;fIR\u0011\u0011\t\u0012\t\u0003\u001f\tK!a\u0011\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u000bz\u0002\rAR\u0001\u0006KZ,g\u000e\u001e\t\u0003\u000f.k\u0011\u0001\u0013\u0006\u0003/%S!A\u0013\u0004\u0002\r\u0011|W.Y5o\u0013\ta\u0005J\u0001\tUCN\\W\u000b\u001d3bi\u0016$WI^3oi\"\u0012aH\u0014\t\u0003\u001fZk\u0011\u0001\u0015\u0006\u0003#J\u000bQ\u0001\u001e\u001ackNT!a\u0015+\u0002\u0011)\fg/\u00193vI\u0016T\u0011!V\u0001\u0003]2L!a\u0016)\u0003\u0013M+(m]2sS\n,\u0007\"B-\u0001\t\u0003Q\u0016!D8o)\u0006\u001c8n\u0015;beR,G\r\u0006\u0002B7\")Q\t\u0017a\u00019B\u0011q)X\u0005\u0003=\"\u0013\u0001\u0003V1tWN#\u0018M\u001d;fI\u00163XM\u001c;)\u0005as\u0005\"B1\u0001\t\u0003\u0011\u0017!D8o)\u0006\u001c8NU3ue&,G\r\u0006\u0002BG\")Q\t\u0019a\u0001IB\u0011q)Z\u0005\u0003M\"\u0013\u0001\u0003V1tWJ+GO]5fI\u00163XM\u001c;)\u0005\u0001t\u0005\"B5\u0001\t\u0003Q\u0017\u0001D8o)\u0006\u001c8NR1jY\u0016$GCA!l\u0011\u0015)\u0005\u000e1\u0001m!\t9U.\u0003\u0002o\u0011\nyA+Y:l\r\u0006LG.\u001a3Fm\u0016tG\u000f\u000b\u0002i\u001d\")\u0011\u000f\u0001C\u0001e\u0006)rN\u001c+bg.<\u0016-\u001b;j]\u001e4uN]%oaV$HCA!t\u0011\u0015)\u0005\u000f1\u0001u!\t9U/\u0003\u0002w\u0011\nAB+Y:l/\u0006LG/\u001b8h\r>\u0014\u0018J\u001c9vi\u00163XM\u001c;)\u0005At\u0005\"B=\u0001\t\u0003Q\u0018!D8o)\u0006\u001c8n\u0014<fe\u0012,X\r\u0006\u0002Bw\")Q\t\u001fa\u0001yB\u0011q)`\u0005\u0003}\"\u0013\u0001\u0003V1tW>3XM\u001d3vK\u00163XM\u001c;)\u0005at\u0005bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u000e_:$\u0016m]6Ek\u0016\u001cvn\u001c8\u0015\u0007\u0005\u000b9\u0001C\u0004F\u0003\u0003\u0001\r!!\u0003\u0011\u0007\u001d\u000bY!C\u0002\u0002\u000e!\u0013\u0001\u0003V1tW\u0012+XmU8p]\u00163XM\u001c;)\u0007\u0005\u0005a\nC\u0004\u0002\u0014\u0001!I!!\u0006\u0002/9|G/\u001b4z\u001b\u0006tW/\u00197UCN\\7\u000b^1si\u0016$GcA!\u0002\u0018!A\u0011\u0011DA\t\u0001\u0004\tY\"\u0001\u0003uCN\\\u0007\u0003BA\u000f\u0003?i\u0011!S\u0005\u0004\u0003CI%\u0001\u0002+bg.D3\u0001AA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016q\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005=\u0012\u0011\u0006\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class TaskNotificationEventHandler
implements EventListening {
    private final XLReleaseEventBus eventBus;
    private final NotificationService notificationService;

    @PostConstruct
    public void postConstruct() {
        EventListening.class.postConstruct((EventListening)this);
    }

    @PreDestroy
    public void preDestroy() {
        EventListening.class.preDestroy((EventListening)this);
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Subscribe
    public void onTaskUpdated(TaskUpdatedEvent event) {
        Tuple2 tuple2 = new Tuple2((Object)event.original(), (Object)event.updated());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Task original = (Task)tuple2._1();
            Task updated = (Task)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)original, (Object)updated);
            Task original2 = (Task)tuple23._1();
            Task updated2 = (Task)tuple23._2();
            if (updated2.isActive()) {
                if (Option$.MODULE$.apply((Object)original2.getOwner()).isDefined() && Option$.MODULE$.apply((Object)updated2.getOwner()).isEmpty()) {
                    this.notificationService.notify(new ActiveTaskUnassigned(updated2));
                } else {
                    String string = original2.getOwner();
                    String string2 = updated2.getOwner();
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        this.notificationService.notify(new ActiveTaskAssigned(updated2));
                    }
                }
                FlagStatus flagStatus = original2.getFlagStatus();
                FlagStatus flagStatus2 = updated2.getFlagStatus();
                if (flagStatus == null ? flagStatus2 != null : !flagStatus.equals(flagStatus2)) {
                    FlagStatus flagStatus3 = updated2.getFlagStatus();
                    FlagStatus flagStatus4 = FlagStatus.OK;
                    if (flagStatus3 == null ? flagStatus4 != null : !flagStatus3.equals(flagStatus4)) {
                        this.notificationService.notify(new TaskFlagged(updated2));
                    }
                }
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Subscribe
    public void onTaskStarted(TaskStartedEvent event) {
        this.notifyManualTaskStarted(event.task());
    }

    @Subscribe
    public void onTaskRetried(TaskRetriedEvent event) {
        this.notifyManualTaskStarted(event.task());
    }

    @Subscribe
    public void onTaskFailed(TaskFailedEvent event) {
        if (!event.task().isTaskGroup()) {
            this.notificationService.notify(new TaskFailed(event.task()));
        }
    }

    @Subscribe
    public void onTaskWaitingForInput(TaskWaitingForInputEvent event) {
        this.notificationService.notify(new TaskWaitingForInput(event.task()));
    }

    @Subscribe
    public void onTaskOverdue(TaskOverdueEvent event) {
        Task task = event.task();
        Option dueDate = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(task.getOrCalculateDueDate()));
        if (task.isInProgress() && dueDate.exists((Function1)new Serializable(this, task){
            public static final long serialVersionUID = 0L;
            private final Task task$1;

            public final boolean apply(Date x$2) {
                return x$2.after(this.task$1.getStartDate());
            }
            {
                this.task$1 = task$1;
            }
        })) {
            this.notificationService.notify(new TaskOverdue(task));
        }
    }

    @Subscribe
    public void onTaskDueSoon(TaskDueSoonEvent event) {
        this.notificationService.notify(new TaskDueSoon(event.task()));
    }

    private void notifyManualTaskStarted(Task task) {
        if (!task.isAutomated() && !task.isTaskGroup()) {
            if (Option$.MODULE$.apply((Object)task.getOwner()).isEmpty() && Option$.MODULE$.apply((Object)task.getTeam()).isEmpty() && package$.MODULE$.TaskWithNotificationFields(task).sendNotificationWhenStarted()) {
                this.notificationService.notify(new ManualTaskStartedWithoutAssignee(task));
            } else {
                this.notificationService.notify(new ManualTaskStarted(task));
            }
        }
    }

    @Autowired
    public TaskNotificationEventHandler(XLReleaseEventBus eventBus, NotificationService notificationService) {
        this.eventBus = eventBus;
        this.notificationService = notificationService;
        EventListening.class.$init$((EventListening)this);
    }
}

