/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.handlers;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseFailedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseStartedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseStartedFailingEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedEvent;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.events.EventListening;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.notifications.NotificationService;
import com.xebialabs.xlrelease.notifications.ReleaseAborted;
import com.xebialabs.xlrelease.notifications.ReleaseCompleted;
import com.xebialabs.xlrelease.notifications.ReleaseFailed;
import com.xebialabs.xlrelease.notifications.ReleaseFailing;
import com.xebialabs.xlrelease.notifications.ReleaseFlagged;
import com.xebialabs.xlrelease.notifications.ReleaseStarted;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u00015\u0011qDU3mK\u0006\u001cXMT8uS\u001aL7-\u0019;j_:,e/\u001a8u\u0011\u0006tG\r\\3s\u0015\t\u0019A!\u0001\u0005iC:$G.\u001a:t\u0015\t)a!A\u0007o_RLg-[2bi&|gn\u001d\u0006\u0003\u000f!\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\r\u00154XM\u001c;t\u0013\tIbC\u0001\bFm\u0016tG\u000fT5ti\u0016t\u0017N\\4\t\u0011m\u0001!Q1A\u0005\u0002q\t\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002;A\u0011QCH\u0005\u0003?Y\u0011\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0011!\t\u0003A!A!\u0002\u0013i\u0012!C3wK:$()^:!\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013a\u00058pi&4\u0017nY1uS>t7+\u001a:wS\u000e,\u0007CA\u0013'\u001b\u0005!\u0011BA\u0014\u0005\u0005Mqu\u000e^5gS\u000e\fG/[8o'\u0016\u0014h/[2f\u0011\u0015I\u0003\u0001\"\u0001+\u0003\u0019a\u0014N\\5u}Q\u00191&\f\u0018\u0011\u00051\u0002Q\"\u0001\u0002\t\u000bmA\u0003\u0019A\u000f\t\u000b\rB\u0003\u0019\u0001\u0013)\u0005!\u0002\u0004CA\u0019=\u001b\u0005\u0011$BA\u001a5\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003kY\nqAZ1di>\u0014\u0018P\u0003\u00028q\u0005)!-Z1og*\u0011\u0011HO\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t1(A\u0002pe\u001eL!!\u0010\u001a\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"B \u0001\t\u0003\u0001\u0015\u0001E8o%\u0016dW-Y:f+B$\u0017\r^3e)\t\tE\t\u0005\u0002\u0010\u0005&\u00111\t\u0005\u0002\u0005+:LG\u000fC\u0003F}\u0001\u0007a)A\u0003fm\u0016tG\u000f\u0005\u0002H\u00176\t\u0001J\u0003\u0002\u0018\u0013*\u0011!JB\u0001\u0007I>l\u0017-\u001b8\n\u00051C%a\u0005*fY\u0016\f7/Z+qI\u0006$X\rZ#wK:$\bF\u0001 O!\tye+D\u0001Q\u0015\t\t&+A\u0003ue\t,8O\u0003\u0002T)\u0006A!.\u0019<bIV$WMC\u0001V\u0003\tqG.\u0003\u0002X!\nI1+\u001e2tGJL'-\u001a\u0005\u00063\u0002!\tAW\u0001\u0011_:\u0014V\r\\3bg\u0016\u001cF/\u0019:uK\u0012$\"!Q.\t\u000b\u0015C\u0006\u0019\u0001/\u0011\u0005\u001dk\u0016B\u00010I\u0005M\u0011V\r\\3bg\u0016\u001cF/\u0019:uK\u0012,e/\u001a8uQ\tAf\nC\u0003b\u0001\u0011\u0005!-\u0001\tp]J+G.Z1tK\u0006\u0013wN\u001d;fIR\u0011\u0011i\u0019\u0005\u0006\u000b\u0002\u0004\r\u0001\u001a\t\u0003\u000f\u0016L!A\u001a%\u0003'I+G.Z1tK\u0006\u0013wN\u001d;fI\u00163XM\u001c;)\u0005\u0001t\u0005\"B5\u0001\t\u0003Q\u0017AE8o%\u0016dW-Y:f\u0007>l\u0007\u000f\\3uK\u0012$\"!Q6\t\u000b\u0015C\u0007\u0019\u00017\u0011\u0005\u001dk\u0017B\u00018I\u0005U\u0011V\r\\3bg\u0016\u001cu.\u001c9mKR,G-\u0012<f]RD#\u0001\u001b(\t\u000bE\u0004A\u0011\u0001:\u0002\u001f=t'+\u001a7fCN,g)Y5mK\u0012$\"!Q:\t\u000b\u0015\u0003\b\u0019\u0001;\u0011\u0005\u001d+\u0018B\u0001<I\u0005I\u0011V\r\\3bg\u00164\u0015-\u001b7fI\u00163XM\u001c;)\u0005At\u0005\"B=\u0001\t\u0003Q\u0018\u0001E8o%\u0016dW-Y:f\r\u0006LG.\u001b8h)\t\t5\u0010C\u0003Fq\u0002\u0007A\u0010\u0005\u0002H{&\u0011a\u0010\u0013\u0002\u001b%\u0016dW-Y:f'R\f'\u000f^3e\r\u0006LG.\u001b8h\u000bZ,g\u000e\u001e\u0015\u0003q:C3\u0001AA\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005q\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u00055\u0011q\u0001\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class ReleaseNotificationEventHandler
implements EventListening {
    private final XLReleaseEventBus eventBus;
    private final NotificationService notificationService;

    @PostConstruct
    public void postConstruct() {
        EventListening.class.postConstruct((EventListening)this);
    }

    @PreDestroy
    public void preDestroy() {
        EventListening.class.preDestroy((EventListening)this);
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Subscribe
    public void onReleaseUpdated(ReleaseUpdatedEvent event) {
        Tuple2 tuple2 = new Tuple2((Object)event.original(), (Object)event.updated());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Release original = (Release)tuple2._1();
            Release updated = (Release)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)original, (Object)updated);
            Release original2 = (Release)tuple23._1();
            Release updated2 = (Release)tuple23._2();
            FlagStatus flagStatus = original2.getFlagStatus();
            FlagStatus flagStatus2 = updated2.getFlagStatus();
            if (flagStatus == null ? flagStatus2 != null : !flagStatus.equals(flagStatus2)) {
                FlagStatus flagStatus3 = updated2.getFlagStatus();
                FlagStatus flagStatus4 = FlagStatus.OK;
                if (flagStatus3 == null ? flagStatus4 != null : !flagStatus3.equals(flagStatus4)) {
                    this.notificationService.notify(new ReleaseFlagged(updated2));
                }
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Subscribe
    public void onReleaseStarted(ReleaseStartedEvent event) {
        this.notificationService.notify(new ReleaseStarted(event.release()));
    }

    @Subscribe
    public void onReleaseAborted(ReleaseAbortedEvent event) {
        this.notificationService.notify(new ReleaseAborted(event.release()));
    }

    @Subscribe
    public void onReleaseCompleted(ReleaseCompletedEvent event) {
        this.notificationService.notify(new ReleaseCompleted(event.release()));
    }

    @Subscribe
    public void onReleaseFailed(ReleaseFailedEvent event) {
        this.notificationService.notify(new ReleaseFailed(event.release()));
    }

    @Subscribe
    public void onReleaseFailing(ReleaseStartedFailingEvent event) {
        this.notificationService.notify(new ReleaseFailing(event.release()));
    }

    @Autowired
    public ReleaseNotificationEventHandler(XLReleaseEventBus eventBus, NotificationService notificationService) {
        this.eventBus = eventBus;
        this.notificationService = notificationService;
        EventListening.class.$init$((EventListening)this);
    }
}

