/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.api.internal;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.notifications.TriggerType$;
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings;
import com.xebialabs.xlrelease.notifications.configuration.trigger.NotificationTriggerSettings;
import com.xebialabs.xlrelease.notifications.email.EmailNotifications;
import com.xebialabs.xlrelease.notifications.email.Templater$;
import com.xebialabs.xlrelease.notifications.views.EmailNotificationSettingsView;
import com.xebialabs.xlrelease.notifications.views.EmailPreviewView;
import com.xebialabs.xlrelease.notifications.views.converters.EmailNotificationSettingsConverter;
import com.xebialabs.xlrelease.security.PermissionChecker;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Enumeration;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@Path(value="/settings/notifications")
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0001\u0003\u0001=\u0011QCT8uS\u001aL7-\u0019;j_:\u001c(+Z:pkJ\u001cWM\u0003\u0002\u0004\t\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0006\r\u0005\u0019\u0011\r]5\u000b\u0005\u001dA\u0011!\u00048pi&4\u0017nY1uS>t7O\u0003\u0002\n\u0015\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011!9\u0002A!A!\u0002\u0013A\u0012AE3nC&dgj\u001c;jM&\u001c\u0017\r^5p]N\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\u000b\u0015l\u0017-\u001b7\n\u0005uQ\"AE#nC&dgj\u001c;jM&\u001c\u0017\r^5p]ND\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\fa\u0016\u0014X.[:tS>t7\u000f\u0005\u0002\"I5\t!E\u0003\u0002$\u0011\u0005A1/Z2ve&$\u00180\u0003\u0002&E\t\t\u0002+\u001a:nSN\u001c\u0018n\u001c8DQ\u0016\u001c7.\u001a:\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\n1c]3sm\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\u0006\u0002\u0011\u0011,\u0007\u000f\\8zSRL!!\f\u0016\u0003'M+'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b=\u0002A\u0011\u0001\u0019\u0002\rqJg.\u001b;?)\u0011\t4\u0007N\u001b\u0011\u0005I\u0002Q\"\u0001\u0002\t\u000b]q\u0003\u0019\u0001\r\t\u000b}q\u0003\u0019\u0001\u0011\t\u000b\u001dr\u0003\u0019\u0001\u0015)\u00059:\u0004C\u0001\u001dD\u001b\u0005I$B\u0001\u001e<\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003yu\nqAZ1di>\u0014\u0018P\u0003\u0002?\u007f\u0005)!-Z1og*\u0011\u0001)Q\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t!)A\u0002pe\u001eL!\u0001R\u001d\u0003\u0013\u0005+Ho\\<je\u0016$\u0007b\u0002$\u0001\u0005\u0004%IaR\u0001\ng\u0016\u0014h/\u001a:Ve2,\u0012\u0001\u0013\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000bA\u0001\\1oO*\tQ*\u0001\u0003kCZ\f\u0017BA(K\u0005\u0019\u0019FO]5oO\"1\u0011\u000b\u0001Q\u0001\n!\u000b!b]3sm\u0016\u0014XK\u001d7!\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003q9W\r^#nC&dgj\u001c;jM&\u001c\u0017\r^5p]N+G\u000f^5oON,\u0012!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031\u001a\tQA^5foNL!AW,\u0003;\u0015k\u0017-\u001b7O_RLg-[2bi&|gnU3ui&twm\u001d,jK^DCA\u0015/gOB\u0011Q\fZ\u0007\u0002=*\u0011q\fY\u0001\u0003eNT!!\u00192\u0002\u0005]\u001c(\"A2\u0002\u000b)\fg/\u0019=\n\u0005\u0015t&\u0001\u0002)bi\"\fQA^1mk\u0016\f\u0013\u0001[\u0001\u0007K6\f\u0017\u000e\\:)\u0005IS\u0007CA/l\u0013\tagLA\u0002H\u000bRCQA\u001c\u0001\u0005\u0002=\fq$\u001e9eCR,W)\\1jY:{G/\u001b4jG\u0006$\u0018n\u001c8TKR$\u0018N\\4t)\t)\u0006\u000fC\u0003r[\u0002\u0007Q+A\u000ff[\u0006LGNT8uS\u001aL7-\u0019;j_:\u001cV\r\u001e;j]\u001e\u001ch+[3xQ\u0011iGLZ4)\u00055$\bCA/v\u0013\t1hL\u0001\u0003Q\u001fN#\u0006\"\u0002=\u0001\t\u0003I\u0018aG;qI\u0006$X-R7bS2$V-\u001c9mCR,7+\u001a;uS:<7\u000f\u0006\u0002{{B\u0011\u0011c_\u0005\u0003yJ\u0011A!\u00168ji\")ap\u001ea\u0001\u007f\u0006Ybn\u001c;jM&\u001c\u0017\r^5p]R\u0013\u0018nZ4feN+G\u000f^5oON\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!A\u0004ue&<w-\u001a:\u000b\u0007\u0005%a!A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003\u001b\t\u0019AA\u000eO_RLg-[2bi&|g\u000e\u0016:jO\u001e,'oU3ui&twm\u001d\u0015\u0006or3\u0017\u0011C\u0011\u0003\u0003'\ta#Z7bS2\u001cx\u0006\u001e:jO\u001e,'oU3ui&twm\u001d\u0015\u0003oRDq!!\u0007\u0001\t\u0003\tY\"A\u0004qe\u00164\u0018.Z<\u0015\t\u0005u\u0011\u0011\u0006\t\u0005\u0003?\t)CD\u0002\u0012\u0003CI1!a\t\u0013\u0003\u0019\u0001&/\u001a3fM&\u0019q*a\n\u000b\u0007\u0005\r\"\u0003\u0003\u0005\u0002,\u0005]\u0001\u0019AA\u0017\u0003\u00111\u0018.Z<\u0011\u0007Y\u000by#C\u0002\u00022]\u0013\u0001#R7bS2\u0004&/\u001a<jK^4\u0016.Z<)\r\u0005]ALZA\u001bC\t\t9$\u0001\bf[\u0006LGn]\u0018qe\u00164\u0018.Z<)\u0007\u0005]A\u000fC\u0005\u0002>\u0001\u0011\r\u0011b\u0003\u0002@\u0005aAm\\7bS:$vNV5foV\u0011\u0011\u0011\t\t\u0007#\u0005\r\u0013qI+\n\u0007\u0005\u0015#CA\u0005Gk:\u001cG/[8ocA!\u0011\u0011JA&\u001b\t\t9!\u0003\u0003\u0002N\u0005\u001d!!G#nC&dgj\u001c;jM&\u001c\u0017\r^5p]N+G\u000f^5oOND\u0001\"!\u0015\u0001A\u0003%\u0011\u0011I\u0001\u000eI>l\u0017-\u001b8U_ZKWm\u001e\u0011\t\u0013\u0005U\u0003A1A\u0005\f\u0005]\u0013\u0001\u0004<jK^$v\u000eR8nC&tWCAA-!\u0019\t\u00121I+\u0002H!A\u0011Q\f\u0001!\u0002\u0013\tI&A\u0007wS\u0016<Hk\u001c#p[\u0006Lg\u000e\t\u0005\n\u0003C\u0002!\u0019!C\u0006\u0003G\n1c\u001d;sS:<Gk\u001c+sS\u001e<WM\u001d+za\u0016,\"!!\u001a\u0011\u000fE\t\u0019%!\b\u0002hA!\u0011\u0011NAC\u001d\u0011\tY'!!\u000f\t\u00055\u0014q\u0010\b\u0005\u0003_\niH\u0004\u0003\u0002r\u0005md\u0002BA:\u0003sj!!!\u001e\u000b\u0007\u0005]d\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0007\u0005\re!A\u0006Ue&<w-\u001a:UsB,\u0017\u0002BAD\u0003\u0013\u00131\u0002\u0016:jO\u001e,'\u000fV=qK*\u0019\u00111\u0011\u0004\t\u0011\u00055\u0005\u0001)A\u0005\u0003K\nAc\u001d;sS:<Gk\u001c+sS\u001e<WM\u001d+za\u0016\u0004\u0003f\u0001\u0001\u0002\u0012B!\u00111SAM\u001b\t\t)JC\u0002\u0002\u0018~\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\tY*!&\u0003\u0015\r{g\u000e\u001e:pY2,'\u000f\u000b\u0004\u0001\u0003?3\u0017Q\u0015\t\u0004;\u0006\u0005\u0016bAAR=\nA\u0001K]8ek\u000e,7\u000f\f\u0002\u0002(\u0006\u0012\u0011\u0011V\u0001\u0011CB\u0004H.[2bi&|gn\f6t_:DS\u0001\u0001/g\u0003[\u000b#!a,\u0002/=\u001aX\r\u001e;j]\u001e\u001cxF\\8uS\u001aL7-\u0019;j_:\u001c\b")
public class NotificationsResource {
    private final EmailNotifications emailNotifications;
    private final PermissionChecker permissions;
    private final String serverUrl;
    private final Function1<EmailNotificationSettings, EmailNotificationSettingsView> domainToView;
    private final Function1<EmailNotificationSettingsView, EmailNotificationSettings> viewToDomain;
    private final Function1<String, Enumeration.Value> stringToTriggerType;

    private String serverUrl() {
        return this.serverUrl;
    }

    @GET
    @Path(value="emails")
    public EmailNotificationSettingsView getEmailNotificationSettings() {
        this.permissions.check(PlatformPermissions.ADMIN);
        return (EmailNotificationSettingsView)this.domainToView().apply((Object)this.emailNotifications.getSettings());
    }

    @POST
    @Path(value="emails")
    public EmailNotificationSettingsView updateEmailNotificationSettings(EmailNotificationSettingsView emailNotificationSettingsView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return (EmailNotificationSettingsView)this.domainToView().apply((Object)this.emailNotifications.updateSettings((EmailNotificationSettings)((Object)this.viewToDomain().apply((Object)emailNotificationSettingsView))));
    }

    @POST
    @Path(value="emails/triggerSettings")
    public void updateEmailTemplateSettings(NotificationTriggerSettings notificationTriggerSettings) {
        this.permissions.check(PlatformPermissions.ADMIN);
        EmailNotificationSettings settings = this.emailNotifications.getSettings();
        settings.setNotificationTriggerSettings(notificationTriggerSettings);
        this.emailNotifications.updateSettings(settings);
    }

    @POST
    @Path(value="emails/preview")
    public String preview(EmailPreviewView view) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return Templater$.MODULE$.createPreviewForTriggerType((Enumeration.Value)this.stringToTriggerType().apply((Object)view.triggerType()), view.body(), this.serverUrl());
    }

    private Function1<EmailNotificationSettings, EmailNotificationSettingsView> domainToView() {
        return this.domainToView;
    }

    private Function1<EmailNotificationSettingsView, EmailNotificationSettings> viewToDomain() {
        return this.viewToDomain;
    }

    private Function1<String, Enumeration.Value> stringToTriggerType() {
        return this.stringToTriggerType;
    }

    @Autowired
    public NotificationsResource(EmailNotifications emailNotifications, PermissionChecker permissions, ServerConfiguration serverConfiguration) {
        this.emailNotifications = emailNotifications;
        this.permissions = permissions;
        this.serverUrl = serverConfiguration.getServerUrl();
        this.domainToView = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final EmailNotificationSettingsView apply(EmailNotificationSettings settings) {
                return EmailNotificationSettingsConverter.toView(settings);
            }
        };
        this.viewToDomain = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final EmailNotificationSettings apply(EmailNotificationSettingsView view) {
                return EmailNotificationSettingsConverter.fromView(view);
            }
        };
        this.stringToTriggerType = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Enumeration.Value apply(String s) {
                return TriggerType$.MODULE$.withName(s);
            }
        };
    }
}

