/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.serialization;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.persistence.serialization.Snapshot;
import akka.serialization.BaseSerializer;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import akka.util.ByteString$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001%\u0011!c\u00158baNDw\u000e^*fe&\fG.\u001b>fe*\u00111\u0001B\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011a\u00039feNL7\u000f^3oG\u0016T\u0011aB\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0007\u0001Q\u0001\u0003\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\t\u0003#Mi\u0011A\u0005\u0006\u0003\u0007\u0019I!\u0001\u0006\n\u0003\u001d\t\u000b7/Z*fe&\fG.\u001b>fe\"Aa\u0003\u0001BC\u0002\u0013\u0005q#\u0001\u0004tsN$X-\\\u000b\u00021A\u0011\u0011\u0004H\u0007\u00025)\u00111DB\u0001\u0006C\u000e$xN]\u0005\u0003;i\u00111#\u0012=uK:$W\rZ!di>\u00148+_:uK6D\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\bgf\u001cH/Z7!\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\u00111%\n\t\u0003I\u0001i\u0011A\u0001\u0005\u0006-\u0001\u0002\r\u0001\u0007\u0005\bO\u0001\u0011\r\u0011\"\u0011)\u0003=Ign\u00197vI\u0016l\u0015M\\5gKN$X#A\u0015\u0011\u0005-Q\u0013BA\u0016\r\u0005\u001d\u0011un\u001c7fC:Da!\f\u0001!\u0002\u0013I\u0013\u0001E5oG2,H-Z'b]&4Wm\u001d;!\u0011!\u0019\u0001\u0001#b\u0001\n\u0013yS#\u0001\u0019\u0011\u0005E\t\u0014B\u0001\u001a\u0013\u00055\u0019VM]5bY&T\u0018\r^5p]\"AA\u0007\u0001E\u0001B\u0003&\u0001'\u0001\btKJL\u0017\r\\5{CRLwN\u001c\u0011\t\u0011Y\u0002\u0001R1A\u0005\n]\nA\u0003\u001e:b]N\u0004xN\u001d;J]\u001a|'/\\1uS>tW#\u0001\u001d\u0011\u0007-I4(\u0003\u0002;\u0019\t1q\n\u001d;j_:\u0004\"\u0001P \u000f\u0005Ei\u0014B\u0001 \u0013\u00035\u0019VM]5bY&T\u0018\r^5p]&\u0011\u0001)\u0011\u0002\f\u0013:4wN]7bi&|gN\u0003\u0002?%!A1\t\u0001E\u0001B\u0003&\u0001(A\u000bue\u0006t7\u000f]8si&sgm\u001c:nCRLwN\u001c\u0011\t\u000b\u0015\u0003A\u0011\u0001$\u0002\u0011Q|')\u001b8bef$\"aR'\u0011\u0007-A%*\u0003\u0002J\u0019\t)\u0011I\u001d:bsB\u00111bS\u0005\u0003\u00192\u0011AAQ=uK\")a\n\u0012a\u0001\u0015\u0005\tq\u000eC\u0003Q\u0001\u0011\u0005\u0011+\u0001\u0006ge>l')\u001b8bef$2A\u0003*U\u0011\u0015\u0019v\n1\u0001H\u0003\u0015\u0011\u0017\u0010^3t\u0011\u0015)v\n1\u0001W\u0003!i\u0017M\\5gKN$\bcA\u0006:/B\u0012\u0001,\u0019\t\u00043r{fBA\u0006[\u0013\tYF\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003;z\u0013Qa\u00117bgNT!a\u0017\u0007\u0011\u0005\u0001\fG\u0002\u0001\u0003\nER\u000b\t\u0011!A\u0003\u0002\r\u00141a\u0018\u00132#\t!w\r\u0005\u0002\fK&\u0011a\r\u0004\u0002\b\u001d>$\b.\u001b8h!\tY\u0001.\u0003\u0002j\u0019\t\u0019\u0011I\\=\t\u000b-\u0004A\u0011\u00027\u0002\u001d!,\u0017\rZ3s)>\u0014\u0015N\\1ssR\u0019q)\\8\t\u000b9T\u0007\u0019\u0001\u0006\u0002\u0011Mt\u0017\r]:i_RDQ\u0001\u001d6A\u0002E\f!c\u001d8baNDw\u000e^*fe&\fG.\u001b>feB\u0011\u0011C]\u0005\u0003gJ\u0011!bU3sS\u0006d\u0017N_3s\u0011\u0015)\b\u0001\"\u0003w\u0003AAW-\u00193fe\u001a\u0013x.\u001c\"j]\u0006\u0014\u0018\u0010F\u0002x\u0003\u0003\u0001Ba\u0003={{&\u0011\u0011\u0010\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005-Y\u0018B\u0001?\r\u0005\rIe\u000e\u001e\t\u00033zL!a 0\u0003\rM#(/\u001b8h\u0011\u0015\u0019F\u000f1\u0001H\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000f\t\u0001c\u001d8baNDw\u000e\u001e+p\u0005&t\u0017M]=\u0015\u0007\u001d\u000bI\u0001\u0003\u0004o\u0003\u0007\u0001\rA\u0003\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0003I\u0019h.\u00199tQ>$hI]8n\u0005&t\u0017M]=\u0015\u0007)\t\t\u0002\u0003\u0004T\u0003\u0017\u0001\ra\u0012\u0005\b\u0003+\u0001A\u0011BA\f\u0003!9(/\u001b;f\u0013:$HCBA\r\u0003?\t\u0019\u0004E\u0002\f\u00037I1!!\b\r\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005\u00121\u0003a\u0001\u0003G\t1a\\;u!\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\t!![8\u000b\u0005\u00055\u0012\u0001\u00026bm\u0006LA!!\r\u0002(\taq*\u001e;qkR\u001cFO]3b[\"9\u0011QGA\n\u0001\u0004Q\u0018!A5\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<\u00059!/Z1e\u0013:$Hc\u0001>\u0002>!A\u0011qHA\u001c\u0001\u0004\t\t%\u0001\u0002j]B!\u0011QEA\"\u0013\u0011\t)%a\n\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c")
public class SnapshotSerializer
implements BaseSerializer {
    private final ExtendedActorSystem system;
    private final boolean includeManifest;
    private Serialization serialization;
    private Option<Serialization.Information> transportInformation;
    private final int identifier;
    private volatile byte bitmap$0;

    private Serialization serialization$lzycompute() {
        SnapshotSerializer snapshotSerializer = this;
        synchronized (snapshotSerializer) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.serialization;
        }
    }

    private Option transportInformation$lzycompute() {
        SnapshotSerializer snapshotSerializer = this;
        synchronized (snapshotSerializer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Address address = this.system().provider().getDefaultAddress();
                this.transportInformation = address.hasLocalScope() ? None$.MODULE$ : new Some((Object)new Serialization.Information(address, (ActorSystem)this.system()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.transportInformation;
        }
    }

    public final String SerializationIdentifiers() {
        return "akka.actor.serialization-identifiers";
    }

    public int identifier() {
        return this.identifier;
    }

    public void akka$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.class.identifierFromConfig((BaseSerializer)this);
    }

    public final Object fromBinary(byte[] bytes) {
        return Serializer.class.fromBinary((Serializer)this, (byte[])bytes);
    }

    public final Object fromBinary(byte[] bytes, Class<?> clazz) {
        return Serializer.class.fromBinary((Serializer)this, (byte[])bytes, clazz);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public boolean includeManifest() {
        return this.includeManifest;
    }

    private Serialization serialization() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.serialization$lzycompute() : this.serialization;
    }

    private Option<Serialization.Information> transportInformation() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.transportInformation$lzycompute() : this.transportInformation;
    }

    public byte[] toBinary(Object o) {
        Object object = o;
        if (object instanceof Snapshot) {
            Snapshot snapshot = (Snapshot)object;
            Object data = snapshot.data();
            byte[] byArray = this.snapshotToBinary(data);
            return byArray;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't serialize object of type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{o.getClass()})));
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return new Snapshot(this.snapshotFromBinary(bytes));
    }

    private byte[] headerToBinary(Object snapshot, Serializer snapshotSerializer) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, snapshotSerializer.identifier());
        Serializer serializer = snapshotSerializer;
        if (serializer instanceof SerializerWithStringManifest) {
            BoxedUnit boxedUnit;
            String manifest;
            SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
            String string = manifest = serializerWithStringManifest.manifest(snapshot);
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                out.write(manifest.getBytes(ByteString$.MODULE$.UTF_8()));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if (snapshotSerializer.includeManifest()) {
                out.write(snapshot.getClass().getName().getBytes(ByteString$.MODULE$.UTF_8()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        }
        return out.toByteArray();
    }

    private Tuple2<Object, String> headerFromBinary(byte[] bytes) {
        String string;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int serializerId = this.readInt(in);
        if ((serializerId & 0xEDAC) == 60844) {
            throw new NotSerializableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replaying snapshot from akka 2.3.x version is not supported any more"})).s((Seq)Nil$.MODULE$));
        }
        int remaining = in.available();
        if (remaining == 0) {
            string = "";
        } else {
            byte[] manifestBytes = new byte[remaining];
            in.read(manifestBytes);
            string = new String(manifestBytes, ByteString$.MODULE$.UTF_8());
        }
        String manifest = string;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)serializerId), (Object)manifest);
    }

    private byte[] snapshotToBinary(Object snapshot) {
        Option<Serialization.Information> option;
        block4: {
            byte[] byArray;
            block3: {
                block2: {
                    option = this.transportInformation();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Serialization.Information ti = (Serialization.Information)some.x();
                    byArray = (byte[])Serialization$.MODULE$.currentTransportInformation().withValue((Object)ti, (Function0)new Serializable(this, snapshot){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ SnapshotSerializer $outer;
                        private final Object snapshot$1;

                        public final byte[] apply() {
                            return this.$outer.akka$persistence$serialization$SnapshotSerializer$$serialize$1(this.snapshot$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.snapshot$1 = snapshot$1;
                        }
                    });
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                byArray = this.akka$persistence$serialization$SnapshotSerializer$$serialize$1(snapshot);
            }
            return byArray;
        }
        throw new MatchError(option);
    }

    private Object snapshotFromBinary(byte[] bytes) {
        int headerLength = this.readInt(new ByteArrayInputStream(bytes));
        byte[] headerBytes = (byte[])Predef$.MODULE$.byteArrayOps(bytes).slice(4, headerLength + 4);
        byte[] snapshotBytes = (byte[])Predef$.MODULE$.byteArrayOps(bytes).drop(headerLength + 4);
        Tuple2<Object, String> tuple2 = this.headerFromBinary(headerBytes);
        if (tuple2 != null) {
            Tuple2 tuple22;
            int serializerId = tuple2._1$mcI$sp();
            String manifest = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)serializerId), (Object)manifest);
            int serializerId2 = tuple23._1$mcI$sp();
            String manifest2 = (String)tuple23._2();
            return this.serialization().deserialize(snapshotBytes, serializerId2, manifest2).get();
        }
        throw new MatchError(tuple2);
    }

    private void writeInt(OutputStream out, int i) {
        out.write(i >>> 0);
        out.write(i >>> 8);
        out.write(i >>> 16);
        out.write(i >>> 24);
    }

    private int readInt(InputStream in) {
        int b1 = in.read();
        int b2 = in.read();
        int b3 = in.read();
        int b4 = in.read();
        if ((b1 | b2 | b3 | b3) == -1) {
            throw new EOFException();
        }
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    public final byte[] akka$persistence$serialization$SnapshotSerializer$$serialize$1(Object snapshot$1) {
        Serializer snapshotSerializer = this.serialization().findSerializerFor(snapshot$1);
        byte[] headerBytes = this.headerToBinary(snapshot$1, snapshotSerializer);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, headerBytes.length);
        out.write(headerBytes);
        out.write(snapshotSerializer.toBinary(snapshot$1));
        return out.toByteArray();
    }

    public SnapshotSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.class.$init$((Serializer)this);
        BaseSerializer.class.$init$((BaseSerializer)this);
        this.includeManifest = false;
    }
}

