/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade.common;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.QueryTemplate;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.query.JcrPredicate;
import com.xebialabs.xlrelease.repository.query.JcrQueryBuilder;
import com.xebialabs.xlrelease.upgrade.Components;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class XLRelease4011JCRActivityLogsMoved
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(XLRelease4011JCRActivityLogsMoved.class);
    private static final String VERSION = "4.0.11";
    private RepositoryService repositoryService;

    @Autowired
    public XLRelease4011JCRActivityLogsMoved(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean doUpgrade() throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Move activity logs to its own directory ***", (Object)"XL Release", (Object)VERSION);
        logger.info("*** This upgrade can take several minutes depending on the amount of activity logs you currently have in your repository ***");
        this.ensureLogsDirExists();
        int pageNumber = 0;
        List logs = this.repositoryService.list(this.getSearchParameters(pageNumber));
        while (logs.size() > 0) {
            logger.info("Moving {} logs for page {}", (Object)logs.size(), (Object)pageNumber);
            this.moveLogs(logs);
            logger.info("Fetching page " + ++pageNumber);
            logs = this.repositoryService.list(this.getSearchParameters(pageNumber));
        }
        logger.info("*** Done {} {} upgrade -- Move activity logs to its own directory ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    private void moveLogs(List<ConfigurationItemData> logs) {
        for (ConfigurationItemData log : logs) {
            String releaseDirectoryPath = ActivityLogs.ACTIVITY_LOGS_DIR + "/" + Ids.getName((String)Ids.releaseIdFrom((String)log.getId()));
            this.ensureReleaseLogsDirExists(releaseDirectoryPath);
            String newId = releaseDirectoryPath + "/" + Ids.getName((String)log.getId());
            if (log.getId().equals(newId)) continue;
            this.repositoryService.move(log.getId(), newId);
        }
    }

    private QueryTemplate getSearchParameters(int pageNumber) {
        QueryTemplate queryTemplate = JcrQueryBuilder.select((String[])new String[]{"*"}).from("ci").where(JcrPredicate.as((String)"ci", ActivityLogEntry.class)).build();
        queryTemplate.setDepth(0);
        queryTemplate.setResultsPerPage(1000L);
        queryTemplate.setPage((long)pageNumber);
        return queryTemplate;
    }

    private void ensureLogsDirExists() {
        if (!this.repositoryService.exists(ActivityLogs.ACTIVITY_LOGS_DIR)) {
            Directory directory = new Directory();
            directory.setId(ActivityLogs.ACTIVITY_LOGS_DIR);
            this.repositoryService.create((ConfigurationItem[])new Directory[]{directory});
        }
    }

    private void ensureReleaseLogsDirExists(String releaseDirectoryPath) {
        if (!this.repositoryService.exists(releaseDirectoryPath)) {
            Directory directory = new Directory();
            directory.setId(releaseDirectoryPath);
            this.repositoryService.create((ConfigurationItem[])new Directory[]{directory});
        }
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)Components.XL_RELEASE_COMPONENT, (String)VERSION);
    }
}

