/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.CiListJsonReader;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@Service
@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u0017\tY\u0012I]2iSZ,G-Q2uSZLG/\u001f'pON\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000fM,'O^5dK*\u0011QAB\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0002\u0005\u0002\u0013a,'-[1mC\n\u001c(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011a$\u0011:dQ&4X\rZ!di&4\u0018\u000e^=M_\u001e\u001c8+\u001a:jC2L'0\u001a:\t\u0011]\u0001!\u0011!Q\u0001\na\tA\"Y2uSZLG/\u001f'pON\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0003\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002\u001e5\ta\u0011i\u0019;jm&$\u0018\u0010T8hg\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\tbe\u000eD\u0017N^3e%\u0016dW-Y:fgB\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005B\u0001\u0003I\nL!!\n\u0012\u0003!\u0005\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\b\"B\u0014\u0001\t\u0003A\u0013A\u0002\u001fj]&$h\bF\u0002*U-\u0002\"a\u0005\u0001\t\u000b]1\u0003\u0019\u0001\r\t\u000b}1\u0003\u0019\u0001\u0011)\u0005\u0019j\u0003C\u0001\u0018:\u001b\u0005y#B\u0001\u00192\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003eM\nqAZ1di>\u0014\u0018P\u0003\u00025k\u0005)!-Z1og*\u0011agN\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001(A\u0002pe\u001eL!AO\u0018\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"\u0002\u001f\u0001\t\u0003i\u0014aD4fi\u0006\u001bG/\u001b<jifdunZ:\u0015\u0005yb\u0005cA E\r6\t\u0001I\u0003\u0002B\u0005\u0006!Q\u000f^5m\u0015\u0005\u0019\u0015\u0001\u00026bm\u0006L!!\u0012!\u0003\t1K7\u000f\u001e\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\u0012\ta\u0001Z8nC&t\u0017BA&I\u0005A\t5\r^5wSRLHj\\4F]R\u0014\u0018\u0010C\u0003Nw\u0001\u0007a*A\u0005sK2,\u0017m]3JIB\u0011qJ\u0015\b\u0003\u001bAK!!\u0015\b\u0002\rA\u0013X\rZ3g\u0013\t\u0019FK\u0001\u0004TiJLgn\u001a\u0006\u0003#:AQA\u0016\u0001\u0005\n]\u000bQcZ3u\u0003\u000e$\u0018N^5us2{wm](qi&|g\u000e\u0006\u0002Y7B\u0019Q\"\u0017 \n\u0005is!AB(qi&|g\u000eC\u0003N+\u0002\u0007a\nC\u0003^\u0001\u0011\u0005a,\u0001\u0004fq&\u001cHo\u001d\u000b\u0003?\n\u0004\"!\u00041\n\u0005\u0005t!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001br\u0003\rA\u0014\u0005\u0006I\u0002!\t%Z\u0001\u0018g\u0016\u0014\u0018.\u00197ju\u0016\f5\r^5wSRLHj\\4t\u001f\u001a$\"A\u00144\t\u000b5\u001b\u0007\u0019\u0001()\u0005\u0001A\u0007CA5m\u001b\u0005Q'BA66\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0003[*\u0014qaU3sm&\u001cW\r")
public class ArchivedActivityLogsService
implements ArchivedActivityLogsSerializer {
    private final ActivityLogs activityLogs;
    private final ArchivedReleases archivedReleases;

    public List<ActivityLogEntry> getActivityLogs(String releaseId) {
        return (List)this.getActivityLogsOption(releaseId).getOrElse((Function0)new Serializable(this, releaseId){
            public static final long serialVersionUID = 0L;
            private final String releaseId$1;

            public final Nothing$ apply() {
                throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find activity logs for archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.releaseId$1})), new Object[0]);
            }
            {
                this.releaseId$1 = releaseId$1;
            }
        });
    }

    private Option<List<ActivityLogEntry>> getActivityLogsOption(String releaseId) {
        return this.archivedReleases.getActivityLogs(releaseId).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<ActivityLogEntry> apply(String activityLogsJson) {
                WriteWithoutPasswordCiConverter ciConverter = new WriteWithoutPasswordCiConverter();
                CiListJsonReader ciReader = new CiListJsonReader(new JSONArray(activityLogsJson));
                return ciConverter.readCis((CiListReader)ciReader);
            }
        });
    }

    public boolean exists(String releaseId) {
        return this.archivedReleases.exists(releaseId);
    }

    public String serializeActivityLogsOf(String releaseId) {
        return CiSerializerHelper$.MODULE$.serialize(this.activityLogs.findAllLogsOf(releaseId), (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
    }

    @Autowired
    public ArchivedActivityLogsService(ActivityLogs activityLogs, ArchivedReleases archivedReleases) {
        this.activityLogs = activityLogs;
        this.archivedReleases = archivedReleases;
    }
}

