/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.domain.ActivityCategory;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.repository.ReleaseExistsQuery;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.repository.XlrRepositoryQuery;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsService;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.views.LogsFilters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityLogsService {
    private UserInfoResolver userInfoResolver;
    private ActivityLogs activityLogs;
    private XlrQueries xlrQueries;
    private ArchivedActivityLogsService archivedActivityLogsService;

    @Autowired
    public ActivityLogsService(UserInfoResolver userInfoResolver, ActivityLogs activityLogs, XlrQueries xlrQueries, ArchivedActivityLogsService archivedActivityLogsService) {
        this.userInfoResolver = userInfoResolver;
        this.activityLogs = activityLogs;
        this.xlrQueries = xlrQueries;
        this.archivedActivityLogsService = archivedActivityLogsService;
    }

    public List<ActivityLogEntry> getFilteredLogs(String releaseId, LogsFilters filters) {
        List<ActivityLogEntry> allActivityLogs;
        if (((Boolean)this.xlrQueries.query((XlrRepositoryQuery)new ReleaseExistsQuery(releaseId))).booleanValue()) {
            allActivityLogs = this.activityLogs.findAllLogsOf(releaseId);
        } else if (this.archivedActivityLogsService.exists(releaseId)) {
            allActivityLogs = this.archivedActivityLogsService.getActivityLogs(releaseId);
        } else {
            throw new NotFoundException(String.format("Release [%s] does not exist in the repository or archive", releaseId), new Object[0]);
        }
        return allActivityLogs.stream().filter(this.matches(filters.getFilter())).filter(this.between(filters.getFrom(), filters.getTo())).filter(this.withCategories(filters)).sorted(filters.isDateAsc() ? ActivityLogEntry.BY_EVENT_TIME : Collections.reverseOrder(ActivityLogEntry.BY_EVENT_TIME)).collect(Collectors.toList());
    }

    private Predicate<ActivityLogEntry> matches(final String filter) {
        return new Predicate<ActivityLogEntry>(){

            @Override
            public boolean test(ActivityLogEntry logEntry) {
                return filter == null || this.matches(logEntry.getMessage()) || this.matches(logEntry.getUsername()) || this.matches(ActivityLogsService.this.userInfoResolver.getFullNameOf(logEntry.getUsername()));
            }

            private boolean matches(String text) {
                return text != null && text.toLowerCase().contains(filter.toLowerCase());
            }
        };
    }

    private Predicate<ActivityLogEntry> between(Date from, Date to) {
        return logEntry -> {
            if (from == null && to == null) {
                return true;
            }
            if (from == null) {
                return logEntry.getEventTime().before(to) || logEntry.getEventTime().equals(to);
            }
            if (to == null) {
                return logEntry.getEventTime().after(from) || logEntry.getEventTime().equals(from);
            }
            return !(!logEntry.getEventTime().after(from) && !logEntry.getEventTime().equals(from) || !logEntry.getEventTime().before(to) && !logEntry.getEventTime().equals(to));
        };
    }

    private Predicate<ActivityLogEntry> withCategories(LogsFilters filters) {
        ArrayList allowedCategories = Lists.newArrayList();
        if (filters.withImportant()) {
            allowedCategories.add(ActivityCategory.IMPORTANT);
        }
        if (filters.withReleaseEdit()) {
            allowedCategories.add(ActivityCategory.RELEASE_EDIT);
        }
        if (filters.withTaskEdit()) {
            allowedCategories.add(ActivityCategory.TASK_EDIT);
        }
        if (filters.withComments()) {
            allowedCategories.add(ActivityCategory.COMMENTS);
        }
        if (filters.withLifecycle()) {
            allowedCategories.add(ActivityCategory.LIFECYCLE);
        }
        if (filters.withReassign()) {
            allowedCategories.add(ActivityCategory.REASSIGN);
        }
        if (filters.withSecurity()) {
            allowedCategories.add(ActivityCategory.SECURITY);
        }
        if (filters.withOther()) {
            allowedCategories.add(ActivityCategory.OTHER);
        }
        return logEntry -> {
            Set<ActivityCategory> activityCategories = ReleaseActivity.safeValueOf(logEntry.getActivityType()).getCategories();
            for (ActivityCategory activityCategory : activityCategories) {
                if (!allowedCategories.contains((Object)activityCategory)) continue;
                return true;
            }
            return false;
        };
    }
}

