/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.initialize.RootInitializer;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.user.User;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityLogs {
    public static final String ACTIVITY_LOGS_DIR = RootInitializer.ACTIVITY_LOGS_DIR();
    private RepositoryService repositoryService;
    private CiIdService ciIdService;

    @Autowired
    public ActivityLogs(RepositoryService repositoryService, CiIdService ciIdService) {
        this.repositoryService = repositoryService;
        this.ciIdService = ciIdService;
    }

    public void log(String releaseId, ActivityLogEntry activityLogEntry) {
        this.log(releaseId, activityLogEntry, User.AUTHENTICATED_USER);
    }

    public void log(String releaseId, ActivityLogEntry activityLogEntry, User user) {
        this.log(releaseId, (List<ActivityLogEntry>)Lists.newArrayList((Object[])new ActivityLogEntry[]{activityLogEntry}), user);
    }

    public void log(String releaseId, ActivityLogEntry activityLogEntry, String username) {
        this.log(releaseId, (List<ActivityLogEntry>)Lists.newArrayList((Object[])new ActivityLogEntry[]{activityLogEntry}), username);
    }

    public void log(String releaseId, List<ActivityLogEntry> activityLogEntries) {
        this.log(releaseId, activityLogEntries, User.AUTHENTICATED_USER);
    }

    public void log(String releaseId, List<ActivityLogEntry> activityLogEntries, User user) {
        this.log(releaseId, activityLogEntries, user.getName());
    }

    public void log(String releaseId, List<ActivityLogEntry> activityLogEntries, String username) {
        String releasesActivityLogsDirectoryPath = this.getActivityLogsDirectoryPath(releaseId);
        List<String> logsIds = this.getUniqueIds(releasesActivityLogsDirectoryPath, activityLogEntries.size());
        for (int i = 0; i < activityLogEntries.size(); ++i) {
            ActivityLogEntry activityLogEntry = activityLogEntries.get(i);
            activityLogEntry.setId(logsIds.get(i));
            activityLogEntry.setUsername(username);
        }
        this.ensureDirectoriesExist(releasesActivityLogsDirectoryPath);
        this.repositoryService.create((ConfigurationItem[])activityLogEntries.toArray(new ActivityLogEntry[activityLogEntries.size()]));
    }

    public List<ActivityLogEntry> findAllLogsOf(String releaseId) {
        SearchParameters parameters = new SearchParameters();
        parameters.setParent(this.getActivityLogsDirectoryPath(releaseId));
        return this.repositoryService.listEntities(parameters);
    }

    public void delete(List<ActivityLogEntry> logEntries) {
        List<String> ids = logEntries.stream().map(BaseConfigurationItem::getId).collect(Collectors.toList());
        this.repositoryService.delete(ids.toArray(new String[ids.size()]));
    }

    public void deleteLogsOf(String releaseId) {
        String releaseDirectoryPath = this.getActivityLogsDirectoryPath(releaseId);
        this.repositoryService.delete(new String[]{releaseDirectoryPath});
    }

    public void ensureDirectoriesExist(String releaseDirectoryPath) {
        List<Directory> directoriesToCreate = this.getActivityLogDirectoriesToCreate(releaseDirectoryPath);
        if (!directoriesToCreate.isEmpty()) {
            this.repositoryService.createCollection(directoriesToCreate);
        }
    }

    public String getActivityLogsDirectoryPath(String releaseId) {
        return ACTIVITY_LOGS_DIR + "/" + Ids.releasePathInRootFolder((String)releaseId);
    }

    private List<Directory> getActivityLogDirectoriesToCreate(String releaseDirectoryPath) {
        ArrayList<Directory> directoriesToCreate = new ArrayList<Directory>();
        String directoryId = releaseDirectoryPath;
        while (!Ids.isRoot((String)directoryId) && !this.repositoryService.exists(directoryId)) {
            directoriesToCreate.add((Directory)Type.valueOf(Directory.class).getDescriptor().newInstance(directoryId));
            directoryId = Ids.getParentId((String)directoryId);
        }
        return directoriesToCreate;
    }

    public List<String> getUniqueIds(String parentId, int length) {
        ArrayList ids = Lists.newArrayList();
        Type activityLogType = Type.valueOf(ActivityLogEntry.class);
        while (length-- > 0) {
            String candidateId;
            while (ids.contains(candidateId = this.ciIdService.getUniqueId(activityLogType, parentId, "ActivityLog"))) {
            }
            ids.add(candidateId);
        }
        return ids;
    }
}

