/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.events.TriggerCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TriggerCreatedNewReleaseEvent;
import com.xebialabs.xlrelease.domain.events.TriggerDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TriggerEvent;
import com.xebialabs.xlrelease.domain.events.TriggerUpdatedEvent;
import com.xebialabs.xlrelease.events.EventListening;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.repository.Ids;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u0017\tQBK]5hO\u0016\u0014Hj\\4hS:<WI^3oi\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\tC\u000e$\u0018N^5us*\u0011QAB\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0002\u0005\u0002\u0013a,'-[1mC\n\u001c(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001a!\u0003\u0007\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011AB3wK:$8/\u0003\u0002\u0018)\tqQI^3oi2K7\u000f^3oS:<\u0007CA\r\u001f\u001b\u0005Q\"BA\u000e\u001d\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005i\u0012\u0001C4sSjTH.\u001a3\n\u0005}Q\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011)\u0019!C\u0001E\u0005AQM^3oi\n+8/F\u0001$!\t\u0019B%\u0003\u0002&)\t\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\t\u0011\u001d\u0002!\u0011!Q\u0001\n\r\n\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\t\u0011%\u0002!\u0011!Q\u0001\n)\nA\"Y2uSZLG/\u001f'pON\u0004\"a\u000b\u0018\u000e\u00031R!!\f\u0003\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00020Y\ta\u0011i\u0019;jm&$\u0018\u0010T8hg\")\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"2aM\u001b7!\t!\u0004!D\u0001\u0003\u0011\u0015\t\u0003\u00071\u0001$\u0011\u0015I\u0003\u00071\u0001+Q\t\u0001\u0004\b\u0005\u0002:\t6\t!H\u0003\u0002<y\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005ur\u0014a\u00024bGR|'/\u001f\u0006\u0003\u007f\u0001\u000bQAY3b]NT!!\u0011\"\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aQ\u0001\u0004_J<\u0017BA#;\u0005%\tU\u000f^8xSJ,G\rC\u0003H\u0001\u0011\u0005\u0001*\u0001\bp]R\u0013\u0018nZ4fe\u00163XM\u001c;\u0015\u0005%c\u0005CA\u0007K\u0013\tYeB\u0001\u0003V]&$\b\"B'G\u0001\u0004q\u0015\u0001\u0004;sS\u001e<WM]#wK:$\bCA(T\u001b\u0005\u0001&BA\u000bR\u0015\t\u0011F!\u0001\u0004e_6\f\u0017N\\\u0005\u0003)B\u0013A\u0002\u0016:jO\u001e,'/\u0012<f]RD#A\u0012,\u0011\u0005]sV\"\u0001-\u000b\u0005eS\u0016!\u0002;3EV\u001c(BA.]\u0003!Q\u0017M^1ek\u0012,'\"A/\u0002\u00059d\u0017BA0Y\u0005%\u0019VOY:de&\u0014W\r\u000b\u0002\u0001CB\u0011!-Z\u0007\u0002G*\u0011A\rQ\u0001\u000bgR,'/Z8usB,\u0017B\u00014d\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class TriggerLoggingEventHandler
implements EventListening,
Logging {
    private final XLReleaseEventBus eventBus;
    private final ActivityLogs activityLogs;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerLoggingEventHandler triggerLoggingEventHandler = this;
        synchronized (triggerLoggingEventHandler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, (Marker)mkr, msg, t);
    }

    @PostConstruct
    public void postConstruct() {
        EventListening.class.postConstruct((EventListening)this);
    }

    @PreDestroy
    public void preDestroy() {
        EventListening.class.preDestroy((EventListening)this);
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Subscribe
    public void onTriggerEvent(TriggerEvent triggerEvent) {
        TriggerEvent triggerEvent2 = triggerEvent;
        if (triggerEvent2 instanceof TriggerCreatedEvent) {
            TriggerCreatedEvent triggerCreatedEvent = (TriggerCreatedEvent)triggerEvent2;
            ReleaseTrigger trigger = triggerCreatedEvent.trigger();
            this.activityLogs.log(Ids.getParentId((String)trigger.getId()), ReleaseActivity.TRIGGER_ADDED.create(trigger.getTitle()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (triggerEvent2 instanceof TriggerUpdatedEvent) {
            TriggerUpdatedEvent triggerUpdatedEvent = (TriggerUpdatedEvent)triggerEvent2;
            ReleaseTrigger updated = triggerUpdatedEvent.updated();
            this.activityLogs.log(Ids.getParentId((String)updated.getId()), ReleaseActivity.TRIGGER_EDITED.create(updated.getTitle()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (triggerEvent2 instanceof TriggerDeletedEvent) {
            TriggerDeletedEvent triggerDeletedEvent = (TriggerDeletedEvent)triggerEvent2;
            ReleaseTrigger trigger = triggerDeletedEvent.trigger();
            this.activityLogs.log(Ids.getParentId((String)trigger.getId()), ReleaseActivity.TRIGGER_DELETED.create(trigger.getTitle()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (triggerEvent2 instanceof TriggerCreatedNewReleaseEvent) {
            TriggerCreatedNewReleaseEvent triggerCreatedNewReleaseEvent = (TriggerCreatedNewReleaseEvent)triggerEvent2;
            ReleaseTrigger releaseTrigger = triggerCreatedNewReleaseEvent.releaseTrigger();
            Release template = triggerCreatedNewReleaseEvent.template();
            Release newRelease = triggerCreatedNewReleaseEvent.newRelease();
            this.activityLogs.log(newRelease.getId(), ReleaseActivity.TRIGGER_CREATE_NEW_RELEASE.create(releaseTrigger.getTitle(), newRelease.getTitle(), template.getTitle()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().debug((Function0)new Serializable(this, triggerEvent2){
                public static final long serialVersionUID = 0L;
                private final TriggerEvent x1$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Event ", " not traced into activity logs"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1}));
                }
                {
                    this.x1$1 = x1$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Autowired
    public TriggerLoggingEventHandler(XLReleaseEventBus eventBus, ActivityLogs activityLogs) {
        this.eventBus = eventBus;
        this.activityLogs = activityLogs;
        EventListening.class.$init$((EventListening)this);
        Logging.class.$init$((Logging)this);
    }
}

