/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.xebialabs.xlrelease.activity.DurationFormatter;
import com.xebialabs.xlrelease.activity.ReleaseActivityDateFormatter;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import java.util.ArrayList;
import java.util.List;

public class PhaseFieldsComparator {
    private Phase original;
    private Phase updated;

    public PhaseFieldsComparator(Phase original, Phase updated) {
        this.original = original;
        this.updated = updated;
    }

    public List<ActivityLogEntry> getLogs() {
        ArrayList logEntries = Lists.newArrayList();
        if (!Objects.equal((Object)this.original.getTitle(), (Object)this.updated.getTitle())) {
            logEntries.add(ReleaseActivity.PHASE_RENAMED.create(this.original.getTitle(), this.updated.getTitle()));
        }
        if (!Objects.equal((Object)this.original.getDescription(), (Object)this.updated.getDescription())) {
            logEntries.add(ReleaseActivity.PHASE_DESCRIPTION_UPDATED.create(this.updated.getTitle(), this.original.getDescription(), this.updated.getDescription()));
        }
        if (!Objects.equal((Object)this.original.getDueDate(), (Object)this.updated.getDueDate())) {
            logEntries.add(ReleaseActivity.PHASE_DUE_DATE_UPDATED.create(this.updated.getTitle(), ReleaseActivityDateFormatter.formatDate(this.original.getDueDate()), ReleaseActivityDateFormatter.formatDate(this.updated.getDueDate())));
        }
        if (!Objects.equal((Object)this.original.getScheduledStartDate(), (Object)this.updated.getScheduledStartDate())) {
            logEntries.add(ReleaseActivity.PHASE_SCHEDULED_START_DATE_UPDATED.create(this.updated.getTitle(), ReleaseActivityDateFormatter.formatDate(this.original.getScheduledStartDate()), ReleaseActivityDateFormatter.formatDate(this.updated.getScheduledStartDate())));
        }
        if (!Objects.equal((Object)this.original.getColor(), (Object)this.updated.getColor())) {
            logEntries.add(ReleaseActivity.PHASE_COLOR_CHANGED.create(this.updated.getTitle(), this.original.getColor(), this.updated.getColor()));
        }
        Integer newDuration = null;
        if (this.updated.getPlannedDuration() != null) {
            newDuration = Ints.checkedCast((long)((long)this.updated.getPlannedDuration().intValue() / 1000L));
        }
        if (!Objects.equal((Object)this.original.getPlannedDuration(), newDuration)) {
            logEntries.add(ReleaseActivity.PHASE_DURATION_UPDATED.create(this.updated.getTitle(), DurationFormatter.formatDuration(this.original.getPlannedDuration()), DurationFormatter.formatDuration(newDuration)));
        }
        return logEntries;
    }
}

