/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.CommentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.CommentEvent;
import com.xebialabs.xlrelease.domain.events.CommentUpdatedEvent;
import com.xebialabs.xlrelease.events.EventListening;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.repository.Ids;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u0017\t\u00113i\\7nK:$\u0018i\u0019;jm&$\u0018\u0010T8hO&tw-\u0012<f]RD\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u0011\u0005\u001cG/\u001b<jifT!!\u0002\u0004\u0002\u0013ad'/\u001a7fCN,'BA\u0004\t\u0003%AXMY5bY\u0006\u00147OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001AB\u0005\r\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0004fm\u0016tGo]\u0005\u0003/Q\u0011a\"\u0012<f]Rd\u0015n\u001d;f]&tw\r\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005)1\u000f\u001c45U*\tQ$\u0001\u0005he&T(\u0010\\3e\u0013\ty\"DA\u0004M_\u001e<\u0017N\\4\t\u0011\u0005\u0002!Q1A\u0005\u0002\t\n\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002GA\u00111\u0003J\u0005\u0003KQ\u0011\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0011!9\u0003A!A!\u0002\u0013\u0019\u0013!C3wK:$()^:!\u0011!I\u0003A!A!\u0002\u0013Q\u0013\u0001D1di&4\u0018\u000e^=M_\u001e\u001c\bCA\u0016/\u001b\u0005a#BA\u0017\u0005\u0003)\u0011X\r]8tSR|'/_\u0005\u0003_1\u0012A\"Q2uSZLG/\u001f'pONDQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtDcA\u001a6mA\u0011A\u0007A\u0007\u0002\u0005!)\u0011\u0005\ra\u0001G!)\u0011\u0006\ra\u0001U!\u0012\u0001\u0007\u000f\t\u0003s\u0011k\u0011A\u000f\u0006\u0003wq\n!\"\u00198o_R\fG/[8o\u0015\tid(A\u0004gC\u000e$xN]=\u000b\u0005}\u0002\u0015!\u00022fC:\u001c(BA!C\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A\"\u0002\u0007=\u0014x-\u0003\u0002Fu\tI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006\u000f\u0002!\t\u0001S\u0001\u000f_:\u001cu.\\7f]R,e/\u001a8u)\tIE\n\u0005\u0002\u000e\u0015&\u00111J\u0004\u0002\u0005+:LG\u000fC\u0003N\r\u0002\u0007a*\u0001\u0007d_6lWM\u001c;Fm\u0016tG\u000f\u0005\u0002P'6\t\u0001K\u0003\u0002\u0016#*\u0011!\u000bB\u0001\u0007I>l\u0017-\u001b8\n\u0005Q\u0003&\u0001D\"p[6,g\u000e^#wK:$\bF\u0001$W!\t9f,D\u0001Y\u0015\tI&,A\u0003ue\t,8O\u0003\u0002\\9\u0006A!.\u0019<bIV$WMC\u0001^\u0003\tqG.\u0003\u0002`1\nI1+\u001e2tGJL'-\u001a\u0015\u0003\u0001\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a!\u0002\u0015M$XM]3pif\u0004X-\u0003\u0002gG\nI1i\\7q_:,g\u000e\u001e")
public class CommentActivityLoggingEventHandler
implements EventListening,
Logging {
    private final XLReleaseEventBus eventBus;
    private final ActivityLogs activityLogs;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CommentActivityLoggingEventHandler commentActivityLoggingEventHandler = this;
        synchronized (commentActivityLoggingEventHandler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, (Marker)mkr, msg, t);
    }

    @PostConstruct
    public void postConstruct() {
        EventListening.class.postConstruct((EventListening)this);
    }

    @PreDestroy
    public void preDestroy() {
        EventListening.class.preDestroy((EventListening)this);
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Subscribe
    public void onCommentEvent(CommentEvent commentEvent) {
        CommentEvent commentEvent2 = commentEvent;
        if (commentEvent2 instanceof CommentCreatedEvent) {
            CommentCreatedEvent commentCreatedEvent = (CommentCreatedEvent)commentEvent2;
            Task task = commentCreatedEvent.task();
            Comment comment = commentCreatedEvent.comment();
            String author = commentCreatedEvent.author();
            this.activityLogs.log(Ids.releaseIdFrom((String)task.getId()), ReleaseActivity.COMMENT_ADDED.create(comment.getText(), task.getTitle()), author);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (commentEvent2 instanceof CommentUpdatedEvent) {
            CommentUpdatedEvent commentUpdatedEvent = (CommentUpdatedEvent)commentEvent2;
            Task task = commentUpdatedEvent.task();
            Comment original = commentUpdatedEvent.original();
            Comment updated = commentUpdatedEvent.updated();
            this.activityLogs.log(Ids.releaseIdFrom((String)task.getId()), ReleaseActivity.COMMENT_UPDATED.create(original.getText(), updated.getText(), task.getTitle()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().debug((Function0)new Serializable(this, commentEvent2){
                public static final long serialVersionUID = 0L;
                private final CommentEvent x1$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Event ", " not traced into activity logs"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1}));
                }
                {
                    this.x1$1 = x1$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Autowired
    public CommentActivityLoggingEventHandler(XLReleaseEventBus eventBus, ActivityLogs activityLogs) {
        this.eventBus = eventBus;
        this.activityLogs = activityLogs;
        EventListening.class.$init$((EventListening)this);
        Logging.class.$init$((Logging)this);
    }
}

