/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.change.Change;
import liquibase.sdk.exception.UnexpectedLiquibaseSdkException;
import liquibase.servicelocator.ServiceLocator;
import liquibase.sqlgenerator.SqlGenerator;

public class Context {
    public static final String LIQUIBASE_SDK_PROPERTIES_FILENAME = "liquibase.sdk.properties";
    private static Context instance;
    private static final List<Class<?>> extensionInterfaces;
    private boolean initialized = false;
    private Set<Class> allClasses = new HashSet<Class>();
    private Map<Class, Set<Class>> seenExtensionClasses = new HashMap<Class, Set<Class>>();
    private Set<File> propertyFiles;

    private Context() {
    }

    public static void reset() {
        instance = null;
    }

    public static Context getInstance() {
        if (instance == null) {
            instance = new Context();
            try {
                instance.init();
            }
            catch (Exception e) {
                System.out.println("Error initializing context: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return instance;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Set<Class> getAllClasses() {
        return this.allClasses;
    }

    public Map<Class, Set<Class>> getSeenExtensionClasses() {
        return this.seenExtensionClasses;
    }

    protected void init() throws Exception {
        this.propertyFiles = new HashSet<File>();
        Enumeration<URL> resourceUrls = Context.class.getClassLoader().getResources(LIQUIBASE_SDK_PROPERTIES_FILENAME);
        while (resourceUrls.hasMoreElements()) {
            File propertiesFile = new File(resourceUrls.nextElement().toURI());
            this.propertyFiles.add(propertiesFile);
        }
        try {
            for (String packageName : ServiceLocator.getInstance().getPackages()) {
                Enumeration<URL> dirs = this.getClass().getClassLoader().getResources(packageName.replace('.', '/'));
                while (dirs.hasMoreElements()) {
                    File dir = new File(dirs.nextElement().toURI());
                    this.findClasses(packageName, dir);
                }
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseSdkException(e);
        }
        for (Class clazz : this.allClasses) {
            Class type;
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()) || (type = this.getExtensionType(clazz)) == null) continue;
            if (!this.seenExtensionClasses.containsKey(type)) {
                this.seenExtensionClasses.put(type, new HashSet());
            }
            this.seenExtensionClasses.get(type).add(clazz);
        }
        this.initialized = true;
    }

    private Class getExtensionType(Class clazz) {
        for (Class<?> type : clazz.getInterfaces()) {
            if (!extensionInterfaces.contains(type)) continue;
            return type;
        }
        Class superclass = clazz.getSuperclass();
        if (superclass == null) {
            return null;
        }
        return this.getExtensionType(superclass);
    }

    private void findClasses(String packageName, File dir) throws ClassNotFoundException {
        File[] subDirs;
        String[] classFiles;
        packageName = packageName.replaceFirst("^\\.", "");
        for (String classFile : classFiles = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        })) {
            Class<?> foundClass = null;
            String className = packageName + "." + classFile.replaceFirst("\\.class$", "");
            try {
                foundClass = Class.forName(className);
                this.allClasses.add(foundClass);
            }
            catch (Throwable e) {
                System.out.println("Error loading class " + className + ": " + e.getCause().getClass().getName() + ": " + e.getCause().getMessage());
            }
        }
        for (File subDir : subDirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            this.findClasses(packageName + "." + subDir.getName(), subDir);
        }
    }

    static {
        extensionInterfaces = Arrays.asList(Change.class, SqlGenerator.class);
    }
}

