/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.dsl.DependencyTargetSpec;
import com.xebialabs.xlrelease.dsl.IdDependencyTargetSpec;
import com.xebialabs.xlrelease.dsl.TargetSpec;
import com.xebialabs.xlrelease.dsl.service.CiProcessor;
import com.xebialabs.xlrelease.dsl.service.DslError;
import com.xebialabs.xlrelease.dsl.service.DslProcessingContext;
import com.xebialabs.xlrelease.dsl.service.PathUtils;
import com.xebialabs.xlrelease.folder.repository.Folders;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemByIdQuery;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.repository.XlrRepositoryCommand;
import com.xebialabs.xlrelease.repository.XlrRepositoryQuery;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DependencyCiProcessor
implements CiProcessor<Dependency> {
    private Releases releaseRepository;
    private Folders folderRepository;
    private PermissionChecker permissionChecker;
    private XlrQueries xlrQueries;
    private XlrRepository xlrRepository;

    @Autowired
    public DependencyCiProcessor(Releases releaseRepository, Folders folderRepository, PermissionChecker permissionChecker, XlrRepository xlrRepository, XlrQueries xlrQueries) {
        this.releaseRepository = releaseRepository;
        this.folderRepository = folderRepository;
        this.permissionChecker = permissionChecker;
        this.xlrQueries = xlrQueries;
        this.xlrRepository = xlrRepository;
    }

    @Override
    public void process(DslProcessingContext processingContext, Dependency ci) {
        Map $metadata = ci.get$metadata();
        if (null != $metadata) {
            TargetSpec targetSpec = (TargetSpec)$metadata.get("targetSpec");
            if (null != ci.getTargetId() && null != targetSpec) {
                throw new DslError("Set either a variable or target for a dependency in gate task.");
            }
            if (null != targetSpec) {
                if (targetSpec instanceof DependencyTargetSpec) {
                    String defaultFolderId = Ids.findFolderId((String)processingContext.getContainer().getId());
                    ci.setTarget(this.resolveTargetFromPath(defaultFolderId, (DependencyTargetSpec)targetSpec));
                } else if (targetSpec instanceof IdDependencyTargetSpec) {
                    ci.setTarget(this.resolveTargetFromId((IdDependencyTargetSpec)targetSpec));
                }
            }
        }
    }

    @Override
    public Type getType() {
        return Type.valueOf(Dependency.class);
    }

    private PlanItem resolveTargetFromId(IdDependencyTargetSpec targetSpec) {
        String targetPlanItemId = targetSpec.getTargetId();
        try {
            return (PlanItem)this.xlrQueries.query((XlrRepositoryQuery)new PlanItemByIdQuery(targetPlanItemId, Integer.valueOf(Integer.MAX_VALUE)));
        }
        catch (NotFoundException ignore) {
            throw new DslError("No target found with ID: '%s'", targetPlanItemId);
        }
    }

    private PlanItem resolveTargetFromPath(String defaultFolderId, DependencyTargetSpec targetSpec) {
        String releaseTitleOrId = targetSpec.getRelease();
        if (StringUtils.hasText((String)releaseTitleOrId)) {
            Release release = this.resolveRelease(defaultFolderId, releaseTitleOrId);
            String phaseTitleOrId = targetSpec.getPhase();
            if (StringUtils.hasText((String)phaseTitleOrId)) {
                Phase phase = this.getPhaseFromRelease(release, phaseTitleOrId);
                String taskTitleOrId = targetSpec.getTask();
                if (StringUtils.hasText((String)taskTitleOrId)) {
                    return this.getTaskFromPhase(phase, taskTitleOrId);
                }
                return phase;
            }
            return release;
        }
        throw new DslError("No target found with path '%s'.", this.getPathFromTarget(targetSpec));
    }

    private Release resolveRelease(String defaultFolderId, String releaseTitleOrId) {
        Release release;
        try {
            release = (Release)this.xlrRepository.handle((XlrRepositoryCommand)new ReleaseGetCommand(releaseTitleOrId, Integer.valueOf(Integer.MAX_VALUE), false, null));
        }
        catch (NotFoundException ignore) {
            release = this.getReleaseFromPath(defaultFolderId, releaseTitleOrId);
        }
        return release;
    }

    private Task getTaskFromPhase(Phase phase, String taskTitleOrId) {
        return phase.getTasks().stream().filter(task -> taskTitleOrId.equals(task.getTitle()) || taskTitleOrId.equals(task.getId())).findAny().orElseThrow(() -> new DslError("No task found with title/id '%s'.", taskTitleOrId));
    }

    private Phase getPhaseFromRelease(Release release, String phaseTitleOrId) {
        return release.getPhases().stream().filter(phase -> phaseTitleOrId.equals(phase.getTitle()) || phaseTitleOrId.equals(phase.getId())).findAny().orElseThrow(() -> new DslError("No phase found with title/id '%s'.", phaseTitleOrId));
    }

    private Release getReleaseFromPath(String defaultFolderId, String releasePath) {
        String releaseTitle;
        Optional<String> folderPath = PathUtils.folderPath(releasePath);
        String folderId = folderPath.map(path -> this.folderRepository.findIdByPath(path)).orElse(defaultFolderId);
        List releases = this.releaseRepository.findReleasesByTitle(folderId, releaseTitle = this.releaseTitle(releasePath), 0, 2, Integer.MAX_VALUE);
        if (releases.isEmpty()) {
            throw new DslError("No release found with title '%s'.", releaseTitle);
        }
        if (releases.size() > 1) {
            throw new DslError("More than one release found with title '%s'.", releaseTitle);
        }
        releases = this.permissionChecker.filter(releases, XLReleasePermissions.VIEW_RELEASE);
        return (Release)releases.get(0);
    }

    private String releaseTitle(String fullReleasePath) {
        return PathUtils.releasePath(fullReleasePath).orElseThrow(() -> new DslError("Unable to find template title in '%s'", fullReleasePath));
    }

    private String getPathFromTarget(DependencyTargetSpec targetSpec) {
        String path = "";
        if (null != targetSpec.getRelease()) {
            path = path + targetSpec.getRelease();
        }
        if (null != targetSpec.getPhase()) {
            path = path + "/" + targetSpec.getPhase();
        }
        if (null != targetSpec.getTask()) {
            path = path + "/" + targetSpec.getTask();
        }
        return path;
    }
}

