/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.dsl.service.CiProcessor;
import com.xebialabs.xlrelease.dsl.service.DslError;
import com.xebialabs.xlrelease.dsl.service.DslProcessingContext;
import com.xebialabs.xlrelease.dsl.service.PathUtils;
import com.xebialabs.xlrelease.folder.repository.Folders;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExistsQuery;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.repository.XlrRepositoryQuery;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateReleaseTaskCiProcessor
implements CiProcessor<CreateReleaseTask> {
    private Releases releaseRepository;
    private Folders folderRepository;
    private PermissionChecker permissionChecker;
    private XlrQueries xlrQueries;

    @Autowired
    public CreateReleaseTaskCiProcessor(Releases releaseRepository, Folders folderRepository, PermissionChecker permissionChecker, XlrQueries xlrQueries) {
        this.releaseRepository = releaseRepository;
        this.folderRepository = folderRepository;
        this.permissionChecker = permissionChecker;
        this.xlrQueries = xlrQueries;
    }

    @Override
    public Type getType() {
        return Type.valueOf(CreateReleaseTask.class);
    }

    @Override
    public void process(DslProcessingContext processingContext, CreateReleaseTask ci) {
        String templateIdOrPath = ci.getTemplateId();
        if (!((Boolean)this.xlrQueries.query((XlrRepositoryQuery)new ReleaseExistsQuery(templateIdOrPath))).booleanValue()) {
            String defaultFolderId = Ids.findFolderId((String)processingContext.getContainer().getId());
            ci.setTemplateId(this.resolveTemplateIdFromPath(defaultFolderId, templateIdOrPath));
        }
    }

    private String resolveTemplateIdFromPath(String defaultFolderId, String fullTemplatePath) {
        String templateTitle;
        Optional<String> folderPath = PathUtils.folderPath(fullTemplatePath);
        String folderId = folderPath.map(path -> this.folderRepository.findIdByPath(path)).orElse(defaultFolderId);
        List templates = this.releaseRepository.findTemplatesByTitle(folderId, templateTitle = this.templateTitle(fullTemplatePath), 0, 2, Integer.MAX_VALUE);
        if (templates.isEmpty()) {
            throw new DslError("No template found with title '%s'.", templateTitle);
        }
        if (templates.size() > 1) {
            throw new DslError("More than one template found with title '%s'.", templateTitle);
        }
        templates = this.permissionChecker.filter(templates, XLReleasePermissions.VIEW_TEMPLATE);
        return ((Release)templates.get(0)).getId();
    }

    private String templateTitle(String fullTemplatePath) {
        return PathUtils.releasePath(fullTemplatePath).orElseThrow(() -> new DslError("Unable to find template title in '%s'", fullTemplatePath));
    }
}

