/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.google.common.base.Preconditions;
import com.wordnik.swagger.annotations.ApiOperation;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.dsl.service.DslExporter;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.security.PermissionChecker;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/dsl")
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class DslApi
implements ApiService {
    private static final String XFILE_EXTENSION = ".groovy";
    private PermissionChecker permissions;
    private Releases releases;
    private DslExporter dslExporter;

    @Autowired
    public DslApi(PermissionChecker permissions, Releases releases, DslExporter dslExporter) {
        this.permissions = permissions;
        this.releases = releases;
        this.dslExporter = dslExporter;
    }

    public String serviceName() {
        return "dslApi";
    }

    @GET
    @Path(value="/export/{templateId:.*Release[^/]*}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Exports a template in xfile format")
    public Response exportTemplateToXFile(@PathParam(value="templateId") String templateId) {
        this.permissions.checkView(templateId);
        Preconditions.checkArgument((boolean)this.releases.isTemplate(templateId), (Object)"Only templates can be exported.");
        Release template = this.releases.findById(templateId);
        StreamingOutput output = outputStream -> this.dslExporter.exportTemplate(template, outputStream);
        String fileName = template.getTitle() + XFILE_EXTENSION;
        return Response.ok((Object)output, (String)"text/plain").header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", fileName)).build();
    }

    @PublicApiMember
    public String exportTemplate(Release template) {
        Preconditions.checkArgument((boolean)this.releases.isTemplate(template.getId()), (Object)"Only templates can be exported.");
        this.permissions.checkView(template.getId());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.dslExporter.exportTemplate(template, baos);
        try {
            return baos.toString(StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

