/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.variable;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.variables.ValueProviderConfiguration;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.VariablesCreateCommand;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import java.util.List;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class VariablePersistenceHelper$ {
    public static final VariablePersistenceHelper$ MODULE$;

    static {
        new VariablePersistenceHelper$();
    }

    public List<Variable> scanAndBuildNewVariables(Release release, VisitableItem updatedItem, CiIdService ciIdService) {
        Buffer newVariables = JavaConversions$.MODULE$.asScalaBuffer(release.scanAndAddNewVariables(updatedItem));
        if (newVariables.nonEmpty()) {
            this.fixUpVariableIds(release.getId(), JavaConversions$.MODULE$.bufferAsJavaList(newVariables), ciIdService);
        }
        return JavaConversions$.MODULE$.bufferAsJavaList(newVariables);
    }

    public boolean scanAndCreateNewVariables(Release release, RepositoryService repositoryService, CiIdService ciIdService) {
        Buffer newVariables = JavaConversions$.MODULE$.asScalaBuffer(release.scanAndAddNewVariables());
        if (newVariables.nonEmpty()) {
            this.fixUpVariableIds(release.getId(), JavaConversions$.MODULE$.bufferAsJavaList(newVariables), ciIdService);
            repositoryService.create((ConfigurationItem[])newVariables.toArray(ClassTag$.MODULE$.apply(Variable.class)));
        }
        return newVariables.nonEmpty();
    }

    public boolean scanAndCreateNewVariables(Release release, XlrRepository xlrRepository, CiIdService ciIdService) {
        BoxedUnit boxedUnit;
        Buffer newVariables = JavaConversions$.MODULE$.asScalaBuffer(release.scanAndAddNewVariables());
        if (newVariables.nonEmpty()) {
            this.fixUpVariableIds(release.getId(), JavaConversions$.MODULE$.bufferAsJavaList(newVariables), ciIdService);
            boxedUnit = xlrRepository.handle(new VariablesCreateCommand((Seq<Variable>)newVariables));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return newVariables.nonEmpty();
    }

    public void fixUpVariableIds(String parentId, List<Variable> variables, CiIdService ciIdService) {
        SortedSet ids = (SortedSet)SortedSet$.MODULE$.apply((Seq)Nil$.MODULE$, (Ordering)Ordering.String$.MODULE$);
        JavaConversions$.MODULE$.asScalaBuffer(variables).foreach((Function1)new Serializable(parentId, ciIdService, ids){
            public static final long serialVersionUID = 0L;
            private final String parentId$1;
            private final CiIdService ciIdService$1;
            private final SortedSet ids$1;

            public final void apply(Variable v) {
                if (v.getId() == null || v.getId().isEmpty()) {
                    String id = this.ciIdService$1.getUniqueId(Type.valueOf(Variable.class), this.parentId$1);
                    while (this.ids$1.contains((Object)id)) {
                        id = this.ciIdService$1.getUniqueId(Type.valueOf(Variable.class), this.parentId$1);
                    }
                    this.ids$1.add((Object)id);
                    v.setId(id);
                } else {
                    v.setId(new StringBuilder().append((Object)this.parentId$1).append((Object)"/").append((Object)Ids.getName((String)v.getId())).toString());
                }
                VariablePersistenceHelper$.MODULE$.com$xebialabs$xlrelease$variable$VariablePersistenceHelper$$fixUpValueProviderConfigurationId(v);
            }
            {
                this.parentId$1 = parentId$1;
                this.ciIdService$1 = ciIdService$1;
                this.ids$1 = ids$1;
            }
        });
    }

    public void com$xebialabs$xlrelease$variable$VariablePersistenceHelper$$fixUpValueProviderConfigurationId(Variable v) {
        ValueProviderConfiguration provider = v.getValueProvider();
        if (provider != null && Ids.isNullId((String)provider.getId())) {
            provider.setId(new StringBuilder().append((Object)v.getId()).append((Object)"/").append((Object)ValueProviderConfiguration.CONFIGURATION_ID).toString());
        }
    }

    private VariablePersistenceHelper$() {
        MODULE$ = this;
    }
}

