/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.filters.TaskFilter;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.views.ReleaseTasks;
import com.xebialabs.xlrelease.views.ReleasesFilters;
import com.xebialabs.xlrelease.views.TaskSearchView;
import com.xebialabs.xlrelease.views.TasksFilters;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskSearchService {
    private static final int DEFAULT_RELEASES_BATCH_SIZE = 20;
    private static final int DEFAULT_TASK_LIMIT = 100;
    private RoleService roleService;
    private TaskAccessService taskAccessService;
    private UserInfoResolver userInfoResolver;
    private PermissionChecker permissions;
    private ReleaseSearchService releaseSearchService;
    private TasksViewConverter tasksViewConverter;

    @Autowired
    public TaskSearchService(RoleService roleService, TaskAccessService taskAccessService, UserInfoResolver userInfoResolver, PermissionChecker permissions, ReleaseSearchService releaseSearchService, TasksViewConverter tasksViewConverter) {
        this.roleService = roleService;
        this.taskAccessService = taskAccessService;
        this.userInfoResolver = userInfoResolver;
        this.permissions = permissions;
        this.releaseSearchService = releaseSearchService;
        this.tasksViewConverter = tasksViewConverter;
    }

    public TaskSearchView getTasksByRelease(TasksFilters tasksFilters, Integer limitTasksHint) {
        return this.getTasksByRelease(tasksFilters, limitTasksHint, null);
    }

    TaskSearchView getTasksByRelease(TasksFilters tasksFilters, Integer limitTasksHintOpt, Integer releasesBatchSizeOpt) {
        int limitTasksHint = limitTasksHintOpt != null ? limitTasksHintOpt : 100;
        int releasesBatchSize = releasesBatchSizeOpt != null ? releasesBatchSizeOpt : 20;
        List userRoles = this.roleService.getRolesFor(Permissions.getAuthentication());
        String username = Permissions.getAuthenticatedUserName();
        TaskFilter taskFilter = new TaskFilter(tasksFilters, this.userInfoResolver);
        ArrayList<Task> tasks = new ArrayList<Task>();
        long page = 0L;
        while (tasks.size() < limitTasksHint) {
            ReleaseSearchResult searchResult = this.releaseSearchService.search(ReleasesFilters.active(), page, releasesBatchSize, Integer.MAX_VALUE, !XlrConfig.getInstance().showTasksFromNonViewableReleases());
            List<Release> activeReleases = searchResult.getReleases();
            for (Release activeRelease : activeReleases) {
                tasks.addAll(this.getTasks(Collections.singletonList(activeRelease), userRoles, username, taskFilter));
                if (tasks.size() < limitTasksHint) continue;
                break;
            }
            if (activeReleases.isEmpty()) break;
            ++page;
        }
        ImmutableListMultimap tasksByRelease = Multimaps.index(tasks, Task::getRelease);
        List<Type> allowedTaskTypesForAuthenticatedUser = this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser();
        List<ReleaseTasks> releaseTasks = tasksByRelease.asMap().entrySet().stream().map(entry -> new ReleaseTasks((Release)entry.getKey(), this.tasksViewConverter.toFullView((Collection)entry.getValue(), allowedTaskTypesForAuthenticatedUser))).collect(Collectors.toList());
        releaseTasks.sort(ReleaseTasks.BY_TITLE);
        return new TaskSearchView(releaseTasks, tasks.size() >= limitTasksHint);
    }

    private List<Task> getTasks(List<Release> activeReleases, List<Role> userRoles, String username, TaskFilter taskFilter) {
        List<Task> tasks = taskFilter.filter(username, userRoles, activeReleases);
        return tasks.stream().filter(task -> this.permissions.hasViewTaskPermissions((Task)task, username, userRoles)).collect(Collectors.toList());
    }
}

