/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.views.TaskAccessView;
import com.xebialabs.xlrelease.configuration.TaskAccess;
import com.xebialabs.xlrelease.customscripts.ScriptTypes;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.PythonScriptDefinition;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskDefinition;
import com.xebialabs.xlrelease.domain.TaskTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskAccessService {
    private ScriptTypes scriptTypes;
    private RepositoryService repositoryService;
    private RoleService roleService;
    private PermissionEnforcer permissionEnforcer;

    @Autowired
    public TaskAccessService(ScriptTypes scriptTypes, RepositoryService repositoryService, RoleService roleService, PermissionEnforcer permissionEnforcer) {
        this.scriptTypes = scriptTypes;
        this.repositoryService = repositoryService;
        this.roleService = roleService;
        this.permissionEnforcer = permissionEnforcer;
    }

    public List<TaskAccessView> getTaskAccesses() {
        List<TaskAccessView> taskAccessViews = this.getAllTaskAccessViews();
        List<TaskAccess> taskAccesses = this.readTaskAccesses();
        return this.mergeWithTaskAccesses(taskAccessViews, taskAccesses);
    }

    private List<TaskAccessView> getAllTaskAccessViews() {
        ArrayList<TaskAccessView> taskAccessViews = new ArrayList<TaskAccessView>();
        for (Type defaultType : TaskTypes.getDefaultTaskTypes()) {
            taskAccessViews.add(new TaskAccessView(defaultType.toString(), defaultType.getDescriptor().getLabel(), true, new ArrayList<String>()));
        }
        for (Type pythonScriptType : this.scriptTypes.getPythonScriptTypes()) {
            taskAccessViews.add(new TaskAccessView(pythonScriptType.toString(), this.getLabel(pythonScriptType), true, new ArrayList<String>()));
        }
        return taskAccessViews;
    }

    private String getLabel(Type pythonScriptType) {
        return TaskDefinition.getDisplayGroup((Type)pythonScriptType) + " " + TaskDefinition.getDisplayName((Type)pythonScriptType);
    }

    private List<TaskAccess> readTaskAccesses() {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setType(Type.valueOf(TaskAccess.class));
        return this.repositoryService.listEntities(searchParameters);
    }

    private List<TaskAccessView> mergeWithTaskAccesses(List<TaskAccessView> taskAccessViews, List<TaskAccess> taskAccesses) {
        ImmutableMap accessesByTaskType = Maps.uniqueIndex(taskAccessViews, TaskAccessView::getTaskType);
        for (TaskAccess taskAccess : taskAccesses) {
            String taskType = taskAccess.getName();
            if (!accessesByTaskType.containsKey(taskType)) continue;
            TaskAccessView taskAccessView = (TaskAccessView)accessesByTaskType.get(taskType);
            taskAccessView.setAllowedToAll(taskAccess.isAllowedToAll());
            taskAccessView.getRoles().addAll(taskAccess.getRoles());
        }
        return taskAccessViews;
    }

    public List<Type> getAllowedTaskTypesForAuthenticatedUser() {
        ArrayList<Type> allowedTypes = new ArrayList<Type>();
        List roles = this.roleService.getRolesFor(Permissions.getAuthentication());
        HashSet<String> roleNamesForAuthenticatedUser = new HashSet<String>(this.transform(roles, Role::getName));
        for (TaskAccessView taskAccess : this.getTaskAccesses()) {
            if (!this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{PlatformPermissions.ADMIN}) && !taskAccess.isGrantedForRoles(roleNamesForAuthenticatedUser)) continue;
            allowedTypes.add(taskAccess.toType());
        }
        return allowedTypes;
    }

    private <T, R> List<R> transform(List<T> collection, Function<T, R> transform) {
        return collection.stream().map(transform::apply).collect(Collectors.toList());
    }

    public List<TaskDefinition> getTaskDefinitions() {
        List<Type> allowedTaskTypesForAuthenticatedUser = this.getAllowedTaskTypesForAuthenticatedUser();
        return this.transform(this.getAllTaskAccessViews(), taskAccessView -> {
            Type type = taskAccessView.toType();
            boolean isAllowed = allowedTaskTypesForAuthenticatedUser.stream().anyMatch(allowedType -> allowedType.equals((Object)type));
            if (type.getDescriptor().isAssignableTo(PythonScript.class)) {
                return new PythonScriptDefinition(type, isAllowed);
            }
            return new TaskDefinition(type, isAllowed);
        });
    }

    public void checkIfAuthenticatedUserCanUseTask(Task task) {
        this.checkIfAuthenticatedUserCanUseTasks(Collections.singletonList(task));
    }

    public void checkIfAuthenticatedUserCanUseTasks(List<Task> tasks) {
        if (null == Permissions.getAuthenticatedUserName()) {
            return;
        }
        List roles = this.roleService.getRolesFor(Permissions.getAuthentication());
        HashSet<String> roleNamesForAuthenticatedUser = new HashSet<String>(this.transform(roles, Role::getName));
        ArrayList<Type> allowedTypes = new ArrayList<Type>();
        for (TaskAccessView taskAccess : this.getTaskAccesses()) {
            if (!this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{PlatformPermissions.ADMIN}) && !taskAccess.isGrantedForRoles(roleNamesForAuthenticatedUser)) continue;
            allowedTypes.add(taskAccess.toType());
        }
        HashSet<Type> rejectedTaskTypes = new HashSet<Type>(this.transform(tasks, Task::getTaskType));
        rejectedTaskTypes.removeAll(allowedTypes);
        if (!rejectedTaskTypes.isEmpty()) {
            throw PermissionDeniedException.withMessage((String)String.format("Task use is not granted to you for types : '%s'", ((Object)rejectedTaskTypes).toString()));
        }
    }

    public void updateTaskAccesses(List<TaskAccessView> taskAccessesView) {
        for (TaskAccessView taskAccessView : taskAccessesView) {
            TaskAccess taskAccess = new TaskAccess(taskAccessView.getTaskType(), taskAccessView.isAllowedToAll(), taskAccessView.getRoles());
            this.repositoryService.createOrUpdate((ConfigurationItem[])new TaskAccess[]{taskAccess});
        }
    }
}

