/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.QueryTemplate;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchServiceWithPermissions {
    private static final int BATCH_SIZE = 1000;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected RepositoryService repositoryService;
    protected PermissionEnforcer permissionEnforcer;

    public SearchServiceWithPermissions(PermissionEnforcer permissionEnforcer, RepositoryService repositoryService) {
        this.permissionEnforcer = permissionEnforcer;
        this.repositoryService = repositoryService;
    }

    protected <T extends ConfigurationItem> List<T> queryEntitiesAndFilterByPermissions(long page, long numberByPage, QueryTemplate queryTemplate, int depth, List<Permission> permissions) {
        queryTemplate.setResultsPerPage(1000L);
        ArrayList<ConfigurationItemData> ciIds = new ArrayList<ConfigurationItemData>();
        int fetchedCount = 0;
        long start = System.currentTimeMillis();
        int batchNumber = 0;
        while ((long)ciIds.size() < (page + 1L) * numberByPage) {
            queryTemplate.setPage((long)batchNumber);
            List batch = this.repositoryService.list(queryTemplate);
            fetchedCount += batch.size();
            if (batch.isEmpty()) break;
            ciIds.addAll(this.filterOnPermissions(batch, permissions));
            ++batchNumber;
        }
        this.logger.debug(String.format("Filtered out %d non-viewable CIs in %d millis", fetchedCount - ciIds.size(), System.currentTimeMillis() - start));
        return ciIds.stream().skip(page * numberByPage).limit(numberByPage).map(ciData -> this.repositoryService.read(ciData.getId(), depth)).collect(Collectors.toList());
    }

    private List<ConfigurationItemData> filterOnPermissions(List<ConfigurationItemData> ciIds, List<Permission> permissions) {
        return ciIds.stream().filter(r -> this.permissionEnforcer.hasLoggedInUserPermission(permissions, r.getId())).collect(Collectors.toList());
    }
}

