/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xlrelease.configuration.ArchivingSettings;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.service.ArchivingScheduleService;
import com.xebialabs.xlrelease.service.ArchivingScheduleService$;
import com.xebialabs.xlrelease.service.ArchivingScheduleService$$anonfun$com$xebialabs$xlrelease$service$ArchivingScheduleService$;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.joda.time.LocalDateTime;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

public abstract class ArchivingScheduleService$class {
    public static String getArchivingJobCronSchedule(ArchivingScheduleService $this) {
        return $this.archivingConfig().getArchivingJobCronSchedule();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void archiveExpiredReleases(ArchivingScheduleService $this, Integer releaseAgeToArchive) {
        if (!$this.archivingConfig().getEnabled()) {
            $this.logger().warn((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Archiving is not enabled.";
                }
            });
            return;
        }
        long startArchiving = System.currentTimeMillis();
        Date expirationDate = LocalDateTime.now().minusHours(Predef$.MODULE$.Integer2int(releaseAgeToArchive)).toDate();
        $this.logger().debug((Function0)new Serializable($this, expirationDate, releaseAgeToArchive){
            public static final long serialVersionUID = 0L;
            private final Date expirationDate$1;
            private final Integer releaseAgeToArchive$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving completed releases older than ", " hours (completed before ", ")..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.releaseAgeToArchive$1, this.expirationDate$1}));
            }
            {
                this.expirationDate$1 = expirationDate$1;
                this.releaseAgeToArchive$1 = releaseAgeToArchive$1;
            }
        });
        Object object = $this.archiveInProgressLock();
        synchronized (object) {
            $this.doArchiveExpiredReleasesAction((Function0<BoxedUnit>)new Serializable($this, startArchiving, expirationDate){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ArchivingScheduleService $outer;
                public final long startArchiving$1;
                private final Date expirationDate$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    int archivedReleasesCount = ArchivingScheduleService$class.com$xebialabs$xlrelease$service$ArchivingScheduleService$$findAndProcessArchivableReleases(this.$outer, this.expirationDate$1, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ArchivingScheduleService$.anonfun.archiveExpiredReleases.1 $outer;

                        public final void apply(String s) {
                            ArchivingScheduleService$class.com$xebialabs$xlrelease$service$ArchivingScheduleService$$processRelease(this.$outer.com$xebialabs$xlrelease$service$ArchivingScheduleService$$anonfun$$$outer(), s);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.logger().debug((Function0)new Serializable(this, archivedReleasesCount){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ArchivingScheduleService$.anonfun.archiveExpiredReleases.1 $outer;
                        private final int archivedReleasesCount$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived ", " releases in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.archivedReleasesCount$1), BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.$outer.startArchiving$1))}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.archivedReleasesCount$1 = archivedReleasesCount$1;
                        }
                    });
                }

                public /* synthetic */ ArchivingScheduleService com$xebialabs$xlrelease$service$ArchivingScheduleService$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.startArchiving$1 = startArchiving$1;
                    this.expirationDate$1 = expirationDate$1;
                }
            });
            return;
        }
    }

    public static void archiveExpiredReleases(ArchivingScheduleService $this) {
        $this.archiveExpiredReleases($this.archivingConfig().getReleaseAgeToDeleteFromJcr());
    }

    public static void com$xebialabs$xlrelease$service$ArchivingScheduleService$$postProcessArchivedRelease(ArchivingScheduleService $this, String releaseId) {
        Try$.MODULE$.apply((Function0)new Serializable($this, releaseId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivingScheduleService $outer;
            public final String releaseId$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long s = System.currentTimeMillis();
                this.$outer.logger().info((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ArchivingScheduleService$$anonfun$com$xebialabs$xlrelease$service$ArchivingScheduleService$.postProcessArchivedRelease.1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Post processing archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.releaseId$2}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.strategy().postProcessArchivedRelease(this.releaseId$2);
                this.$outer.logger().debug((Function0)new Serializable(this, s){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ArchivingScheduleService$$anonfun$com$xebialabs$xlrelease$service$ArchivingScheduleService$.postProcessArchivedRelease.1 $outer;
                    private final long s$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Post processed archived release [", "] in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.releaseId$2, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.s$1))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.s$1 = s$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$2 = releaseId$2;
            }
        }).recover((PartialFunction)new Serializable($this, releaseId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivingScheduleService $outer;
            public final String releaseId$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ArchivingScheduleService$$anonfun$com$xebialabs$xlrelease$service$ArchivingScheduleService$.postProcessArchivedRelease.2 $outer;
                        private final Exception x2$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not delete release [", "]: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.releaseId$2, this.x2$1.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$1 = x2$1;
                        }
                    }, (Function0)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception x2$1;

                        public final Exception apply() {
                            return this.x2$1;
                        }
                        {
                            this.x2$1 = x2$1;
                        }
                    });
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$2 = releaseId$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static int com$xebialabs$xlrelease$service$ArchivingScheduleService$$findAndProcessArchivableReleases(ArchivingScheduleService $this, Date date, Function1 action) {
        long runStartTimeMillis = System.currentTimeMillis();
        AtomicInteger count = new AtomicInteger(0);
        boolean done = false;
        while (true) {
            void var3_3;
            boolean bl;
            void var5_4;
            if (done || $this.isCancelRequested().get()) {
                if (count.get() > 0) {
                    $this.logger().info((Function0)new Serializable($this, date, count){
                        public static final long serialVersionUID = 0L;
                        private final Date date$1;
                        private final AtomicInteger count$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived ", " releases that completed before ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.count$1.get()), this.date$1}));
                        }
                        {
                            this.date$1 = date$1;
                            this.count$1 = count$1;
                        }
                    });
                }
                return count.get();
            }
            int archivingPageSize = ArchivingScheduleService$class.getSearchPageSize($this);
            $this.logger().debug((Function0)new Serializable($this, archivingPageSize){
                public static final long serialVersionUID = 0L;
                private final int archivingPageSize$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching ", " completed or aborted releases from repository"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.archivingPageSize$1)}));
                }
                {
                    this.archivingPageSize$1 = archivingPageSize$1;
                }
            });
            Seq<String> releaseIds = $this.strategy().findArchivableReleases(date, archivingPageSize);
            if (releaseIds.nonEmpty() && var5_4.get() == 0) {
                $this.logger().info((Function0)new Serializable($this, date){
                    public static final long serialVersionUID = 0L;
                    private final Date date$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving releases that completed before ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.date$1}));
                    }
                    {
                        this.date$1 = date$1;
                    }
                });
            }
            if (bl = ArchivingScheduleService$class.processReleases($this, releaseIds, (AtomicInteger)var5_4, (long)var3_3, action)) continue;
            if (releaseIds.isEmpty() || releaseIds.size() < archivingPageSize) {
                $this.logger().debug((Function0)new Serializable($this, releaseIds){
                    public static final long serialVersionUID = 0L;
                    private final Seq releaseIds$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processed only ", " finished releases on this page: we're done."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.releaseIds$1.size())}));
                    }
                    {
                        this.releaseIds$1 = releaseIds$1;
                    }
                });
                bl = true;
                continue;
            }
            $this.logger().debug((Function0)new Serializable($this, date, (AtomicInteger)var5_4, archivingPageSize){
                public static final long serialVersionUID = 0L;
                private final Date date$1;
                private final AtomicInteger count$1;
                private final int archivingPageSize$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived ", " releases that completed before ", ", fetching the next ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.count$1.get()), this.date$1, BoxesRunTime.boxToInteger((int)this.archivingPageSize$1)}));
                }
                {
                    this.date$1 = date$1;
                    this.count$1 = count$1;
                    this.archivingPageSize$1 = archivingPageSize$1;
                }
            });
        }
    }

    private static boolean processReleases(ArchivingScheduleService $this, Iterable releaseIds, AtomicInteger count, long runStartTimeMillis, Function1 action) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                releaseIds.foreach((Function1)new Serializable($this, count, runStartTimeMillis, action, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ArchivingScheduleService $outer;
                    private final AtomicInteger count$2;
                    private final long runStartTimeMillis$1;
                    private final Function1 action$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(String releaseId) {
                        if (this.$outer.isCancelRequested().get()) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                        }
                        if (this.count$2.get() > 0) {
                            ArchivingScheduleService$class.com$xebialabs$xlrelease$service$ArchivingScheduleService$$sleepIfNeeded(this.$outer);
                        }
                        this.action$1.apply((Object)releaseId);
                        this.count$2.incrementAndGet();
                        if (ArchivingScheduleService$class.com$xebialabs$xlrelease$service$ArchivingScheduleService$$ranTooLong(this.$outer, this.runStartTimeMillis$1)) {
                            this.$outer.logger().warn((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ArchivingScheduleService$.anonfun.processReleases.1 $outer;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving paused because it ran for more than ", " seconds. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$xebialabs$xlrelease$service$ArchivingScheduleService$$anonfun$$$outer().archivingConfig().getMaxSecondsPerRun()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving will continue in the next run"})).s((Seq)Nil$.MODULE$)).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                        }
                    }

                    public /* synthetic */ ArchivingScheduleService com$xebialabs$xlrelease$service$ArchivingScheduleService$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.count$2 = count$2;
                        this.runStartTimeMillis$1 = runStartTimeMillis$1;
                        this.action$1 = action$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public static void com$xebialabs$xlrelease$service$ArchivingScheduleService$$processRelease(ArchivingScheduleService $this, String releaseId) {
        WorkDirContext.initWorkdir();
        try {
            ArchivingScheduleService$class.archiveCompletedRelease($this, releaseId).map((Function1)new Serializable($this, releaseId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ArchivingScheduleService $outer;
                private final String releaseId$1;

                public final void apply(BoxedUnit x$1) {
                    ArchivingScheduleService$class.com$xebialabs$xlrelease$service$ArchivingScheduleService$$postProcessArchivedRelease(this.$outer, this.releaseId$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.releaseId$1 = releaseId$1;
                }
            });
        }
        catch (Throwable throwable) {
            WorkDirContext.get().delete();
            WorkDirContext.clear();
            $this.logger().debug((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Completed cleanup after the archiving";
                }
            });
            throw throwable;
        }
        WorkDirContext.get().delete();
        WorkDirContext.clear();
        $this.logger().debug((Function0)new /* invalid duplicate definition of identical inner class */);
    }

    private static Try archiveCompletedRelease(ArchivingScheduleService $this, String releaseId) {
        return Try$.MODULE$.apply((Function0)new Serializable($this, releaseId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivingScheduleService $outer;
            public final String releaseId$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.$outer.archivingService().exists(this.releaseId$3)) {
                    this.$outer.logger().warn((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ArchivingScheduleService$.anonfun.archiveCompletedRelease.1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release [", "] was already archived before, skipping the archiving"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.releaseId$3}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                } else {
                    this.$outer.logger().info((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ArchivingScheduleService$.anonfun.archiveCompletedRelease.1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.releaseId$3}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    long s = System.currentTimeMillis();
                    Release release = this.$outer.releases().findById(this.releaseId$3);
                    release.setTeams(this.$outer.teams().getEffectiveTeams(release));
                    this.$outer.dependencyService().archiveAllOutgoingDependencies(release);
                    List releaseAttachments = (List)JavaConversions$.MODULE$.asScalaBuffer(release.getAttachments()).toList().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ArchivingScheduleService$.anonfun.archiveCompletedRelease.1 $outer;

                        public final Attachment apply(Attachment attachment) {
                            return this.$outer.com$xebialabs$xlrelease$service$ArchivingScheduleService$$anonfun$$$outer().attachments().findById(attachment.getId());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.$outer.archivingService().archiveRelease(release, JavaConversions$.MODULE$.seqAsJavaList((Seq)releaseAttachments));
                    this.$outer.logger().debug((Function0)new Serializable(this, s){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ArchivingScheduleService$.anonfun.archiveCompletedRelease.1 $outer;
                        private final long s$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived release [", "] in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.releaseId$3, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.s$2))}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.s$2 = s$2;
                        }
                    });
                }
            }

            public /* synthetic */ ArchivingScheduleService com$xebialabs$xlrelease$service$ArchivingScheduleService$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$3 = releaseId$3;
            }
        }).recoverWith((PartialFunction)new Serializable($this, releaseId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivingScheduleService $outer;
            public final String releaseId$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ArchivingScheduleService$.anonfun.archiveCompletedRelease.2 $outer;
                        private final Exception x2$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not archive release [", "]: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.releaseId$3, this.x2$2.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$2 = x2$2;
                        }
                    }, (Function0)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception x2$2;

                        public final Exception apply() {
                            return this.x2$2;
                        }
                        {
                            this.x2$2 = x2$2;
                        }
                    });
                    object = new Failure((Throwable)exception);
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$3 = releaseId$3;
            }
        });
    }

    private static int getSearchPageSize(ArchivingScheduleService $this) {
        return Predef$.MODULE$.Integer2int($this.archivingConfig().getSearchPageSize()) > 0 ? Predef$.MODULE$.Integer2int($this.archivingConfig().getSearchPageSize()) : ArchivingSettings.DEFAULT_SEARCH_PAGE_SIZE;
    }

    public static void com$xebialabs$xlrelease$service$ArchivingScheduleService$$sleepIfNeeded(ArchivingScheduleService $this) {
        if (Predef$.MODULE$.Integer2int($this.archivingConfig().getSleepSecondsBetweenReleases()) > 0) {
            $this.logger().debug((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ArchivingScheduleService $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sleeping for ", " seconds before archiving the next release"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.archivingConfig().getSleepSecondsBetweenReleases()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            try {
                Thread.sleep(Predef$.MODULE$.Integer2int($this.archivingConfig().getSleepSecondsBetweenReleases()) * 1000);
            }
            catch (InterruptedException interruptedException) {
                $this.logger().warn((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ArchivingScheduleService $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sleeping for ", " seconds was interrupted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.archivingConfig().getSleepSecondsBetweenReleases()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }
    }

    public static boolean com$xebialabs$xlrelease$service$ArchivingScheduleService$$ranTooLong(ArchivingScheduleService $this, long runStartTimeMillis) {
        return Predef$.MODULE$.Integer2int($this.archivingConfig().getMaxSecondsPerRun()) > 0 ? System.currentTimeMillis() - runStartTimeMillis > (long)(Predef$.MODULE$.Integer2int($this.archivingConfig().getMaxSecondsPerRun()) * 1000) : false;
    }

    private static void off(ArchivingScheduleService $this) {
        $this.isCancelRequested().set(true);
        $this.logger().debug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Waiting until no archiving is in progress";
            }
        });
        Object object = $this.archiveInProgressLock();
        synchronized (object) {
            $this.logger().debug((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Archiving done, destroying ArchivingScheduleService";
                }
            });
            return;
        }
    }

    @PreDestroy
    private static void preDestroy(ArchivingScheduleService $this) {
        ArchivingScheduleService$class.off($this);
    }

    public static void $init$(ArchivingScheduleService $this) {
        $this.com$xebialabs$xlrelease$service$ArchivingScheduleService$_setter_$isCancelRequested_$eq(new AtomicBoolean(false));
        $this.com$xebialabs$xlrelease$service$ArchivingScheduleService$_setter_$archiveInProgressLock_$eq(new Object());
    }
}

