/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.Team;
import com.xebialabs.deployit.security.TeamService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand;
import com.xebialabs.xlrelease.repository.ReleaseTeamsUpdateCommand;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class Teams {
    private static final Logger logger = LoggerFactory.getLogger(Teams.class);
    private static final String PLATFORM_PREFIX = "Team$";
    private CiIdService ciIdService;
    private TeamService teamService;
    private PermissionEditor permissionEditor;
    private RoleService roleService;
    private ArchivingService archivingService;
    private RepositoryService repositoryService;
    private XlrRepository xlrRepository;
    private static BinaryOperator<Team> throwingMerger = (u, v) -> {
        throw new IllegalStateException(String.format("Duplicate key %s", u));
    };

    @Autowired
    public Teams(CiIdService ciIdService, TeamService teamService, PermissionEditor permissionEditor, RoleService roleService, ArchivingService archivingService, RepositoryService repositoryService, XlrRepository xlrRepository) {
        this.ciIdService = ciIdService;
        this.teamService = teamService;
        this.permissionEditor = permissionEditor;
        this.roleService = roleService;
        this.archivingService = archivingService;
        this.repositoryService = repositoryService;
        this.xlrRepository = xlrRepository;
    }

    public com.xebialabs.xlrelease.domain.Team create(String containerId, com.xebialabs.xlrelease.domain.Team team) {
        if (Ids.isNullId((String)team.getId())) {
            team.setId(this.ciIdService.getUniqueId(Type.valueOf(com.xebialabs.xlrelease.domain.Team.class), containerId));
        }
        ArrayList<com.xebialabs.xlrelease.domain.Team> currentTeams = new ArrayList<com.xebialabs.xlrelease.domain.Team>(this.getStoredTeams(containerId));
        currentTeams.add(team);
        this.saveTeamsToPlatform(containerId, currentTeams);
        return team;
    }

    public void deleteTeam(String teamId) {
        String containerId = Ids.getParentId((String)teamId);
        ArrayList<com.xebialabs.xlrelease.domain.Team> currentTeams = new ArrayList<com.xebialabs.xlrelease.domain.Team>(this.getStoredTeams(containerId));
        currentTeams.stream().filter(team -> Objects.equals(team.getId(), teamId)).findAny().ifPresent(currentTeams::remove);
        this.saveTeamsToPlatform(containerId, currentTeams);
    }

    public com.xebialabs.xlrelease.domain.Team updateTeam(com.xebialabs.xlrelease.domain.Team teamToUpdate) {
        String containerId = Ids.getParentId((String)teamToUpdate.getId());
        ArrayList<com.xebialabs.xlrelease.domain.Team> currentTeams = new ArrayList<com.xebialabs.xlrelease.domain.Team>(this.getStoredTeams(containerId));
        List<com.xebialabs.xlrelease.domain.Team> teamUpdatedList = currentTeams.stream().map(team -> Objects.equals(team.getId(), teamToUpdate.getId()) ? teamToUpdate : team).collect(Collectors.toList());
        this.saveTeamsToPlatform(containerId, teamUpdatedList);
        return teamToUpdate;
    }

    public void synchronizeTeamsToPlatform(Release release) {
        this.saveTeamsToPlatform(release.getId(), release.getTeams());
    }

    public List<com.xebialabs.xlrelease.domain.Team> saveTeamsToPlatform(String containerId, List<com.xebialabs.xlrelease.domain.Team> teams) {
        if (!teams.isEmpty()) {
            Optional<com.xebialabs.xlrelease.domain.Team> anInheritedTeam = teams.stream().filter(team -> !Ids.isNullId((String)team.getId()) && !Objects.equals(containerId, Ids.getParentId((String)team.getId()))).findAny();
            anInheritedTeam.ifPresent(team -> Checks.checkArgument((boolean)false, (String)"Cannot save team %s as it does not belong to %s", (Object[])new Object[]{team, containerId}));
            int numberOfUniqueTeamNames = teams.stream().map(com.xebialabs.xlrelease.domain.Team::getTeamName).collect(Collectors.toSet()).size();
            Checks.checkArgument((teams.size() == numberOfUniqueTeamNames ? 1 : 0) != 0, (String)"Cannot save teams %s in %s with duplicates names", (Object[])new Object[]{teams, containerId});
            teams.stream().filter(team -> team.getPermissions().isEmpty()).forEach(team -> team.getPermissions().add(XLReleasePermissions.DUMMY.getPermissionName()));
        }
        return this.saveTeamsToPlatformWithNoValidation(containerId, teams);
    }

    List<com.xebialabs.xlrelease.domain.Team> saveTeamsToPlatformWithNoValidation(String containerId, List<com.xebialabs.xlrelease.domain.Team> teams) {
        teams.forEach(team -> {
            if (Ids.isNullId((String)team.getId())) {
                team.setId(this.ciIdService.getUniqueId(Type.valueOf(com.xebialabs.xlrelease.domain.Team.class), containerId));
            }
            this.removeMissingRoles((com.xebialabs.xlrelease.domain.Team)team);
        });
        if (Ids.isReleaseId((String)containerId) && !this.repositoryService.exists(containerId)) {
            this.xlrRepository.handle(new ReleaseTeamsUpdateCommand(containerId, teams));
        } else {
            Map xlr2platformTeams = teams.stream().collect(Collectors.toMap(Function.identity(), this::convertToPlatformTeam, throwingMerger, LinkedHashMap::new));
            this.saveTeamPermissions(xlr2platformTeams, containerId);
        }
        return teams;
    }

    public void decorateWithEffectiveTeams(Release release) {
        List<com.xebialabs.xlrelease.domain.Team> teams = this.getEffectiveTeams(release);
        release.setTeams(teams);
    }

    public void decorateWithStoredTeams(Release release) {
        List<com.xebialabs.xlrelease.domain.Team> teams = this.getStoredTeams(release);
        release.setTeams(teams);
    }

    public List<com.xebialabs.xlrelease.domain.Team> getEffectiveTeams(String containerId) {
        List<com.xebialabs.xlrelease.domain.Team> containerTeams = this.getStoredTeams(containerId);
        if (containerTeams.isEmpty() && !Ids.ROOT_FOLDER_ID.equals(containerId)) {
            return this.getEffectiveTeams(Ids.getParentId((String)containerId));
        }
        return containerTeams;
    }

    public List<com.xebialabs.xlrelease.domain.Team> getEffectiveTeams(Release release) {
        List<com.xebialabs.xlrelease.domain.Team> releaseTeams = this.getStoredTeams(release);
        if (releaseTeams.isEmpty()) {
            String parentFolderId = Ids.getParentId((String)release.getId());
            return this.getEffectiveTeams(parentFolderId);
        }
        return releaseTeams;
    }

    public List<com.xebialabs.xlrelease.domain.Team> getStoredTeams(Release release) {
        return this.getTeamOrPermissionFromRelease(release, Release::getTeams, (Release r) -> new ArrayList(), (Release r) -> this.getTeamsOfCiInPlatform(r.getId()), Release::getTeams);
    }

    private List<com.xebialabs.xlrelease.domain.Team> getStoredTeamsOfRelease(String releaseId) {
        return this.getTeamOrPermissionFromRelease(releaseId, Release::getTeams, (String r) -> new ArrayList(), this::getTeamsOfCiInPlatform, Release::getTeams);
    }

    public <T> T getTeamOrPermissionFromRelease(Release release, Function<Release, T> onArchivedRelease, Function<Release, T> onReleaseInFolder, Function<Release, T> onJcrRelease, Function<Release, T> onSqlRelease) {
        if (release.isArchived() && !XlrConfig.getInstance().isSqlRepositoryEnabled()) {
            return onArchivedRelease.apply(release);
        }
        String releaseId = release.getId();
        if (Ids.isNullId((String)releaseId) || Ids.isInFolder((String)releaseId)) {
            return onReleaseInFolder.apply(release);
        }
        if (this.repositoryService.exists(releaseId)) {
            return onJcrRelease.apply(release);
        }
        return onSqlRelease.apply(release);
    }

    public <T> T getTeamOrPermissionFromRelease(String releaseId, Function<Release, T> onArchivedRelease, Function<String, T> onReleaseInFolder, Function<String, T> onJcrRelease, Function<Release, T> onSqlRelease) {
        if (this.archivingService.exists(releaseId)) {
            Release release = this.archivingService.getRelease(releaseId);
            return onArchivedRelease.apply(release);
        }
        if (Ids.isInFolder((String)releaseId)) {
            return onReleaseInFolder.apply(releaseId);
        }
        if (this.repositoryService.exists(releaseId)) {
            return onJcrRelease.apply(releaseId);
        }
        Release release = this.xlrRepository.handle(new ReleaseGetCommand(releaseId, 2, true, null));
        return onSqlRelease.apply(release);
    }

    public List<com.xebialabs.xlrelease.domain.Team> getStoredTeams(String containerId) {
        if (Ids.isNullId((String)containerId) || Ids.isRoot((String)containerId)) {
            return new ArrayList<com.xebialabs.xlrelease.domain.Team>();
        }
        if (Ids.isReleaseId((String)containerId)) {
            return this.getStoredTeamsOfRelease(containerId);
        }
        return this.getTeamsOfCiInPlatform(containerId);
    }

    private List<com.xebialabs.xlrelease.domain.Team> getTeamsOfCiInPlatform(String containerId) {
        Map permissionsByTeam = this.permissionEditor.readPermissions(containerId);
        return this.teamService.getTeams(containerId).stream().map(platformTeam -> this.convertToTeam(containerId, (Team)platformTeam, permissionsByTeam.getOrDefault(platformTeam, Collections.emptySet()))).collect(Collectors.toList());
    }

    public Optional<com.xebialabs.xlrelease.domain.Team> findTeamByName(String containerId, String teamName) {
        if (StringUtils.isEmpty((Object)teamName)) {
            return Optional.empty();
        }
        return this.getEffectiveTeams(containerId).stream().filter(team -> teamName.equals(team.getTeamName())).findAny();
    }

    public List<com.xebialabs.xlrelease.domain.Team> findTeamsByNames(String containerId, Collection<String> teamNames) {
        return this.getEffectiveTeams(containerId).stream().filter(team -> teamNames.contains(team.getTeamName())).collect(Collectors.toList());
    }

    public void decorateWithEffectiveTeams(Collection<Release> releases) {
        releases.forEach(this::decorateWithEffectiveTeams);
    }

    private com.xebialabs.xlrelease.domain.Team convertToTeam(String containerId, Team platformTeam, Set<Permission> permissions) {
        com.xebialabs.xlrelease.domain.Team team = (com.xebialabs.xlrelease.domain.Team)Type.valueOf(com.xebialabs.xlrelease.domain.Team.class).getDescriptor().newInstance(this.platformTeamIdToTeamId(containerId, platformTeam.getId()));
        team.setRoles(platformTeam.getRoles());
        team.setMembers(platformTeam.getPrincipals());
        team.setTeamName(platformTeam.getName());
        team.setPermissions(permissions.stream().map(Permission::getPermissionName).collect(Collectors.toList()));
        return team;
    }

    private Team convertToPlatformTeam(com.xebialabs.xlrelease.domain.Team team) {
        Checks.checkArgument((!StringUtils.isEmpty((Object)team.getTeamName()) ? 1 : 0) != 0, (String)("Team name is missing in team " + team.getId()), (Object[])new Object[0]);
        Team platformTeam = new Team(this.teamIdToPlatformTeamId(team.getId()), team.getTeamName());
        platformTeam.setRoles(team.getRoles());
        platformTeam.setPrincipals(team.getMembers());
        return platformTeam;
    }

    private String teamIdToPlatformTeamId(String id) {
        return PLATFORM_PREFIX + Ids.getName((String)id);
    }

    private String platformTeamIdToTeamId(String containerId, String id) {
        return containerId + "/" + id.replace(PLATFORM_PREFIX, "");
    }

    private void saveTeamPermissions(Map<com.xebialabs.xlrelease.domain.Team, Team> xlr2platformTeams, String containerId) {
        this.teamService.writeTeams(new ArrayList<Team>(xlr2platformTeams.values()), containerId);
        Map permissionsMap = this.permissionEditor.readPermissions(containerId);
        xlr2platformTeams.forEach((xlrTeam, platformTeam) -> {
            List permissions = xlrTeam.getPermissions();
            Set platformPermissions = permissions.stream().map(Permission::find).collect(Collectors.toSet());
            permissionsMap.put(platformTeam, platformPermissions);
        });
        this.permissionEditor.editPermissions(containerId, permissionsMap);
    }

    private void removeMissingRoles(com.xebialabs.xlrelease.domain.Team team) {
        List nonExistingRoles = team.getRoles().stream().filter(role -> !this.roleExists((String)role)).collect(Collectors.toList());
        if (!nonExistingRoles.isEmpty()) {
            logger.warn(String.format("The following role(s) do not exist: %s. They were removed from the team %s (%s).", nonExistingRoles, team.getTeamName(), team.getId()));
            team.getRoles().removeAll(nonExistingRoles);
        }
    }

    private boolean roleExists(String role) {
        boolean exists = true;
        try {
            this.roleService.getRoleForRoleName(role);
        }
        catch (NotFoundException e) {
            exists = false;
        }
        return exists;
    }
}

