/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.repository.ReleaseTriggerCreateCommand;
import com.xebialabs.xlrelease.repository.ReleaseTriggerDeleteCommand;
import com.xebialabs.xlrelease.repository.ReleaseTriggerGetCommand;
import com.xebialabs.xlrelease.repository.ReleaseTriggerUpdateCommand;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ReleaseTriggers {
    private CiIdService ciIdService;
    private XlrRepository xlrRepository;

    @Autowired
    public ReleaseTriggers(CiIdService ciIdService, XlrRepository xlrRepository) {
        this.ciIdService = ciIdService;
        this.xlrRepository = xlrRepository;
    }

    public ReleaseTrigger find(String triggerId) {
        return this.xlrRepository.handle(new ReleaseTriggerGetCommand(triggerId));
    }

    public ReleaseTrigger create(String templateId, ReleaseTrigger releaseTrigger) {
        String releaseTriggerId = this.ciIdService.getUniqueId(releaseTrigger.getType(), templateId);
        releaseTrigger.setId(releaseTriggerId);
        this.updateVariables(releaseTrigger);
        this.xlrRepository.handle(new ReleaseTriggerCreateCommand(releaseTrigger, releaseTrigger.getVariables()));
        return releaseTrigger;
    }

    public void update(ReleaseTrigger releaseTrigger) {
        this.updateVariables(releaseTrigger);
        this.xlrRepository.handle(new ReleaseTriggerUpdateCommand(releaseTrigger, releaseTrigger.getVariables()));
    }

    public void delete(String triggerId) {
        this.xlrRepository.handle(new ReleaseTriggerDeleteCommand(triggerId));
    }

    private void updateVariables(ReleaseTrigger releaseTrigger) {
        VariablePersistenceHelper.fixUpVariableIds(releaseTrigger.getId(), releaseTrigger.getVariables(), this.ciIdService);
    }
}

