/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.builder.PhaseBuilder;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.PhaseCopiedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseDeletedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseDuplicatedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.PhaseCreateCommand;
import com.xebialabs.xlrelease.repository.PhaseDeleteCommand;
import com.xebialabs.xlrelease.repository.PhaseGetCommand;
import com.xebialabs.xlrelease.repository.PhaseMoveCommand;
import com.xebialabs.xlrelease.repository.PhaseUpdateCommand;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import com.xebialabs.xlrelease.views.MovementIndexes;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Phases {
    private static final String DEFAULT_TITLE = "New Phase";
    private CiIdService ciIdService;
    private XlrRepository xlrRepository;
    private Releases releases;
    private XLReleaseEventBus eventBus;

    @Autowired
    public Phases(CiIdService ciIdService, XlrRepository xlrRepository, Releases releases, XLReleaseEventBus eventBus) {
        this.ciIdService = ciIdService;
        this.xlrRepository = xlrRepository;
        this.releases = releases;
        this.eventBus = eventBus;
    }

    public Phase create(String parentId) {
        return this.create(parentId, DEFAULT_TITLE);
    }

    public Phase create(String parentId, String phaseTitle) {
        Release release = this.releases.findById(parentId);
        return this.createInPosition(release, phaseTitle, null, null);
    }

    public Phase create(String parentId, Phase phaseTemplate, Integer position) {
        Release release = this.releases.findById(parentId);
        this.checkPosition(release, position);
        return this.createInPosition(release, null, phaseTemplate, position);
    }

    private void checkPosition(Release release, Integer position) {
        if (position != null) {
            Preconditions.checkArgument((position >= 0 && position <= release.getPhases().size() ? 1 : 0) != 0, (Object)"Phase index out of bounds");
            if (position < release.getPhases().size()) {
                Phase phaseAfterPosition = (Phase)release.getPhases().get(position);
                Preconditions.checkArgument((boolean)phaseAfterPosition.isPlanned(), (Object)"Can't add a phase before a phase that is active or done");
            }
        }
    }

    private Phase createInPosition(Release release, String title, Phase phaseTemplate, Integer position) {
        Phase releasePhase = phaseTemplate != null ? phaseTemplate : PhaseBuilder.newPhase().withTitle(title != null ? title : DEFAULT_TITLE).build();
        Preconditions.checkArgument((boolean)release.isUpdatable(), (Object)"You can't add a phase to finished release");
        Phase newPhase = PhaseBuilder.newPhase().withId(this.getUniqueId(release.getId())).withTitle(Optional.ofNullable(releasePhase.getTitle()).orElse(DEFAULT_TITLE)).withStatus(PhaseStatus.PLANNED).withColor(releasePhase.getColor()).withDescription(releasePhase.getDescription()).withDueDate(releasePhase.getDueDate()).withPlannedDuration(releasePhase.getPlannedDuration()).withScheduledStartDate(releasePhase.getScheduledStartDate()).withRelease(release).build();
        release.addPhase(newPhase, position != null ? position.intValue() : release.getPhases().size());
        List<Variable> newVariables = VariablePersistenceHelper.scanAndBuildNewVariables(release, (VisitableItem)newPhase, this.ciIdService);
        Phase createdPhase = this.xlrRepository.handle(new PhaseCreateCommand(newPhase, release, newVariables));
        this.eventBus.publish((XLReleaseEvent)new PhaseCreatedEvent(createdPhase));
        return createdPhase;
    }

    public String getUniqueId(String parentId) {
        return this.ciIdService.getUniqueId(Type.valueOf(Phase.class), parentId);
    }

    public Phase findById(String phaseId) {
        return this.xlrRepository.handle(new PhaseGetCommand(phaseId));
    }

    public void delete(String phaseId) {
        Phase phase = this.findById(phaseId);
        Preconditions.checkArgument((boolean)phase.isPlanned(), (Object)"Only planned phases can be deleted");
        phase.getRelease().deletePhase(phase);
        this.xlrRepository.handle(new PhaseDeleteCommand(phase));
        this.eventBus.publish((XLReleaseEvent)new PhaseDeletedEvent(phase));
    }

    public Phase update(String phaseId, Phase toUpdate) {
        Phase updated = this.findById(phaseId);
        Preconditions.checkArgument((boolean)updated.isUpdatable(), (String)"The phase '%s' can't be updated because it has finished.", (Object[])new Object[]{updated.getTitle()});
        Preconditions.checkArgument((boolean)this.isScheduledStartDateUpdatable(updated, toUpdate), (String)"The start date of '%s' can't be updated because this phase has already started.", (Object[])new Object[]{updated.getTitle()});
        Phase original = CiCloneHelper.cloneCi(updated);
        if (toUpdate.getTitle() != null) {
            Preconditions.checkArgument((!toUpdate.getTitle().isEmpty() ? 1 : 0) != 0, (Object)"Phase title is required.");
            updated.setTitle(toUpdate.getTitle());
        }
        updated.setDescription(toUpdate.getDescription());
        updated.setColor(toUpdate.getColor());
        updated.updateDates(toUpdate.getScheduledStartDate(), toUpdate.getDueDate(), toUpdate.getPlannedDuration());
        List<Variable> newVariables = VariablePersistenceHelper.scanAndBuildNewVariables(updated.getRelease(), (VisitableItem)updated, this.ciIdService);
        Phase savedPhase = this.xlrRepository.handle(new PhaseUpdateCommand(original, updated, newVariables));
        this.eventBus.publish((XLReleaseEvent)new PhaseUpdatedEvent(original, savedPhase));
        return savedPhase;
    }

    public Phase copyPhase(Release release, String originPhaseId, int targetPosition) {
        Preconditions.checkArgument((targetPosition >= 0 ? 1 : 0) != 0, (Object)"Target position must be greater or equal to 0.");
        Preconditions.checkArgument((targetPosition <= release.getPhases().size() ? 1 : 0) != 0, (String)"Target position must be between 0 and %s.", (Object[])new Object[]{release.getPhases().size()});
        Phase originPhase = this.findById(originPhaseId);
        Preconditions.checkArgument((boolean)originPhase.isUpdatable(), (String)"Cannot copy phase '%s' because it is %s.", (Object[])new Object[]{originPhase.getTitle(), originPhase.getStatus()});
        if (targetPosition < release.getPhases().size()) {
            Phase phaseAtPosition = release.getPhase(Integer.valueOf(targetPosition));
            Preconditions.checkArgument((boolean)phaseAtPosition.isUpdatable(), (String)"Can't copy '%s' to targetPosition %s because it will move a phase with status %s to the right. A copied phase must be positioned after an ACTIVE phase.", (Object[])new Object[]{originPhase.getTitle(), targetPosition, phaseAtPosition.getStatus()});
            Preconditions.checkArgument((!phaseAtPosition.isActive() ? 1 : 0) != 0, (String)"Can't copy '%s' to targetPosition %s because it will move an ACTIVE phase to the right.", (Object[])new Object[]{originPhase.getTitle(), targetPosition});
        }
        String newPhaseId = this.getUniqueId(release.getId());
        Phase newPhase = CiCloneHelper.cloneCi(originPhase);
        newPhase.resetToPlanned();
        CiHelper.eraseTokens((ConfigurationItem)newPhase);
        CiHelper.rewriteWithNewId((ConfigurationItem)newPhase, (String)newPhaseId);
        newPhase.setTitle(newPhase.getTitle() + " (copy)");
        release.getPhases().add(targetPosition, newPhase);
        Phase savedPhase = this.xlrRepository.handle(new PhaseCreateCommand(newPhase, release, Collections.emptyList()));
        this.eventBus.publish((XLReleaseEvent)new PhaseCopiedEvent(savedPhase));
        return savedPhase;
    }

    public Phase duplicatePhase(Release release, String originPhaseId) {
        Phase originPhase = this.findById(originPhaseId);
        Preconditions.checkArgument((boolean)originPhase.isUpdatable(), (String)"Can't duplicate phase '%s' because it is %s.", (Object[])new Object[]{originPhase.getTitle(), originPhase.getStatus()});
        String newPhaseId = this.getUniqueId(release.getId());
        Phase duplicatedPhase = CiCloneHelper.cloneCi(originPhase);
        duplicatedPhase.resetToPlanned();
        CiHelper.eraseTokens((ConfigurationItem)duplicatedPhase);
        CiHelper.rewriteWithNewId((ConfigurationItem)duplicatedPhase, (String)newPhaseId);
        release.addBelow(originPhaseId, duplicatedPhase);
        Phase savedDuplicatedPhase = this.xlrRepository.handle(new PhaseCreateCommand(duplicatedPhase, release, Collections.emptyList()));
        this.eventBus.publish((XLReleaseEvent)new PhaseDuplicatedEvent(savedDuplicatedPhase));
        return savedDuplicatedPhase;
    }

    public Phase movePhase(Release release, MovementIndexes movementIndexes) {
        Phase movedPhase = release.movePhase(movementIndexes.getOriginIndex(), movementIndexes.getTargetIndex());
        Phase savedPhase = this.xlrRepository.handle(new PhaseMoveCommand(movedPhase));
        this.eventBus.publish((XLReleaseEvent)new PhaseMovedEvent(savedPhase, movementIndexes.getOriginIndex().intValue(), movementIndexes.getTargetIndex().intValue()));
        return savedPhase;
    }

    private boolean isScheduledStartDateUpdatable(Phase original, Phase updated) {
        return original.isPlanned() || Objects.equal((Object)original.getScheduledStartDate(), (Object)updated.getScheduledStartDate());
    }
}

