/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSeqLike;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.RichInt$;

public final class PhaseRestart$ {
    public static final PhaseRestart$ MODULE$;

    static {
        new PhaseRestart$();
    }

    @VisibleForTesting
    public String computePhaselessTaskId(String taskId) {
        return taskId.substring(Ids.phaseIdFrom((String)taskId).length() + 1);
    }

    public Map<PlanItem, PlanItem> buildOriginToRestored(Seq<Phase> phasesToRestore, Seq<Phase> restoredPhases) {
        return ((TraversableOnce)((TraversableLike)phasesToRestore.zip(restoredPhases, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<PlanItem, PlanItem>> apply(Tuple2<Phase, Phase> x0$1) {
                Tuple2<Phase, Phase> tuple2 = x0$1;
                if (tuple2 != null) {
                    Phase original = (Phase)tuple2._1();
                    Phase restored = (Phase)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)original), (Object)restored);
                    Seq seq = (Seq)PhaseRestart$.MODULE$.com$xebialabs$xlrelease$repository$PhaseRestart$$originToRestoredTasks$1(original, restored).$plus$colon((Object)tuple22, Seq$.MODULE$.canBuildFrom());
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @VisibleForTesting
    public List<Phase> getPhasesToRestore(Release release, String phaseId) {
        Predef$.MODULE$.require(release.hasPhase(phaseId), (Function0)new Serializable(release, phaseId){
            public static final long serialVersionUID = 0L;
            private final Release release$1;
            private final String phaseId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Phase with id ", " not found in release '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.phaseId$1, this.release$1.getTitle()}));
            }
            {
                this.release$1 = release$1;
                this.phaseId$1 = phaseId$1;
            }
        });
        int firstPhaseToRestoreIndex = release.getPhases().indexOf(release.getPhase(phaseId));
        Predef$.MODULE$.require(release.hasCurrentPhase(), (Function0)new Serializable(release){
            public static final long serialVersionUID = 0L;
            private final Release release$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release '", "' must have a current phase in order to restart phases"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.release$1.getTitle()}));
            }
            {
                this.release$1 = release$1;
            }
        });
        int currentPhaseIndex = release.getPhases().indexOf(release.getCurrentPhase());
        Predef$.MODULE$.require(currentPhaseIndex >= firstPhaseToRestoreIndex, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't restore a phase that is after the current phase.";
            }
        });
        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(release.getPhases()).slice(firstPhaseToRestoreIndex, currentPhaseIndex + 1));
    }

    public void checkIfPhaseCanBeRestartedFrom(Task task, Phase phase, PermissionChecker permissions) {
        if (task != null) {
            Preconditions.checkState((task.isDone() || task.isActive() ? 1 : 0) != 0, (String)"You can not restart from a task that hasn't been started", (Object[])new Object[]{null});
            int taskIndexToRestartFrom = ((GenSeqLike)JavaConversions$.MODULE$.asScalaBuffer(phase.getTasks()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Task x$3) {
                    return (String)CiHelper.TO_ID.apply(x$3);
                }
            }, Buffer$.MODULE$.canBuildFrom())).indexOf((Object)task.getId());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), taskIndexToRestartFrom).foreach$mVc$sp((Function1)new Serializable(phase, permissions){
                public static final long serialVersionUID = 0L;
                private final Phase phase$1;
                private final PermissionChecker permissions$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Task taskToSkip = (Task)this.phase$1.getTasks().get(i);
                    this.permissions$1.checkHasPermissionsToUpdateTask(taskToSkip);
                }
                {
                    this.phase$1 = phase$1;
                    this.permissions$1 = permissions$1;
                }
            });
        }
    }

    public final Seq com$xebialabs$xlrelease$repository$PhaseRestart$$originToRestoredTasks$1(Phase originalPhase, Phase restoredPhase) {
        Map phaselessTaskIdsToOriginalTasks = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(originalPhase.getAllTasks()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Task> apply(Task task) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PhaseRestart$.MODULE$.computePhaselessTaskId(task.getId())), (Object)task);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return (Seq)JavaConversions$.MODULE$.asScalaBuffer(restoredPhase.getAllTasks()).flatMap((Function1)new Serializable(phaselessTaskIdsToOriginalTasks){
            public static final long serialVersionUID = 0L;
            private final Map phaselessTaskIdsToOriginalTasks$1;

            public final Iterable<Tuple2<Task, Task>> apply(Task restoredTask) {
                String phaselessTaskId = PhaseRestart$.MODULE$.computePhaselessTaskId(restoredTask.getId());
                return Option$.MODULE$.option2Iterable(this.phaselessTaskIdsToOriginalTasks$1.get((Object)phaselessTaskId).map((Function1)new Serializable(this, restoredTask){
                    public static final long serialVersionUID = 0L;
                    private final Task restoredTask$1;

                    public final Tuple2<Task, Task> apply(Task x$1) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$1), (Object)this.restoredTask$1);
                    }
                    {
                        this.restoredTask$1 = restoredTask$1;
                    }
                }));
            }
            {
                this.phaselessTaskIdsToOriginalTasks$1 = phaselessTaskIdsToOriginalTasks$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    private PhaseRestart$() {
        MODULE$ = this;
    }
}

