/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Preconditions;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.GateConditionCreatedEvent;
import com.xebialabs.xlrelease.domain.events.GateConditionDeletedEvent;
import com.xebialabs.xlrelease.domain.events.GateConditionUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.GateConditionCreateCommand;
import com.xebialabs.xlrelease.repository.GateConditionDeleteCommand;
import com.xebialabs.xlrelease.repository.GateConditionGetCommand;
import com.xebialabs.xlrelease.repository.GateConditionUpdateCommand;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskGetCommand;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class GateConditions {
    private static final String DEFAULT_TITLE = "New Condition";
    private CiIdService ciIdService;
    private XlrRepository xlrRepository;
    private XLReleaseEventBus eventBus;

    @Autowired
    public GateConditions(XlrRepository xlrRepository, CiIdService ciIdService, XLReleaseEventBus eventBus) {
        this.xlrRepository = xlrRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
    }

    public GateCondition create(String parentId) {
        return this.create(parentId, DEFAULT_TITLE);
    }

    public GateCondition create(String gateId, String text) {
        GateTask gate = (GateTask)this.xlrRepository.handle(new TaskGetCommand(gateId));
        Preconditions.checkArgument((boolean)gate.isUpdatable(), (Object)"You can't add a condition to a finished gate");
        GateCondition condition = new GateCondition();
        condition.setId(this.ciIdService.getUniqueId(condition.getType(), gateId));
        condition.setTitle(text);
        gate.addCondition(condition);
        List<Variable> variables = this.updateVariables(gate);
        this.xlrRepository.handle(new GateConditionCreateCommand(condition, variables));
        this.eventBus.publish((XLReleaseEvent)new GateConditionCreatedEvent(gate, condition));
        return condition;
    }

    public GateCondition findById(String conditionId) {
        return this.xlrRepository.handle(new GateConditionGetCommand(conditionId));
    }

    public GateCondition update(String conditionId, GateCondition updatedCondition) {
        String gateId = Ids.getParentId((String)updatedCondition.getId());
        GateTask gate = (GateTask)this.xlrRepository.handle(new TaskGetCommand(gateId));
        Preconditions.checkArgument((boolean)gate.isUpdatable(), (Object)"You can't update a condition of a finished gate.");
        GateCondition condition = gate.getCondition(conditionId);
        GateCondition originalCondition = CiCloneHelper.cloneCi(condition);
        condition.setChecked(updatedCondition.isChecked());
        condition.setTitle(updatedCondition.getTitle());
        List<Variable> variables = this.updateVariables(gate);
        this.xlrRepository.handle(new GateConditionUpdateCommand(updatedCondition, variables));
        this.eventBus.publish((XLReleaseEvent)new GateConditionUpdatedEvent(gate, originalCondition, updatedCondition));
        return updatedCondition;
    }

    private List<Variable> updateVariables(GateTask gate) {
        Release release = gate.getRelease();
        return VariablePersistenceHelper.scanAndBuildNewVariables(release, (VisitableItem)gate, this.ciIdService);
    }

    public void delete(String conditionId) {
        String gateId = Ids.getParentId((String)conditionId);
        GateTask gate = (GateTask)this.xlrRepository.handle(new TaskGetCommand(gateId));
        Preconditions.checkArgument((boolean)gate.isUpdatable(), (Object)"You can't delete a condition from a finished gate");
        GateCondition gateCondition = this.findById(conditionId);
        this.xlrRepository.handle(new GateConditionDeleteCommand(gateCondition));
        this.eventBus.publish((XLReleaseEvent)new GateConditionDeletedEvent(gate, gateCondition));
    }
}

