/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.tasks.gate.TargetIdResolutionFailedException;
import com.xebialabs.xlrelease.repository.IdMatchers$PhaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$ReleaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$TaskId$;
import com.xebialabs.xlrelease.repository.PlanItemByIdQuery;
import com.xebialabs.xlrelease.repository.PlanItemExistsQuery;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u0017\tAB)\u001a9f]\u0012,gnY=UCJ<W\r\u001e*fg>dg/\u001a:\u000b\u0005\r!\u0011A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011QAB\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0002\u0005\u0002\u0013a,'-[1mC\n\u001c(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0003\u0005\u0014\u0001\t\u0005\t\u0015!\u0003\u0015\u0003)AHN])vKJLWm\u001d\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011!\u0002\u00177s#V,'/[3t\u0011!I\u0002A!A!\u0002\u0013Q\u0012\u0001E1sG\"Lg/\u001b8h'\u0016\u0014h/[2f!\tYb$D\u0001\u001d\u0015\tiB!A\u0004tKJ4\u0018nY3\n\u0005}a\"\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\u00191\u0005J\u0013\u0011\u0005U\u0001\u0001\"B\n!\u0001\u0004!\u0002\"B\r!\u0001\u0004Q\u0002F\u0001\u0011(!\tA3'D\u0001*\u0015\tQ3&\u0001\u0006b]:|G/\u0019;j_:T!\u0001L\u0017\u0002\u000f\u0019\f7\r^8ss*\u0011afL\u0001\u0006E\u0016\fgn\u001d\u0006\u0003aE\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002e\u0005\u0019qN]4\n\u0005QJ#!C!vi><\u0018N]3e\u0011\u00151\u0004\u0001\"\u00018\u00035\u0011Xm]8mm\u0016$\u0016M]4fiR\u0011\u0001h\u000f\t\u0003\u001beJ!A\u000f\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006yU\u0002\r!P\u0001\u000bI\u0016\u0004XM\u001c3f]\u000eL\bC\u0001 B\u001b\u0005y$B\u0001!\u0005\u0003\u0019!w.\\1j]&\u0011!i\u0010\u0002\u000b\t\u0016\u0004XM\u001c3f]\u000eL\b\"\u0002#\u0001\t\u0013)\u0015!\u0006:fg>dg/Z!sG\"Lg/\u001a3UCJ<W\r\u001e\u000b\u0004\r&\u0013\u0006C\u0001 H\u0013\tAuH\u0001\u0005QY\u0006t\u0017\n^3n\u0011\u0015Q5\t1\u0001L\u0003!!\u0018M]4fi&#\u0007C\u0001'P\u001d\tiQ*\u0003\u0002O\u001d\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tqe\u0002C\u0003T\u0007\u0002\u00071*\u0001\u0007eKB,g\u000eZ3oGfLE\r\u000b\u0002\u0001+B\u0011a+W\u0007\u0002/*\u0011\u0001lL\u0001\u000bgR,'/Z8usB,\u0017B\u0001.X\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class DependencyTargetResolver {
    private final XlrQueries xlrQueries;
    private final ArchivingService archivingService;

    public void resolveTarget(Dependency dependency) {
        String targetId = dependency.getTargetId();
        if (Strings.isNotEmpty((String)targetId) && !VariableHelper$.MODULE$.containsVariables(targetId) && !dependency.isArchived()) {
            if (Predef$.MODULE$.Boolean2boolean(this.xlrQueries.query(new PlanItemExistsQuery(targetId)))) {
                PlanItem planItem = (PlanItem)this.xlrQueries.query(new PlanItemByIdQuery(targetId, Predef$.MODULE$.int2Integer(Integer.MAX_VALUE)));
                dependency.setTarget(planItem);
            } else if (this.archivingService.exists(targetId)) {
                PlanItem target = this.resolveArchivedTarget(targetId, dependency.getId());
                dependency.setTarget(target);
                dependency.archive();
            } else {
                throw new TargetIdResolutionFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find target on dependency ", " by ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency.getId(), targetId})));
            }
        }
    }

    private PlanItem resolveArchivedTarget(String targetId, String dependencyId) {
        Release release;
        String string = targetId;
        Option<String> option = IdMatchers$ReleaseId$.MODULE$.unapply(string);
        if (option.isEmpty()) {
            Option<String> option2 = IdMatchers$PhaseId$.MODULE$.unapply(string);
            if (option2.isEmpty()) {
                Option<String> option3 = IdMatchers$TaskId$.MODULE$.unapply(string);
                if (option3.isEmpty()) {
                    throw new TargetIdResolutionFailedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid archived target on dependency ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependencyId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"it is not a plan item: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetId}))).toString());
                }
                release = this.archivingService.getTask(targetId);
            } else {
                release = this.archivingService.getPhase(targetId);
            }
        } else {
            release = this.archivingService.getRelease(targetId);
        }
        return release;
    }

    @Autowired
    public DependencyTargetResolver(XlrQueries xlrQueries, ArchivingService archivingService) {
        this.xlrQueries = xlrQueries;
        this.archivingService = archivingService;
    }
}

