/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.configuration.SpecialDay;
import com.xebialabs.xlrelease.domain.blackout.Blackout;
import com.xebialabs.xlrelease.domain.events.BlackoutCreatedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutDeletedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Calendar$;
import com.xebialabs.xlrelease.repository.CalendarSearchStrategy;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.util.Date;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Repository
@ScalaSignature(bytes="\u0006\u0001\u0005mv!B\u0001\u0003\u0011\u0003Y\u0011\u0001C\"bY\u0016tG-\u0019:\u000b\u0005\r!\u0011A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011QAB\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0002\u0005\u0002\u0013a,'-[1mC\n\u001c(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003\u0011\r\u000bG.\u001a8eCJ\u001c\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0004\u001b\u001b\t\u0007I\u0011A\u000e\u0002%\r\u000bE*\u0012(E\u0003J{F)\u0013*F\u0007R{%+W\u000b\u00029A\u0011Q\u0004\t\b\u0003#yI!a\b\n\u0002\rA\u0013X\rZ3g\u0013\t\t#E\u0001\u0004TiJLgn\u001a\u0006\u0003?IAa\u0001J\u0007!\u0002\u0013a\u0012aE\"B\u0019\u0016sE)\u0011*`\t&\u0013Vi\u0011+P%f\u0003\u0003\"\u0002\u0014\u000e\t\u00139\u0013AB7bW\u0016LE\r\u0006\u0002\u001dQ!)\u0011&\na\u00019\u0005!A-\u0019;f\r\u0011q!\u0001A\u0016\u0014\u0007)\u0002B\u0006\u0005\u0002.e5\taF\u0003\u00020a\u0005)1\u000f\u001c45U*\t\u0011'\u0001\u0005he&T(\u0010\\3e\u0013\t\u0019dFA\u0004M_\u001e<\u0017N\\4\t\u0011UR#Q1A\u0005\u0002Y\n\u0011C]3q_NLGo\u001c:z'\u0016\u0014h/[2f+\u00059\u0004C\u0001\u001d=\u001b\u0005I$BA\u0002;\u0015\tYd!\u0001\u0005eKBdw._5u\u0013\ti\u0014HA\tSKB|7/\u001b;pef\u001cVM\u001d<jG\u0016D\u0001b\u0010\u0016\u0003\u0002\u0003\u0006IaN\u0001\u0013e\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0007\u0005\u0003\u0005BU\t\u0015\r\u0011\"\u0001C\u0003Y\u0019\u0017\r\\3oI\u0006\u00148+Z1sG\"\u001cFO]1uK\u001eLX#A\"\u0011\u00051!\u0015BA#\u0003\u0005Y\u0019\u0015\r\\3oI\u0006\u00148+Z1sG\"\u001cFO]1uK\u001eL\b\u0002C$+\u0005\u0003\u0005\u000b\u0011B\"\u0002/\r\fG.\u001a8eCJ\u001cV-\u0019:dQN#(/\u0019;fOf\u0004\u0003\u0002C%+\u0005\u000b\u0007I\u0011\u0001&\u0002\u0017\rL\u0017\nZ*feZL7-Z\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011a\nB\u0001\bg\u0016\u0014h/[2f\u0013\t\u0001VJA\u0006DS&#7+\u001a:wS\u000e,\u0007\u0002\u0003*+\u0005\u0003\u0005\u000b\u0011B&\u0002\u0019\rL\u0017\nZ*feZL7-\u001a\u0011\t\u0011QS#Q1A\u0005\u0002U\u000b\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002-B\u0011qKW\u0007\u00021*\u0011\u0011\fB\u0001\u0007KZ,g\u000e^:\n\u0005mC&!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\"AQL\u000bB\u0001B\u0003%a+A\u0005fm\u0016tGOQ;tA!)qC\u000bC\u0001?R)\u0001-\u00192dIB\u0011AB\u000b\u0005\u0006ky\u0003\ra\u000e\u0005\u0006\u0003z\u0003\ra\u0011\u0005\u0006\u0013z\u0003\ra\u0013\u0005\u0006)z\u0003\rA\u0016\u0015\u0003=\u001a\u0004\"a\u001a:\u000e\u0003!T!!\u001b6\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002lY\u00069a-Y2u_JL(BA7o\u0003\u0015\u0011W-\u00198t\u0015\ty\u0007/A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\t\u0018aA8sO&\u00111\u000f\u001b\u0002\n\u0003V$xn^5sK\u0012DQ!\u001e\u0016\u0005\u0002Y\fQbZ3u'B,7-[1m\t\u0006LHCA<~!\tA80D\u0001z\u0015\tQH!A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0003yf\u0014!b\u00159fG&\fG\u000eR1z\u0011\u0015IC\u000f1\u0001\u001d\u0011\u0019y(\u0006\"\u0001\u0002\u0002\u0005i1/\u001a;Ta\u0016\u001c\u0017.\u00197ECf$Ra^A\u0002\u0003\u000bAQ!\u000b@A\u0002qAa!a\u0002\u007f\u0001\u00049\u0018AC:qK\u000eL\u0017\r\u001c#bs\"9\u00111\u0002\u0016\u0005\u0002\u00055\u0011AD4fiN\u0003XmY5bY\u0012\u000b\u0017p\u001d\u000b\u0007\u0003\u001f\ty\"a\t\u0011\u000b\u0005E\u00111D<\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\tA!\u001e;jY*\u0011\u0011\u0011D\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u0005M!\u0001\u0002'jgRDq!!\t\u0002\n\u0001\u0007A$\u0001\u0003ge>l\u0007bBA\u0013\u0003\u0013\u0001\r\u0001H\u0001\u0003i>Dq!!\u000b+\t\u0003\tY#A\u0006bI\u0012\u0014E.Y2l_V$H\u0003BA\u0017\u0003{\u0001B!a\f\u0002:5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0005cY\u0006\u001c7n\\;u\u0015\r\t9\u0004B\u0001\u0007I>l\u0017-\u001b8\n\t\u0005m\u0012\u0011\u0007\u0002\t\u00052\f7m[8vi\"A\u00111GA\u0014\u0001\u0004\ti\u0003C\u0004\u0002*)\"\t!!\u0011\u0015\r\u00055\u00121IA$\u0011\u001d\t)%a\u0010A\u0002q\t\u0001\u0002]1sK:$\u0018\n\u001a\u0005\t\u0003g\ty\u00041\u0001\u0002.!9\u00111\n\u0016\u0005\u0002\u00055\u0013AD;qI\u0006$XM\u00117bG.|W\u000f\u001e\u000b\u0005\u0003[\ty\u0005\u0003\u0005\u0002R\u0005%\u0003\u0019AA\u0017\u0003\u001d)\b\u000fZ1uK\u0012Dq!!\u0016+\t\u0003\t9&\u0001\beK2,G/\u001a\"mC\u000e\\w.\u001e;\u0015\t\u0005e\u0013q\f\t\u0004#\u0005m\u0013bAA/%\t!QK\\5u\u0011\u001d\t\t'a\u0015A\u0002q\t!B\u00197bG.|W\u000f^%e\u0011\u001d\t)G\u000bC\u0001\u0003O\n1bZ3u\u00052\f7m[8viR!\u0011QFA5\u0011\u001d\t\t'a\u0019A\u0002qAq!!\u001c+\t\u0003\ty'\u0001\u0007jg&s'\t\\1dW>,H\u000f\u0006\u0003\u0002r\u0005]\u0004cA\t\u0002t%\u0019\u0011Q\u000f\n\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011PA6\u0001\u0004\tY(A\u0002o_^\u0004B!!\u0005\u0002~%!\u0011qPA\n\u0005\u0011!\u0015\r^3\t\u000f\u0005\r%\u0006\"\u0001\u0002\u0006\u0006aq-\u001a;CY\u0006\u001c7n\\;ugR1\u0011qQAE\u0003\u0017\u0003b!!\u0005\u0002\u001c\u00055\u0002\u0002CA\u0011\u0003\u0003\u0003\r!a\u001f\t\u0011\u0005\u0015\u0012\u0011\u0011a\u0001\u0003wBq!a!+\t\u0003\ty\t\u0006\u0005\u0002\b\u0006E\u00151SAK\u0011\u001d\t)%!$A\u0002qA\u0001\"!\t\u0002\u000e\u0002\u0007\u00111\u0010\u0005\t\u0003K\ti\t1\u0001\u0002|!9\u00111\u0011\u0016\u0005\u0002\u0005eE\u0003BAD\u00037C\u0001\"!\u001f\u0002\u0018\u0002\u0007\u00111\u0010\u0005\b\u0003\u0007SC\u0011AAP)\u0019\t9)!)\u0002$\"9\u0011QIAO\u0001\u0004a\u0002\u0002CA=\u0003;\u0003\r!a\u001f\t\u000f\u0005\u001d&\u0006\"\u0001\u0002*\u0006Aa/\u00197jI\u0006$X\r\u0006\u0003\u0002Z\u0005-\u0006\u0002CA\u001a\u0003K\u0003\r!!\f)\u0007)\ny\u000b\u0005\u0003\u00022\u0006]VBAAZ\u0015\r\t)L\\\u0001\u000bgR,'/Z8usB,\u0017\u0002BA]\u0003g\u0013!BU3q_NLGo\u001c:z\u0001")
public class Calendar
implements Logging {
    private final RepositoryService repositoryService;
    private final CalendarSearchStrategy calendarSearchStrategy;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public static String CALENDAR_DIRECTORY() {
        return Calendar$.MODULE$.CALENDAR_DIRECTORY();
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Calendar calendar = this;
        synchronized (calendar) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, (Marker)mkr, msg, t);
    }

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public CalendarSearchStrategy calendarSearchStrategy() {
        return this.calendarSearchStrategy;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    public SpecialDay getSpecialDay(String date) {
        SpecialDay specialDay;
        String specialDayId = Calendar$.MODULE$.com$xebialabs$xlrelease$repository$Calendar$$makeId(date);
        if (this.repositoryService().exists(specialDayId)) {
            specialDay = (SpecialDay)this.repositoryService().read(specialDayId);
        } else {
            void var3_3;
            SpecialDay result2 = new SpecialDay();
            result2.setId(specialDayId);
            specialDay = var3_3;
        }
        return specialDay;
    }

    public SpecialDay setSpecialDay(String date, SpecialDay specialDay) {
        String specialDayId = Calendar$.MODULE$.com$xebialabs$xlrelease$repository$Calendar$$makeId(date);
        if (specialDay.isBlank()) {
            if (this.repositoryService().exists(specialDayId)) {
                this.repositoryService().delete(new String[]{specialDayId});
            }
        } else {
            specialDay.setId(specialDayId);
            specialDay.setDate(date);
            this.repositoryService().createOrUpdate((ConfigurationItem[])new SpecialDay[]{specialDay});
        }
        return specialDay;
    }

    public List<SpecialDay> getSpecialDays(String from, String to) {
        return JavaConversions$.MODULE$.seqAsJavaList(this.calendarSearchStrategy().getSpecialDays(from, to));
    }

    public Blackout addBlackout(Blackout blackout) {
        return this.addBlackout(Calendar$.MODULE$.CALENDAR_DIRECTORY(), blackout);
    }

    public Blackout addBlackout(String parentId, Blackout blackout) {
        this.logger().debug((Function0)new Serializable(this, parentId, blackout){
            public static final long serialVersionUID = 0L;
            private final String parentId$1;
            private final Blackout blackout$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding new blackout [", " for period [", "] - [", "] to parent [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blackout$1.getLabel(), this.blackout$1.getStartDate(), this.blackout$1.getEndDate(), this.parentId$1}));
            }
            {
                this.parentId$1 = parentId$1;
                this.blackout$1 = blackout$1;
            }
        });
        this.validate(blackout);
        blackout.setId(this.ciIdService().getUniqueId(Type.valueOf(Blackout.class), parentId));
        this.repositoryService().createOrUpdate((ConfigurationItem[])new Blackout[]{blackout});
        this.eventBus().publish((XLReleaseEvent)new BlackoutCreatedEvent(blackout));
        return (Blackout)this.repositoryService().read(blackout.getId(), false);
    }

    public Blackout updateBlackout(Blackout updated) {
        this.logger().debug((Function0)new Serializable(this, updated){
            public static final long serialVersionUID = 0L;
            private final Blackout updated$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating blackout [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.updated$1.getId()}));
            }
            {
                this.updated$1 = updated$1;
            }
        });
        this.validate(updated);
        Blackout original = (Blackout)this.repositoryService().read(updated.getId());
        this.repositoryService().update((ConfigurationItem[])new Blackout[]{updated});
        this.eventBus().publish((XLReleaseEvent)new BlackoutUpdatedEvent(original, updated));
        return (Blackout)this.repositoryService().read(updated.getId(), false);
    }

    public void deleteBlackout(String blackoutId) {
        this.logger().debug((Function0)new Serializable(this, blackoutId){
            public static final long serialVersionUID = 0L;
            private final String blackoutId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting blackout [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blackoutId$1}));
            }
            {
                this.blackoutId$1 = blackoutId$1;
            }
        });
        Blackout blackout = (Blackout)this.repositoryService().read(blackoutId);
        this.repositoryService().delete(new String[]{blackoutId});
        this.eventBus().publish((XLReleaseEvent)new BlackoutDeletedEvent(blackout));
    }

    public Blackout getBlackout(String blackoutId) {
        return (Blackout)this.repositoryService().read(blackoutId);
    }

    public boolean isInBlackout(Date now) {
        return this.getBlackouts(now).size() > 0;
    }

    public List<Blackout> getBlackouts(Date from, Date to) {
        return this.getBlackouts(Calendar$.MODULE$.CALENDAR_DIRECTORY(), from, to);
    }

    public List<Blackout> getBlackouts(String parentId, Date from, Date to) {
        return JavaConversions$.MODULE$.seqAsJavaList(this.calendarSearchStrategy().getBlackouts(parentId, from, to));
    }

    public List<Blackout> getBlackouts(Date now) {
        return this.getBlackouts(Calendar$.MODULE$.CALENDAR_DIRECTORY(), now);
    }

    public List<Blackout> getBlackouts(String parentId, Date now) {
        return JavaConversions$.MODULE$.seqAsJavaList(this.calendarSearchStrategy().getBlackouts(parentId, now, now));
    }

    public void validate(Blackout blackout) {
        Checks.checkNotNull((Object)blackout.getLabel(), (String)"Blackout label");
        Checks.checkNotNull((Object)blackout.getStartDate(), (String)"Blackout start date");
        Checks.checkNotNull((Object)blackout.getEndDate(), (String)"Blackout end date");
        Checks.checkArgument((boolean)blackout.getStartDate().before(blackout.getEndDate()), (String)"Blackout end date must be after start date.", (Object[])new Object[0]);
    }

    @Autowired
    public Calendar(RepositoryService repositoryService, CalendarSearchStrategy calendarSearchStrategy, CiIdService ciIdService, XLReleaseEventBus eventBus) {
        this.repositoryService = repositoryService;
        this.calendarSearchStrategy = calendarSearchStrategy;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        Logging.class.$init$((Logging)this);
    }
}

