/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.mbeans;

import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@Component
@ManagedResource(objectName="com.xebialabs.xlrelease:name=Archiving", description="MBean to configure the release archiving service")
public class ArchivingSettingsManagerMBean {
    private ArchivingSettingsManager archivingSettingsManager;

    @Autowired
    public ArchivingSettingsManagerMBean(ArchivingSettingsManager archivingSettingsManager) {
        this.archivingSettingsManager = archivingSettingsManager;
    }

    @ManagedAttribute(description="Enable archiving")
    public boolean getEnabled() {
        return this.archivingSettingsManager.getEnabled();
    }

    @ManagedAttribute(description="Enable archiving")
    public void setEnabled(boolean val) {
        this.archivingSettingsManager.setEnabled(val);
    }

    @ManagedAttribute(description="Number of archivable releases to retrieve from the repository in a single search query")
    public int getSearchPageSize() {
        return this.archivingSettingsManager.getSearchPageSize();
    }

    @ManagedAttribute(description="Number of archivable releases to retrieve from the repository in a single search query")
    public void setSearchPageSize(int val) {
        this.archivingSettingsManager.setSearchPageSize(val);
    }

    @ManagedAttribute(description="Number of seconds that archiving is allowed to run before it is paused until the next time it is scheduled")
    public int getMaxSecondsPerRun() {
        return this.archivingSettingsManager.getMaxSecondsPerRun();
    }

    @ManagedAttribute(description="Number of seconds that archiving is allowed to run before it is paused until the next time it is scheduled")
    public void setMaxSecondsPerRun(int val) {
        this.archivingSettingsManager.setMaxSecondsPerRun(val);
    }

    @ManagedAttribute(description="Number of seconds to sleep between archiving individual releases within a single run")
    public int getSleepSecondsBetweenReleases() {
        return this.archivingSettingsManager.getSleepSecondsBetweenReleases();
    }

    @ManagedAttribute(description="Number of seconds to sleep between archiving individual releases within a single run")
    public void setSleepSecondsBetweenReleases(int val) {
        this.archivingSettingsManager.setSleepSecondsBetweenReleases(val);
    }

    @ManagedAttribute(description="Archiving job CRON schedule, configurable in deployit-defaults.properties")
    public String getJobCronSchedule() {
        return this.archivingSettingsManager.getArchivingJobCronSchedule();
    }

    @ManagedAttribute(description="Archive completed releases older than (in hours, configurable in UI)")
    public Integer getReleaseAgeToDeleteFromJcr() {
        return this.archivingSettingsManager.getReleaseAgeToDeleteFromJcr();
    }
}

