/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.initialize;

import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.server.api.upgrade.RepositoryInitialization;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.export.TemplateImporter;
import com.xebialabs.xlrelease.upgrade.Components;
import com.xebialabs.xlrelease.views.ImportResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class SampleTemplatesInitialization
implements RepositoryInitialization {
    private static final Logger logger = LoggerFactory.getLogger(SampleTemplatesInitialization.class);
    public static final String WELCOME_TEMPLATES_CREATED_PROPERTY = "welcomeTemplatesCreated";
    public static final String TEMPLATE_WELCOME_ID = "Applications/ReleaseTemplate_welcome";
    public static final String TEMPLATE_CONFIGURE_ID = "Applications/ReleaseTemplate_configure";
    public static final String TEMPLATE_TOUR_ID = "Applications/ReleaseTemplate_tour";
    public static final String TEMPLATE_SAMPLE_ID = "Applications/ReleaseTemplate_sample";
    public static final String TEMPLATE_SAMPLE_WITH_XLD_ID = "Applications/ReleaseTemplate_sample_with_Deployit";
    public static final String FOLDER_TEMPLATE_WELCOME_ID = "Applications/FolderSamplesAndTutorials/ReleaseTemplate_welcome";
    public static final String FOLDER_TEMPLATE_CONFIGURE_ID = "Applications/FolderSamplesAndTutorials/ReleaseTemplate_configure";
    private TemplateImporter templateImporter;
    private XlrConfig xlrConfig;
    private WorkDirContext workDirContext;
    private Map<String, String> sampleTemplates = new LinkedHashMap<String, String>(){
        {
            this.put("templates/welcome.json", SampleTemplatesInitialization.TEMPLATE_WELCOME_ID);
            this.put("templates/configure.json", SampleTemplatesInitialization.TEMPLATE_CONFIGURE_ID);
            this.put("templates/tour.json", SampleTemplatesInitialization.TEMPLATE_TOUR_ID);
            this.put("templates/sample.json", SampleTemplatesInitialization.TEMPLATE_SAMPLE_ID);
        }
    };

    @Autowired
    public SampleTemplatesInitialization(TemplateImporter templateImporter, XlrConfig xlrConfig, WorkDirContext workDirContext) {
        this.templateImporter = templateImporter;
        this.xlrConfig = xlrConfig;
        this.workDirContext = workDirContext;
    }

    public void doInitialize() {
        if (this.xlrConfig.initialization_createSampleTemplates()) {
            logger.info("Importing sample templates");
            this.importSampleTemplates();
        } else {
            logger.info("Skipping import of sample templates");
        }
    }

    private void importSampleTemplates() {
        WorkDirContext.initWorkdir((String)"import");
        try {
            for (Map.Entry<String, String> template : this.sampleTemplates.entrySet()) {
                this.importTemplate(template.getKey(), template.getValue());
            }
        }
        finally {
            WorkDirContext.get().delete();
            WorkDirContext.clear();
        }
    }

    private void importTemplate(String classpathResource, String destinationId) {
        byte[] template = SampleTemplatesInitialization.getTemplate(classpathResource);
        if (template == null) {
            return;
        }
        ImportResult result2 = this.templateImporter.importDefaultTemplate(new ByteArrayInputStream(template)).get(0);
        logger.info("Imported template {} from {}", (Object)destinationId, (Object)classpathResource);
        for (String warning : result2.getWarnings()) {
            logger.info("  Warning: {}", (Object)warning);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getTemplate(String classpathResource) {
        try (InputStream in = new ClassPathResource(classpathResource).getInputStream();){
            if (in == null) {
                logger.warn("Could not find template {}", (Object)classpathResource);
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray = ByteStreams.toByteArray((InputStream)in);
            return byArray;
        }
        catch (IOException e) {
            logger.warn("Could not load template {}: {}", (Object)classpathResource, (Object)e.toString());
            return null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public String getComponent() {
        return Components.XL_RELEASE_COMPONENT;
    }
}

