/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.excel;

import com.xebialabs.xlrelease.api.internal.ReportResource;
import com.xebialabs.xlrelease.excel.TopLongestPhaseExport;
import com.xebialabs.xlrelease.excel.TopLongestReleaseExport;
import com.xebialabs.xlrelease.excel.TopLongestTaskExport;
import com.xebialabs.xlrelease.excel.TopPeopleMostInvolvedExport;
import com.xebialabs.xlrelease.reports.PhaseDuration;
import com.xebialabs.xlrelease.reports.ReleaseDuration;
import com.xebialabs.xlrelease.reports.TaskDuration;
import com.xebialabs.xlrelease.reports.UserParticipation;
import com.xebialabs.xlrelease.service.ReportServiceCache;
import com.xebialabs.xlrelease.views.TimeFrame;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportExcel {
    private ReportServiceCache reportService;

    @Autowired
    public ReportExcel(ReportServiceCache reportService) {
        this.reportService = reportService;
    }

    public Workbook getWorkBook(ReportResource.ReportType report, TimeFrame timeFrame, List<String> tags, Date from, Date to) {
        switch (report) {
            case TOP_LONGEST_RELEASE: {
                return this.exportTopLongestRelease(timeFrame, tags, from, to);
            }
            case TOP_LONGEST_PHASE: {
                return this.exportTopLongestPhase(timeFrame, tags, from, to);
            }
            case TOP_LONGEST_TASK: {
                return this.exportTopLongestTask(timeFrame, tags, from, to);
            }
            case TOP_PEOPLE_MOST_INVOLVED: {
                return this.exportTopPeopleMostInvolved(timeFrame, tags, from, to);
            }
        }
        throw new IllegalArgumentException("Can't generate excel for report " + report.name());
    }

    private Workbook exportTopLongestRelease(TimeFrame timeFrame, List<String> tags, Date from, Date to) {
        List<ReleaseDuration> topLongestReleases = this.reportService.getReleaseDuration(timeFrame, tags, from, to).getLongestReleases();
        return new TopLongestReleaseExport(topLongestReleases).getWorkBook();
    }

    private Workbook exportTopLongestPhase(TimeFrame timeFrame, List<String> tags, Date from, Date to) {
        List<PhaseDuration> topLongestPhases = this.reportService.getTopLongestPhases(timeFrame, tags, from, to);
        return new TopLongestPhaseExport(topLongestPhases).getWorkBook();
    }

    private Workbook exportTopLongestTask(TimeFrame timeFrame, List<String> tags, Date from, Date to) {
        List<TaskDuration> topLongestTasks = this.reportService.getTopLongestTasks(timeFrame, tags, from, to);
        return new TopLongestTaskExport(topLongestTasks).getWorkBook();
    }

    private Workbook exportTopPeopleMostInvolved(TimeFrame timeFrame, List<String> tags, Date from, Date to) {
        List<UserParticipation> topPeopleMostInvolved = this.reportService.getTopPeopleMostInvolved(timeFrame, tags, from, to);
        return new TopPeopleMostInvolvedExport(topPeopleMostInvolved).getWorkBook();
    }
}

