/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.content;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.StartWelcomeReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseEditor;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.views.ReleaseForm;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.VariableView;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.Subscribe;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Templates {
    private static final Logger logger = LoggerFactory.getLogger(Templates.class);
    private final Releases releases;
    private final ReleaseActorService releaseActorService;
    private final ReleaseEditor releaseEditor;
    private final UserInfoResolver userInfoResolver;
    private final XLReleaseEventBus eventBus;
    private final Scheduler scheduler;

    @Autowired
    public Templates(Releases releases, ReleaseActorService releaseActorService, ReleaseEditor releaseEditor, UserInfoResolver userInfoResolver, XLReleaseEventBus eventBus, Scheduler scheduler) {
        this.releases = releases;
        this.releaseActorService = releaseActorService;
        this.releaseEditor = releaseEditor;
        this.userInfoResolver = userInfoResolver;
        this.eventBus = eventBus;
        this.scheduler = scheduler;
    }

    @Subscribe
    public void startWelcomeReleaseAsync(StartWelcomeReleaseEvent startWelcomeReleaseEvent) {
        this.scheduler.execute(() -> this.startWelcomeRelease(startWelcomeReleaseEvent.getUsername()));
    }

    private void startWelcomeRelease(String username) {
        String fullNameOrUsername = this.userInfoResolver.getFullNameOrUsernameOf(username);
        this.startRelease(username, "Applications/FolderSamplesAndTutorials/ReleaseTemplate_welcome", "Welcome " + fullNameOrUsername);
        if (XLReleasePermissions.isAdmin((String)username)) {
            this.startRelease(username, "Applications/FolderSamplesAndTutorials/ReleaseTemplate_configure", "Configure XL Release");
        }
    }

    private void startRelease(String username, String templateId, String title) {
        if (!this.releases.exists(templateId)) {
            logger.info("Skipping creation of welcome release because template {} is not in the repository", (Object)templateId);
            return;
        }
        ReleaseForm releaseData = new ReleaseForm();
        releaseData.setOwner(new UserView(username, this.getFullname(username)));
        releaseData.setScheduledStartDate(new DateTime().withHourOfDay(17).withMinuteOfHour(0).toDate());
        releaseData.setDueDate(new DateTime().plusDays(7).withHourOfDay(17).withMinuteOfHour(0).toDate());
        releaseData.setTitle(title);
        releaseData.setVariables(Lists.newArrayList((Object[])new VariableView[]{new VariableView("${user}", username)}));
        Release sourceTemplate = this.releases.findById(templateId);
        releaseData.setTags(sourceTemplate.getTags());
        Release welcomeRelease = this.releaseEditor.createFromTemplate(templateId, releaseData.toRelease());
        this.releaseActorService.startRelease(welcomeRelease.getId(), User.AUTHENTICATED_USER);
    }

    private String getFullname(String username) {
        String fullName = null;
        if (username != null && !VariableHelper.containsVariables((String)username)) {
            fullName = this.userInfoResolver.getFullNameOf(username);
        }
        return fullName;
    }

    @PostConstruct
    public void postConstruct() {
        this.eventBus.register(this);
    }

    @PreDestroy
    public void preDestroy() {
        this.eventBus.deregister(this);
    }
}

