/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.internal.UploadResource;
import com.xebialabs.xlrelease.api.v1.TeamFacade;
import com.xebialabs.xlrelease.api.v1.VariableComponent;
import com.xebialabs.xlrelease.api.v1.forms.CreateRelease;
import com.xebialabs.xlrelease.api.v1.forms.StartRelease;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.export.TemplateImporter;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseEditor;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import com.xebialabs.xlrelease.views.ImportResult;
import com.xebialabs.xlrelease.views.TemplateFilters;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.fileupload.FileUploadException;
import org.joda.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Api(value="templates", description="Template API")
@Path(value="/api/v1/templates")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class TemplateApi
implements ApiService {
    public static final String SERVICE_NAME = "templateApi";
    private ReleaseActorService releaseActorService;
    private PermissionChecker permissions;
    private ReleaseEditor releaseEditor;
    private Releases releases;
    private ReleaseSearchService releaseSearchService;
    private TemplateImporter templateImporter;
    private UploadResource uploadResource;
    private VariableComponent variableComponent;
    private CiIdService ciIdService;
    private TeamFacade teamFacade;

    @Autowired
    public TemplateApi(ReleaseActorService releaseActorService, PermissionChecker permissions, ReleaseEditor releaseEditor, Releases releases, ReleaseSearchService releaseSearchService, TemplateImporter templateImporter, UploadResource uploadResource, VariableComponent variableComponent, CiIdService ciIdService, TeamFacade teamFacade) {
        this.releaseActorService = releaseActorService;
        this.permissions = permissions;
        this.releaseEditor = releaseEditor;
        this.releases = releases;
        this.releaseSearchService = releaseSearchService;
        this.templateImporter = templateImporter;
        this.uploadResource = uploadResource;
        this.variableComponent = variableComponent;
        this.ciIdService = ciIdService;
        this.teamFacade = teamFacade;
    }

    @Override
    public String serviceName() {
        return SERVICE_NAME;
    }

    @GET
    @ApiOperation(value="Gets the list of templates", response=Release.class, responseContainer="List")
    @PublicApiMember
    public List<Release> getTemplates(@QueryParam(value="title") @ApiParam(value="An optional title of the template") String title, @QueryParam(value="tag") @ApiParam(value="An optional list of tags of the template") List<String> tags, @DefaultValue(value="0") @QueryParam(value="page") @ApiParam(value="The (optional) page of results to return. Default value is 0.") Long page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") @ApiParam(value="The (optional) number of results per page. Default value is 100.") Long resultsPerPage, @DefaultValue(value="1") @QueryParam(value="depth") @ApiParam(value="The (optional) depth to search for. Default value is 1.") Integer depth) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        TemplateFilters templateFilters = new TemplateFilters();
        templateFilters.setTitle(title);
        templateFilters.setTags(tags);
        ReleaseSearchResult searchResult = this.releaseSearchService.searchTemplates(templateFilters, page, resultsPerPage, depth);
        return searchResult.getReleases();
    }

    @PublicApiMember
    public List<Release> getTemplates(@QueryParam(value="title") @ApiParam(value="An optional search filter containing the title or tag of the template") String filter) {
        return this.getTemplates(filter, null, 0L, 100L, 1);
    }

    @PUT
    @Path(value="/{templateId:.*Release[^/]*}")
    @ApiOperation(value="Updates a template", response=Release.class, responseContainer="List")
    @PublicApiMember
    public Release updateTemplate(@PathParam(value="templateId") @ApiParam(value="Full template identifier; for example, Applications/Release1") String templateId, @ApiParam(value="The updated template object") Release template) {
        this.permissions.checkEdit(templateId);
        return this.releaseActorService.updateTemplate(templateId, template);
    }

    @PublicApiMember
    public Release updateTemplate(Release template) {
        return this.updateTemplate(template.getId(), template);
    }

    @POST
    @ApiOperation(value="Creates a template", response=Release.class)
    @PublicApiMember
    public Release createTemplate(@ApiParam(value="The release template; only the template properties are processed, for nested items please use corresponding API objects like phaseApi and taskApi.") Release template) {
        this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        CiHelper.stripChildrenCis((ConfigurationItem)template);
        Checks.checkArgument((boolean)template.hasTitle(), (String)"Template title is mandatory", (Object[])new Object[0]);
        Checks.checkArgument((boolean)template.hasValidStartDates(), (String)"Dates are not valid", (Object[])new Object[0]);
        Checks.checkArgument((boolean)template.isTemplate(), (String)"Only templates can be created", (Object[])new Object[0]);
        return this.releaseEditor.createTemplate(template);
    }

    @POST
    @Path(value="/import")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Imports a template, serialized in JSON format", response=ImportResult.class, responseContainer="List")
    @PublicApiMember
    public List<ImportResult> importTemplate(@ApiParam(value="JSON representation of the imported template") String json, @QueryParam(value="folderId") @ApiParam(value="Optional folder ID where the template will be imported") String folderId) {
        ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes());
        if (Ids.isNullId((String)folderId)) {
            this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        } else {
            this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, folderId);
        }
        return this.templateImporter.importReleaseStream(stream, true, folderId);
    }

    @POST
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    @ApiOperation(value="Imports a template, serialized in XLR format", notes="Content must be sent as a multipart/form stream", response=ImportResult.class, responseContainer="List")
    public List<ImportResult> importTemplateAsXlr(@Context HttpServletRequest request, @QueryParam(value="folderId") @ApiParam(value="Optional folder ID where the template will be imported") String folderId) throws IOException, FileUploadException {
        return this.uploadResource.importTemplates(request, folderId);
    }

    @GET
    @Path(value="/{templateId:.*Release[^/]*}")
    @ApiOperation(value="Returns the template for the given ID", response=Release.class)
    @PublicApiMember
    public Release getTemplate(@PathParam(value="templateId") @ApiParam(value="Full template identifier; for example, Applications/Release1") String templateId) {
        Release template = this.releases.findById(templateId);
        this.permissions.checkView(template);
        return template;
    }

    @DELETE
    @Path(value="/{templateId:.*Release[^/]*}")
    @ApiOperation(value="Deletes a template")
    @PublicApiMember
    public void deleteTemplate(@PathParam(value="templateId") @ApiParam(value="Full template identifier; for example, Applications/Release1") String templateId) {
        this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        this.releaseActorService.deleteTemplate(templateId);
    }

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/create")
    @ApiOperation(value="Creates a release from a template, but does not start the release", response=Release.class)
    @PublicApiMember
    public Release create(@PathParam(value="templateId") @ApiParam(value="Full template identifier; for example, Applications/Release1") String templateId, @ApiParam(value="CreateRelease object containing the releases parameters; for example, {\"releaseTitle\":\"MyRelease\", \"releaseVariables\": {\"var1\": \"value1\"}}") CreateRelease createRelease) {
        this.permissions.checkIsAllowedToCreateReleaseFromTemplate(templateId);
        Checks.checkArgument((createRelease.getReleaseTitle() != null ? 1 : 0) != 0, (String)"Release title is mandatory", (Object[])new Object[0]);
        Release releaseMetadata = this.releases.findById(templateId);
        releaseMetadata.setId(null);
        releaseMetadata.setTitle(createRelease.getReleaseTitle());
        releaseMetadata.setVariableValues(createRelease.getReleaseVariables());
        releaseMetadata.setPasswordVariableValues(createRelease.getReleasePasswordVariables());
        releaseMetadata.setAutoStart(createRelease.getAutoStart());
        this.releaseEditor.setDatesFromTemplate(releaseMetadata, releaseMetadata, createRelease.hasScheduledStartDate() ? new LocalDateTime((Object)createRelease.getScheduledStartDate()) : LocalDateTime.now());
        VariablePersistenceHelper.fixUpVariableIds(releaseMetadata.getId(), releaseMetadata.getVariables(), this.ciIdService);
        return this.releaseEditor.createFromTemplate(templateId, releaseMetadata);
    }

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/start")
    @ApiOperation(value="Creates a release from a template and starts the release", response=Release.class)
    @PublicApiMember
    public Release start(@PathParam(value="templateId") @ApiParam(value="Full template identifier; for example Applications/Release1") String templateId, @ApiParam(value="StartRelease object containing the releases parameters; for example, {\"releaseTitle\":\"MyRelease\", \"releaseVariables\": {\"var1\": \"value1\"}}") StartRelease startRelease) {
        Release release = this.create(templateId, startRelease);
        return this.releaseActorService.startRelease(release.getId(), User.AUTHENTICATED_USER);
    }

    @GET
    @Path(value="/{templateId:.*Release[^/]*}/variables")
    @ApiOperation(value="Gets the variables in a template", response=com.xebialabs.xlrelease.domain.variables.Variable.class, responseContainer="List")
    @PublicApiMember
    public List<com.xebialabs.xlrelease.domain.variables.Variable> getVariables(@PathParam(value="templateId") @ApiParam(value="Full identifier of the template; for example, Applications/Release1") String templateId) {
        return this.variableComponent.getVariables(templateId);
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @ApiOperation(value="Returns the variable for the given ID", response=com.xebialabs.xlrelease.domain.variables.Variable.class)
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable getVariable(@PathParam(value="variableId") @ApiParam(value="Full identifier of the variable; for example, Applications/Release1/Variable1") String variableId) {
        return this.variableComponent.getVariable(variableId);
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/possibleValues")
    @ApiOperation(value="Returns possible values of the variable with the given ID", response=Object.class, responseContainer="List")
    @PublicApiMember
    public Collection<Object> getVariablePossibleValues(@PathParam(value="variableId") @ApiParam(value="Full identifier of the variable; for example, Applications/Release1/Variable1") String variableId) {
        return this.variableComponent.getVariablePossibleValues(variableId);
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/used")
    @ApiOperation(value="Returns true if a variable with the given ID is used in the template", response=Boolean.class)
    @PublicApiMember
    public Boolean isVariableUsed(@PathParam(value="variableId") @ApiParam(value="Full identifier of the variable, e.g. Applications/Release1/Variable1") String variableId) {
        return this.variableComponent.isVariableUsed(variableId);
    }

    @POST
    @Path(value="/{variableId:.*/Variable[^/]*}/replace")
    @ApiOperation(value="Replaces variable occurrences with the given value")
    @PublicApiMember
    public void replaceVariable(@PathParam(value="variableId") @ApiParam(value="Full identifier of the variable; for example, Applications/Release1/Variable1") String variableId, @ApiParam(value="Replacement for the variable") VariableOrValue variableOrValue) {
        this.variableComponent.replaceVariable(variableId, variableOrValue);
    }

    @DELETE
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @ApiOperation(value="Deletes a variable from a template")
    @PublicApiMember
    public void deleteVariable(@PathParam(value="variableId") @ApiParam(value="Full identifier of the variable; for example, Applications/Release1/Variable1") String variableId) {
        this.variableComponent.deleteVariable(variableId);
    }

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/variables")
    @ApiOperation(value="Creates a new variable", response=com.xebialabs.xlrelease.domain.variables.Variable.class)
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable createVariable(@PathParam(value="templateId") @ApiParam(value="Full identifier of the template; for example, Applications/Release1") String templateId, @ApiParam(value="The variable object; for example, {\"key\": \"var1\"}") Variable variable) {
        return this.variableComponent.createVariable(templateId, variable);
    }

    @PUT
    @Path(value="/{releaseId:.*Release[^/]*}/variables")
    @ApiOperation(value="Updates the variable list", response=com.xebialabs.xlrelease.domain.variables.Variable.class, responseContainer="List")
    @PublicApiMember
    public List<com.xebialabs.xlrelease.domain.variables.Variable> updateVariables(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId, @ApiParam(value="List of variables to update") List<com.xebialabs.xlrelease.domain.variables.Variable> variables) {
        return this.variableComponent.updateVariables(releaseId, variables);
    }

    @PUT
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @ApiOperation(value="Updates the properties of a variable", response=com.xebialabs.xlrelease.domain.variables.Variable.class)
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(@PathParam(value="variableId") @ApiParam(value="Full identifier of the variable; for example, Applications/Release1/Variable1") String variableId, @ApiParam(value="The updated variable object") com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.variableComponent.updateVariable(variableId, variable);
    }

    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.variableComponent.updateVariable(variable.getId(), variable);
    }

    @GET
    @Path(value="/permissions")
    @PublicApiMember
    public List<String> getPermissions() {
        return XLReleasePermissions.getTemplatePermissions();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/]*}/teams")
    @ApiOperation(value="Returns effective teams of the template")
    @PublicApiMember
    public List<TeamView> getTeams(@PathParam(value="templateId") String templateId) {
        return this.teamFacade.getTeams(templateId);
    }

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/teams")
    @ApiOperation(value="Sets teams, team members and permissions of the template")
    @PublicApiMember
    public List<TeamView> setTeams(@PathParam(value="templateId") String templateId, List<TeamView> teamDtos) {
        return this.teamFacade.setTeams(templateId, teamDtos);
    }
}

