/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class TeamFacade {
    private PermissionChecker permissions;
    private Teams teams;
    private UserInfoResolver userInfoResolver;
    private ReleaseActorService releaseActorService;

    @Autowired
    public TeamFacade(PermissionChecker permissions, Teams teams, UserInfoResolver userInfoResolver, ReleaseActorService releaseActorService) {
        this.permissions = permissions;
        this.teams = teams;
        this.userInfoResolver = userInfoResolver;
        this.releaseActorService = releaseActorService;
    }

    public List<TeamView> getTeams(String containerId) {
        this.checkEdit(containerId);
        return this.teams.getEffectiveTeams(containerId).stream().map(team -> new TeamView((Team)team, this.userInfoResolver)).collect(Collectors.toList());
    }

    public List<TeamView> setTeams(String containerId, List<TeamView> teamsToUpdate) {
        Checks.checkNotNull(teamsToUpdate, (String)"No teams submitted for update.");
        this.checkEdit(containerId);
        this.checkPermissions(teamsToUpdate);
        List<Team> submittedTeams = teamsToUpdate.stream().map(TeamView::toTeam).collect(Collectors.toList());
        List<Team> updatedTeams = Ids.isReleaseId((String)containerId) ? this.releaseActorService.updateTeams(containerId, submittedTeams) : this.teams.saveTeamsToPlatform(containerId, submittedTeams);
        return updatedTeams.stream().map(team -> new TeamView((Team)team, this.userInfoResolver)).collect(Collectors.toList());
    }

    private void checkPermissions(List<TeamView> teamsToUpdate) {
        TreeSet unknownPermissions = new TreeSet();
        teamsToUpdate.forEach(t -> unknownPermissions.addAll(t.getPermissions().stream().filter(p -> Permission.find((String)p) == null).collect(Collectors.toList())));
        Checks.checkArgument((boolean)unknownPermissions.isEmpty(), (String)"Unknown permissions found: '%s'", (Object[])new Object[]{unknownPermissions.stream().collect(Collectors.joining(", "))});
    }

    private void checkEdit(String teamContainerId) {
        if (Ids.isReleaseId((String)teamContainerId)) {
            this.permissions.checkEdit(teamContainerId);
        } else if (Ids.isFolderId((String)teamContainerId)) {
            this.permissions.check(XLReleasePermissions.EDIT_FOLDER_SECURITY, teamContainerId);
        } else {
            throw new Checks.IncorrectArgumentException("[%s] is not a release or a folder", new Object[]{teamContainerId});
        }
    }
}

