/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.Comment;
import com.xebialabs.xlrelease.api.v1.forms.Condition;
import com.xebialabs.xlrelease.api.v1.forms.StartTask;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.GateConditions;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.UploadService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.jboss.resteasy.spi.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Api(value="tasks", description="Task API")
@Path(value="/api/v1/tasks/")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class TaskApi
implements ApiService {
    private static final Logger logger = LoggerFactory.getLogger(TaskApi.class);
    public static final String SERVICE_NAME = "taskApi";
    private ReleaseActorService releaseActorService;
    private Tasks tasks;
    private GateConditions gateConditions;
    private PermissionChecker permissions;
    private Releases releases;
    private UploadService uploadService;

    @Autowired
    public TaskApi(ReleaseActorService releaseActorService, Tasks tasks, PermissionChecker permissions, GateConditions gateConditions, UploadService uploadService, Releases releases) {
        this.releaseActorService = releaseActorService;
        this.tasks = tasks;
        this.permissions = permissions;
        this.gateConditions = gateConditions;
        this.uploadService = uploadService;
        this.releases = releases;
    }

    @Override
    public String serviceName() {
        return SERVICE_NAME;
    }

    @POST
    @Path(value="{taskId:.*/Task[^/]*}/attachments")
    @Consumes(value={"multipart/form-data"})
    @ApiOperation(value="Uploads attachments", notes="Content must be sent as a multipart/form-data", response=Attachment.class, responseContainer="List")
    public List<Attachment> addAttachments(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId, @Context HttpServletRequest request) throws IOException, FileUploadException {
        this.permissions.checkEditTask(taskId);
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator fileItems = upload.getItemIterator(request);
        List<Attachment> attachments = this.uploadService.addAttachment(taskId, fileItems);
        if (attachments.isEmpty()) {
            logger.debug("No attachments uploaded caused by incorrect form body");
            throw new BadRequestException("Expected file upload");
        }
        return attachments;
    }

    @PublicApiMember
    public Attachment addAttachment(String taskId, String fileName, byte[] fileByteArray) throws IOException {
        this.permissions.checkEditTask(taskId);
        return this.uploadService.addAttachment(taskId, fileName, fileByteArray);
    }

    @DELETE
    @Path(value="{taskId:.*/Task[^/]*}/attachments/{attachmentId:.*/Attachment[^/]*}")
    @ApiOperation(value="Deletes attachment from a task")
    @PublicApiMember
    public void deleteAttachment(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId, @PathParam(value="attachmentId") @ApiParam(value="Full identifier of the attachment; for example, Applications/Release1/Attachment1") String attachmentId) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE_TASK, releaseId);
        this.releaseActorService.deleteAttachmentFromTask(releaseId, taskId, attachmentId);
    }

    @GET
    @Path(value="/{taskId:.*/Task[^/]*}")
    @ApiOperation(value="Returns the task for the given ID", response=Task.class)
    @PublicApiMember
    public Task getTask(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId) {
        this.permissions.checkView(Ids.releaseIdFrom((String)taskId));
        return this.tasks.findById(taskId);
    }

    @POST
    @Path(value="{taskId:.*/Task[^/]*}/copy")
    @ApiOperation(value="Copy an existing task and place it at given target position", response=Phase.class)
    @PublicApiMember
    public Task copyTask(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId, @QueryParam(value="targetContainerId") @ApiParam(value="Full identifier of the target container to put the copied task into; this can be a different phase. Copying to another release is not supported. For example, Applications/Release1/Phase1/Task4") String targetContainerId, @QueryParam(value="targetPosition") @ApiParam(value="The position you want to have the copy. Default is 0.") int targetPosition) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        this.permissions.checkCopyTask(releaseId);
        return this.releaseActorService.copyTask(taskId, targetContainerId, targetPosition);
    }

    @PUT
    @Path(value="/{taskId:.*/Task[^/]*}")
    @ApiOperation(value="Updates the task for the given ID", response=Task.class)
    public Task updateTask(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId, @ApiParam(value="The updated task object; only top-level properties will be updated.") Task task) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        return this.releaseActorService.updateTask(taskId, task);
    }

    @PublicApiMember
    public Task updateTask(Task task) {
        return this.updateTask(task.getId(), task);
    }

    @POST
    @Path(value="{taskId:.*/Task[^/]*}/changeType")
    @ApiOperation(value="Changes a task to the target task type; the target can be a core task type such as xlrelease.GateTask or a custom script definition type such as jenkins.Build", response=Task.class)
    @PublicApiMember
    public Task changeTaskType(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3", required=true) String taskId, @QueryParam(value="targetType") @ApiParam(value="Target task type; for example, targetType=xlrelease.Task or targetType=jenkins.Build", required=true) String targetType) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)targetType) ? 1 : 0) != 0, (String)"Query parameter targetType must be provided", (Object[])new Object[0]);
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        return this.releaseActorService.changeTaskType(taskId, Type.valueOf((String)targetType));
    }

    @POST
    @Path(value="/{containerId:.*?}/tasks")
    @ApiOperation(value="Adds a task in a phase or a task", response=Task.class)
    @PublicApiMember
    public Task addTask(@PathParam(value="containerId") @ApiParam(value="Full identifier of the task container: either a Phase, a ParallelGroup or a SequentialGroup; for example Applications/Release1/Phase2") String containerId, @ApiParam(value="Definition of the task to add") Task task) {
        String releaseId = Ids.releaseIdFrom((String)containerId);
        this.permissions.checkView(releaseId);
        this.permissions.checkEdit(releaseId);
        this.permissions.checkEditTask(releaseId);
        return this.releaseActorService.createTask(containerId, task, null);
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/complete")
    @ApiOperation(value="Completes a task", response=Task.class)
    @PublicApiMember
    public Task completeTask(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId, @ApiParam(value="The comment to associate with the action") Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when completing a task.");
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        Checks.checkArgument((boolean)this.areAllRequiredVariablesSet(taskId), (String)"All required values must be set before completing the task", (Object[])new Object[0]);
        return this.releaseActorService.completeTask(taskId, comment.getComment());
    }

    private boolean areAllRequiredVariablesSet(String taskId) {
        Object task = this.tasks.findById(taskId);
        return !this.isUserInputTask((Task)task) || ((UserInputTask)task).getVariables().stream().noneMatch(v -> v.getRequiresValue() && v.isValueEmpty());
    }

    private boolean isUserInputTask(Task task) {
        return task instanceof UserInputTask;
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/skip")
    @ApiOperation(value="Skips a task", response=Task.class)
    @PublicApiMember
    public Task skipTask(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId, @ApiParam(value="The comment to associate with the action") Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when skipping a task.");
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        return this.releaseActorService.skipTask(taskId, comment.getComment());
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/fail")
    @ApiOperation(value="Fails a task", response=Task.class)
    @PublicApiMember
    public Task failTask(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId, @ApiParam(value="The comment to associate with the action") Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when failing a task.");
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        return this.releaseActorService.failTaskManually(taskId, comment.getComment());
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/abort")
    @ApiOperation(value="Aborts a task", response=Task.class)
    @PublicApiMember
    public Task abortTask(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId, @ApiParam(value="The comment to associate with the action") Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when aborting a task.");
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment.getComment()) ? 1 : 0) != 0, (String)"Comment is mandatory when aborting a task.", (Object[])new Object[0]);
        return this.releaseActorService.abortTask(taskId, comment.getComment());
    }

    @PublicApiMember
    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/retry")
    @ApiOperation(value="Retry a task", response=Task.class)
    public Task retryTask(@PathParam(value="taskId") @ApiParam(value="Task to start") String taskId, @ApiParam(value="The comment to associate with the action") Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when retrying a task.");
        this.permissions.checkRetryTask(taskId);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment.getComment()) ? 1 : 0) != 0, (String)"Comment is mandatory when retrying a task.", (Object[])new Object[0]);
        return this.releaseActorService.retryTask(taskId, comment.getComment());
    }

    @PublicApiMember
    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/startNow")
    @ApiOperation(value="Start a pending task", response=Task.class)
    public Task start(@PathParam(value="taskId") @ApiParam(value="Task to start") String taskId, @ApiParam(value="The comment to associate with the action") Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when starting a pending task.");
        this.permissions.checkIsAllowedToStartTask(taskId);
        return this.releaseActorService.startTask(taskId, comment.getComment());
    }

    @PublicApiMember
    public Task start(@ApiParam(value="Task to start") Task task, @ApiParam(value="List of input variables for the task to be started") List<Variable> variables) {
        return this.start(task.getId(), new StartTask(variables));
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/start")
    @ApiOperation(value="Starts a task that is waiting for input", response=Task.class)
    public Task start(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId, @ApiParam(value="StartTask object containing missing variables values for the task") StartTask startTask) {
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        List<Variable> taskVariables = startTask.getVariables();
        return this.releaseActorService.startTaskWithInput(taskId, taskVariables);
    }

    @PublicApiMember
    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/reopen")
    @ApiOperation(value="Reopen a task", response=Task.class)
    public Task reopenTask(@PathParam(value="taskId") @ApiParam(value="Task to reopen") String taskId, @ApiParam(value="The comment to associate with the action") Comment comment) {
        this.permissions.checkReopenTaskInRelease(Ids.releaseIdFrom((String)taskId));
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when reopening a task.");
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment.getComment()) ? 1 : 0) != 0, (String)"Comment is mandatory when reopening a task.", (Object[])new Object[0]);
        return this.releaseActorService.reopenTask(taskId, comment.getComment());
    }

    @GET
    @Path(value="/{taskId:.*/Task[^/]*}/variables")
    @ApiOperation(value="Returns the variables used by the task input fields", response=Variable.class, responseContainer="List")
    @PublicApiMember
    public List<Variable> getVariables(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId) {
        Object task = this.tasks.findById(taskId);
        this.permissions.checkViewTask((Task)task);
        return task.getInputVariables();
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/comment")
    @ApiOperation(value="Adds a comment to a task", response=Task.class)
    @PublicApiMember
    public Task commentTask(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId, @ApiParam(value="The comment to associate with the action") Comment comment) {
        this.permissions.checkIsAllowedToCommentOnTask(taskId);
        this.releaseActorService.addCommentToTask(taskId, comment.getComment());
        return this.tasks.findById(taskId);
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/assign/{username: .*?}")
    @ApiOperation(value="Assigns a task to an user", response=Task.class)
    @PublicApiMember
    public Task assignTask(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId, @PathParam(value="username") @ApiParam(value="The user name of the assigned user") String username) {
        this.permissions.checkReassignTaskToUser(taskId, username);
        return this.releaseActorService.reassignTaskToOwner(taskId, username);
    }

    @GET
    @Path(value="/byTitle")
    @ApiOperation(value="Searches tasks in a release by title", response=Task.class, responseContainer="List")
    @PublicApiMember
    public List<Task> searchTasksByTitle(@QueryParam(value="taskTitle") @ApiParam(value="The task title") String taskTitle, @QueryParam(value="phaseTitle") @ApiParam(value="The phase title (optional)") String phaseTitle, @QueryParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)taskTitle) ? 1 : 0) != 0, (String)"Query parameter taskTitle must be provided", (Object[])new Object[0]);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)releaseId) ? 1 : 0) != 0, (String)"Query parameter releaseId must be provided", (Object[])new Object[0]);
        Release release = this.releases.findById(releaseId);
        this.permissions.checkView(release);
        return release.getTasksByTitle(phaseTitle, taskTitle);
    }

    @PublicApiMember
    public Task newTask() {
        return this.newTask("xlrelease.Task");
    }

    @PublicApiMember
    public Task newTask(String type) {
        Task task = Task.fromType((String)type);
        task.setTitle("New task");
        return task;
    }

    public Comment newComment(String commentText) {
        return new Comment(commentText);
    }

    @DELETE
    @Path(value="/{taskId:.*/Task[^/]*}")
    @ApiOperation(value="Deletes a task")
    @PublicApiMember
    public void delete(@PathParam(value="taskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase2/Task3") String taskId) {
        this.permissions.checkEdit(Ids.releaseIdFrom((String)taskId));
        this.releaseActorService.deleteTask(taskId);
    }

    @DELETE
    @Path(value="/{dependencyId:.*/Dependency[^/]*}")
    @ApiOperation(value="Deletes a dependency from a gate task.")
    @PublicApiMember
    public void deleteDependency(@PathParam(value="dependencyId") @ApiParam(value="Full identifier of the dependency; for example, Applications/Release1/Phase2/Task3/Dependency0") String dependencyId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)dependencyId));
        String taskId = Ids.getParentId((String)dependencyId);
        Object task = this.tasks.findById(taskId);
        Checks.checkArgument((boolean)task.isGate(), (String)("Can only delete a dependency from a GateTask, not a " + task.getTaskType().toString()), (Object[])new Object[0]);
        this.releaseActorService.deleteDependency(taskId, dependencyId);
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/dependencies/{targetId:.*?}")
    @ApiOperation(value="Adds a dependency to a gate task.", response=Dependency.class)
    @PublicApiMember
    public Dependency addDependency(@PathParam(value="taskId") @ApiParam(value="Full identifier of the gate task; for example, Applications/Release1/Phase2/Task3") String taskId, @PathParam(value="targetId") @ApiParam(value="Full identifier of the release, phase or task that the gate will depend on, or a variable which will resolve to such an identifier. When using a variable you can also combine variables, for example \"Applications/${shortReleaseId}\"") String targetId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        if (!VariableHelper.containsVariables((String)targetId)) {
            this.permissions.checkView(Ids.releaseIdFrom((String)targetId));
        }
        Object task = this.tasks.findById(taskId);
        Checks.checkArgument((boolean)task.isGate(), (String)("Can only add a dependency to a GateTask, not a " + task.getTaskType().toString()), (Object[])new Object[0]);
        return this.releaseActorService.createDependency(taskId, targetId);
    }

    @POST
    @Path(value="{taskId:.*/Task[^/]*}/conditions")
    @ApiOperation(value="Adds a condition to a gate task.", response=GateCondition.class)
    @PublicApiMember
    public GateCondition addCondition(@PathParam(value="taskId") @ApiParam(value="Full identifier of the gate task; for example, Applications/Release1/Phase2/Task3") String taskId, @ApiParam(value="Definition of the condition to add") Condition condition) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        Object task = this.tasks.findById(taskId);
        Checks.checkArgument((boolean)task.isGate(), (String)("Can only add a condition to a GateTask, not a " + task.getType()), (Object[])new Object[0]);
        GateCondition gateCondition = this.releaseActorService.createGateCondition(taskId);
        gateCondition.setTitle(condition.getTitle());
        gateCondition.setChecked(condition.isChecked());
        return this.releaseActorService.updateGateCondition(gateCondition.getId(), gateCondition);
    }

    @POST
    @Path(value="/{conditionId:.*/GateCondition[^/]*}")
    @ApiOperation(value="Updates a condition on a gate task. Use this method to (un)check the condition.", response=GateCondition.class)
    public GateCondition updateCondition(@PathParam(value="conditionId") @ApiParam(value="Full identifier of the condition; for example, Applications/Release1/Phase2/Task3/GateCondition1") String conditionId, @ApiParam(value="New values of the condition") Condition condition) {
        String gateId = Ids.getParentId((String)conditionId);
        this.permissions.checkIsAllowedToWorkOnTask(gateId);
        GateCondition previousCondition = this.gateConditions.findById(conditionId);
        previousCondition.setChecked(condition.isChecked());
        if (!Objects.equal((Object)previousCondition.getTitle(), (Object)condition.getTitle())) {
            this.permissions.checkEditTask(Ids.releaseIdFrom((String)conditionId));
            previousCondition.setTitle(condition.getTitle());
        }
        return this.releaseActorService.updateGateCondition(conditionId, previousCondition);
    }

    @PublicApiMember
    public GateCondition updateCondition(GateCondition condition) {
        return this.releaseActorService.updateGateCondition(condition.getId(), condition);
    }

    @DELETE
    @Path(value="{conditionId:.*/GateCondition[^/]*?}")
    @ApiOperation(value="Deletes a condition from a gate task.")
    @PublicApiMember
    public void deleteCondition(@PathParam(value="conditionId") @ApiParam(value="Full identifier of the condition; for example, Applications/Release1/Phase2/Task3/GateCondition1") String conditionId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)conditionId));
        this.releaseActorService.deleteGateCondition(conditionId);
    }
}

