/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.api.v1.TeamFacade;
import com.xebialabs.xlrelease.api.v1.VariableComponent;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Attachments;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.ReleaseOrderMode;
import com.xebialabs.xlrelease.views.ReleasesFilters;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Api(value="releases", description="Release API")
@Path(value="/api/v1/releases")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AllCILevels
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class ReleaseApi
implements ApiService {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseApi.class);
    public static final String SERVICE_NAME = "releaseApi";
    private PermissionChecker permissions;
    private Releases releases;
    private ReleaseSearchService releaseSearchService;
    private ReleaseActorService releaseActorService;
    private VariableComponent variableComponent;
    private TeamFacade teamFacade;
    private Attachments attachments;

    @Autowired
    public ReleaseApi(PermissionChecker permissions, Releases releases, ReleaseSearchService releaseSearchService, VariableComponent variableComponent, ReleaseActorService releaseActorService, TeamFacade teamFacade, Attachments attachmentService) {
        this.permissions = permissions;
        this.releases = releases;
        this.releaseSearchService = releaseSearchService;
        this.releaseActorService = releaseActorService;
        this.variableComponent = variableComponent;
        this.teamFacade = teamFacade;
        this.attachments = attachmentService;
    }

    @Override
    public String serviceName() {
        return SERVICE_NAME;
    }

    @GET
    @Workdir(prefix="download")
    @Path(value="attachments/{attachmentId:.*/Attachment[^/]*}")
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Downloads an attachment with the given identifier", notes="Accept must be sent as a application/octet-stream")
    public Response downloadAttachment(@PathParam(value="attachmentId") @ApiParam(value="Full identifier of the attachment; for example, Applications/Release1/Attachment1") String attachmentId) {
        this.permissions.checkView(Ids.releaseIdFrom((String)attachmentId));
        Attachment attachment = this.attachments.findByIdIncludingArchived(attachmentId);
        WorkDir workDir = WorkDirContext.get();
        StreamingOutput output = outputStream -> {
            try (InputStream inputStream = attachment.getFile().getInputStream();){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                workDir.delete();
            }
        };
        String fileName = attachment.getFile().getName();
        return ResponseHelper.streamFile(fileName, output, attachment.getContentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublicApiMember
    public byte[] getAttachment(String attachmentId) throws IOException {
        byte[] byteArray;
        this.permissions.checkView(Ids.releaseIdFrom((String)attachmentId));
        WorkdirHolder.initWorkdir((String)"download");
        Attachment attachment = this.attachments.findByIdIncludingArchived(attachmentId);
        WorkDir workDir = WorkDirContext.get();
        try (InputStream inputStream = attachment.getFile().getInputStream();){
            byteArray = ByteStreams.toByteArray((InputStream)inputStream);
        }
        finally {
            workDir.delete();
        }
        return byteArray;
    }

    @GET
    @Path(value="/")
    @ApiOperation(value="Returns the list of active releases that are visible to the current user", response=Release.class, responseContainer="List")
    @PublicApiMember
    public List<Release> getReleases(@DefaultValue(value="0") @QueryParam(value="page") @ApiParam(value="The (optional) page of results to return. Default value is 0.") Long page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") @ApiParam(value="The (optional) number of results per page. Default value is 100.") Long resultsPerPage, @DefaultValue(value="1") @QueryParam(value="depth") @ApiParam(value="The (optional) depth to search for. Default value is 1.") Integer depth) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        ReleasesFilters filters = new ReleasesFilters();
        filters.setPlanned(true);
        filters.setActive(true);
        filters.setOrderBy(ReleaseOrderMode.start_date);
        ReleaseSearchResult searchResult = this.releaseSearchService.search(filters, page, resultsPerPage, depth);
        return searchResult.getReleases();
    }

    @PublicApiMember
    public List<Release> getReleases() {
        return this.getReleases(0L, 100L, Integer.MAX_VALUE);
    }

    @GET
    @Path(value="/{releaseId:((?!archived).)*Release[^/]*}")
    @ApiOperation(value="Returns the release with the given ID", response=Release.class)
    @PublicApiMember
    public Release getRelease(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId) {
        Release release = this.releases.findById(releaseId);
        this.permissions.checkView(release);
        return release;
    }

    @GET
    @Path(value="/archived/{releaseId:.*Release[^/]*}")
    @ApiOperation(value="Returns the archived release for the given ID", response=Release.class)
    @PublicApiMember
    public Release getArchivedRelease(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId) {
        Release release = this.releases.findByIdInArchive(releaseId);
        this.permissions.checkView(release);
        return release;
    }

    @GET
    @Path(value="/{releaseId:.*Release[^/]*}/active-tasks")
    @ApiOperation(value="Returns the active tasks in a release", response=Task.class)
    @PublicApiMember
    public List<Task> getActiveTasks(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId) {
        Release release = this.releases.findById(releaseId);
        this.permissions.checkView(release);
        return release.getActiveTasks();
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/start")
    @ApiOperation(value="Starts a planned release", response=Release.class)
    @PublicApiMember
    public Release start(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId) {
        this.permissions.check(XLReleasePermissions.START_RELEASE, releaseId);
        Checks.checkArgument((!this.releases.isTemplate(releaseId) ? 1 : 0) != 0, (String)String.format("Could not start %s because it is a template.", releaseId), (Object[])new Object[0]);
        try {
            return this.releaseActorService.startRelease(releaseId, User.AUTHENTICATED_USER);
        }
        catch (IllegalStateException e) {
            logger.error("Could not start release " + releaseId, (Throwable)e);
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @PUT
    @Path(value="/{releaseId:.*Release[^/]*}")
    @ApiOperation(value="Updates a release with the given ID", response=Release.class)
    public Release updateRelease(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId, @ApiParam(value="The updated release object; only top-level properties will be updated.") Release release) {
        this.permissions.checkEdit(releaseId);
        return this.releaseActorService.updateRelease(releaseId, release);
    }

    @PublicApiMember
    public Release updateRelease(Release release) {
        return this.updateRelease(release.getId(), release);
    }

    @DELETE
    @Path(value="/{releaseId:.*Release[^/]*}")
    @ApiOperation(value="Deletes a release")
    @PublicApiMember
    public void delete(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.releaseActorService.deleteRelease(releaseId);
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/abort")
    @ApiOperation(value="Aborts a release", response=Release.class)
    @PublicApiMember
    public Release abort(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId) {
        this.permissions.check(XLReleasePermissions.ABORT_RELEASE, releaseId);
        return this.releaseActorService.abortRelease(releaseId);
    }

    @GET
    @Path(value="/byTitle")
    @ApiOperation(value="Searches releases by title", response=Release.class, responseContainer="List")
    @PublicApiMember
    public List<Release> searchReleasesByTitle(@QueryParam(value="releaseTitle") @ApiParam(value="The title of the release") String releaseTitle) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)releaseTitle) ? 1 : 0) != 0, (String)"Query parameter releaseTitle must be provided", (Object[])new Object[0]);
        return this.releaseSearchService.searchReleasesByTitle(releaseTitle, 0L, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @GET
    @Path(value="/{releaseId:.*Release[^/]*}/variables")
    @ApiOperation(value="Gets the variables in a release", response=com.xebialabs.xlrelease.domain.variables.Variable.class, responseContainer="List")
    @PublicApiMember
    public List<com.xebialabs.xlrelease.domain.variables.Variable> getVariables(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId) {
        return this.variableComponent.getVariables(releaseId);
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @ApiOperation(value="Returns the variable with the given ID", response=com.xebialabs.xlrelease.domain.variables.Variable.class)
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable getVariable(@PathParam(value="variableId") @ApiParam(value="Full identifier of the variable; for example, Applications/Release1/Variable1") String variableId) {
        return this.variableComponent.getVariable(variableId);
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/possibleValues")
    @ApiOperation(value="Returns possible values of the variable with the given ID", response=Object.class, responseContainer="List")
    @PublicApiMember
    public Collection<Object> getVariablePossibleValues(@PathParam(value="variableId") @ApiParam(value="Full identifier of the variable; for example, Applications/Release1/Variable1") String variableId) {
        return this.variableComponent.getVariablePossibleValues(variableId);
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/used")
    @ApiOperation(value="Returns true if a variable with the given ID is used in the release", response=Boolean.class)
    @PublicApiMember
    public Boolean isVariableUsed(@PathParam(value="variableId") @ApiParam(value="Full identifier of the variable; for example, Applications/Release1/Variable1") String variableId) {
        return this.variableComponent.isVariableUsed(variableId);
    }

    @POST
    @Path(value="/{variableId:.*/Variable[^/]*}/replace")
    @ApiOperation(value="Replaces variable occurrences with a given value")
    @PublicApiMember
    public void replaceVariable(@PathParam(value="variableId") @ApiParam(value="Full identifier of the variable; for example, Applications/Release1/Variable1") String variableId, @ApiParam(value="Replacement for the variable") VariableOrValue variableOrValue) {
        this.variableComponent.replaceVariable(variableId, variableOrValue);
    }

    @DELETE
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @ApiOperation(value="Deletes a variable from a release")
    @PublicApiMember
    public void deleteVariable(@PathParam(value="variableId") @ApiParam(value="Full identifier of the variable; for example, Applications/Release1/Variable1") String variableId) {
        this.variableComponent.deleteVariable(variableId);
    }

    @POST
    @Path(value="/{releaseId:.*?}/variables")
    @ApiOperation(value="Creates a new variable", response=com.xebialabs.xlrelease.domain.variables.Variable.class)
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable createVariable(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId, @ApiParam(value="The variable object; for example, {\"key\": \"var1\"}") Variable variable) {
        return this.variableComponent.createVariable(releaseId, variable);
    }

    @PUT
    @Path(value="/{releaseId:.*?}/variables")
    @ApiOperation(value="Updates the list of variables in a release", response=com.xebialabs.xlrelease.domain.variables.Variable.class, responseContainer="List")
    @PublicApiMember
    public List<com.xebialabs.xlrelease.domain.variables.Variable> updateVariables(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId, @ApiParam(value="List of variables to update") List<com.xebialabs.xlrelease.domain.variables.Variable> variables) {
        return this.variableComponent.updateVariables(releaseId, variables);
    }

    @PUT
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @ApiOperation(value="Updates the properties of a variable", response=com.xebialabs.xlrelease.domain.variables.Variable.class)
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(@PathParam(value="variableId") @ApiParam(value="Full identifier of the variable; for example, Applications/Release1/Variable1") String variableId, @ApiParam(value="The updated variable object") com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.variableComponent.updateVariable(variableId, variable);
    }

    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.variableComponent.updateVariable(variable.getId(), variable);
    }

    @GET
    @Path(value="/permissions")
    @PublicApiMember
    public List<String> getPermissions() {
        return XLReleasePermissions.getReleasePermissions();
    }

    @GET
    @Path(value="/{releaseId:.*Release[^/]*}/teams")
    @ApiOperation(value="Returns effective teams of the release")
    @PublicApiMember
    public List<TeamView> getTeams(@PathParam(value="releaseId") String releaseId) {
        return this.teamFacade.getTeams(releaseId);
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/teams")
    @ApiOperation(value="Updates teams, team members and permissions of the release")
    @PublicApiMember
    public List<TeamView> setTeams(@PathParam(value="releaseId") String releaseId, List<TeamView> teamDtos) {
        return this.teamFacade.setTeams(releaseId, teamDtos);
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/resume")
    @ApiOperation(value="Resume a release that has been paused as part of a restart phases operation", response=Release.class)
    @PublicApiMember
    public Release resume(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId) {
        this.permissions.checkEdit(releaseId);
        try {
            return this.releaseActorService.resume(releaseId);
        }
        catch (IllegalStateException e) {
            logger.error("Could not resume release " + releaseId, (Throwable)e);
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/restart")
    @ApiOperation(value="Restarts the release from a given phase and task.", response=Release.class)
    public Release restartPhases(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId, @QueryParam(value="fromPhaseId") @ApiParam(value="Full identifier of the phase; for example, Applications/Release1/Phase11") String phaseId, @QueryParam(value="fromTaskId") @ApiParam(value="Full identifier of the task; for example, Applications/Release1/Phase11/Task111") String taskId) {
        this.permissions.checkEdit(releaseId);
        try {
            return this.releaseActorService.restartPhase(releaseId, phaseId, taskId);
        }
        catch (IllegalStateException e) {
            logger.error("Could not restart phases of release " + releaseId, (Throwable)e);
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @PublicApiMember
    public Release restartPhase(Release release) {
        Checks.checkNotNull((Object)release, (String)"given release");
        Checks.checkArgument((boolean)release.hasCurrentPhase(), (String)"Release '%s' must have a current phase in order to restart phases", (Object[])new Object[]{release.getTitle()});
        Checks.checkArgument((!release.getCurrentPhase().getTasks().isEmpty() ? 1 : 0) != 0, (String)"The given release does not have any task", (Object[])new Object[0]);
        return this.restartPhases(release.getId(), release.getCurrentPhase().getId(), release.getCurrentPhase().getTask(Integer.valueOf(0)).getId());
    }

    @PublicApiMember
    public Release restartPhase(Release release, Phase phase) {
        Checks.checkNotNull((Object)release, (String)"given release");
        Checks.checkNotNull((Object)phase, (String)"given phase");
        Checks.checkArgument((!phase.getTasks().isEmpty() ? 1 : 0) != 0, (String)"The release with given phase does not have any task", (Object[])new Object[0]);
        return this.restartPhases(release.getId(), phase.getId(), phase.getTask(Integer.valueOf(0)).getId());
    }

    @PublicApiMember
    public Release restartPhase(Release release, Phase phase, Task task) {
        Checks.checkNotNull((Object)release, (String)"given release");
        Checks.checkNotNull((Object)phase, (String)"given phase");
        Checks.checkNotNull((Object)task, (String)"given task");
        return this.restartPhases(release.getId(), phase.getId(), task.getId());
    }
}

