/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.google.common.base.Strings;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Phases;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.security.PermissionChecker;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Api(value="phases", description="Phase API")
@Path(value="/api/v1/phases")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class PhaseApi
implements ApiService {
    private static final Logger logger = LoggerFactory.getLogger(PhaseApi.class);
    public static final String SERVICE_NAME = "phaseApi";
    private PermissionChecker permissions;
    private Phases phases;
    private Releases releases;
    private ReleaseActorService releaseActorService;

    @Autowired
    public PhaseApi(PermissionChecker permissions, Phases phases, Releases releases, ReleaseActorService releaseActorService) {
        this.permissions = permissions;
        this.phases = phases;
        this.releases = releases;
        this.releaseActorService = releaseActorService;
    }

    @Override
    public String serviceName() {
        return SERVICE_NAME;
    }

    @GET
    @Path(value="/{phaseId:.*/Phase[^/]*}")
    @ApiOperation(value="Returns the phase for the given ID", response=Phase.class)
    @PublicApiMember
    public Phase getPhase(@PathParam(value="phaseId") @ApiParam(value="Full phase identifier; for example, Applications/Release1/Phase2") String phaseId) {
        this.permissions.checkView(Ids.releaseIdFrom((String)phaseId));
        return this.phases.findById(phaseId);
    }

    @PUT
    @Path(value="/{phaseId:.*/Phase[^/]*}")
    @ApiOperation(value="Updates the phase for the given ID", response=Phase.class)
    public Phase updatePhase(@PathParam(value="phaseId") @ApiParam(value="Full phase identifier; for example, Applications/Release1/Phase2") String phaseId, @ApiParam(value="The updated phase object; only top-level properties will be updated") Phase phase) {
        this.permissions.checkEdit(Ids.releaseIdFrom((String)phaseId));
        return this.releaseActorService.updatePhase(phaseId, phase);
    }

    @PublicApiMember
    public Phase updatePhase(Phase phase) {
        return this.updatePhase(phase.getId(), phase);
    }

    @POST
    @Path(value="/{phaseId:.*/Phase[^/]*}/tasks")
    @ApiOperation(value="Adds a task at the end of a phase", response=Task.class)
    @PublicApiMember
    public Task addTask(@PathParam(value="phaseId") @ApiParam(value="Full phase identifier; for example, Applications/Release1/Phase2") String phaseId, @ApiParam(value="The task to add") Task task, @QueryParam(value="position") @ApiParam(value="The position in the phase, zero-based; leave empty to add the task to the end of the phase") Integer position) {
        String releaseId = Ids.releaseIdFrom((String)phaseId);
        this.permissions.checkView(releaseId);
        this.permissions.checkEdit(releaseId);
        this.permissions.checkEditTask(releaseId);
        try {
            return this.releaseActorService.createTask(phaseId, task, position);
        }
        catch (IllegalArgumentException e) {
            logger.error("Could not add a task to a phase", (Throwable)e);
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @GET
    @Path(value="/byTitle")
    @ApiOperation(value="Search phases in a release by title", response=Phase.class, responseContainer="List")
    @PublicApiMember
    public List<Phase> searchPhasesByTitle(@QueryParam(value="phaseTitle") @ApiParam(value="The phase title") String phaseTitle, @QueryParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)phaseTitle) ? 1 : 0) != 0, (String)"Query parameter phaseTitle must be provided", (Object[])new Object[0]);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)releaseId) ? 1 : 0) != 0, (String)"Query parameter releaseId must be provided", (Object[])new Object[0]);
        Release release = this.releases.findById(releaseId);
        this.permissions.checkView(release);
        return release.getPhasesByTitle(phaseTitle);
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/phase")
    @ApiOperation(value="Creates a new phase", response=Phase.class)
    @PublicApiMember
    public Phase addPhase(@PathParam(value="releaseId") @ApiParam(value="Full identifier of the release; for example, Applications/Release1") String releaseId, @ApiParam(value="The phase to add") Phase phase, @QueryParam(value="position") @ApiParam(value="The position in the template, zero-based; leave empty to add the phase to the end of the template") Integer position) {
        this.permissions.checkView(releaseId);
        this.permissions.checkEdit(releaseId);
        try {
            return this.releaseActorService.addPhase(releaseId, phase, position);
        }
        catch (IllegalArgumentException e) {
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @POST
    @Path(value="/{phaseId:.*/Phase[^/]*}/copy")
    @ApiOperation(value="Copy an existing phase and place it at given target position", response=Phase.class)
    @PublicApiMember
    public Phase copyPhase(@PathParam(value="phaseId") @ApiParam(value="The phase id to copy") String phaseIdToCopy, @QueryParam(value="targetPosition") @ApiParam(value="The position you want to have the copy. Default is 0.") int targetPosition) {
        String releaseId = Ids.releaseIdFrom((String)phaseIdToCopy);
        this.permissions.copyPhase(releaseId);
        try {
            return this.releaseActorService.copyPhase(releaseId, phaseIdToCopy, targetPosition);
        }
        catch (IllegalArgumentException e) {
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @PublicApiMember
    public Phase addPhase(String releaseId, Phase phase) {
        return this.addPhase(releaseId, phase, null);
    }

    @PublicApiMember
    public Phase newPhase() {
        return this.newPhase("New Phase");
    }

    @PublicApiMember
    public Phase newPhase(String title) {
        Phase phase = new Phase();
        phase.setTitle(title);
        return phase;
    }

    @DELETE
    @Path(value="/{phaseId:.*/Phase[^/]*}")
    @ApiOperation(value="Deletes the phase with the given ID")
    @PublicApiMember
    public void deletePhase(@PathParam(value="phaseId") @ApiParam(value="Full phase identifier; for example, Applications/Release1/Phase2") String phaseId) {
        this.permissions.checkEdit(Ids.releaseIdFrom((String)phaseId));
        this.releaseActorService.deletePhase(phaseId);
    }
}

