/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.google.common.base.Strings;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemConflictException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Configurations;
import com.xebialabs.xlrelease.repository.Variables;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Api(value="config", description="Configuration API")
@Path(value="/api/v1/config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
@AllCILevels
public class ConfigurationApi
implements ApiService {
    public static final String SERVICE_NAME = "configurationApi";
    private Configurations configurations;
    private PermissionChecker permissions;
    private Variables variables;

    @Autowired
    public ConfigurationApi(PermissionChecker permissions, Variables variables, Configurations configurations) {
        this.permissions = permissions;
        this.variables = variables;
        this.configurations = configurations;
    }

    public ConfigurationApi() {
    }

    @Override
    public String serviceName() {
        return SERVICE_NAME;
    }

    @GET
    @Path(value="/Configuration/variables/global")
    @ApiOperation(value="Returns the list of global variables", response=com.xebialabs.xlrelease.domain.variables.Variable.class, responseContainer="List")
    @PublicApiMember
    public List<com.xebialabs.xlrelease.domain.variables.Variable> getGlobalVariables() {
        return this.variables.findGlobalVariablesOrEmpty().getVariables();
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @ApiOperation(value="Returns the global variable for the given ID", response=com.xebialabs.xlrelease.domain.variables.Variable.class)
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable getGlobalVariable(@PathParam(value="variableId") @ApiParam(value="Full identifier of the global variable; for example, Configuration/variables/global/Variable1") String variableId) {
        return this.variables.findById(variableId);
    }

    @POST
    @Path(value="/Configuration/variables/global")
    @ApiOperation(value="Adds a global variable", response=com.xebialabs.xlrelease.domain.variables.Variable.class)
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable addGlobalVariable(@ApiParam(value="The global variable to add") Variable variable) {
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_VARIABLES);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)variable.getKey()) ? 1 : 0) != 0, (String)"Variable must have a 'key' field", (Object[])new Object[0]);
        if (this.variables.findGlobalVariablesOrEmpty().getVariablesByKeys().containsKey(variable.getKey())) {
            throw new ItemConflictException("A global variable already exists by key [%s]", new Object[]{variable.getKey()});
        }
        return this.variables.addGlobalVariable(variable.toReleaseVariable());
    }

    @PUT
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @ApiOperation(value="Updates the properties of the global variable with the given ID", response=com.xebialabs.xlrelease.domain.variables.Variable.class)
    public com.xebialabs.xlrelease.domain.variables.Variable updateGlobalVariable(@PathParam(value="variableId") @ApiParam(value="Full identifier of the global variable to update; for example, Configuration/variables/global/Variable1") String variableId, @ApiParam(value="The updated global variable object") com.xebialabs.xlrelease.domain.variables.Variable variable) {
        VariableHelper.checkVariableIdsAreTheSame((String)variableId, (String)variable.getId());
        if (!VariableHelper.isGlobalVariableId((String)variable.getId())) {
            throw new ItemConflictException("Variable id [%s] doesn't belong to the global variable", new Object[]{variable.getId()});
        }
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_VARIABLES);
        return this.variables.updateGlobalVariable(variable);
    }

    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable updateGlobalVariable(com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.updateGlobalVariable(variable.getId(), variable);
    }

    @DELETE
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @ApiOperation(value="Deletes the global variable with the given ID")
    @PublicApiMember
    public void deleteGlobalVariable(@PathParam(value="variableId") @ApiParam(value="Full identifier of the global variable to delete, for example, Configuration/variables/global/Variable1") String variableId) {
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_VARIABLES);
        this.variables.findById(variableId);
        this.variables.deleteGlobalVariable(variableId);
    }

    @GET
    @Path(value="byTypeAndTitle")
    @ApiOperation(value="Searches configuration objects by type and title. Returns first 100 results loaded with depth 1. Password properties are not returned.", response=Configuration.class, responseContainer="List")
    @PublicApiMember
    public List<Configuration> searchByTypeAndTitle(@QueryParam(value="configurationType") @ApiParam(value="Type of the Configuration object") String configurationType, @QueryParam(value="title") @ApiParam(value="The title of the Configuration object") String title) {
        List<Configuration> items = this.configurations.searchByTypeAndTitle(Type.valueOf((String)configurationType), title);
        items.forEach(item -> CiHelper.forFields((ConfigurationItem)item, PropertyDescriptor::isPassword, (ci, pd) -> pd.set(ci, null)));
        return items;
    }

    @GET
    @Path(value="/{configurationId:.*/Configuration[^/]*}")
    @ApiOperation(value="Returns the configuration with the given ID", response=Configuration.class)
    @PublicApiMember
    public Configuration getConfiguration(@PathParam(value="configurationId") @ApiParam(value="Full identifier of the configuration, for example, Configuration/Custom/Configuration1") String configurationId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.configurations.findById(configurationId);
    }

    @POST
    @ApiOperation(value="Creates a new configuration", response=Configuration.class)
    @PublicApiMember
    public Configuration addConfiguration(@ApiParam(value="Definition of the configuration item to add") Configuration configuration) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.configurations.create(configuration);
    }

    @PUT
    @Path(value="{configurationId:.*/Configuration[^/]*}")
    @ApiOperation(value="Updates the configuration", response=Configuration.class)
    public Configuration updateConfiguration(@PathParam(value="configurationId") @ApiParam(value="Full identifier of the configuration, for example, Configuration/Custom/Configuration1") String configurationId, @ApiParam(value="The updated configuration object") Configuration configuration) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.configurations.updateWith(configurationId, configuration);
    }

    @PublicApiMember
    public Configuration updateConfiguration(Configuration configuration) {
        return this.updateConfiguration(configuration.getId(), configuration);
    }

    @DELETE
    @Path(value="{configurationId:.*/Configuration[^/]*}")
    @ApiOperation(value="Deletes the configuration")
    @PublicApiMember
    public void deleteConfiguration(@PathParam(value="configurationId") @ApiParam(value="Full identifier of the configuration, for example, Configuration/Custom/Configuration1") String configurationId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.configurations.delete(configurationId);
    }
}

