/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.views.TeamView;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/teams")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class TeamResource {
    private PermissionChecker permissions;
    private UserInfoResolver userInfoResolver;
    private ReleaseActorService releaseActorService;
    private Teams teams;

    @Autowired
    public TeamResource(PermissionChecker permissions, UserInfoResolver userInfoResolver, ReleaseActorService releaseActorService, Teams teams) {
        this.permissions = permissions;
        this.userInfoResolver = userInfoResolver;
        this.releaseActorService = releaseActorService;
        this.teams = teams;
    }

    @GET
    @Path(value="{teamContainerId:.*(Release|Folder)[^/-]*}")
    public List<TeamView> getTeams(@PathParam(value="teamContainerId") @IdParam String teamContainerId) {
        this.checkEdit(teamContainerId);
        return this.teams.getEffectiveTeams(teamContainerId).stream().map(team -> new TeamView((Team)team, this.userInfoResolver)).collect(Collectors.toList());
    }

    @POST
    @Path(value="{teamContainerId:.*(Release|Folder)[^/-]*}/new")
    public TeamView addTeam(@PathParam(value="teamContainerId") @IdParam String teamContainerId, TeamView teamView) {
        this.checkEdit(teamContainerId);
        Checks.checkArgument((boolean)this.isReleaseAdminTeamPresent(teamContainerId, Collections.singletonList(teamView)), (String)"Cannot add team %s in %s, missing 'Release Admin' team", (Object[])new Object[]{teamView, teamContainerId});
        Team team = Ids.isReleaseId((String)teamContainerId) ? this.releaseActorService.addTeam(teamContainerId, teamView.toTeam()) : this.teams.create(teamContainerId, teamView.toTeam());
        return new TeamView(team, this.userInfoResolver);
    }

    @DELETE
    @Path(value="/{teamId:.*Team[^/-]*}")
    public void deleteTeam(@PathParam(value="teamId") @IdParam String teamId) {
        String teamContainerId = Ids.getParentId((String)teamId);
        this.checkEdit(teamContainerId);
        if (Ids.isReleaseId((String)teamContainerId)) {
            this.releaseActorService.deleteTeam(teamId);
        } else {
            this.teams.deleteTeam(teamId);
        }
    }

    @DELETE
    @Path(value="/{teamContainerId:.*(Release|Folder)[^/-]*}")
    public void deleteAllOwnTeams(@PathParam(value="teamContainerId") @IdParam String teamContainerId) {
        this.checkEdit(teamContainerId);
        if (Ids.isReleaseId((String)teamContainerId)) {
            this.releaseActorService.updateTeams(teamContainerId, Collections.emptyList());
        } else {
            this.teams.saveTeamsToPlatform(teamContainerId, Collections.emptyList());
        }
    }

    @PUT
    @Path(value="{teamId:.*Team[^/-]*}")
    public TeamView updateTeam(@PathParam(value="teamId") @IdParam String teamId, TeamView newTeam) {
        String teamContainerId = Ids.getParentId((String)teamId);
        this.checkEdit(teamContainerId);
        Team team = Ids.isReleaseId((String)teamContainerId) ? this.releaseActorService.updateTeam(teamId, newTeam.toTeam()) : this.teams.updateTeam(newTeam.toTeam());
        return new TeamView(team, this.userInfoResolver);
    }

    @POST
    @Path(value="{teamContainerId:.*(Release|Folder)[^/-]*}")
    public List<TeamView> updateTeams(@PathParam(value="teamContainerId") @IdParam String teamContainerId, List<TeamView> updatedListOfTeams) {
        this.checkEdit(teamContainerId);
        Checks.checkArgument((boolean)this.isReleaseAdminTeamPresent(teamContainerId, updatedListOfTeams), (String)"Cannot save teams %s in %s, missing 'Release Admin' team", (Object[])new Object[]{updatedListOfTeams, teamContainerId});
        List<Team> submittedTeams = updatedListOfTeams.stream().map(TeamView::toTeam).collect(Collectors.toList());
        List<Team> updatedTeams = Ids.isReleaseId((String)teamContainerId) ? this.releaseActorService.updateTeams(teamContainerId, submittedTeams) : this.teams.saveTeamsToPlatform(teamContainerId, submittedTeams);
        return updatedTeams.stream().map(team -> new TeamView((Team)team, this.userInfoResolver)).collect(Collectors.toList());
    }

    private void checkEdit(String teamContainerId) {
        if (Ids.isReleaseId((String)teamContainerId)) {
            this.permissions.checkEdit(teamContainerId);
        } else if (Ids.isFolderId((String)teamContainerId)) {
            this.permissions.check(XLReleasePermissions.EDIT_FOLDER_SECURITY, teamContainerId);
        } else {
            throw new Checks.IncorrectArgumentException("[%s] is not a release or a folder", new Object[]{teamContainerId});
        }
    }

    private boolean isReleaseAdminTeamPresent(String containerId, List<TeamView> updatedListOfTeams) {
        return this.isReleaseAdminTeamPresent(this.getTeams(containerId)) || this.isReleaseAdminTeamPresent(updatedListOfTeams);
    }

    private boolean isReleaseAdminTeamPresent(List<TeamView> teamViewList) {
        return teamViewList.stream().anyMatch(team -> "Release Admin".equals(team.getTeamName()));
    }
}

