/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.SupportService;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/support")
@Controller
public class SupportResource {
    private static final String ZIP_FILE_NAME = "xlr-support-package.zip";
    private static final List<String> directories = Arrays.asList("conf", "ext", "plugins", "hotfix", "log", "bin");
    private PermissionChecker permissionChecker;
    private SupportService supportService;

    @Autowired
    public SupportResource(PermissionChecker permissionChecker, SupportService supportService) {
        this.permissionChecker = permissionChecker;
        this.supportService = supportService;
    }

    @Path(value="/zip")
    @Produces(value={"application/zip"})
    @GET
    public Response generateZip() {
        if (!this.permissionChecker.hasGlobalPermission(PlatformPermissions.ADMIN)) {
            throw new PermissionDeniedException("This operation requires an admin permission");
        }
        StreamingOutput stream = output -> this.supportService.prepareZip(output, directories);
        return Response.ok((Object)stream).header("Content-Disposition", (Object)"attachment; filename=\"xlr-support-package.zip\"").build();
    }
}

