/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.core.rest.api.RepositoryResource;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.configuration.ArchivingSettings;
import com.xebialabs.xlrelease.configuration.PollingSettings;
import com.xebialabs.xlrelease.configuration.ReportsSettings;
import com.xebialabs.xlrelease.views.ArchivingSettingsView;
import com.xebialabs.xlrelease.views.ReportsSettingsView;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class SettingsResource {
    private RepositoryService repositoryService;
    private RepositoryResource repositoryResource;

    @Autowired
    public SettingsResource(RepositoryService repositoryService, RepositoryResource repositoryResource) {
        this.repositoryService = repositoryService;
        this.repositoryResource = repositoryResource;
    }

    @GET
    @Path(value="reports")
    public ReportsSettingsView getReportsSettings() {
        ReportsSettings reportsSettings = (ReportsSettings)this.repositoryService.read("Configuration/reports/ReportsSettings");
        return new ReportsSettingsView(reportsSettings);
    }

    @GET
    @Path(value="polling-interval")
    public Integer getPollingInterval() {
        PollingSettings pollingSettings = (PollingSettings)this.repositoryService.read("Configuration/settings/PollingSettings");
        return pollingSettings.getPollingInterval();
    }

    @GET
    @Path(value="archiving-settings")
    public ArchivingSettingsView getArchivingSettings() {
        ArchivingSettings archivingSettings = (ArchivingSettings)this.repositoryService.read("Configuration/settings/ArchivingSettings");
        return new ArchivingSettingsView(archivingSettings);
    }

    @GET
    @Path(value="ci/{ID:.*?}")
    public ConfigurationItem read(@PathParam(value="ID") String id) {
        return this.repositoryResource.read(id);
    }

    @POST
    @Path(value="ci/{ID:.*?}")
    public ConfigurationItem create(@PathParam(value="ID") String id, ConfigurationItem configurationItem) {
        return this.repositoryResource.create(id, configurationItem);
    }

    @PUT
    @Path(value="ci/{ID:.*?}")
    public ConfigurationItem update(@PathParam(value="ID") String id, ConfigurationItem configurationItem) {
        if (configurationItem instanceof ArchivingSettings) {
            ArchivingSettings archivingSettings = (ArchivingSettings)configurationItem;
            Preconditions.checkArgument((archivingSettings.getReleaseAgeToDeleteFromJcr() >= 0 ? 1 : 0) != 0);
        }
        if (configurationItem instanceof PollingSettings) {
            PollingSettings pollingSettings = (PollingSettings)configurationItem;
            Preconditions.checkArgument((pollingSettings.getPollingInterval() > 0 ? 1 : 0) != 0, (Object)"Polling interval must be greater than 0 seconds.");
        }
        return this.repositoryResource.update(id, configurationItem);
    }
}

