/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.DateParam;
import com.xebialabs.xlrelease.reports.PhaseDuration;
import com.xebialabs.xlrelease.reports.ReleaseAutomationData;
import com.xebialabs.xlrelease.reports.ReleasesAutomation;
import com.xebialabs.xlrelease.reports.ReleasesDuration;
import com.xebialabs.xlrelease.reports.TaskDuration;
import com.xebialabs.xlrelease.reports.UserParticipation;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReportServiceCache;
import com.xebialabs.xlrelease.views.Point;
import com.xebialabs.xlrelease.views.TimeFrame;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/reports")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ReportResource {
    private PermissionChecker permissions;
    private ReportServiceCache reportService;

    @Autowired
    public ReportResource(PermissionChecker permissions, ReportServiceCache reportService) {
        this.permissions = permissions;
        this.reportService = reportService;
    }

    @GET
    @Path(value="releases/duration")
    public ReleasesDuration getReleaseDuration(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="timeFrame") TimeFrame timeFrame, @QueryParam(value="tags") String tags, @DateParam @QueryParam(value="from") Date from, @DateParam @QueryParam(value="to") Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getReleaseDuration(timeFrame, ReportResource.splitTags(tags), from, to);
    }

    @GET
    @Path(value="most-involved-people")
    public List<UserParticipation> getTopPeopleMostInvolved(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="timeFrame") TimeFrame timeFrame, @QueryParam(value="tags") String tags, @DateParam @QueryParam(value="from") Date from, @DateParam @QueryParam(value="to") Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getTopPeopleMostInvolved(timeFrame, ReportResource.splitTags(tags), from, to);
    }

    @GET
    @Path(value="longest-tasks")
    public List<TaskDuration> getTopLongestTasks(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="timeFrame") TimeFrame timeFrame, @QueryParam(value="tags") String tags, @DateParam @QueryParam(value="from") Date from, @DateParam @QueryParam(value="to") Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getTopLongestTasks(timeFrame, ReportResource.splitTags(tags), from, to);
    }

    @GET
    @Path(value="releases/automation")
    public ReleasesAutomation getReleaseAutomation(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="timeFrame") TimeFrame timeFrame, @QueryParam(value="tags") String tags, @DateParam @QueryParam(value="from") Date from, @DateParam @QueryParam(value="to") Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getReleaseAutomationSeries(timeFrame, ReportResource.splitTags(tags), from, to);
    }

    @GET
    @Path(value="longest-phases")
    public List<PhaseDuration> getTopLongestPhases(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="timeFrame") TimeFrame timeFrame, @QueryParam(value="tags") String tags, @DateParam @QueryParam(value="from") Date from, @DateParam @QueryParam(value="to") Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getTopLongestPhases(timeFrame, ReportResource.splitTags(tags), from, to);
    }

    @GET
    @Path(value="releases/number-by-month")
    public List<Point> getNumberOfReleaseByMonth(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="timeFrame") TimeFrame timeFrame, @QueryParam(value="tags") String tags, @DateParam @QueryParam(value="from") Date from, @DateParam @QueryParam(value="to") Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getNumberOfReleaseByMonth(timeFrame, ReportResource.splitTags(tags), from, to);
    }

    @GET
    @Path(value="releases/most-recent/{limit}")
    public List<ReleaseAutomationData> getMostRecentReleaseData(@PathParam(value="limit") Integer limit, @QueryParam(value="tags") String tags, @DateParam @QueryParam(value="from") Date from, @DateParam @QueryParam(value="to") Date to) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getMostRecentReleasesData(ReportResource.splitTags(tags), limit, from, to);
    }

    static List<String> splitTags(@QueryParam(value="tags") String tagsInput) {
        if (tagsInput == null) {
            return Lists.newArrayList();
        }
        ArrayList tags = Lists.newArrayList((Object[])tagsInput.split(","));
        Preconditions.checkArgument((tags.size() <= 100 ? 1 : 0) != 0, (Object)"At most 100 tags are supported");
        return tags;
    }

    public static enum ReportType {
        RELEASE_DURATION,
        RELEASE_AUTOMATION,
        TOP_PEOPLE_MOST_INVOLVED,
        TOP_LONGEST_TASK,
        TOP_LONGEST_PHASE,
        TOP_LONGEST_RELEASE,
        NUMBER_OF_RELEASE_BY_MONTH;

    }
}

