/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.google.common.base.Charsets;
import com.xebialabs.deployit.core.api.InternalSecurityProxy;
import com.xebialabs.deployit.core.rest.api.UserResource;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.engine.api.security.User;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlplatform.artifact.ArtifactEnricher;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.utils.ReleaseActorLifecycleUtils;
import com.xebialabs.xlrelease.configuration.TaskAccess;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.CreatedWithoutTemplate;
import com.xebialabs.xlrelease.domain.events.Imported;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Attachments;
import com.xebialabs.xlrelease.repository.Calendar;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseCreateCommand;
import com.xebialabs.xlrelease.repository.ReleaseDeleteCommand;
import com.xebialabs.xlrelease.repository.ReleaseExistsQuery;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand;
import com.xebialabs.xlrelease.repository.TaskGetCommand;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.Variables;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.repository.query.ArchivingReleasesStrategy;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.SessionService;
import com.xebialabs.xlrelease.service.ArchivingScheduleService;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.UserProfilesService;
import com.xebialabs.xlrelease.views.FixturesUser;
import com.xebialabs.xlrelease.views.RolePermissionsView;
import com.xebialabs.xlrelease.views.RolePrincipalsView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import scala.concurrent.duration.FiniteDuration;

@javax.ws.rs.Path(value="/fixtures")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@NoCache
public class FixturesResource {
    private static final Logger logger = LoggerFactory.getLogger(FixturesResource.class);
    private static final String USER_PATH = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Users/";
    private RepositoryService repositoryService;
    private UserResource userResource;
    private PermissionChecker permissions;
    private InternalSecurityProxy internalSecurityProxy;
    private UserProfilesService userProfilesService;
    private UserService userService;
    private SessionService sessionService;
    private ArchivedReleases archivedReleases;
    private ArchivingService archivingService;
    private ArchivingScheduleService archivingScheduleService;
    private WorkDirFactory workDirFactory;
    private Variables variables;
    private ReleaseActorLifecycleUtils releaseActorLifecycleUtils;
    private Teams teams;
    private ReleaseActorService releaseActorService;
    private XLReleaseEventBus eventBus;
    private RoleService roleService;
    private Attachments attachments;
    private XlrRepository xlrRepository;
    private XlrQueries xlrQueries;
    private ArchivingReleasesStrategy archivingReleasesStrategy;

    @Autowired
    public FixturesResource(RepositoryService repositoryService, UserResource userResource, PermissionChecker permissions, InternalSecurityProxy internalSecurityProxy, UserProfilesService userProfilesService, UserService userService, SessionService sessionService, ArchivingService archivingService, ArchivedReleases archivedReleases, ArchivingScheduleService archivingScheduleService, WorkDirFactory workDirFactory, Variables variables, ReleaseActorLifecycleUtils releaseActorLifecycleUtils, Teams teams, ReleaseActorService releaseActorService, XLReleaseEventBus eventBus, RoleService roleService, Attachments attachments, XlrRepository xlrRepository, XlrQueries xlrQueries, ArchivingReleasesStrategy archivingReleasesStrategy) {
        this.repositoryService = repositoryService;
        this.userResource = userResource;
        this.permissions = permissions;
        this.internalSecurityProxy = internalSecurityProxy;
        this.userProfilesService = userProfilesService;
        this.userService = userService;
        this.sessionService = sessionService;
        this.archivedReleases = archivedReleases;
        this.archivingService = archivingService;
        this.archivingScheduleService = archivingScheduleService;
        this.workDirFactory = workDirFactory;
        this.variables = variables;
        this.releaseActorLifecycleUtils = releaseActorLifecycleUtils;
        this.teams = teams;
        this.releaseActorService = releaseActorService;
        this.eventBus = eventBus;
        this.roleService = roleService;
        this.attachments = attachments;
        this.xlrRepository = xlrRepository;
        this.xlrQueries = xlrQueries;
        this.archivingReleasesStrategy = archivingReleasesStrategy;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @Deprecated
    public void createEntities(List<ConfigurationItem> entities) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Creating entities: %s", entities));
        List<String> releaseIds = entities.stream().filter(ci -> ci.getType().equals((Object)Type.valueOf(Release.class))).map(ConfigurationItem::getId).collect(Collectors.toList());
        this.createCis(entities);
        releaseIds.forEach(id -> {
            Release release = (Release)this.repositoryService.read(id);
            this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(release, (ReleaseCreationSource)new Imported()));
        });
        this.userProfilesService.clearCache();
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @javax.ws.rs.Path(value="tree")
    @Deprecated
    public void createCiTree(ConfigurationItem ci) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Creating entity: %s", ci));
        this.createCis(CiHelper.getNestedCis((ConfigurationItem)ci));
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @javax.ws.rs.Path(value="release")
    public void createRelease(Release release) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Creating release: %s", release));
        WorkDir workDir = this.workDirFactory.newWorkDir("external");
        WorkDirTemplate.cleanOnFinally((WorkDir)workDir, wd -> {
            this.enrichAttachments(release.getAttachments(), wd);
            this.xlrRepository.handle(new ReleaseCreateCommand(release, (ReleaseCreationSource)new CreatedWithoutTemplate()));
            this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(release, (ReleaseCreationSource)new Imported()));
            return null;
        });
        this.teams.synchronizeTeamsToPlatform(release);
        this.startTriggersIfNeeded(release.getReleaseTriggers());
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @javax.ws.rs.Path(value="archived")
    public void createArchivedRelease(Release release) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.createRelease(release);
        logger.debug(String.format("Archiving release: %s", release));
        WorkDirContext.initWorkdir((String)"external");
        this.archiveRelease(release.getId());
    }

    @javax.ws.rs.Path(value="archive/{releaseId:.*}")
    @GET
    @Workdir(prefix="download")
    public Response archiveRelease(@PathParam(value="releaseId") String releaseId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Release release = this.xlrRepository.handle(new ReleaseGetCommand(releaseId, Integer.MAX_VALUE, false, WorkDirContext.get()));
        this.teams.decorateWithEffectiveTeams(release);
        List<Attachment> releaseAttachments = release.getAttachments().stream().map(attachment -> this.attachments.findById(attachment.getId())).collect(Collectors.toList());
        this.archivingService.archiveRelease(release, releaseAttachments);
        this.archivingReleasesStrategy.postProcessArchivedRelease(releaseId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @javax.ws.rs.Path(value="archiveAll")
    public Response triggerArchivingOfCompletedReleases() {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("Archiving all finished releases");
        this.archivingScheduleService.archiveExpiredReleases(0);
        return Response.ok().build();
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PUT
    public void updateEntities(List<ConfigurationItem> entities) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Updating entities: %s", entities));
        List releaseCis = entities.stream().filter(ci -> ci instanceof PlanItem).collect(Collectors.toList());
        if (!releaseCis.isEmpty()) {
            throw new UnsupportedOperationException("You cannot update parts of release using PUT /fixtures: " + releaseCis);
        }
        Predicate<ConfigurationItem> exists = ci -> this.repositoryService.exists(ci.getId());
        List<ConfigurationItem> newCis = entities.stream().filter(exists.negate()).collect(Collectors.toList());
        List existingCis = entities.stream().filter(exists).collect(Collectors.toList());
        this.createCisAttachmentsAndNoTeams(newCis);
        this.repositoryService.updateCollection(existingCis);
        FixturesResource.saveTeams(entities, this.teams);
        this.userProfilesService.clearCache();
    }

    @javax.ws.rs.Path(value="task-access")
    @DELETE
    public void deleteTaskAccess() {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("Deleting all task accesses");
        this.deleteAll(TaskAccess.class);
    }

    @javax.ws.rs.Path(value="{id:(Applications|Folder|Template|Release|Custom|Configuration).*}")
    @DELETE
    public void deleteApplicationEntity(@PathParam(value="id") String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting application entity: [%s]", id));
        this.deleteCi(id);
    }

    @javax.ws.rs.Path(value="/configuration/{id:.*}")
    @DELETE
    public void deleteConfigurationItem(@PathParam(value="id") String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting configuration entity: [%s]", id));
        this.repositoryService.delete(new String[]{"Configuration/" + id});
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/user")
    @POST
    public void createUser(FixturesUser fixturesUser) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Creating user: %s", fixturesUser.getUsername()));
        User user = fixturesUser.toUser();
        try {
            this.userResource.read(user.getUsername());
            logger.debug(String.format("User %s already exists", user.getUsername()));
        }
        catch (NotFoundException e) {
            this.userResource.create(user.getUsername(), user);
        }
    }

    @javax.ws.rs.Path(value="/user/{login}")
    @DELETE
    public void deleteUser(@PathParam(value="login") String login) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting user: %s", login));
        this.userService.delete(login);
        this.sessionService.disconnect(login);
        this.userProfilesService.clearCache();
    }

    @javax.ws.rs.Path(value="/role/{roleName}")
    @DELETE
    public void deleteRole(@PathParam(value="roleName") String roleName) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting role: %s", roleName));
        List roles = this.roleService.readRoleAssignments();
        roles.removeIf(r -> r.getName().equals(roleName));
        this.roleService.writeRoleAssignments(roles);
        this.userProfilesService.clearCache();
    }

    @javax.ws.rs.Path(value="/calendar")
    @DELETE
    public void deleteCalendar() {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("Deleting all special days and blackouts from calendar");
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setParent(Calendar.CALENDAR_DIRECTORY());
        List children = this.repositoryService.list(searchParameters);
        for (ConfigurationItemData child : children) {
            this.repositoryService.delete(new String[]{child.getId()});
        }
    }

    @javax.ws.rs.Path(value="/cis")
    @DELETE
    public void deleteCIs(List<ConfigurationItem> cis) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting CIs: %s", cis));
        for (ConfigurationItem ci : cis) {
            this.deleteCi(ci.getId());
        }
        this.userProfilesService.clearCache();
    }

    @javax.ws.rs.Path(value="/userProfile")
    @GET
    public Response searchUserProfile(@QueryParam(value="name") String username, @QueryParam(value="email") String userEmail, @QueryParam(value="fullName") String fullName) {
        this.permissions.check(PlatformPermissions.ADMIN);
        String id = USER_PATH + username;
        if (!this.repositoryService.exists(id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        UserProfile profile = (UserProfile)this.repositoryService.read(id);
        boolean sameEmail = Objects.equals(profile.getEmail(), userEmail);
        boolean sameFullName = Objects.equals(profile.getFullName(), fullName);
        return sameEmail && sameFullName ? Response.ok().build() : Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @javax.ws.rs.Path(value="/expectContainingAttachments/{releaseId:.*}")
    @POST
    @Workdir(prefix="artifact")
    public Response expectContainingAttachments(@PathParam(value="releaseId") String releaseId, ExpectedAttachment expectedAttachment) throws IOException {
        this.permissions.check(PlatformPermissions.ADMIN);
        Release release = this.xlrRepository.handle(new ReleaseGetCommand(releaseId, Integer.MAX_VALUE, true, WorkDirContext.get()));
        for (Attachment attachment : release.getAttachments()) {
            OverthereFile file = attachment.getFile();
            if (!file.getName().equals(expectedAttachment.getName())) continue;
            return this.checkContent(expectedAttachment, file);
        }
        throw new Error("Attachment not found");
    }

    private Response checkContent(ExpectedAttachment expectedAttachment, OverthereFile file) throws IOException {
        Throwable throwable = null;
        try (InputStream inputStream = file.getInputStream();){
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            String content = outputStream.toString(Charsets.UTF_8.name());
            if (content.equals(expectedAttachment.getExpectedContent())) {
                Response response = Response.ok().build();
                return response;
            }
            try {
                throw new Error("Expected content to be " + expectedAttachment.getExpectedContent() + " content found : " + content);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @POST
    @javax.ws.rs.Path(value="roles/permissions/{id:.*?}")
    public void writeRolePermissions(@PathParam(value="id") String id, List<RolePermissionsView> rolePermissionsViews) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Setting %d role permissions for [%s]", rolePermissionsViews.size(), id));
        List permissions = rolePermissionsViews.stream().map(RolePermissionsView::toRolePermissions).collect(Collectors.toList());
        this.internalSecurityProxy.writeRolePermissions(id, permissions);
    }

    @POST
    @javax.ws.rs.Path(value="roles/principals")
    public void writeRolePrincipals(List<RolePrincipalsView> rolePrincipalsViews) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Setting %d role principals", rolePrincipalsViews.size()));
        List rolePrincipals = rolePrincipalsViews.stream().map(RolePrincipalsView::toRolePrincipals).collect(Collectors.toList());
        this.internalSecurityProxy.writeRolePrincipals(rolePrincipals);
    }

    @POST
    @javax.ws.rs.Path(value="expectCommentAdded/{taskId:.*?}")
    public boolean checkCommentAdded(@PathParam(value="taskId") String taskId, String textToSearch) {
        Task task = (Task)this.xlrRepository.handle(new TaskGetCommand(taskId));
        for (Comment comment : task.getComments()) {
            if (!comment.getText().contains(textToSearch)) continue;
            return true;
        }
        return false;
    }

    @GET
    @javax.ws.rs.Path(value="auth")
    public boolean checkAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication().isAuthenticated();
    }

    private void deleteAll(Class<? extends ConfigurationItem> ciClass) {
        this.permissions.check(PlatformPermissions.ADMIN);
        SearchParameters query = new SearchParameters().setType(Type.valueOf(ciClass));
        List items = this.repositoryService.listEntities(query);
        List<String> ids = items.stream().map(ConfigurationItem::getId).collect(Collectors.toList());
        this.repositoryService.delete(ids.toArray(new String[ids.size()]));
    }

    @javax.ws.rs.Path(value="/globalVariables/")
    @DELETE
    public void deleteGlobalVariables() {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("Deleting all global variables");
        this.variables.findGlobalVariablesOrEmpty().getVariables().forEach(v -> this.variables.deleteGlobalVariable(v.getId()));
    }

    private void createCis(List<ConfigurationItem> entities) {
        this.createCisAttachmentsAndNoTeams(entities);
        FixturesResource.saveTeams(entities, this.teams);
        this.startTriggersIfNeeded(entities);
    }

    private void startTriggersIfNeeded(List<? extends ConfigurationItem> cis) {
        cis.stream().filter(ci -> ci instanceof ReleaseTrigger).forEach(releaseTrigger -> this.releaseActorService.startTrigger(Ids.releaseIdFrom((String)releaseTrigger.getId()), releaseTrigger.getId()));
    }

    private void createCisAttachmentsAndNoTeams(List<ConfigurationItem> cis) {
        List cisWithoutTeams = cis.stream().filter(ci -> !ci.getType().instanceOf(Type.valueOf(Team.class))).collect(Collectors.toList());
        WorkDir workDir = this.workDirFactory.newWorkDir("external");
        WorkDirTemplate.cleanOnFinally((WorkDir)workDir, wd -> {
            List<Attachment> attachments = cisWithoutTeams.stream().filter(ci -> ci instanceof Attachment).map(ci -> (Attachment)ci).collect(Collectors.toList());
            this.enrichAttachments(attachments, wd);
            this.repositoryService.createCollection((Collection)cisWithoutTeams);
            return null;
        });
    }

    private void enrichAttachments(List<Attachment> attachments, WorkDir workDir) {
        for (Attachment attachment : attachments) {
            if (attachment.getFileUri() != null) {
                new ArtifactEnricher((Artifact)attachment, workDir).enrich();
                continue;
            }
            LocalFile dummyFile = workDir.newFile(attachment.getName() + ".txt");
            Path dummyFilePath = Paths.get(dummyFile.getFile().toURI());
            try {
                Files.write(dummyFilePath, Collections.singletonList("test"), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                attachment.setFile((OverthereFile)dummyFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create dummy content for attachment " + attachment.getId(), e);
            }
        }
    }

    public static void saveTeams(Collection<ConfigurationItem> entities, Teams teams) {
        HashMap<String, List> containersToTeams = new HashMap<String, List>();
        entities.stream().filter(entity -> Type.valueOf(Team.class).equals((Object)entity.getType())).forEach(team -> {
            String containerId = Ids.getParentId((String)team.getId());
            containersToTeams.computeIfAbsent(containerId, s -> new ArrayList()).add((Team)team);
        });
        containersToTeams.forEach(teams::saveTeamsToPlatform);
    }

    private void deleteCi(String id) {
        if (Ids.isReleaseId((String)id)) {
            try {
                this.releaseActorLifecycleUtils.terminateReleaseActorAndAwait(id, FiniteDuration.apply((long)10L, (TimeUnit)TimeUnit.SECONDS));
            }
            catch (Exception e) {
                logger.error(String.format("Could not terminate release actor %s within timeout", id), (Throwable)e);
            }
            this.archivedReleases.delete(id);
            if (this.xlrQueries.query(new ReleaseExistsQuery(id)).booleanValue()) {
                this.deleteReleaseWithRetry(id);
                Release deletedRelease = (Release)Type.valueOf(Release.class).getDescriptor().newInstance(id);
                this.eventBus.publish((XLReleaseEvent)new ReleaseDeletedEvent(deletedRelease));
            }
        } else if (this.repositoryService.exists(id)) {
            this.repositoryService.delete(new String[]{id});
        }
    }

    private void deleteReleaseWithRetry(String releaseId) {
        try {
            this.xlrRepository.handle(new ReleaseDeleteCommand(releaseId));
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null && e.getMessage().contains("stale")) {
                logger.warn(String.format("Failed to delete release %s, will retry after 50 ms", releaseId), (Throwable)e);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {
                    logger.error("Interrupted while waiting for 50 ms", (Throwable)ie);
                }
                this.xlrRepository.handle(new ReleaseDeleteCommand(releaseId));
            }
            throw e;
        }
    }

    private static class ExpectedAttachment {
        String name;
        String expectedContent;

        public String getName() {
            return this.name;
        }

        public String getExpectedContent() {
            return this.expectedContent;
        }
    }
}

