/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.id;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.repository.Configurations;

public enum IdType {
    DOMAIN{
        private final String APPLICATIONS_ROOT = Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName() + "/";

        @Override
        public String convertToJcrId(String viewId) {
            if (null != viewId) {
                return this.APPLICATIONS_ROOT + viewId.replace('-', '/');
            }
            throw new IllegalArgumentException("Empty View id");
        }

        @Override
        public String convertToViewId(String jcrId) {
            if (jcrId != null && jcrId.startsWith(this.APPLICATIONS_ROOT)) {
                return jcrId.substring(this.APPLICATIONS_ROOT.length()).replace('/', '-');
            }
            throw new IllegalArgumentException("Invalid JCR id : " + jcrId);
        }
    }
    ,
    CONFIGURATION{
        private final String CONFIGURATION_ROOT = Configurations.CUSTOM_CONFIGURATION_ROOT + "/";

        @Override
        public String convertToJcrId(String viewId) {
            if (null != viewId) {
                return this.CONFIGURATION_ROOT + viewId;
            }
            throw new IllegalArgumentException("Empty View id");
        }

        @Override
        public String convertToViewId(String jcrId) {
            if (jcrId != null && jcrId.startsWith(this.CONFIGURATION_ROOT)) {
                return jcrId.substring(this.CONFIGURATION_ROOT.length());
            }
            throw new IllegalArgumentException("Invalid JCR id : " + jcrId);
        }
    };


    public abstract String convertToJcrId(String var1);

    public abstract String convertToViewId(String var1);
}

