/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.UnhandledExceptionMapper;
import java.util.Date;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Provider
@Component
public class UnhandledExceptionMapperProvider
extends UnhandledExceptionMapper
implements ExceptionMapper<RuntimeException> {
    @Autowired
    public UnhandledExceptionMapperProvider(ServerConfiguration config) {
        super(config);
    }

    protected Response handleException(RuntimeException runtimeException) {
        Response response = super.handleException(runtimeException);
        response.getMetadata().add((Object)"Date", (Object)new Date());
        if (runtimeException instanceof NotFoundException) {
            return Response.fromResponse((Response)response).status(Response.Status.NOT_FOUND).build();
        }
        if (runtimeException instanceof IllegalArgumentException) {
            return Response.fromResponse((Response)response).status(Response.Status.BAD_REQUEST).entity((Object)runtimeException.getMessage()).build();
        }
        return response;
    }
}

