/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionOutputWriter
extends Writer {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionOutputWriter.class);
    protected Writer out;
    protected OverthereExecutionOutputHandler[] outputHandlers;

    public ExecutionOutputWriter(Writer out, OverthereExecutionOutputHandler ... outputHandlers) {
        super((Object)out);
        this.out = out;
        this.outputHandlers = outputHandlers;
    }

    @Override
    public void write(char[] cbuf, int off2, int len) throws IOException {
        this.out.write(cbuf, off2, len);
        if (len == 1) {
            this.notifyChar(cbuf[off2]);
        } else {
            this.notifyLine(String.valueOf(cbuf, off2, len));
        }
    }

    private void notifyChar(char c) {
        for (OverthereExecutionOutputHandler outputHandler : this.outputHandlers) {
            outputHandler.handleChar(c);
        }
    }

    protected void notifyLine(String line) {
        for (OverthereExecutionOutputHandler outputHandler : this.outputHandlers) {
            outputHandler.handleLine(line);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.closeHandlers();
        this.out.close();
    }

    protected void closeHandlers() throws IOException {
        logger.debug("Closing {} output handlers", (Object)this.outputHandlers.length);
        for (OverthereExecutionOutputHandler outputHandler : this.outputHandlers) {
            if (!(outputHandler instanceof Closeable)) continue;
            ((Closeable)outputHandler).close();
        }
    }

    public String toString() {
        return this.out.toString();
    }
}

